/*
 * Decompiled with CFR 0.152.
 */
package net.picopress.mc.mods.zombietactics2.mixin;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.profiling.metrics.MetricCategory;
import net.minecraft.world.level.pathfinder.BinaryHeap;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.Target;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={PathFinder.class})
public abstract class PathFinderMixin {
    @Final
    @Shadow
    private final BinaryHeap openSet = new BinaryHeap();
    @Final
    @Shadow
    private final Node[] neighbors = new Node[32];
    @Mutable
    @Final
    @Shadow
    private final NodeEvaluator nodeEvaluator;
    @Mutable
    @Final
    @Shadow
    private final int maxVisitedNodes;

    @Shadow
    private Path reconstructPath(Node node, BlockPos pos, boolean bl) {
        return null;
    }

    public PathFinderMixin(NodeEvaluator nodeEvaluator, int maxVisitedNodes) {
        this.nodeEvaluator = nodeEvaluator;
        this.maxVisitedNodes = maxVisitedNodes;
    }

    @Overwrite
    private float getBestH(Node node, Set<Target> targets) {
        float f = Float.MAX_VALUE;
        for (Target target : targets) {
            float g = node.distanceToSqr((Node)target);
            target.updateBest(g, node);
            f = Math.min(g, f);
        }
        return f * 3.0f / 2.0f;
    }

    @Overwrite
    @Nullable
    private Path findPath(ProfilerFiller profiler, Node node, Map<Target, BlockPos> targetPos, float maxRange, int accuracy, float searchDepthMultiplier) {
        profiler.push("find_path");
        profiler.markForCharting(MetricCategory.PATH_FINDING);
        Set<Target> set = targetPos.keySet();
        ArrayList target_list = Lists.newArrayListWithExpectedSize((int)set.size());
        int j = (int)((float)this.maxVisitedNodes * searchDepthMultiplier);
        int i = 0;
        float range2 = maxRange * maxRange;
        node.g = 0.0f;
        node.f = node.h = this.getBestH(node, set);
        this.openSet.clear();
        this.openSet.insert(node);
        while (!this.openSet.isEmpty() && ++i < j) {
            Node node2 = this.openSet.pop();
            node2.closed = true;
            for (Target target : set) {
                if (!(node2.distanceManhattan((Node)target) <= (float)accuracy)) continue;
                target.setReached();
                target_list.add(target);
            }
            if (!target_list.isEmpty()) break;
            if (!(node2.distanceToSqr(node) < range2)) continue;
            int k = this.nodeEvaluator.getNeighbors(this.neighbors, node2);
            for (int l = 0; l < k; ++l) {
                Node node3 = this.neighbors[l];
                float f = node2.distanceToSqr(node3);
                float g = node2.g + f + node3.costMalus;
                node3.walkedDistance = node2.walkedDistance + f;
                if (!(node3.walkedDistance < maxRange) || node3.inOpenSet() && !(g < node3.g)) continue;
                node3.cameFrom = node2;
                node3.g = g;
                node3.h = this.getBestH(node3, set);
                if (node3.inOpenSet()) {
                    this.openSet.changeCost(node3, node3.g + node3.h);
                    continue;
                }
                node3.f = node3.g + node3.h;
                this.openSet.insert(node3);
            }
        }
        Optional<Path> optional = !target_list.isEmpty() ? target_list.stream().map(tg -> this.reconstructPath(tg.getBestNode(), (BlockPos)targetPos.get(tg), true)).min(Comparator.comparingInt(path -> path != null ? path.getNodeCount() : 0)) : set.stream().map(x -> this.reconstructPath(x.getBestNode(), (BlockPos)targetPos.get(x), false)).min(Comparator.comparingDouble(Path::getDistToTarget).thenComparingInt(Path::getNodeCount));
        profiler.pop();
        return optional.orElse(null);
    }
}

