/*
 * Decompiled with CFR 0.152.
 */
package net.picopress.mc.mods.zombietactics2.goals;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.picopress.mc.mods.zombietactics2.attachments.MiningData;

public abstract class BreakBlockGoal
extends Goal {
    public final MiningData mine;
    protected final Level level;
    protected final Mob mob;
    private final double hardnessMultiplier;
    private final double break_speed;
    private final boolean dropBlock;
    protected double progress;
    protected double hardness = Double.MAX_VALUE;

    public BreakBlockGoal(Mob mob, double hardnessMultiplier, double break_speed, boolean dropBlock) {
        this.mine = new MiningData();
        this.level = mob.level();
        this.mob = mob;
        this.hardnessMultiplier = hardnessMultiplier;
        this.break_speed = break_speed;
        this.dropBlock = dropBlock;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK));
    }

    protected boolean checkBlock(BlockPos pos) {
        BlockState state = this.level.getBlockState(pos);
        Block b = state.getBlock();
        return !b.isPossibleToRespawnInThis(state) && b.defaultDestroyTime() >= 0.0f && state.getFluidState().isEmpty();
    }

    public void terminate() {
        this.level.destroyBlockProgress(this.mob.getId(), this.mine.bp, -1);
        this.progress = 0.0;
        this.mine.doMining = false;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public boolean canUse() {
        return !this.mob.isNoAi() && this.mob.isAlive();
    }

    public void start() {
        this.progress = 0.0;
        this.hardness = (double)this.level.getBlockState(this.mine.bp).getBlock().defaultDestroyTime() * this.hardnessMultiplier;
        this.mine.doMining = true;
    }

    public void stop() {
        this.level.destroyBlockProgress(this.mob.getId(), this.mine.bp, -1);
        this.mine.doMining = false;
        this.mine.bp = null;
        this.mob.getNavigation().recomputePath();
        this.progress = 0.0;
        this.hardness = Double.MAX_VALUE;
    }

    public void tick() {
        if (!this.mine.doMining) {
            return;
        }
        if (this.level.getBlockState(this.mine.bp).isAir()) {
            this.terminate();
            return;
        }
        if (this.progress >= this.hardness) {
            this.level.destroyBlock(this.mine.bp, this.dropBlock, (Entity)this.mob);
            this.terminate();
        } else {
            this.level.destroyBlockProgress(this.mob.getId(), this.mine.bp, (int)(this.progress / this.hardness * 10.0));
            this.mob.stopInPlace();
            this.mob.getLookControl().setLookAt(this.mine.bp_vec3);
            this.progress += this.break_speed;
            this.mob.swing(InteractionHand.MAIN_HAND);
        }
    }

    public boolean canContinueToUse() {
        return this.mine.doMining;
    }
}

