/*
 * Decompiled with CFR 0.152.
 */
package net.picopress.mc.mods.zombietactics2.goals.mining;

import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.pathfinder.Path;
import net.picopress.mc.mods.zombietactics2.Config;
import net.picopress.mc.mods.zombietactics2.goals.BreakBlockGoal;
import net.picopress.mc.mods.zombietactics2.util.Tactics;

public class DestroyBlockGoal
extends BreakBlockGoal {
    private final Block block;
    private int delay = 0;
    private int y;
    private final int range;

    public DestroyBlockGoal(Mob mob, Block block, int range) {
        super(mob, Config.hardnessMultiplier, Config.break_speed, false);
        this.block = block;
        this.range = range;
        this.y = -range;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    @Override
    public boolean canUse() {
        if (!super.canUse()) {
            return false;
        }
        ++this.delay;
        if (this.delay < 2) {
            return false;
        }
        this.delay = 0;
        BlockPos mob_pos = this.mob.blockPosition();
        double dist = Double.MAX_VALUE;
        List<BlockPos> positions = Tactics.World.findBlocks(this.level, this.block, mob_pos.getX() - this.range, mob_pos.getY() + this.y, mob_pos.getZ() - this.range, mob_pos.getX() + this.range, mob_pos.getY() + this.y, mob_pos.getZ() + this.range);
        ++this.y;
        if (this.y > this.range) {
            this.y = -this.range;
        }
        if (positions.isEmpty()) {
            return false;
        }
        for (BlockPos pos : positions) {
            double d = this.mob.distanceToSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
            if (!(d < dist)) continue;
            dist = d;
            this.mine.bp = pos;
            this.mine.bp_vec3 = pos.getCenter();
        }
        Path p = this.mob.getNavigation().createPath(this.mine.bp, 1);
        if (p == null || p.getEndNode() == null || !(p.getEndNode().distanceManhattan(this.mine.bp) < 3.0f)) {
            return false;
        }
        this.mob.getNavigation().moveTo(p, 1.0);
        return Tactics.World.ManhattanDistance(Objects.requireNonNull(this.mine.bp), this.mob.blockPosition()) < 3;
    }
}

