/*
 * Decompiled with CFR 0.152.
 */
package net.picopress.mc.mods.zombietactics2.goals.target;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.picopress.mc.mods.zombietactics2.Config;
import net.picopress.mc.mods.zombietactics2.attachments.FindTargetType;
import net.picopress.mc.mods.zombietactics2.util.Tactics;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Pair;

public class FindAllTargetsGoal
extends TargetGoal {
    public static final List<Pair<LivingEntity, Path>> cache_path = new ArrayList<Pair<LivingEntity, Path>>();
    private final List<Pair<Class<? extends LivingEntity>, Integer>> list;
    private final List<LivingEntity> imposters = new ArrayList<LivingEntity>();
    private TargetingConditions targetingConditions;
    @Nullable
    private final ServerLevel serverLevel;
    private int delay;
    private int idx;
    private Task task;

    public FindAllTargetsGoal(List<Pair<Class<? extends LivingEntity>, Integer>> targets, Mob mob, boolean mustSee) {
        super(mob, mustSee);
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
        this.list = targets;
        this.serverLevel = Tactics.getServerLevel(mob);
        this.targetingConditions = TargetingConditions.forCombat().range((double)Config.followRange).selector(null);
        if (Config.attackInvisible) {
            this.targetingConditions = this.targetingConditions.ignoreLineOfSight();
        }
    }

    public boolean canUse() {
        return this.mob.getTarget() == null;
    }

    public void start() {
        this.idx = 0;
        this.delay = 0;
        this.task = Task.IDLE;
    }

    public void tick() {
        if (this.serverLevel == null) {
            return;
        }
        if (this.task == Task.IDLE) {
            ++this.delay;
            if (Config.findTargetType == FindTargetType.SIMPLE && this.delay > 4) {
                this.task = Task.SEARCH;
            } else if (this.delay > 6) {
                this.task = Task.SEARCH;
            }
        } else if (this.task == Task.SEARCH) {
            if (Config.findTargetType == FindTargetType.SIMPLE) {
                Pair<Class<? extends LivingEntity>, Integer> clazz = this.list.get(this.idx);
                Object target = clazz.getA() != Player.class && clazz.getA() != ServerPlayer.class ? this.serverLevel.getNearestEntity((Class)clazz.getA(), this.targetingConditions, (LivingEntity)this.mob, this.mob.getX(), this.mob.getEyeY(), this.mob.getZ(), this.followBox()) : this.serverLevel.getNearestPlayer(this.targetingConditions, (LivingEntity)this.mob, this.mob.getX(), this.mob.getEyeY(), this.mob.getZ());
                if (this.mob.getTarget() == null || target != null && this.mob.getTarget() != null && this.mob.distanceToSqr((Entity)target) < this.mob.distanceToSqr((Entity)this.mob.getTarget())) {
                    this.mob.setTarget((LivingEntity)target);
                }
                ++this.idx;
                this.idx %= this.list.size();
                this.task = Task.IDLE;
            } else {
                List imposter2 = this.mob.level().getEntitiesOfClass(LivingEntity.class, this.followBox(), t -> {
                    for (Pair<Class<? extends LivingEntity>, Integer> sus : this.list) {
                        if (!((Class)sus.getA()).isAssignableFrom(t.getClass()) || !this.targetingConditions.test(this.serverLevel, (LivingEntity)this.mob, t)) continue;
                        return true;
                    }
                    return false;
                });
                for (LivingEntity imposter : imposter2) {
                    if (imposter == null) continue;
                    this.imposters.add(imposter);
                }
                this.task = Task.PRIORITIZE;
            }
            this.delay = 0;
        } else if (this.task == Task.PRIORITIZE) {
            BlockPos me = this.mob.blockPosition();
            LivingEntity target = null;
            int minimumCost = Integer.MAX_VALUE;
            for (LivingEntity amogus : this.imposters) {
                Path path;
                BlockPos delta = me.subtract((Vec3i)amogus.blockPosition());
                int score = 0;
                int idx = 0;
                if (Config.findTargetType == FindTargetType.INTENSIVE) {
                    boolean found = false;
                    Path path2 = null;
                    for (Pair<LivingEntity, Path> p : cache_path) {
                        if (p.getA() != amogus) continue;
                        path2 = (Path)p.getB();
                        found = true;
                        break;
                    }
                    if (!found) {
                        path2 = this.mob.getNavigation().createPath((Entity)amogus, Config.accuracy);
                        cache_path.add((Pair<LivingEntity, Path>)new Pair((Object)amogus, (Object)path2));
                    }
                    if (path2 != null) {
                        score += path2.getNodeCount();
                        if (!path2.canReach()) {
                            score *= 128;
                        }
                    }
                } else if (Config.findTargetType == FindTargetType.LINEAR) {
                    BlockPos.MutableBlockPos bp = this.mob.blockPosition().mutable();
                    double len = this.mob.distanceTo((Entity)amogus);
                    int i = 0;
                    while ((double)i <= len) {
                        double cache = (double)i / len;
                        score = !this.mob.level().getBlockState((BlockPos)bp.set((double)delta.getX() * cache, (double)delta.getY() * cache, (double)delta.getZ() * cache)).isAir() ? (score += Config.blockCost) : ++score;
                        ++i;
                    }
                } else if (Config.findTargetType == FindTargetType.OVERLOAD && (path = this.mob.getNavigation().createPath((Entity)amogus, Config.accuracy)) != null) {
                    score += path.getNodeCount();
                    if (!path.canReach()) {
                        score *= 128;
                    }
                }
                for (Pair<Class<? extends LivingEntity>, Integer> p : this.list) {
                    if (((Class)p.getA()).isAssignableFrom(amogus.getClass())) break;
                    ++idx;
                }
                score *= ((Integer)this.list.get(idx).getB()).intValue();
                if (this.mob.hasLineOfSight((Entity)amogus)) {
                    score /= 2;
                }
                if (delta.getY() >= -2) {
                    score /= 2;
                }
                if (score >= minimumCost) continue;
                minimumCost = score;
                target = amogus;
            }
            if (target != null) {
                this.mob.setTarget(target);
            }
            this.imposters.clear();
            this.task = Task.IDLE;
        }
    }

    public boolean canContinueToUse() {
        return this.canUse() || super.canContinueToUse();
    }

    private AABB followBox() {
        return this.mob.getBoundingBox().inflate(this.getFollowDistance());
    }

    public static enum Task {
        SEARCH,
        PRIORITIZE,
        IDLE;

    }
}

