/*
 * Decompiled with CFR 0.152.
 */
package net.picopress.mc.mods.zombietactics2.mixin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.BreakDoorGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.picopress.mc.mods.zombietactics2.Config;
import net.picopress.mc.mods.zombietactics2.goals.mining.DestroyBlockGoal;
import net.picopress.mc.mods.zombietactics2.goals.mining.MonsterBreakBlockGoal;
import net.picopress.mc.mods.zombietactics2.goals.move.SelectiveFloatGoal;
import net.picopress.mc.mods.zombietactics2.goals.move.ZombieGoal;
import net.picopress.mc.mods.zombietactics2.goals.target.FindAllTargetsGoal;
import net.picopress.mc.mods.zombietactics2.goals.target.GoToWantedItemGoal;
import net.picopress.mc.mods.zombietactics2.impl.Plane;
import net.picopress.mc.mods.zombietactics2.util.Tactics;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import oshi.util.tuples.Pair;

@Mixin(value={Zombie.class})
public abstract class ZombieMixin
extends Monster
implements Plane {
    @Unique
    private static final List<Pair<Class<? extends LivingEntity>, Integer>> zombie_tactics$target_priority = new ArrayList<Pair<Class<? extends LivingEntity>, Integer>>();
    @Unique
    private static final Set<Class<? extends LivingEntity>> zombie_tactics$target_class = new HashSet<Class<? extends LivingEntity>>();
    @Unique
    private static int zombie_tactics$threshold = 0;
    @Unique
    private MonsterBreakBlockGoal<? extends Monster> zombie_tactics$mine_goal;
    @Unique
    private BreakDoorGoal zombie_tactics$bdg;
    @Unique
    private int zombieTactics$climbedCount = 0;
    @Unique
    private boolean zombieTactics$isClimbing = false;
    @Unique
    private boolean zombie_tactics$persistence;
    @Final
    @Shadow
    private static Predicate<Difficulty> DOOR_BREAKING_PREDICATE;
    @Shadow
    private int inWaterTime;

    @Shadow
    public abstract boolean canBreakDoors();

    @Shadow
    public abstract void readAdditionalSaveData(CompoundTag var1);

    public ZombieMixin(EntityType<? extends Zombie> entityType, Level level) {
        super(entityType, level);
    }

    protected void checkFallDamage(double y, boolean onGround, @NotNull BlockState state, @NotNull BlockPos pos) {
        if (this.zombieTactics$isClimbing && onGround) {
            this.fallDistance = 0.0f;
            this.zombieTactics$isClimbing = false;
            this.zombieTactics$climbedCount = 0;
        }
        super.checkFallDamage(y, onGround, state, pos);
    }

    protected float getFlyingSpeed() {
        return (float)this.getAttributeValue((Holder<Attribute>)Attributes.FLYING_SPEED);
    }

    @NotNull
    protected AABB getAttackBoundingBox() {
        AABB aabb;
        Entity entity = this.getVehicle();
        if (entity != null) {
            AABB aabb1 = entity.getBoundingBox();
            AABB aabb2 = this.getBoundingBox();
            aabb = new AABB(Math.min(aabb2.minX, aabb1.minX), aabb2.minY, Math.min(aabb2.minZ, aabb1.minZ), Math.max(aabb2.maxX, aabb1.maxX), aabb2.maxY, Math.max(aabb2.maxZ, aabb1.maxZ));
        } else {
            aabb = this.getBoundingBox();
        }
        return aabb.inflate(Config.attackRange, Config.attackRange, Config.attackRange);
    }

    public int getMaxSpawnClusterSize() {
        return 32;
    }

    @Override
    public int zombie_tactics$getInt(int id) {
        if (id == 0) {
            return this.inWaterTime;
        }
        if (id == 1) {
            return this.zombieTactics$climbedCount;
        }
        return 0;
    }

    @Override
    public boolean zombie_tactics$getBool(int id) {
        if (id == 0) {
            if (this.zombie_tactics$mine_goal == null) {
                return false;
            }
            return this.zombie_tactics$mine_goal.mine.doMining;
        }
        return false;
    }

    public double getAttributeValue(Holder<Attribute> attribute) {
        if (attribute == Attributes.FOLLOW_RANGE) {
            return Config.followRange;
        }
        return super.getAttributeValue(attribute);
    }

    public boolean wantsToPickUp(ServerLevel sl, @NotNull ItemStack stack) {
        Item item = stack.getItem();
        if (stack.is(ItemTags.WEAPON_ENCHANTABLE)) {
            ItemStack my = this.getMainHandItem();
            if (my.is(ItemTags.WEAPON_ENCHANTABLE)) {
                AttributeModifier my_weapon = Tactics.getItemAttr(my, "attack_damage");
                AttributeModifier other = Tactics.getItemAttr(stack, "attack_damage");
                if (my_weapon == null || other == null) {
                    return false;
                }
                return my_weapon.amount() < other.amount();
            }
            return this.getMainHandItem().is(Items.AIR);
        }
        if (stack.is(ItemTags.ARMOR_ENCHANTABLE)) {
            ItemStack slot = this.getItemBySlot(Objects.requireNonNull((Equippable)item.components().get(DataComponents.EQUIPPABLE)).slot());
            if (slot.is(Items.AIR)) {
                return true;
            }
            if (slot.getItem().components().has(DataComponents.EQUIPPABLE)) {
                AttributeModifier dropped = Tactics.getItemAttr(stack, "armor_toughness");
                AttributeModifier equipped = Tactics.getItemAttr(slot, "armor_toughness");
                if (dropped != null && equipped != null) {
                    return equipped.amount() < dropped.amount();
                }
                System.out.println("what the fuck [mine: " + String.valueOf(equipped) + ", other:" + String.valueOf(dropped));
            }
        }
        return false;
    }

    public boolean isPersistenceRequired() {
        return this.zombie_tactics$persistence || super.isPersistenceRequired();
    }

    public void push(@NotNull Entity entity) {
        if (this.zombie_tactics$bdg != null && Config.zombiesClimbing && entity instanceof Zombie && (this.horizontalCollision || Config.hyperClimbing) && !((Plane)this.zombie_tactics$bdg).zombie_tactics$getBool(0) && this.zombieTactics$climbedCount < Config.climbLimitTicks) {
            Vec3 v = this.getDeltaMovement();
            if (Config.randomlyClimb) {
                this.setDeltaMovement(v.x + (this.getRandom().nextDouble() - 0.5) / 64.0, Config.climbingSpeed, v.z + (this.getRandom().nextDouble() - 0.5) / 64.0);
            } else {
                this.setDeltaMovement(v.x, Config.climbingSpeed, v.z);
            }
            this.zombieTactics$isClimbing = true;
            ++this.zombieTactics$climbedCount;
        }
        super.push(entity);
    }

    public boolean removeWhenFarAway(double d) {
        if (Config.noDespawn) {
            return false;
        }
        return super.removeWhenFarAway(d);
    }

    public void remove(Entity.RemovalReason reason) {
        super.remove(reason);
        --zombie_tactics$threshold;
    }

    public void die(@NotNull DamageSource source) {
        super.die(source);
        if (this.zombie_tactics$mine_goal != null && this.zombie_tactics$mine_goal.mine.doMining) {
            this.level().destroyBlockProgress(this.getId(), this.zombie_tactics$mine_goal.mine.bp, -1);
        }
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader level) {
        return Config.spawnUnderSun ? 0.0f : super.getWalkTargetValue(pos, level);
    }

    @Inject(method={"createAttributes()Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;"}, at={@At(value="RETURN")}, cancellable=true)
    private static void createAttributes(CallbackInfoReturnable<AttributeSupplier.Builder> cir) {
        cir.setReturnValue((Object)((AttributeSupplier.Builder)cir.getReturnValue()).add(Attributes.FLYING_SPEED, Config.flySpeed));
    }

    @Inject(method={"hurtServer(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at={@At(value="HEAD")})
    public void hurtServer(ServerLevel sl, DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        Entity who = source.getEntity();
        if (who instanceof PathfinderMob) {
            PathfinderMob mob = (PathfinderMob)who;
            if (!(who instanceof Monster) && !zombie_tactics$target_class.contains(who.getClass())) {
                zombie_tactics$target_priority.add((Pair<Class<? extends LivingEntity>, Integer>)new Pair(mob.getClass(), (Object)3));
                zombie_tactics$target_class.add(mob.getClass());
            }
        }
    }

    @Inject(method={"<init>(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V"}, at={@At(value="TAIL")})
    public void constructor(EntityType<? extends Zombie> entityType, Level level, CallbackInfo ci) {
        double tmp = this.level().random.nextDouble();
        boolean bl = this.zombie_tactics$persistence = tmp <= Config.persistenceChance;
        if (this.zombie_tactics$persistence && zombie_tactics$threshold < Config.maxThreshold) {
            ++zombie_tactics$threshold;
        } else {
            this.zombie_tactics$persistence = false;
        }
        if (this.zombie_tactics$persistence) {
            this.setPersistenceRequired();
        }
        if (Config.canFly) {
            this.moveControl = new FlyingMoveControl((Mob)this, 360, true);
            this.navigation = new FlyingPathNavigation((Mob)this, level);
            Objects.requireNonNull(this.getAttribute(Attributes.FLYING_SPEED)).setBaseValue(Config.flySpeed);
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    public void tick(CallbackInfo ci) {
        if (!this.canPickUpLoot()) {
            this.setCanPickUpLoot(true);
        }
        if (Config.canFly) {
            this.fallDistance = 0.0f;
        }
        if (Config.showDeltaMovement) {
            this.setCustomName((Component)Component.literal((String)String.valueOf(this.getDeltaMovement().length())));
            this.setCustomNameVisible(true);
        }
        if (Config.noIdle) {
            this.setNoActionTime(0);
        }
    }

    @Inject(method={"doHurtTarget(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/Entity;)Z"}, at={@At(value="HEAD")})
    public void doHurtTargetHead(ServerLevel sl, Entity entity, CallbackInfoReturnable<Boolean> cir) {
        if (this.zombie_tactics$mine_goal != null) {
            this.zombie_tactics$mine_goal.mine.doMining = false;
        }
    }

    @Inject(method={"doHurtTarget(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/Entity;)Z"}, at={@At(value="TAIL")})
    public void doHurtTargetTail(ServerLevel sl, Entity ent, CallbackInfoReturnable<Boolean> ci) {
        if (ent instanceof LivingEntity && this.getHealth() <= this.getMaxHealth()) {
            this.heal((float)Config.healAmount);
        }
        if (Config.noMercy) {
            ent.invulnerableTime = 0;
        }
    }

    @Inject(method={"isSunSensitive()Z"}, at={@At(value="RETURN")}, cancellable=true)
    public void isSunSensitive(CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)Config.sunSensitive);
    }

    @Overwrite
    public void addBehaviourGoals() {
        if (Config.targetAnimals && !zombie_tactics$target_class.contains(Animal.class)) {
            zombie_tactics$target_priority.add((Pair<Class<? extends LivingEntity>, Integer>)new Pair(Animal.class, (Object)5));
            zombie_tactics$target_class.add(Animal.class);
        }
        if (Config.mineBlocks) {
            this.zombie_tactics$mine_goal = new MonsterBreakBlockGoal<ZombieMixin>(this);
            this.goalSelector.addGoal(1, this.zombie_tactics$mine_goal);
        }
        if (Config.canFloat) {
            this.goalSelector.addGoal(5, (Goal)new SelectiveFloatGoal((Mob)this));
        }
        if (Config.canFly) {
            this.goalSelector.addGoal(10, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        } else {
            this.goalSelector.addGoal(10, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        }
        if (Config.breakChest) {
            this.goalSelector.addGoal(6, (Goal)new DestroyBlockGoal((Mob)this, Blocks.CHEST, Config.findChest));
        }
        this.targetSelector.addGoal(3, (Goal)new FindAllTargetsGoal(zombie_tactics$target_priority, (Mob)this, false));
        this.goalSelector.addGoal(1, (Goal)new ZombieGoal((Zombie)this, Config.aggressiveSpeed, true));
        this.goalSelector.addGoal(7, (Goal)new MoveThroughVillageGoal((PathfinderMob)this, 1.0, false, 4, this::canBreakDoors));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[]{ZombifiedPiglin.class}));
        this.zombie_tactics$bdg = new BreakDoorGoal((Mob)this, DOOR_BREAKING_PREDICATE);
        this.goalSelector.addGoal(1, (Goal)this.zombie_tactics$bdg);
        this.goalSelector.addGoal(5, (Goal)new GoToWantedItemGoal((Mob)this, item -> this.wantsToPickUp(Tactics.getSl((Mob)this), (ItemStack)item)));
    }

    static {
        zombie_tactics$target_priority.add((Pair<Class<? extends LivingEntity>, Integer>)new Pair(Player.class, (Object)2));
        zombie_tactics$target_priority.add((Pair<Class<? extends LivingEntity>, Integer>)new Pair(AbstractVillager.class, (Object)3));
        zombie_tactics$target_priority.add((Pair<Class<? extends LivingEntity>, Integer>)new Pair(IronGolem.class, (Object)3));
        zombie_tactics$target_priority.add((Pair<Class<? extends LivingEntity>, Integer>)new Pair(Turtle.class, (Object)3));
        zombie_tactics$target_class.add(Player.class);
        zombie_tactics$target_class.add(AbstractVillager.class);
        zombie_tactics$target_class.add(IronGolem.class);
        zombie_tactics$target_class.add(Turtle.class);
    }
}

