/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.scriptblocks;

import com.github.theredbrain.scriptblocks.block.entity.PVPControllerBlockEntity;
import com.github.theredbrain.scriptblocks.compatibility.LootableCompat;
import com.github.theredbrain.scriptblocks.config.ServerConfig;
import com.github.theredbrain.scriptblocks.entity.player.DuckPlayerEntityMixin;
import com.github.theredbrain.scriptblocks.registry.BlockRegistry;
import com.github.theredbrain.scriptblocks.registry.CustomDynamicRegistries;
import com.github.theredbrain.scriptblocks.registry.EntityRegistry;
import com.github.theredbrain.scriptblocks.registry.EventsRegistry;
import com.github.theredbrain.scriptblocks.registry.GameRulesRegistry;
import com.github.theredbrain.scriptblocks.registry.ItemComponentRegistry;
import com.github.theredbrain.scriptblocks.registry.ItemGroupRegistry;
import com.github.theredbrain.scriptblocks.registry.ItemRegistry;
import com.github.theredbrain.scriptblocks.registry.ScreenHandlerTypesRegistry;
import com.github.theredbrain.scriptblocks.registry.ServerPacketRegistry;
import com.github.theredbrain.scriptblocks.registry.StatusEffectsRegistry;
import com.github.theredbrain.scriptblocks.registry.StructurePlacementTypesRegistry;
import com.github.theredbrain.scriptblocks.world.DimensionsManager;
import java.util.Optional;
import me.fzzyhmstrs.fzzy_config.api.ConfigApiJava;
import me.fzzyhmstrs.fzzy_config.api.RegisterType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_268;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import org.apache.commons.lang3.tuple.MutablePair;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptBlocks
implements ModInitializer {
    public static final String MOD_ID = "scriptblocks";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"scriptblocks");
    public static ServerConfig SERVER_CONFIG;
    public static final boolean isLootablesLoaded;

    public static void supplyLootableLoot(class_2960 identifier, class_3218 world, class_3222 serverPlayerEntity, class_243 pos, int rolls, int choices, boolean withChoice, @Nullable class_1799 itemStack) {
        if (isLootablesLoaded) {
            LootableCompat.supplyLootableLoot(identifier, world, serverPlayerEntity, pos, rolls, choices, withChoice, itemStack);
        } else {
            ScriptBlocks.info("Tried to supply loot via Lootables, but the mod is not installed!");
        }
    }

    public static void setCurrentPVPControllerBlockPosition(class_1657 playerEntity, Optional<class_2338> currentPVPControllerBlockPosition) {
        ((DuckPlayerEntityMixin)playerEntity).scriptblocks$setCurrentPVPControllerBlockPosition(currentPVPControllerBlockPosition);
    }

    public static void addPlayerAndTeamToPVPControllerBlock(class_268 team, class_1657 playerEntity, class_3218 serverWorld, Optional<class_2338> currentPVPControllerBlockPosition) {
        class_2586 class_25862;
        if (currentPVPControllerBlockPosition.isPresent() && (class_25862 = serverWorld.method_8321(currentPVPControllerBlockPosition.get())) instanceof PVPControllerBlockEntity) {
            PVPControllerBlockEntity pvpControllerBlockEntity = (PVPControllerBlockEntity)class_25862;
            pvpControllerBlockEntity.addPlayerAndTeam(team, playerEntity);
        }
    }

    public static void removePlayerFromPVPControllerBlock(class_1657 playerEntity, class_3218 serverWorld, Optional<class_2338> currentPVPControllerBlockPosition) {
        class_2586 class_25862;
        if (currentPVPControllerBlockPosition.isPresent() && (class_25862 = serverWorld.method_8321(currentPVPControllerBlockPosition.get())) instanceof PVPControllerBlockEntity) {
            PVPControllerBlockEntity pvpControllerBlockEntity = (PVPControllerBlockEntity)class_25862;
            pvpControllerBlockEntity.removePlayer(playerEntity);
        }
    }

    @Nullable
    public static MutablePair<class_5321<class_1937>, MutablePair<class_2338, MutablePair<Double, Double>>> getPVPRespawnPosition(class_268 team, class_3222 serverPlayerEntity, boolean endOfBattle) {
        Optional<class_2338> optionalBlockPos = ((DuckPlayerEntityMixin)serverPlayerEntity).scriptblocks$getCurrentPVPControllerBlockPosition();
        class_1937 world = serverPlayerEntity.method_37908();
        if (optionalBlockPos.isPresent() && team != null && world instanceof class_3218) {
            PVPControllerBlockEntity pvpControllerBlockEntity;
            MutablePair<class_2338, MutablePair<Double, Double>> teamRespawnPos;
            class_3218 serverWorld = (class_3218)world;
            String teamId = team.method_1197();
            class_2586 blockEntity = serverWorld.method_8321(optionalBlockPos.get());
            if (blockEntity instanceof PVPControllerBlockEntity && (teamRespawnPos = (pvpControllerBlockEntity = (PVPControllerBlockEntity)blockEntity).getTeamRespawnPosition(teamId, endOfBattle)) != null) {
                if (endOfBattle) {
                    pvpControllerBlockEntity.removePlayer((class_1657)serverPlayerEntity);
                }
                return new MutablePair((Object)serverWorld.method_27983(), (Object)new MutablePair((Object)((class_2338)teamRespawnPos.getLeft()), (Object)new MutablePair((Object)((Double)((MutablePair)teamRespawnPos.getRight()).getLeft()), (Object)((Double)((MutablePair)teamRespawnPos.getRight()).getRight()))));
            }
        }
        return null;
    }

    public void onInitialize() {
        LOGGER.info("This was scripted!");
        SERVER_CONFIG = (ServerConfig)ConfigApiJava.registerAndLoadConfig(ServerConfig::new, (RegisterType)RegisterType.BOTH);
        ServerPacketRegistry.init();
        ItemComponentRegistry.init();
        BlockRegistry.init();
        EntityRegistry.init();
        DimensionsManager.init();
        EventsRegistry.initializeEvents();
        CustomDynamicRegistries.init();
        ItemRegistry.init();
        ItemGroupRegistry.init();
        ScreenHandlerTypesRegistry.registerAll();
        StatusEffectsRegistry.registerEffects();
        GameRulesRegistry.init();
        StructurePlacementTypesRegistry.register();
    }

    public static class_2960 identifier(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    public static void info(String message) {
        LOGGER.info("[scriptblocks] [info]: " + message);
    }

    public static void warn(String message) {
        LOGGER.warn("[scriptblocks] [warn]: " + message);
    }

    public static void debug(String message) {
        LOGGER.debug("[scriptblocks] [debug]: " + message);
    }

    public static void error(String message) {
        LOGGER.error("[scriptblocks] [error]: " + message);
    }

    static {
        isLootablesLoaded = FabricLoader.getInstance().isModLoaded("lootables");
    }
}

