/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.scriptblocks.block;

import com.github.theredbrain.scriptblocks.block.ProvidesData;
import com.github.theredbrain.scriptblocks.data.CommonDataStructures;
import com.github.theredbrain.scriptblocks.data.Dialogue;
import com.github.theredbrain.scriptblocks.data.DialogueAnswer;
import com.github.theredbrain.scriptblocks.registry.CustomDynamicRegistries;
import com.github.theredbrain.scriptblocks.screen.DialogueScreenHandler;
import com.github.theredbrain.scriptblocks.util.ItemUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_2985;
import net.minecraft.class_2989;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_6880;
import net.minecraft.class_8779;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.MutablePair;
import org.jetbrains.annotations.Nullable;

public interface DialogueAnchor {
    public class_2338 getDataBlockPos();

    public List<MutablePair<String, class_2338>> getDialogueUsedBlocks();

    public List<MutablePair<String, MutablePair<class_2338, Boolean>>> getDialogueTriggeredBlocks();

    public static String getDialogue(class_1937 world, class_1657 player, List<String> dialogueList) {
        if (dialogueList.isEmpty()) {
            return "";
        }
        class_2985 playerAdvancementTracker = null;
        class_2989 serverAdvancementLoader = null;
        if (player instanceof class_3222) {
            class_3222 serverPlayerEntity = (class_3222)player;
            playerAdvancementTracker = serverPlayerEntity.method_14236();
            MinecraftServer minecraftServer = serverPlayerEntity.method_5682();
            if (minecraftServer != null) {
                serverAdvancementLoader = minecraftServer.method_3851();
            }
        }
        for (String dialogueEntry : dialogueList) {
            Optional optionalDialogueReference = world.method_30349().method_30530(CustomDynamicRegistries.DIALOGUE_REGISTRY_KEY).method_55841(class_2960.method_12829((String)dialogueEntry));
            if (!optionalDialogueReference.isPresent()) continue;
            String lockAdvancement = ((Dialogue)((class_6880.class_6883)optionalDialogueReference.get()).comp_349()).lockAdvancement();
            String unlockAdvancement = ((Dialogue)((class_6880.class_6883)optionalDialogueReference.get()).comp_349()).unlockAdvancement();
            class_8779 lockAdvancementEntry = null;
            class_8779 unlockAdvancementEntry = null;
            if (serverAdvancementLoader != null) {
                if (!lockAdvancement.isEmpty()) {
                    lockAdvancementEntry = serverAdvancementLoader.method_12896(class_2960.method_60654((String)lockAdvancement));
                }
                if (!unlockAdvancement.isEmpty()) {
                    unlockAdvancementEntry = serverAdvancementLoader.method_12896(class_2960.method_60654((String)unlockAdvancement));
                }
            }
            if (playerAdvancementTracker == null || !lockAdvancement.isEmpty() && (lockAdvancementEntry == null || playerAdvancementTracker.method_12882(lockAdvancementEntry).method_740()) || !unlockAdvancement.isEmpty() && (unlockAdvancementEntry == null || !playerAdvancementTracker.method_12882(unlockAdvancementEntry).method_740())) continue;
            return dialogueEntry;
        }
        return "";
    }

    public static void openDialogueScreen(class_1937 world, MinecraftServer server, class_3222 serverPlayerEntity, final String dialogueIdentifierString, final class_2338 dataBlockPos, final List<MutablePair<String, class_2338>> dialogueUsedBlocks, final List<MutablePair<String, MutablePair<class_2338, Boolean>>> dialogueTriggeredBlocks) {
        Optional optionalDialogueReference = world.method_30349().method_30530(CustomDynamicRegistries.DIALOGUE_REGISTRY_KEY).method_55841(class_2960.method_12829((String)dialogueIdentifierString));
        if (optionalDialogueReference.isPresent()) {
            Dialogue dialogue = (Dialogue)((class_6880.class_6883)optionalDialogueReference.get()).comp_349();
            final ArrayList<String> unlockedAnswersList = new ArrayList<String>(List.of());
            final ArrayList<String> visibleAnswersList = new ArrayList<String>(List.of());
            class_2985 playerAdvancementTracker = serverPlayerEntity.method_14236();
            class_2989 serverAdvancementLoader = server.method_3851();
            for (String answerIdentifierString : dialogue.answerList()) {
                if (!answerIdentifierString.isEmpty()) {
                    class_2586 blockEntity;
                    DialogueAnswer dialogueAnswer = null;
                    Optional optionalDialogueAnswerReference1 = world.method_30349().method_30530(CustomDynamicRegistries.DIALOGUE_ANSWER_REGISTRY_KEY).method_55841(class_2960.method_60654((String)answerIdentifierString));
                    if (optionalDialogueAnswerReference1.isPresent()) {
                        dialogueAnswer = (DialogueAnswer)((class_6880.class_6883)optionalDialogueAnswerReference1.get()).comp_349();
                    }
                    if (dialogueAnswer == null) continue;
                    boolean isItemCostAffordable = true;
                    if (!dialogueAnswer.availability().itemCosts().isEmpty()) {
                        int inventorySize = serverPlayerEntity.method_31548().method_5439();
                        class_1277 playerInventoryCopy = new class_1277(inventorySize);
                        for (int k = 0; k < inventorySize; ++k) {
                            playerInventoryCopy.method_5447(k, serverPlayerEntity.method_31548().method_5438(k).method_7972());
                        }
                        for (CommonDataStructures.ItemCost itemCost : dialogueAnswer.availability().itemCosts()) {
                            class_1799 costStack = itemCost.itemStack();
                            int itemCount = costStack.method_7947();
                            if (costStack.method_7960()) continue;
                            for (int j = 0; j < inventorySize; ++j) {
                                if (!class_1799.method_31577((class_1799)playerInventoryCopy.method_5438(j), (class_1799)costStack)) continue;
                                class_1799 itemStack = playerInventoryCopy.method_5438(j).method_7972();
                                int stackCount = itemStack.method_7947();
                                if (stackCount >= itemCount) {
                                    itemStack.method_7939(stackCount - itemCount);
                                    playerInventoryCopy.method_5447(j, itemStack);
                                    itemCount = 0;
                                    break;
                                }
                                playerInventoryCopy.method_5447(j, class_1799.field_8037);
                                itemCount -= stackCount;
                            }
                            if (itemCount <= 0) continue;
                            isItemCostAffordable = false;
                        }
                    }
                    CommonDataStructures.DataCheck unlockDataCheck = dialogueAnswer.availability().unlockDataCheck();
                    CommonDataStructures.DataCheck lockDataCheck = dialogueAnswer.availability().lockDataCheck();
                    boolean unlockDataCheckPassed = true;
                    boolean lockDataCheckPassed = false;
                    if ((unlockDataCheck != CommonDataStructures.DataCheck.DEFAULT || lockDataCheck != CommonDataStructures.DataCheck.DEFAULT) && (blockEntity = world.method_8321(dataBlockPos)) instanceof ProvidesData) {
                        ProvidesData providesDataBlockEntity = (ProvidesData)blockEntity;
                        String existingUnlockData = providesDataBlockEntity.getData(unlockDataCheck.dataIdentifier());
                        String existingLockData = providesDataBlockEntity.getData(lockDataCheck.dataIdentifier());
                        unlockDataCheckPassed = switch (unlockDataCheck.comparisonMode()) {
                            case 0 -> Objects.equals(unlockDataCheck.dataValue(), existingUnlockData);
                            case 1 -> {
                                if (!Objects.equals(unlockDataCheck.dataValue(), existingUnlockData)) {
                                    yield true;
                                }
                                yield false;
                            }
                            case 2 -> {
                                if (ItemUtils.parseInt(unlockDataCheck.dataValue()) < ItemUtils.parseInt(existingUnlockData)) {
                                    yield true;
                                }
                                yield false;
                            }
                            case 3 -> {
                                if (ItemUtils.parseInt(unlockDataCheck.dataValue()) > ItemUtils.parseInt(existingUnlockData)) {
                                    yield true;
                                }
                                yield false;
                            }
                            default -> true;
                        };
                        switch (lockDataCheck.comparisonMode()) {
                            case 0: {
                                boolean bl = Objects.equals(lockDataCheck.dataValue(), existingLockData);
                                break;
                            }
                            case 1: {
                                boolean bl;
                                if (!Objects.equals(lockDataCheck.dataValue(), existingLockData)) {
                                    bl = true;
                                    break;
                                }
                                bl = false;
                                break;
                            }
                            case 2: {
                                boolean bl;
                                if (ItemUtils.parseInt(lockDataCheck.dataValue()) < ItemUtils.parseInt(existingLockData)) {
                                    bl = true;
                                    break;
                                }
                                bl = false;
                                break;
                            }
                            case 3: {
                                boolean bl;
                                if (ItemUtils.parseInt(lockDataCheck.dataValue()) > ItemUtils.parseInt(existingLockData)) {
                                    bl = true;
                                    break;
                                }
                                bl = false;
                                break;
                            }
                            default: {
                                boolean bl = lockDataCheckPassed = false;
                            }
                        }
                    }
                    if (playerAdvancementTracker == null || serverAdvancementLoader == null) continue;
                    class_8779 lockAdvancementEntry = serverAdvancementLoader.method_12896(class_2960.method_60654((String)dialogueAnswer.availability().lockAdvancement()));
                    class_8779 unlockAdvancementEntry = serverAdvancementLoader.method_12896(class_2960.method_60654((String)dialogueAnswer.availability().unlockAdvancement()));
                    if ((dialogueAnswer.availability().lockAdvancement().isEmpty() || lockAdvancementEntry != null && !playerAdvancementTracker.method_12882(lockAdvancementEntry).method_740()) && (dialogueAnswer.availability().unlockAdvancement().isEmpty() || unlockAdvancementEntry != null && playerAdvancementTracker.method_12882(unlockAdvancementEntry).method_740()) && unlockDataCheckPassed && !lockDataCheckPassed) {
                        if (isItemCostAffordable) {
                            unlockedAnswersList.add(answerIdentifierString);
                            visibleAnswersList.add(answerIdentifierString);
                            continue;
                        }
                        if (!dialogueAnswer.availability().showUnaffordableAnswer()) continue;
                        unlockedAnswersList.add("");
                        visibleAnswersList.add(answerIdentifierString);
                        continue;
                    }
                    if (!dialogueAnswer.availability().showLockedAnswer()) continue;
                    unlockedAnswersList.add("");
                    visibleAnswersList.add(answerIdentifierString);
                    continue;
                }
                unlockedAnswersList.add("");
                visibleAnswersList.add("");
            }
            serverPlayerEntity.method_17355((class_3908)new ExtendedScreenHandlerFactory<Object>(){

                public DialogueScreenHandler.DialogueData getScreenOpeningData(class_3222 player) {
                    return new DialogueScreenHandler.DialogueData(dialogueIdentifierString, dataBlockPos, dialogueUsedBlocks, dialogueTriggeredBlocks, unlockedAnswersList, visibleAnswersList);
                }

                public class_2561 method_5476() {
                    return class_2561.method_43473();
                }

                @Nullable
                public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
                    return new DialogueScreenHandler(syncId, playerInventory, dialogueIdentifierString, dataBlockPos, dialogueUsedBlocks, dialogueTriggeredBlocks, unlockedAnswersList, visibleAnswersList);
                }
            });
        }
    }
}

