/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.scriptblocks.block;

import com.github.theredbrain.scriptblocks.ScriptBlocks;
import com.github.theredbrain.scriptblocks.block.entity.InteractiveLootBlockEntity;
import com.github.theredbrain.scriptblocks.entity.player.DuckPlayerEntityMixin;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;

public class InteractiveLootBlock
extends class_2237 {
    public static final MapCodec<InteractiveLootBlock> CODEC = InteractiveLootBlock.method_54094(InteractiveLootBlock::new);

    public InteractiveLootBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    public MapCodec<InteractiveLootBlock> method_53969() {
        return CODEC;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new InteractiveLootBlockEntity(pos, state);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        class_2586 blockEntity;
        if (state.method_27852((class_2248)this) && (blockEntity = world.method_8321(pos)) instanceof InteractiveLootBlockEntity) {
            class_3218 serverWorld;
            InteractiveLootBlockEntity interactiveLootBlockEntity = (InteractiveLootBlockEntity)blockEntity;
            if (player.method_7338()) {
                ((DuckPlayerEntityMixin)player).scriptblocks$openInteractiveLootBlockScreen(interactiveLootBlockEntity);
                return class_1269.method_29236((boolean)world.field_9236);
            }
            if (world instanceof class_3218 && !(serverWorld = (class_3218)world).method_8608() && player instanceof class_3222) {
                class_3222 serverPlayerEntity = (class_3222)player;
                if (interactiveLootBlockEntity.isPlayerInSet((class_1657)serverPlayerEntity)) {
                    String alreadyLootedMessage;
                    String alreadyLootedSoundId = interactiveLootBlockEntity.getAlreadyLootedSoundId();
                    if (!alreadyLootedSoundId.isEmpty()) {
                        class_3414 soundEvent = class_3414.method_47908((class_2960)class_2960.method_60654((String)alreadyLootedSoundId));
                        if (class_7923.field_41172.method_47983((Object)soundEvent) != null) {
                            serverPlayerEntity.method_17356(soundEvent, class_3419.field_15245, 1.0f, 1.0f);
                        } else {
                            ScriptBlocks.info("No registered sound event of id '" + alreadyLootedSoundId + "' found.");
                        }
                    }
                    if (!(alreadyLootedMessage = interactiveLootBlockEntity.getAlreadyLootedMessage()).isEmpty()) {
                        serverPlayerEntity.method_7353((class_2561)class_2561.method_43471((String)alreadyLootedMessage), true);
                    }
                } else {
                    class_243 lootPos = new class_243((double)interactiveLootBlockEntity.method_11016().method_10263(), (double)interactiveLootBlockEntity.method_11016().method_10264(), (double)interactiveLootBlockEntity.method_11016().method_10260());
                    if (interactiveLootBlockEntity.getMode() == InteractiveLootBlockEntity.Mode.CHOICE) {
                        ScriptBlocks.supplyLootableLoot(class_2960.method_60654((String)interactiveLootBlockEntity.getLootTableIdentifierString()), serverWorld, serverPlayerEntity, lootPos, interactiveLootBlockEntity.getRolls(), interactiveLootBlockEntity.getChoices(), true, null);
                    } else if (interactiveLootBlockEntity.getMode() == InteractiveLootBlockEntity.Mode.RANDOM) {
                        ScriptBlocks.supplyLootableLoot(class_2960.method_60654((String)interactiveLootBlockEntity.getLootTableIdentifierString()), serverWorld, serverPlayerEntity, lootPos, interactiveLootBlockEntity.getRolls(), interactiveLootBlockEntity.getChoices(), false, null);
                    } else {
                        List<class_1799> lootStacks = InteractiveLootBlock.getLootItems(serverWorld, pos, player, interactiveLootBlockEntity);
                        for (class_1799 itemStack : lootStacks) {
                            player.method_31548().method_7398(itemStack);
                        }
                        InteractiveLootBlock.lootWasSupplied(serverPlayerEntity, interactiveLootBlockEntity);
                    }
                    return class_1269.field_5812;
                }
            }
        }
        return class_1269.field_5811;
    }

    public static void lootWasSupplied(class_3222 serverPlayerEntity, InteractiveLootBlockEntity interactiveLootBlockEntity) {
        String lootAcquiredMessage;
        String lootAcquiredSoundId;
        if (interactiveLootBlockEntity.getTrackPlayers()) {
            interactiveLootBlockEntity.addPlayerToSet((class_1657)serverPlayerEntity);
        }
        if (!(lootAcquiredSoundId = interactiveLootBlockEntity.getLootAcquiredSoundId()).isEmpty()) {
            class_3414 soundEvent = class_3414.method_47908((class_2960)class_2960.method_60654((String)lootAcquiredSoundId));
            if (class_7923.field_41172.method_47983((Object)soundEvent) != null) {
                serverPlayerEntity.method_17356(soundEvent, class_3419.field_15245, 1.0f, 1.0f);
            } else {
                ScriptBlocks.info("No registered sound event of id '" + lootAcquiredSoundId + "' found.");
            }
        }
        if (!(lootAcquiredMessage = interactiveLootBlockEntity.getLootAcquiredMessage()).isEmpty()) {
            serverPlayerEntity.method_7353((class_2561)class_2561.method_43471((String)lootAcquiredMessage), true);
        }
    }

    private static List<class_1799> getLootItems(class_3218 serverWorld, class_2338 pos, class_1657 player, InteractiveLootBlockEntity interactiveLootBlockEntity) {
        ObjectArrayList list = new ArrayList();
        class_2960 lootTableIdentifier = class_2960.method_12829((String)interactiveLootBlockEntity.getLootTableIdentifierString());
        if (lootTableIdentifier != null) {
            class_52 lootTable = serverWorld.method_8503().method_58576().method_58295(class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)lootTableIdentifier));
            list = lootTable.method_51878(new class_8567.class_8568(serverWorld).method_51874(class_181.field_24424, (Object)new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260())).method_51874(class_181.field_1226, (Object)player).method_51875(class_173.field_1179));
        }
        return list;
    }
}

