/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.scriptblocks.block.entity;

import com.github.theredbrain.scriptblocks.ScriptBlocks;
import com.github.theredbrain.scriptblocks.block.Resetable;
import com.github.theredbrain.scriptblocks.block.RotatedBlockWithEntity;
import com.github.theredbrain.scriptblocks.block.Triggerable;
import com.github.theredbrain.scriptblocks.block.entity.RotatedBlockEntity;
import com.github.theredbrain.scriptblocks.data.Boss;
import com.github.theredbrain.scriptblocks.entity.mob.DuckMobEntityMixin;
import com.github.theredbrain.scriptblocks.registry.CustomDynamicRegistries;
import com.github.theredbrain.scriptblocks.registry.EntityRegistry;
import com.github.theredbrain.scriptblocks.util.BlockRotationUtils;
import com.github.theredbrain.scriptblocks.util.DebuggingHelper;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_5131;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.apache.commons.lang3.tuple.MutablePair;
import org.jetbrains.annotations.Nullable;

public class BossControllerBlockEntity
extends RotatedBlockEntity
implements Triggerable,
Resetable {
    private static final class_2338 POSITION_OFFSET_DEFAULT = new class_2338(0, 0, 0);
    public static final Predicate<class_1297> EXCEPT_PLAYERS = entity -> !(entity instanceof class_1657);
    private long globalTimer = 0L;
    private long phaseTimer = 0L;
    private int currentPhaseId = -1;
    private Boss.Phase currentPhase = null;
    private Boss boss;
    @Nullable
    private UUID bossEntityUuid = null;
    private class_2487 entityTypeCompound = new class_2487();
    private boolean calculateAreaBox = true;
    private class_238 area = null;
    private boolean showArea = false;
    private class_2382 areaDimensions = class_2382.field_11176;
    private class_2338 areaPositionOffset = POSITION_OFFSET_DEFAULT;
    private String bossIdentifier = "";
    private class_2338 bossSpawnPositionOffset = POSITION_OFFSET_DEFAULT;
    private double bossSpawnOrientationPitch = 0.0;
    private double bossSpawnOrientationYaw = 0.0;
    Multimap<class_6880<class_1320>, class_1322> entityAttributeModifiers = Multimaps.newMultimap((Map)Maps.newLinkedHashMap(), ArrayList::new);
    private HashMap<String, MutablePair<class_2338, Boolean>> bossTriggeredBlocks = new HashMap();

    public BossControllerBlockEntity(class_2338 pos, class_2680 state) {
        super(EntityRegistry.BOSS_CONTROLLER_BLOCK_ENTITY, pos, state);
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return this.method_58692(registryLookup);
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        if (this.showArea) {
            nbt.method_10556("showArea", true);
        } else {
            nbt.method_10551("showArea");
        }
        if (this.area != null) {
            nbt.method_10549("areaMinX", this.area.field_1323);
            nbt.method_10549("areaMaxX", this.area.field_1320);
            nbt.method_10549("areaMinY", this.area.field_1322);
            nbt.method_10549("areaMaxY", this.area.field_1325);
            nbt.method_10549("areaMinZ", this.area.field_1321);
            nbt.method_10549("areaMaxZ", this.area.field_1324);
        } else {
            nbt.method_10551("areaMinX");
            nbt.method_10551("areaMaxX");
            nbt.method_10551("areaMinY");
            nbt.method_10551("areaMaxY");
            nbt.method_10551("areaMinZ");
            nbt.method_10551("areaMaxZ");
        }
        if (this.areaDimensions != class_2382.field_11176) {
            nbt.method_10569("areaDimensionsX", this.areaDimensions.method_10263());
            nbt.method_10569("areaDimensionsY", this.areaDimensions.method_10264());
            nbt.method_10569("areaDimensionsZ", this.areaDimensions.method_10260());
        } else {
            nbt.method_10551("areaDimensionsX");
            nbt.method_10551("areaDimensionsY");
            nbt.method_10551("areaDimensionsZ");
        }
        class_2338 areaPositionOffset = this.areaPositionOffset;
        if (!areaPositionOffset.equals((Object)POSITION_OFFSET_DEFAULT)) {
            nbt.method_10569("areaPositionOffsetX", this.areaPositionOffset.method_10263());
            nbt.method_10569("areaPositionOffsetY", this.areaPositionOffset.method_10264());
            nbt.method_10569("areaPositionOffsetZ", this.areaPositionOffset.method_10260());
        } else {
            nbt.method_10551("areaPositionOffsetX");
            nbt.method_10551("areaPositionOffsetY");
            nbt.method_10551("areaPositionOffsetZ");
        }
        if (this.bossIdentifier != null) {
            nbt.method_10582("bossIdentifier", this.bossIdentifier);
        } else {
            nbt.method_10551("bossIdentifier");
        }
        class_2338 bossSpawnPositionOffset = this.bossSpawnPositionOffset;
        if (!bossSpawnPositionOffset.equals((Object)POSITION_OFFSET_DEFAULT)) {
            nbt.method_10569("bossSpawnPositionOffsetX", this.bossSpawnPositionOffset.method_10263());
            nbt.method_10569("bossSpawnPositionOffsetY", this.bossSpawnPositionOffset.method_10264());
            nbt.method_10569("bossSpawnPositionOffsetZ", this.bossSpawnPositionOffset.method_10260());
        } else {
            nbt.method_10551("bossSpawnPositionOffsetX");
            nbt.method_10551("bossSpawnPositionOffsetY");
            nbt.method_10551("bossSpawnPositionOffsetZ");
        }
        if (this.bossSpawnOrientationPitch != 0.0) {
            nbt.method_10549("bossSpawnOrientationPitch", this.bossSpawnOrientationPitch);
        } else {
            nbt.method_10551("bossSpawnOrientationPitch");
        }
        if (this.bossSpawnOrientationYaw != 0.0) {
            nbt.method_10549("bossSpawnOrientationYaw", this.bossSpawnOrientationYaw);
        } else {
            nbt.method_10551("bossSpawnOrientationYaw8");
        }
        ArrayList<String> bossTriggeredBlocksKeys = new ArrayList<String>(this.bossTriggeredBlocks.keySet());
        nbt.method_10569("bossTriggeredBlocksKeysSize", bossTriggeredBlocksKeys.size());
        for (int i = 0; i < bossTriggeredBlocksKeys.size(); ++i) {
            String key = (String)bossTriggeredBlocksKeys.get(i);
            nbt.method_10582("bossTriggeredBlocks_key_" + i, key);
            nbt.method_10569("bossTriggeredBlocks_entry_X_" + i, ((class_2338)this.bossTriggeredBlocks.get(key).getLeft()).method_10263());
            nbt.method_10569("bossTriggeredBlocks_entry_Y_" + i, ((class_2338)this.bossTriggeredBlocks.get(key).getLeft()).method_10264());
            nbt.method_10569("bossTriggeredBlocks_entry_Z_" + i, ((class_2338)this.bossTriggeredBlocks.get(key).getLeft()).method_10260());
            nbt.method_10556("bossTriggeredBlocks_entry_resets_" + i, ((Boolean)this.bossTriggeredBlocks.get(key).getRight()).booleanValue());
        }
        if (!Objects.equals(this.entityTypeCompound, new class_2487())) {
            nbt.method_10566("EntityTypeCompound", (class_2520)this.entityTypeCompound);
        } else {
            nbt.method_10551("EntityTypeCompound");
        }
        if (this.bossEntityUuid != null) {
            nbt.method_25927("bossEntityUuid", this.bossEntityUuid);
        } else {
            nbt.method_10551("bossEntityUuid");
        }
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.showArea = nbt.method_10573("showArea", 1) ? nbt.method_10577("showArea") : false;
        if (nbt.method_10545("areaMinX") && nbt.method_10545("areaMinY") && nbt.method_10545("areaMinZ") && nbt.method_10545("areaMaxX") && nbt.method_10545("areaMaxY") && nbt.method_10545("areaMaxZ")) {
            this.area = new class_238(nbt.method_10574("areaMinX"), nbt.method_10574("areaMinY"), nbt.method_10574("areaMinZ"), nbt.method_10574("areaMaxX"), nbt.method_10574("areaMaxY"), nbt.method_10574("areaMaxZ"));
            this.calculateAreaBox = true;
        } else {
            this.area = null;
        }
        this.areaDimensions = nbt.method_10573("areaDimensionsX", 3) || nbt.method_10573("areaDimensionsY", 3) || nbt.method_10573("areaDimensionsZ", 3) ? new class_2382(class_3532.method_15340((int)nbt.method_10550("areaDimensionsX"), (int)0, (int)48), class_3532.method_15340((int)nbt.method_10550("areaDimensionsY"), (int)0, (int)48), class_3532.method_15340((int)nbt.method_10550("areaDimensionsZ"), (int)0, (int)48)) : class_2382.field_11176;
        this.areaPositionOffset = nbt.method_10573("areaPositionOffsetX", 3) || nbt.method_10573("areaPositionOffsetY", 3) || nbt.method_10573("areaPositionOffsetZ", 3) ? new class_2338(class_3532.method_15340((int)nbt.method_10550("areaPositionOffsetX"), (int)-48, (int)48), class_3532.method_15340((int)nbt.method_10550("areaPositionOffsetY"), (int)-48, (int)48), class_3532.method_15340((int)nbt.method_10550("areaPositionOffsetZ"), (int)-48, (int)48)) : POSITION_OFFSET_DEFAULT;
        this.bossIdentifier = nbt.method_10573("bossIdentifier", 8) ? nbt.method_10558("bossIdentifier") : "";
        this.bossSpawnPositionOffset = nbt.method_10573("bossSpawnPositionOffsetX", 3) || nbt.method_10573("bossSpawnPositionOffsetY", 3) || nbt.method_10573("bossSpawnPositionOffsetZ", 3) ? new class_2338(class_3532.method_15340((int)nbt.method_10550("bossSpawnPositionOffsetX"), (int)-48, (int)48), class_3532.method_15340((int)nbt.method_10550("bossSpawnPositionOffsetY"), (int)-48, (int)48), class_3532.method_15340((int)nbt.method_10550("bossSpawnPositionOffsetZ"), (int)-48, (int)48)) : POSITION_OFFSET_DEFAULT;
        this.bossSpawnOrientationPitch = nbt.method_10573("bossSpawnOrientationPitch", 6) ? nbt.method_10574("bossSpawnOrientationPitch") : 0.0;
        this.bossSpawnOrientationYaw = nbt.method_10573("bossSpawnOrientationYaw", 6) ? nbt.method_10574("bossSpawnOrientationYaw") : 0.0;
        this.bossTriggeredBlocks.clear();
        int bossTriggeredBlocksKeysSize = nbt.method_10550("bossTriggeredBlocksKeysSize");
        for (int b = 0; b < bossTriggeredBlocksKeysSize; ++b) {
            this.bossTriggeredBlocks.put(nbt.method_10558("bossTriggeredBlocks_key_" + b), (MutablePair<class_2338, Boolean>)new MutablePair((Object)new class_2338(class_3532.method_15340((int)nbt.method_10550("bossTriggeredBlocks_entry_X_" + b), (int)-48, (int)48), class_3532.method_15340((int)nbt.method_10550("bossTriggeredBlocks_entry_Y_" + b), (int)-48, (int)48), class_3532.method_15340((int)nbt.method_10550("bossTriggeredBlocks_entry_Z_" + b), (int)-48, (int)48)), (Object)nbt.method_10577("bossTriggeredBlocks_entry_resets_" + b)));
        }
        this.entityTypeCompound = nbt.method_10573("EntityTypeCompound", 10) ? nbt.method_10562("EntityTypeCompound") : new class_2487();
        this.bossEntityUuid = nbt.method_25928("bossEntityUuid") ? nbt.method_25926("bossEntityUuid") : null;
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, BossControllerBlockEntity bC) {
        if (!world.field_9236 && bC.currentPhase != null && bC.boss != null) {
            ++bC.globalTimer;
            ++bC.phaseTimer;
            int globalTimerThreshold = bC.currentPhase.globalTimerThreshold();
            int phaseTimerThreshold = bC.currentPhase.phaseTimerThreshold();
            if (globalTimerThreshold > -1 && bC.globalTimer >= (long)globalTimerThreshold) {
                BossControllerBlockEntity.advancePhase(bC);
            } else if (phaseTimerThreshold > -1 && bC.phaseTimer >= (long)phaseTimerThreshold) {
                BossControllerBlockEntity.advancePhase(bC);
            }
        }
    }

    private static void startBattle(BossControllerBlockEntity bC) {
        Optional optionalBossReference;
        DebuggingHelper.sendBossControllerLogMessage("startBattle", null);
        String identifierString = bC.bossIdentifier;
        if (!identifierString.isEmpty() && bC.field_11863 != null && (optionalBossReference = bC.field_11863.method_30349().method_30530(CustomDynamicRegistries.BOSS_REGISTRY_KEY).method_55841(class_2960.method_60654((String)identifierString))).isPresent()) {
            bC.boss = (Boss)((class_6880.class_6883)optionalBossReference.get()).comp_349();
        }
        if (bC.boss != null) {
            DebuggingHelper.sendBossControllerLogMessage("bC.boss != null", null);
            if (bC.setEntityType(bC.boss.bossEntityTypeId())) {
                bC.currentPhaseId = 0;
                bC.currentPhase = bC.boss.phases().getFirst();
                if (BossControllerBlockEntity.spawnBossEntity(bC)) {
                    DebuggingHelper.sendBossControllerLogMessage("boss spawned", null);
                    BossControllerBlockEntity.startPhase(bC);
                }
            }
        }
    }

    private static void advancePhase(BossControllerBlockEntity bC) {
        DebuggingHelper.sendBossControllerLogMessage("advancePhase", null);
        if (bC.boss != null) {
            if (bC.currentPhaseId + 1 < bC.boss.phases().size()) {
                bC.phaseTimer = 0L;
                BossControllerBlockEntity.endPhase(bC, true);
                ++bC.currentPhaseId;
                bC.currentPhase = bC.boss.phases().get(bC.currentPhaseId);
                BossControllerBlockEntity.startPhase(bC);
            } else {
                BossControllerBlockEntity.endBattle(bC);
            }
        } else {
            DebuggingHelper.sendBossControllerLogMessage("A bossControllerBlock at " + bC.method_11016().toString() + " tried to advance a non existing boss fight.", null);
        }
    }

    private static void endBattle(BossControllerBlockEntity bC) {
        class_1937 class_19372;
        BossControllerBlockEntity.endPhase(bC, false);
        bC.currentPhase = null;
        if (bC.boss.discardEntityAtEnd() && bC.bossEntityUuid != null && (class_19372 = bC.field_11863) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            class_1297 entity = serverWorld.method_14190(bC.bossEntityUuid);
            if (entity != null) {
                entity.method_31472();
            }
            bC.bossEntityUuid = null;
        }
    }

    private static void startPhase(BossControllerBlockEntity bC) {
        class_3218 serverWorld;
        class_1297 entity;
        Object keyList;
        Boss.Phase phase = bC.currentPhase;
        DebuggingHelper.sendBossControllerLogMessage("startPhase", null);
        bC.entityAttributeModifiers = BossControllerBlockEntity.getEntityAttributeModifiers(bC.currentPhase);
        String triggeredBlock = phase.triggeredBlockAtStart();
        if (triggeredBlock != null) {
            ArrayList<MutablePair> bossTriggeredBlocksList = new ArrayList<MutablePair>(List.of());
            keyList = new ArrayList<String>(bC.getBossTriggeredBlocks().keySet());
            Iterator iterator = keyList.iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                bossTriggeredBlocksList.add(new MutablePair((Object)key, bC.getBossTriggeredBlocks().get(key)));
            }
            for (MutablePair entry : bossTriggeredBlocksList) {
                if (!((String)entry.getLeft()).equals(triggeredBlock)) continue;
                class_1937 world = bC.method_10997();
                class_2586 blockEntity = null;
                if (world != null) {
                    blockEntity = world.method_8321(((class_2338)((MutablePair)entry.getRight()).getLeft()).method_10081((class_2382)bC.field_11867));
                }
                if (blockEntity == null || blockEntity == bC) break;
                boolean triggeredBlockResets = (Boolean)((MutablePair)entry.getRight()).getRight();
                if (triggeredBlockResets && blockEntity instanceof Resetable) {
                    Resetable resetable = (Resetable)blockEntity;
                    resetable.reset();
                    break;
                }
                if (triggeredBlockResets || !(blockEntity instanceof Triggerable)) break;
                Triggerable triggerable = (Triggerable)blockEntity;
                triggerable.trigger();
                break;
            }
        }
        if (bC.bossEntityUuid != null && (keyList = bC.field_11863) instanceof class_3218 && (entity = (serverWorld = (class_3218)keyList).method_14190(bC.bossEntityUuid)) instanceof class_1308) {
            class_1308 mobEntity = (class_1308)entity;
            ((DuckMobEntityMixin)mobEntity).scriptblocks$setBossHealthThreshold(bC.currentPhase.bossHealthThreshold());
            ((DuckMobEntityMixin)mobEntity).scriptblocks$setBossPhase(bC.currentPhaseId);
            if (!bC.entityAttributeModifiers.isEmpty()) {
                class_5131 attributeContainer = mobEntity.method_6127();
                bC.entityAttributeModifiers.forEach((attribute, attributeModifier) -> {
                    class_1324 entityAttributeInstance = attributeContainer.method_45329(attribute);
                    if (entityAttributeInstance != null) {
                        entityAttributeInstance.method_26837(attributeModifier);
                    }
                });
            }
            if ((double)bC.currentPhase.newHealthRatio() > 0.0) {
                mobEntity.method_6033(mobEntity.method_6063() * Math.min(1.0f, bC.currentPhase.newHealthRatio()));
            }
        }
    }

    private static void endPhase(BossControllerBlockEntity bC, boolean removeAttributeModifiers) {
        Object keyList;
        Boss.Phase phase = bC.currentPhase;
        DebuggingHelper.sendBossControllerLogMessage("endPhase, removeAttributeModifiers: " + removeAttributeModifiers, null);
        String triggeredBlock = phase.triggeredBlockAtEnd();
        if (triggeredBlock != null) {
            ArrayList<MutablePair> bossTriggeredBlocksList = new ArrayList<MutablePair>(List.of());
            keyList = new ArrayList<String>(bC.getBossTriggeredBlocks().keySet());
            Iterator iterator = keyList.iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                bossTriggeredBlocksList.add(new MutablePair((Object)key, bC.getBossTriggeredBlocks().get(key)));
            }
            for (MutablePair entry : bossTriggeredBlocksList) {
                if (!((String)entry.getLeft()).equals(triggeredBlock)) continue;
                class_1937 world = bC.method_10997();
                class_2586 blockEntity = null;
                if (world != null) {
                    blockEntity = world.method_8321(((class_2338)((MutablePair)entry.getRight()).getLeft()).method_10081((class_2382)bC.field_11867));
                }
                if (blockEntity == null || blockEntity == bC) break;
                boolean triggeredBlockResets = (Boolean)((MutablePair)entry.getRight()).getRight();
                if (triggeredBlockResets && blockEntity instanceof Resetable) {
                    Resetable resetable = (Resetable)blockEntity;
                    resetable.reset();
                    break;
                }
                if (triggeredBlockResets || !(blockEntity instanceof Triggerable)) break;
                Triggerable triggerable = (Triggerable)blockEntity;
                triggerable.trigger();
                break;
            }
        }
        if (bC.bossEntityUuid != null && removeAttributeModifiers && (keyList = bC.field_11863) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)keyList;
            class_1297 entity = serverWorld.method_14190(bC.bossEntityUuid);
            if (!bC.entityAttributeModifiers.isEmpty() && entity instanceof class_1309) {
                class_5131 attributeContainer = ((class_1309)entity).method_6127();
                bC.entityAttributeModifiers.forEach((attribute, attributeModifier) -> {
                    class_1324 entityAttributeInstance = attributeContainer.method_45329(attribute);
                    if (entityAttributeInstance != null) {
                        entityAttributeInstance.method_6202(attributeModifier);
                    }
                });
            } else if (bC.entityAttributeModifiers.isEmpty()) {
                DebuggingHelper.sendBossControllerLogMessage("bC.entityAttributeModifiers.isEmpty()", null);
            }
        }
    }

    public static void bossReachedHealthThreshold(BossControllerBlockEntity bC, class_1308 mobEntity) {
        if (mobEntity.method_5667() != bC.bossEntityUuid) {
            mobEntity.method_31472();
        }
        BossControllerBlockEntity.advancePhase(bC);
    }

    private static Multimap<class_6880<class_1320>, class_1322> getEntityAttributeModifiers(Boss.Phase phase) {
        Multimap entityAttributeModifiers = Multimaps.newMultimap((Map)Maps.newLinkedHashMap(), ArrayList::new);
        for (Boss.Phase.AttributeModifierEntry entityAttributeModifier : phase.entityAttributeModifiers()) {
            Optional optional = class_7923.field_41190.method_17966(class_2960.method_60654((String)entityAttributeModifier.attributeIdentifier()));
            if (!optional.isPresent()) continue;
            class_6880 key = class_7923.field_41190.method_47983((Object)((class_1320)optional.get()));
            entityAttributeModifiers.put((Object)key, (Object)new class_1322(class_2960.method_60654((String)entityAttributeModifier.id()), entityAttributeModifier.amount(), class_1322.class_1323.valueOf((String)entityAttributeModifier.operation())));
        }
        return entityAttributeModifiers;
    }

    private static boolean spawnBossEntity(BossControllerBlockEntity bC) {
        class_1937 class_19372 = bC.field_11863;
        if (class_19372 instanceof class_3218) {
            Optional optional;
            class_1297 entity2;
            class_3218 serverWorld = (class_3218)class_19372;
            if (bC.bossEntityUuid != null && (entity2 = serverWorld.method_14190(bC.bossEntityUuid)) != null) {
                entity2.method_31472();
            }
            if ((optional = class_1299.method_17684((class_2487)bC.entityTypeCompound)).isEmpty()) {
                ScriptBlocks.info("optional.isEmpty()");
                return false;
            }
            double d = (double)bC.field_11867.method_10263() + (double)bC.bossSpawnPositionOffset.method_10263() + 0.5;
            double e = (double)bC.field_11867.method_10264() + (double)bC.bossSpawnPositionOffset.method_10264();
            double f = (double)bC.field_11867.method_10260() + (double)bC.bossSpawnPositionOffset.method_10260() + 0.5;
            if (!serverWorld.method_18026(((class_1299)optional.get()).method_58629(d, e, f))) {
                DebuggingHelper.sendBossControllerLogMessage("not enough space for spawning boss entity", null);
                return false;
            }
            class_2338 blockPos = class_2338.method_49637((double)d, (double)e, (double)f);
            class_1297 entity22 = class_1299.method_17842((class_2487)bC.entityTypeCompound, (class_1937)bC.field_11863, entity -> {
                entity.method_5808(d, e, f, entity.method_36454(), entity.method_36455());
                return entity;
            });
            if (entity22 == null) {
                return false;
            }
            entity22.method_5636((float)bC.bossSpawnOrientationYaw);
            entity22.method_5847((float)bC.bossSpawnOrientationYaw);
            entity22.method_5808(entity22.method_23317(), entity22.method_23318(), entity22.method_23321(), (float)bC.bossSpawnOrientationYaw, (float)bC.bossSpawnOrientationPitch);
            if (entity22 instanceof class_1308 && bC.entityTypeCompound.method_10573("id", 8)) {
                ((class_1308)entity22).method_5943((class_5425)serverWorld, serverWorld.method_8404(entity22.method_24515()), class_3730.field_16469, null);
            }
            if (!serverWorld.method_30736(entity22)) {
                return false;
            }
            serverWorld.method_20290(2004, bC.field_11867, 0);
            serverWorld.method_33596(entity22, (class_6880)class_5712.field_28738, blockPos);
            if (entity22 instanceof class_1309) {
                bC.bossEntityUuid = ((class_1309)entity22).method_5667();
                if (entity22 instanceof class_1308) {
                    class_1308 mobEntity = (class_1308)entity22;
                    mobEntity.method_5990();
                    mobEntity.method_5971();
                    ((DuckMobEntityMixin)mobEntity).scriptblocks$setControllerBlockPos(bC.field_11867);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
        this.globalTimer = 0L;
        this.phaseTimer = 0L;
        this.currentPhaseId = -1;
        this.currentPhase = null;
        this.boss = null;
        DebuggingHelper.sendBossControllerLogMessage("BossControllerBlock reset", null);
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            DebuggingHelper.sendBossControllerLogMessage("world instanceof ServerWorld", null);
            if (this.bossEntityUuid != null) {
                DebuggingHelper.sendBossControllerLogMessage("bossEntityUuid != null", null);
                class_1297 entity = serverWorld.method_14190(this.bossEntityUuid);
                if (entity != null) {
                    DebuggingHelper.sendBossControllerLogMessage("bossEntity discarded", null);
                    entity.method_31472();
                }
                this.bossEntityUuid = null;
            } else {
                DebuggingHelper.sendBossControllerLogMessage("bossEntityUuid == null", null);
            }
        }
        this.discardLivingEntitiesInBossArena();
    }

    private void discardLivingEntitiesInBossArena() {
        DebuggingHelper.sendBossControllerLogMessage("LivingEntities in boss arena discarded", null);
        if (this.calculateAreaBox || this.area == null) {
            class_2338 areaPositionOffset = this.areaPositionOffset;
            class_2382 areaDimensions = this.areaDimensions;
            class_243 areaStart = new class_243((double)(this.field_11867.method_10263() + areaPositionOffset.method_10263()), (double)(this.field_11867.method_10264() + areaPositionOffset.method_10264()), (double)(this.field_11867.method_10260() + areaPositionOffset.method_10260()));
            class_243 areaEnd = new class_243(areaStart.method_10216() + (double)areaDimensions.method_10263(), areaStart.method_10214() + (double)areaDimensions.method_10264(), areaStart.method_10215() + (double)areaDimensions.method_10260());
            this.area = new class_238(areaStart, areaEnd);
            this.calculateAreaBox = false;
        }
        if (this.field_11863 != null) {
            List entityList = this.field_11863.method_8390(class_1309.class, this.area, EXCEPT_PLAYERS);
            DebuggingHelper.sendBossControllerLogMessage("Discarding " + entityList.size() + " entities.", null);
            for (class_1309 livingEntity : entityList) {
                livingEntity.method_31472();
            }
        }
    }

    @Override
    public void trigger() {
        if (this.boss != null && this.currentPhase != null && this.currentPhase.triggerEndsPhase()) {
            BossControllerBlockEntity.advancePhase(this);
        }
        if (this.currentPhase == null && this.currentPhaseId == -1) {
            BossControllerBlockEntity.startBattle(this);
        }
    }

    @Override
    protected void onRotate(class_2680 state) {
        if (state.method_26204() instanceof RotatedBlockWithEntity) {
            Iterator offsetArea;
            MutablePair<class_2338, Boolean> oldBlockPos;
            ArrayList<String> keys;
            if ((Integer)state.method_11654((class_2769)RotatedBlockWithEntity.ROTATED) != this.rotated) {
                class_2470 blockRotation = BlockRotationUtils.calculateRotationFromDifferentRotatedStates((Integer)state.method_11654((class_2769)RotatedBlockWithEntity.ROTATED), this.rotated);
                this.bossSpawnPositionOffset = BlockRotationUtils.rotateOffsetBlockPos(this.bossSpawnPositionOffset, blockRotation);
                this.bossSpawnOrientationYaw = BlockRotationUtils.rotateYaw(this.bossSpawnOrientationYaw, blockRotation);
                ArrayList<String> keys2 = new ArrayList<String>(this.bossTriggeredBlocks.keySet());
                Iterator iterator = keys2.iterator();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    MutablePair<class_2338, Boolean> oldBlockPos2 = this.bossTriggeredBlocks.get(key);
                    oldBlockPos2.setLeft((Object)BlockRotationUtils.rotateOffsetBlockPos((class_2338)oldBlockPos2.getLeft(), blockRotation));
                    this.bossTriggeredBlocks.put(key, oldBlockPos2);
                }
                MutablePair<class_2338, class_2382> offsetArea2 = BlockRotationUtils.rotateOffsetArea(this.areaPositionOffset, this.areaDimensions, blockRotation);
                this.areaPositionOffset = (class_2338)offsetArea2.getLeft();
                this.areaDimensions = (class_2382)offsetArea2.getRight();
                this.rotated = (Integer)state.method_11654((class_2769)RotatedBlockWithEntity.ROTATED);
            }
            if ((Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.X_MIRRORED) != this.x_mirrored) {
                this.bossSpawnPositionOffset = BlockRotationUtils.mirrorOffsetBlockPos(this.bossSpawnPositionOffset, class_2415.field_11301);
                this.bossSpawnOrientationYaw = BlockRotationUtils.mirrorYaw(this.bossSpawnOrientationYaw, class_2415.field_11301);
                keys = new ArrayList<String>(this.bossTriggeredBlocks.keySet());
                for (String key : keys) {
                    oldBlockPos = this.bossTriggeredBlocks.get(key);
                    oldBlockPos.setLeft((Object)BlockRotationUtils.mirrorOffsetBlockPos((class_2338)oldBlockPos.getLeft(), class_2415.field_11301));
                    this.bossTriggeredBlocks.put(key, oldBlockPos);
                }
                offsetArea = BlockRotationUtils.mirrorOffsetArea(this.areaPositionOffset, this.areaDimensions, class_2415.field_11301);
                this.areaPositionOffset = (class_2338)offsetArea.getLeft();
                this.areaDimensions = (class_2382)offsetArea.getRight();
                this.x_mirrored = (Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.X_MIRRORED);
            }
            if ((Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.Z_MIRRORED) != this.z_mirrored) {
                this.bossSpawnPositionOffset = BlockRotationUtils.mirrorOffsetBlockPos(this.bossSpawnPositionOffset, class_2415.field_11300);
                this.bossSpawnOrientationYaw = BlockRotationUtils.mirrorYaw(this.bossSpawnOrientationYaw, class_2415.field_11300);
                keys = new ArrayList<String>(this.bossTriggeredBlocks.keySet());
                for (String key : keys) {
                    oldBlockPos = this.bossTriggeredBlocks.get(key);
                    oldBlockPos.setLeft((Object)BlockRotationUtils.mirrorOffsetBlockPos((class_2338)oldBlockPos.getLeft(), class_2415.field_11300));
                    this.bossTriggeredBlocks.put(key, oldBlockPos);
                }
                offsetArea = BlockRotationUtils.mirrorOffsetArea(this.areaPositionOffset, this.areaDimensions, class_2415.field_11300);
                this.areaPositionOffset = (class_2338)offsetArea.getLeft();
                this.areaDimensions = (class_2382)offsetArea.getRight();
                this.z_mirrored = (Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.Z_MIRRORED);
            }
        }
    }

    public String getEntityTypeId() {
        if (this.entityTypeCompound != null && this.entityTypeCompound.method_10545("id")) {
            return this.entityTypeCompound.method_10558("id");
        }
        return "";
    }

    public boolean setEntityType(String entityTypeId) {
        Optional optional = class_1299.method_5898((String)entityTypeId);
        if (optional.isPresent()) {
            class_1299 entityType = (class_1299)optional.get();
            this.entityTypeCompound.method_10582("id", class_7923.field_41177.method_10221((Object)entityType).toString());
            return true;
        }
        return entityTypeId.isEmpty();
    }

    public boolean showArea() {
        return this.showArea;
    }

    public void setShowArea(boolean showArea) {
        this.showArea = showArea;
    }

    public class_2382 getAreaDimensions() {
        return this.areaDimensions;
    }

    public boolean setAreaDimensions(class_2382 areaDimensions) {
        this.areaDimensions = areaDimensions;
        this.calculateAreaBox = true;
        return true;
    }

    public class_2338 getAreaPositionOffset() {
        return this.areaPositionOffset;
    }

    public boolean setAreaPositionOffset(class_2338 areaPositionOffset) {
        this.areaPositionOffset = areaPositionOffset;
        this.calculateAreaBox = true;
        return true;
    }

    public class_2338 getBossSpawnPositionOffset() {
        return this.bossSpawnPositionOffset;
    }

    public boolean setBossSpawnPositionOffset(class_2338 bossSpawnPositionOffset) {
        this.bossSpawnPositionOffset = bossSpawnPositionOffset;
        return true;
    }

    public double getBossSpawnOrientationPitch() {
        return this.bossSpawnOrientationPitch;
    }

    public boolean setBossSpawnPositionPitch(double bossSpawnPositionPitch) {
        this.bossSpawnOrientationPitch = bossSpawnPositionPitch;
        return true;
    }

    public double getBossSpawnOrientationYaw() {
        return this.bossSpawnOrientationYaw;
    }

    public boolean setBossSpawnPositionYaw(double bossSpawnPositionYaw) {
        this.bossSpawnOrientationYaw = bossSpawnPositionYaw;
        return true;
    }

    public String getBossIdentifier() {
        return this.bossIdentifier;
    }

    public void setBossIdentifier(String bossIdentifier) {
        this.bossIdentifier = bossIdentifier;
    }

    public HashMap<String, MutablePair<class_2338, Boolean>> getBossTriggeredBlocks() {
        return this.bossTriggeredBlocks;
    }

    public boolean setBossTriggeredBlocks(HashMap<String, MutablePair<class_2338, Boolean>> bossTriggeredBlocks) {
        this.bossTriggeredBlocks = bossTriggeredBlocks;
        return true;
    }
}

