/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.scriptblocks.block.entity;

import com.github.theredbrain.scriptblocks.block.Resetable;
import com.github.theredbrain.scriptblocks.registry.EntityRegistry;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3542;
import net.minecraft.class_7225;

public class InteractiveLootBlockEntity
extends class_2586
implements Resetable {
    private Set<UUID> playerSet = new HashSet<UUID>();
    private String lootTableIdentifierString = "";
    private Mode mode = Mode.VANILLA;
    private int rolls = 3;
    private int choices = 1;
    private boolean trackPlayers = false;
    private String lootAcquiredMessage = "gui.interactive_loot_block.loot_acquired";
    private String lootAcquiredSoundId = "";
    private String alreadyLootedMessage = "gui.interactive_loot_block.already_looted";
    private String alreadyLootedSoundId = "block.chest.locked";

    public InteractiveLootBlockEntity(class_2338 pos, class_2680 state) {
        super(EntityRegistry.INTERACTIVE_LOOT_BLOCK_ENTITY, pos, state);
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        List list = this.playerSet.stream().toList();
        int listSize = list.size();
        nbt.method_10569("listSize", listSize);
        for (int i = 0; i < listSize; ++i) {
            nbt.method_25927("listEntry_" + i, (UUID)list.get(i));
        }
        if (!this.lootTableIdentifierString.isEmpty()) {
            nbt.method_10582("lootTableIdentifierString", this.lootTableIdentifierString);
        } else {
            nbt.method_10551("lootTableIdentifierString");
        }
        if (this.mode != Mode.VANILLA) {
            nbt.method_10582("mode", this.mode.method_15434());
        } else {
            nbt.method_10551("mode");
        }
        if (this.rolls != 3) {
            nbt.method_10569("rolls", this.rolls);
        } else {
            nbt.method_10551("rolls");
        }
        if (this.choices != 1) {
            nbt.method_10569("choices", this.choices);
        } else {
            nbt.method_10551("choices");
        }
        if (this.trackPlayers) {
            nbt.method_10556("trackPlayers", true);
        } else {
            nbt.method_10551("trackPlayers");
        }
        if (!this.lootAcquiredMessage.isEmpty()) {
            nbt.method_10582("lootAcquiredMessage", this.lootAcquiredMessage);
        } else {
            nbt.method_10551("lootAcquiredMessage");
        }
        if (!this.lootAcquiredSoundId.isEmpty()) {
            nbt.method_10582("lootAcquiredSoundId", this.lootAcquiredSoundId);
        } else {
            nbt.method_10551("lootAcquiredSoundId");
        }
        if (!this.alreadyLootedMessage.isEmpty()) {
            nbt.method_10582("alreadyLootedMessage", this.alreadyLootedMessage);
        } else {
            nbt.method_10551("alreadyLootedMessage");
        }
        if (!this.alreadyLootedSoundId.isEmpty()) {
            nbt.method_10582("alreadyLootedSoundId", this.alreadyLootedSoundId);
        } else {
            nbt.method_10551("alreadyLootedSoundId");
        }
        super.method_11007(nbt, registryLookup);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        this.playerSet.clear();
        int listSize = nbt.method_10550("listSize");
        for (int i = 0; i < listSize; ++i) {
            if (!nbt.method_25928("listEntry_" + i)) continue;
            this.playerSet.add(nbt.method_25926("listEntry_" + i));
        }
        this.lootTableIdentifierString = nbt.method_10545("lootTableIdentifierString") ? nbt.method_10558("lootTableIdentifierString") : "";
        this.mode = Mode.byName(nbt.method_10558("mode")).orElse(Mode.VANILLA);
        this.rolls = nbt.method_10545("rolls") ? nbt.method_10550("rolls") : 3;
        this.choices = nbt.method_10545("choices") ? nbt.method_10550("choices") : 1;
        this.trackPlayers = nbt.method_10545("trackPlayers");
        this.lootAcquiredMessage = nbt.method_10545("lootAcquiredMessage") ? nbt.method_10558("lootAcquiredMessage") : "";
        this.lootAcquiredSoundId = nbt.method_10545("lootAcquiredSoundId") ? nbt.method_10558("lootAcquiredSoundId") : "";
        this.alreadyLootedMessage = nbt.method_10545("alreadyLootedMessage") ? nbt.method_10558("alreadyLootedMessage") : "";
        this.alreadyLootedSoundId = nbt.method_10545("alreadyLootedSoundId") ? nbt.method_10558("alreadyLootedSoundId") : "";
        super.method_11014(nbt, registryLookup);
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return this.method_58692(registryLookup);
    }

    public String getLootTableIdentifierString() {
        return this.lootTableIdentifierString;
    }

    public void setLootTableIdentifierString(String lootTableIdentifierString) {
        this.lootTableIdentifierString = lootTableIdentifierString;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public int getRolls() {
        return this.rolls;
    }

    public void setRolls(int rolls) {
        this.rolls = rolls;
    }

    public int getChoices() {
        return this.choices;
    }

    public void setChoices(int choices) {
        this.choices = choices;
    }

    public boolean getTrackPlayers() {
        return this.trackPlayers;
    }

    public void setTrackPlayers(boolean trackPlayers) {
        this.trackPlayers = trackPlayers;
    }

    public String getLootAcquiredMessage() {
        return this.lootAcquiredMessage;
    }

    public void setLootAcquiredMessage(String lootAcquiredMessage) {
        this.lootAcquiredMessage = lootAcquiredMessage;
    }

    public String getLootAcquiredSoundId() {
        return this.lootAcquiredSoundId;
    }

    public void setLootAcquiredSoundId(String lootAcquiredSoundId) {
        this.lootAcquiredSoundId = lootAcquiredSoundId;
    }

    public String getAlreadyLootedMessage() {
        return this.alreadyLootedMessage;
    }

    public void setAlreadyLootedMessage(String alreadyLootedMessage) {
        this.alreadyLootedMessage = alreadyLootedMessage;
    }

    public String getAlreadyLootedSoundId() {
        return this.alreadyLootedSoundId;
    }

    public void setAlreadyLootedSoundId(String alreadyLootedSoundId) {
        this.alreadyLootedSoundId = alreadyLootedSoundId;
    }

    public boolean isPlayerInSet(class_1657 playerEntity) {
        return this.playerSet.contains(playerEntity.method_5667());
    }

    public void addPlayerToSet(class_1657 playerEntity) {
        this.playerSet.add(playerEntity.method_5667());
    }

    public void removePlayerFromSet(class_1657 playerEntity) {
        this.playerSet.remove(playerEntity.method_5667());
    }

    @Override
    public void reset() {
        this.playerSet.clear();
    }

    public static enum Mode implements class_3542
    {
        CHOICE("choice"),
        RANDOM("random"),
        VANILLA("vanilla");

        private final String name;

        private Mode(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        public static Optional<Mode> byName(String name) {
            return Arrays.stream(Mode.values()).filter(mode -> mode.method_15434().equals(name)).findFirst();
        }

        public class_2561 asText() {
            return class_2561.method_43471((String)("gui.interactive_loot_block.mode." + this.name));
        }
    }
}

