/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.scriptblocks.block.entity;

import com.github.theredbrain.scriptblocks.block.Resetable;
import com.github.theredbrain.scriptblocks.block.RotatedBlockWithEntity;
import com.github.theredbrain.scriptblocks.block.Triggerable;
import com.github.theredbrain.scriptblocks.block.entity.EntranceDelegationBlockEntity;
import com.github.theredbrain.scriptblocks.block.entity.RotatedBlockEntity;
import com.github.theredbrain.scriptblocks.registry.EntityRegistry;
import com.github.theredbrain.scriptblocks.util.BlockRotationUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_7225;
import org.apache.commons.lang3.tuple.MutablePair;

public class LocationControlBlockEntity
extends RotatedBlockEntity
implements Resetable {
    private static final class_2338 DATA_PROVIDING_BLOCK_POS_DEFAULT = new class_2338(0, 1, 0);
    private static final class_2338 TRIGGERED_BLOCK_POS_DEFAULT = new class_2338(0, 2, 0);
    private static final int RESET_AREA_MIN_X_DEFAULT = -16;
    private static final int RESET_AREA_MIN_Z_DEFAULT = -16;
    private static final int RESET_AREA_MAX_X_DEFAULT = 31;
    private static final int RESET_AREA_MAX_Z_DEFAULT = 31;
    private MutablePair<class_2338, MutablePair<Double, Double>> mainEntrance = new MutablePair((Object)new class_2338(0, 1, 0), (Object)new MutablePair((Object)0.0, (Object)0.0));
    private HashMap<String, MutablePair<class_2338, MutablePair<Double, Double>>> sideEntrances = new HashMap(Map.of());
    private MutablePair<class_2338, Boolean> triggeredBlock = new MutablePair((Object)TRIGGERED_BLOCK_POS_DEFAULT, (Object)false);
    private class_2338 dataProvidingBlockPosOffset = DATA_PROVIDING_BLOCK_POS_DEFAULT;
    private boolean manualReset = false;
    private boolean shouldAlwaysReset = false;
    private int initialResetTimer = -1;
    private int resetAreaMinX = -16;
    private int resetAreaMinZ = -16;
    private int resetAreaMaxX = 31;
    private int resetAreaMaxZ = 31;

    public LocationControlBlockEntity(class_2338 pos, class_2680 state) {
        super(EntityRegistry.LOCATION_CONTROL_BLOCK_ENTITY, pos, state);
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        nbt.method_10569("mainEntrance_X", ((class_2338)this.mainEntrance.getLeft()).method_10263());
        nbt.method_10569("mainEntrance_Y", ((class_2338)this.mainEntrance.getLeft()).method_10264());
        nbt.method_10569("mainEntrance_Z", ((class_2338)this.mainEntrance.getLeft()).method_10260());
        nbt.method_10549("mainEntrance_Yaw", ((Double)((MutablePair)this.mainEntrance.getRight()).getLeft()).doubleValue());
        nbt.method_10549("mainEntrance_Pitch", ((Double)((MutablePair)this.mainEntrance.getRight()).getRight()).doubleValue());
        List keyList = this.sideEntrances.keySet().stream().toList();
        int sideEntrancesSize = this.sideEntrances.keySet().size();
        nbt.method_10569("sideEntrancesSize", sideEntrancesSize);
        for (int i = 0; i < sideEntrancesSize; ++i) {
            String key = (String)keyList.get(i);
            nbt.method_10582("key_" + i, key);
            nbt.method_10569("sideEntrance_" + i + "_X", ((class_2338)this.sideEntrances.get(key).getLeft()).method_10263());
            nbt.method_10569("sideEntrance_" + i + "_Y", ((class_2338)this.sideEntrances.get(key).getLeft()).method_10264());
            nbt.method_10569("sideEntrance_" + i + "_Z", ((class_2338)this.sideEntrances.get(key).getLeft()).method_10260());
            nbt.method_10549("sideEntrance_" + i + "_Yaw", ((Double)((MutablePair)this.sideEntrances.get(key).getRight()).getLeft()).doubleValue());
            nbt.method_10549("sideEntrance_" + i + "_Pitch", ((Double)((MutablePair)this.sideEntrances.get(key).getRight()).getRight()).doubleValue());
        }
        if (this.triggeredBlock.getLeft() != TRIGGERED_BLOCK_POS_DEFAULT || !((Boolean)this.triggeredBlock.getRight()).booleanValue()) {
            nbt.method_10569("triggeredBlockPositionOffsetX", ((class_2338)this.triggeredBlock.getLeft()).method_10263());
            nbt.method_10569("triggeredBlockPositionOffsetY", ((class_2338)this.triggeredBlock.getLeft()).method_10264());
            nbt.method_10569("triggeredBlockPositionOffsetZ", ((class_2338)this.triggeredBlock.getLeft()).method_10260());
            nbt.method_10556("triggeredBlockResets", ((Boolean)this.triggeredBlock.getRight()).booleanValue());
        } else {
            nbt.method_10551("triggeredBlockPositionOffsetX");
            nbt.method_10551("triggeredBlockPositionOffsetY");
            nbt.method_10551("triggeredBlockPositionOffsetZ");
            nbt.method_10551("triggeredBlockResets");
        }
        if (this.dataProvidingBlockPosOffset != DATA_PROVIDING_BLOCK_POS_DEFAULT) {
            nbt.method_10569("dataProvingBlockPosOffsetX", this.dataProvidingBlockPosOffset.method_10263());
            nbt.method_10569("dataProvingBlockPosOffsetY", this.dataProvidingBlockPosOffset.method_10264());
            nbt.method_10569("dataProvingBlockPosOffsetZ", this.dataProvidingBlockPosOffset.method_10260());
        } else {
            nbt.method_10551("dataProvingBlockPosOffsetX");
            nbt.method_10551("dataProvingBlockPosOffsetY");
            nbt.method_10551("dataProvingBlockPosOffsetZ");
        }
        nbt.method_10556("manualReset", this.manualReset);
        nbt.method_10556("shouldAlwaysReset", this.shouldAlwaysReset);
        nbt.method_10569("initialResetTimer", this.initialResetTimer);
        if (this.resetAreaMinX != -16) {
            nbt.method_10569("resetAreaMinX", this.resetAreaMinX);
        }
        if (this.resetAreaMinZ != -16) {
            nbt.method_10569("resetAreaMinZ", this.resetAreaMinZ);
        }
        if (this.resetAreaMaxX != 31) {
            nbt.method_10569("resetAreaMaxX", this.resetAreaMaxX);
        }
        if (this.resetAreaMaxZ != 31) {
            nbt.method_10569("resetAreaMaxZ", this.resetAreaMaxZ);
        }
        super.method_11007(nbt, registryLookup);
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        int mainEntrance_X = nbt.method_10550("mainEntrance_X");
        int mainEntrance_Y = nbt.method_10550("mainEntrance_Y");
        int mainEntrance_Z = nbt.method_10550("mainEntrance_Z");
        this.mainEntrance.setLeft((Object)new class_2338(mainEntrance_X, mainEntrance_Y, mainEntrance_Z));
        double mainEntrance_Yaw = nbt.method_10574("mainEntrance_Yaw");
        double mainEntrance_Pitch = nbt.method_10574("mainEntrance_Pitch");
        this.mainEntrance.setRight((Object)new MutablePair((Object)mainEntrance_Yaw, (Object)mainEntrance_Pitch));
        int sideEntrancesSize = nbt.method_10550("sideEntrancesSize");
        this.sideEntrances = new HashMap(Map.of());
        for (int i = 0; i < sideEntrancesSize; ++i) {
            String key = nbt.method_10558("key_" + i);
            int sideEntranceX = nbt.method_10550("sideEntrance_" + i + "_X");
            int sideEntranceY = nbt.method_10550("sideEntrance_" + i + "_Y");
            int sideEntranceZ = nbt.method_10550("sideEntrance_" + i + "_Z");
            double sideEntranceYaw = nbt.method_10574("sideEntrance_" + i + "_Yaw");
            double sideEntrancePitch = nbt.method_10574("sideEntrance_" + i + "_Pitch");
            this.sideEntrances.put(key, (MutablePair<class_2338, MutablePair<Double, Double>>)new MutablePair((Object)new class_2338(sideEntranceX, sideEntranceY, sideEntranceZ), (Object)new MutablePair((Object)sideEntranceYaw, (Object)sideEntrancePitch)));
        }
        if (nbt.method_10573("triggeredBlockPositionOffsetX", 3) && nbt.method_10573("triggeredBlockPositionOffsetY", 3) && nbt.method_10573("triggeredBlockPositionOffsetZ", 3) && nbt.method_10573("triggeredBlockResets", 1)) {
            this.triggeredBlock = new MutablePair((Object)new class_2338(class_3532.method_15340((int)nbt.method_10550("triggeredBlockPositionOffsetX"), (int)-48, (int)48), class_3532.method_15340((int)nbt.method_10550("triggeredBlockPositionOffsetY"), (int)-48, (int)48), class_3532.method_15340((int)nbt.method_10550("triggeredBlockPositionOffsetZ"), (int)-48, (int)48)), (Object)nbt.method_10577("triggeredBlockResets"));
        }
        if (nbt.method_10573("dataProvingBlockPosOffsetX", 3) && nbt.method_10573("dataProvingBlockPosOffsetY", 3) && nbt.method_10573("dataProvingBlockPosOffsetZ", 3)) {
            this.dataProvidingBlockPosOffset = new class_2338(class_3532.method_15340((int)nbt.method_10550("dataProvingBlockPosOffsetX"), (int)-48, (int)48), class_3532.method_15340((int)nbt.method_10550("dataProvingBlockPosOffsetY"), (int)-48, (int)48), class_3532.method_15340((int)nbt.method_10550("dataProvingBlockPosOffsetZ"), (int)-48, (int)48));
        }
        this.manualReset = nbt.method_10577("manualReset");
        this.shouldAlwaysReset = nbt.method_10577("shouldAlwaysReset");
        this.initialResetTimer = nbt.method_10573("initialResetTimer", 3) ? nbt.method_10550("initialResetTimer") : -1;
        this.resetAreaMinX = nbt.method_10545("resetAreaMinX") ? nbt.method_10550("resetAreaMinX") : -16;
        this.resetAreaMinZ = nbt.method_10545("resetAreaMinZ") ? nbt.method_10550("resetAreaMinZ") : -16;
        this.resetAreaMaxX = nbt.method_10545("resetAreaMaxX") ? nbt.method_10550("resetAreaMaxX") : 31;
        this.resetAreaMaxZ = nbt.method_10545("resetAreaMaxZ") ? nbt.method_10550("resetAreaMaxZ") : 31;
        super.method_11014(nbt, registryLookup);
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return this.method_58692(registryLookup);
    }

    public MutablePair<class_2338, MutablePair<Double, Double>> getMainEntrance() {
        return this.mainEntrance;
    }

    public void setMainEntrance(MutablePair<class_2338, MutablePair<Double, Double>> mainEntrance) {
        this.mainEntrance = mainEntrance;
    }

    public MutablePair<class_2338, MutablePair<Double, Double>> getTargetEntrance(class_3218 serverWorld, String entrance) {
        MutablePair targetOrientation;
        class_2338 targetPos;
        if (!entrance.isEmpty() && this.sideEntrances.containsKey(entrance)) {
            MutablePair<class_2338, MutablePair<Double, Double>> targetEntranceOffset = this.sideEntrances.get(entrance);
            targetPos = new class_2338(((class_2338)targetEntranceOffset.getLeft()).method_10263() + this.method_11016().method_10263(), ((class_2338)targetEntranceOffset.getLeft()).method_10264() + this.method_11016().method_10264(), ((class_2338)targetEntranceOffset.getLeft()).method_10260() + this.method_11016().method_10260());
            targetOrientation = (MutablePair)targetEntranceOffset.getRight();
        } else {
            targetPos = new class_2338(((class_2338)this.mainEntrance.getLeft()).method_10263() + this.method_11016().method_10263(), ((class_2338)this.mainEntrance.getLeft()).method_10264() + this.method_11016().method_10264(), ((class_2338)this.mainEntrance.getLeft()).method_10260() + this.method_11016().method_10260());
            targetOrientation = (MutablePair)this.mainEntrance.getRight();
        }
        class_2586 class_25862 = serverWorld.method_8321(targetPos);
        if (class_25862 instanceof EntranceDelegationBlockEntity) {
            EntranceDelegationBlockEntity entranceDelegationBlockEntity = (EntranceDelegationBlockEntity)class_25862;
            return entranceDelegationBlockEntity.getTargetEntrance(serverWorld);
        }
        return new MutablePair((Object)targetPos, (Object)targetOrientation);
    }

    public HashMap<String, MutablePair<class_2338, MutablePair<Double, Double>>> getSideEntrances() {
        return this.sideEntrances;
    }

    public void setSideEntrances(HashMap<String, MutablePair<class_2338, MutablePair<Double, Double>>> sideEntrances) {
        this.sideEntrances.clear();
        this.sideEntrances.putAll(sideEntrances);
    }

    public MutablePair<class_2338, Boolean> getTriggeredBlock() {
        return this.triggeredBlock;
    }

    public void setTriggeredBlock(MutablePair<class_2338, Boolean> triggeredBlock) {
        this.triggeredBlock = triggeredBlock;
    }

    public class_2338 getDataProvidingBlockPosOffset() {
        return this.dataProvidingBlockPosOffset;
    }

    public void setDataProvidingBlockPosOffset(class_2338 dataProvidingBlockPosOffset) {
        this.dataProvidingBlockPosOffset = dataProvidingBlockPosOffset;
    }

    public void trigger() {
        class_2586 blockEntity;
        this.manualReset = false;
        if (this.field_11863 != null && (blockEntity = this.field_11863.method_8321(new class_2338(this.field_11867.method_10263() + ((class_2338)this.triggeredBlock.getLeft()).method_10263(), this.field_11867.method_10264() + ((class_2338)this.triggeredBlock.getLeft()).method_10264(), this.field_11867.method_10260() + ((class_2338)this.triggeredBlock.getLeft()).method_10260()))) != this) {
            boolean triggeredBlockResets = (Boolean)this.triggeredBlock.getRight();
            if (triggeredBlockResets && blockEntity instanceof Resetable) {
                Resetable resetable = (Resetable)blockEntity;
                resetable.reset();
            } else if (!triggeredBlockResets && blockEntity instanceof Triggerable) {
                Triggerable triggerable = (Triggerable)blockEntity;
                triggerable.trigger();
            }
        }
    }

    public boolean shouldReset() {
        return this.manualReset || this.shouldAlwaysReset;
    }

    @Override
    public void reset() {
        this.manualReset = true;
    }

    public void setManualReset(boolean manualReset) {
        this.manualReset = manualReset;
    }

    public boolean shouldAlwaysReset() {
        return this.shouldAlwaysReset;
    }

    public void setShouldAlwaysReset(boolean shouldAlwaysReset) {
        this.shouldAlwaysReset = shouldAlwaysReset;
    }

    public int getResetAreaMinX() {
        return this.resetAreaMinX;
    }

    public void setResetAreaMinX(int resetAreaMinX) {
        this.resetAreaMinX = resetAreaMinX;
    }

    public int getResetAreaMinZ() {
        return this.resetAreaMinZ;
    }

    public void setResetAreaMinZ(int resetAreaMinZ) {
        this.resetAreaMinZ = resetAreaMinZ;
    }

    public int getResetAreaMaxX() {
        return this.resetAreaMaxX;
    }

    public void setResetAreaMaxX(int resetAreaMaxX) {
        this.resetAreaMaxX = resetAreaMaxX;
    }

    public int getResetAreaMaxZ() {
        return this.resetAreaMaxZ;
    }

    public void setResetAreaMaxZ(int resetAreaMaxZ) {
        this.resetAreaMaxZ = resetAreaMaxZ;
    }

    public int getInitialResetTimer() {
        return this.initialResetTimer;
    }

    public void setInitialResetTimer(int initialResetTimer) {
        this.initialResetTimer = initialResetTimer;
    }

    @Override
    protected void onRotate(class_2680 state) {
        if (state.method_26204() instanceof RotatedBlockWithEntity) {
            class_2382 resetAreaMax;
            MutablePair<class_2338, MutablePair<Double, Double>> mirroredEntrance;
            String key;
            int i;
            List keyList;
            if ((Integer)state.method_11654((class_2769)RotatedBlockWithEntity.ROTATED) != this.rotated) {
                class_2470 blockRotation = BlockRotationUtils.calculateRotationFromDifferentRotatedStates((Integer)state.method_11654((class_2769)RotatedBlockWithEntity.ROTATED), this.rotated);
                this.mainEntrance = BlockRotationUtils.rotateEntrance(this.mainEntrance, blockRotation);
                List keyList2 = this.sideEntrances.keySet().stream().toList();
                int sideEntrancesSize = this.sideEntrances.keySet().size();
                for (int i2 = 0; i2 < sideEntrancesSize; ++i2) {
                    String key2 = (String)keyList2.get(i2);
                    MutablePair<class_2338, MutablePair<Double, Double>> rotatedEntrance = BlockRotationUtils.rotateEntrance(this.sideEntrances.get(key2), blockRotation);
                    this.sideEntrances.put(key2, rotatedEntrance);
                }
                this.triggeredBlock.setLeft((Object)BlockRotationUtils.rotateOffsetBlockPos((class_2338)this.triggeredBlock.getLeft(), blockRotation));
                class_2382 resetAreaMin = BlockRotationUtils.rotateOffsetVec3i(new class_2382(this.resetAreaMinX, 0, this.resetAreaMinZ), blockRotation);
                this.resetAreaMinX = resetAreaMin.method_10263();
                this.resetAreaMinZ = resetAreaMin.method_10260();
                class_2382 resetAreaMax2 = BlockRotationUtils.rotateOffsetVec3i(new class_2382(this.resetAreaMaxX, 0, this.resetAreaMaxZ), blockRotation);
                this.resetAreaMaxX = resetAreaMax2.method_10263();
                this.resetAreaMaxZ = resetAreaMax2.method_10260();
                this.rotated = (Integer)state.method_11654((class_2769)RotatedBlockWithEntity.ROTATED);
            }
            if ((Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.X_MIRRORED) != this.x_mirrored) {
                this.mainEntrance = BlockRotationUtils.mirrorEntrance(this.mainEntrance, class_2415.field_11301);
                keyList = this.sideEntrances.keySet().stream().toList();
                int sideEntrancesSize = this.sideEntrances.keySet().size();
                for (i = 0; i < sideEntrancesSize; ++i) {
                    key = (String)keyList.get(i);
                    mirroredEntrance = BlockRotationUtils.mirrorEntrance(this.sideEntrances.get(key), class_2415.field_11301);
                    this.sideEntrances.put(key, mirroredEntrance);
                }
                this.triggeredBlock.setLeft((Object)BlockRotationUtils.mirrorOffsetBlockPos((class_2338)this.triggeredBlock.getLeft(), class_2415.field_11301));
                class_2382 resetAreaMin = BlockRotationUtils.mirrorOffsetVec3i(new class_2382(this.resetAreaMinX, 0, this.resetAreaMinZ), class_2415.field_11301);
                this.resetAreaMinX = resetAreaMin.method_10263();
                this.resetAreaMinZ = resetAreaMin.method_10260();
                resetAreaMax = BlockRotationUtils.mirrorOffsetVec3i(new class_2382(this.resetAreaMaxX, 0, this.resetAreaMaxZ), class_2415.field_11301);
                this.resetAreaMaxX = resetAreaMax.method_10263();
                this.resetAreaMaxZ = resetAreaMax.method_10260();
                this.x_mirrored = (Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.X_MIRRORED);
            }
            if ((Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.Z_MIRRORED) != this.z_mirrored) {
                this.mainEntrance = BlockRotationUtils.mirrorEntrance(this.mainEntrance, class_2415.field_11300);
                keyList = this.sideEntrances.keySet().stream().toList();
                int sideEntrancesSize = this.sideEntrances.keySet().size();
                for (i = 0; i < sideEntrancesSize; ++i) {
                    key = (String)keyList.get(i);
                    mirroredEntrance = BlockRotationUtils.mirrorEntrance(this.sideEntrances.get(key), class_2415.field_11300);
                    this.sideEntrances.put(key, mirroredEntrance);
                }
                this.triggeredBlock.setLeft((Object)BlockRotationUtils.mirrorOffsetBlockPos((class_2338)this.triggeredBlock.getLeft(), class_2415.field_11300));
                class_2382 resetAreaMin = BlockRotationUtils.mirrorOffsetVec3i(new class_2382(this.resetAreaMinX, 0, this.resetAreaMinZ), class_2415.field_11300);
                this.resetAreaMinX = resetAreaMin.method_10263();
                this.resetAreaMinZ = resetAreaMin.method_10260();
                resetAreaMax = BlockRotationUtils.mirrorOffsetVec3i(new class_2382(this.resetAreaMaxX, 0, this.resetAreaMaxZ), class_2415.field_11300);
                this.resetAreaMaxX = resetAreaMax.method_10263();
                this.resetAreaMaxZ = resetAreaMax.method_10260();
                this.z_mirrored = (Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.Z_MIRRORED);
            }
        }
    }
}

