/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.scriptblocks.block.entity;

import com.github.theredbrain.scriptblocks.ScriptBlocks;
import com.github.theredbrain.scriptblocks.block.LootableVaultBlock;
import com.github.theredbrain.scriptblocks.block.lootable_vault.LootableVaultClientData;
import com.github.theredbrain.scriptblocks.block.lootable_vault.LootableVaultServerData;
import com.github.theredbrain.scriptblocks.block.lootable_vault.LootableVaultSharedData;
import com.github.theredbrain.scriptblocks.block.lootable_vault.LootableVaultState;
import com.github.theredbrain.scriptblocks.data.LootableVaultConfig;
import com.github.theredbrain.scriptblocks.registry.CustomDynamicRegistries;
import com.github.theredbrain.scriptblocks.registry.EntityRegistry;
import com.github.theredbrain.scriptblocks.util.DebuggingHelper;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8567;
import net.minecraft.class_9197;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class LootableVaultBlockEntity
extends class_2586 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final LootableVaultServerData serverData = new LootableVaultServerData();
    private final LootableVaultSharedData sharedData = new LootableVaultSharedData();
    private final LootableVaultClientData clientData = new LootableVaultClientData();
    private String lootableVaultConfigIdentifier = "";

    public LootableVaultBlockEntity(class_2338 pos, class_2680 state) {
        super(EntityRegistry.LOOTABLE_VAULT_BLOCK_ENTITY, pos, state);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return (class_2487)class_156.method_654((Object)new class_2487(), nbt -> nbt.method_10566("shared_data", LootableVaultBlockEntity.encodeValue(LootableVaultSharedData.CODEC, this.sharedData, registryLookup)));
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        nbt.method_10582("config_identifier", this.lootableVaultConfigIdentifier);
        nbt.method_10566("shared_data", LootableVaultBlockEntity.encodeValue(LootableVaultSharedData.CODEC, this.sharedData, registryLookup));
        nbt.method_10566("server_data", LootableVaultBlockEntity.encodeValue(LootableVaultServerData.CODEC, this.serverData, registryLookup));
        super.method_11007(nbt, registryLookup);
    }

    private static <T> class_2520 encodeValue(Codec<T> codec, T value, class_7225.class_7874 registries) {
        return (class_2520)codec.encodeStart((DynamicOps)registries.method_57093((DynamicOps)class_2509.field_11560), value).getOrThrow();
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        class_6903 dynamicOps = registryLookup.method_57093((DynamicOps)class_2509.field_11560);
        if (nbt.method_10545("server_data")) {
            LootableVaultServerData.CODEC.parse((DynamicOps)dynamicOps, (Object)nbt.method_10580("server_data")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(this.serverData::copyFrom);
        }
        this.lootableVaultConfigIdentifier = nbt.method_10558("config_identifier");
        if (nbt.method_10545("shared_data")) {
            LootableVaultSharedData.CODEC.parse((DynamicOps)dynamicOps, (Object)nbt.method_10580("shared_data")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(this.sharedData::copyFrom);
        }
        super.method_11014(nbt, registryLookup);
    }

    @Nullable
    public LootableVaultServerData getServerData() {
        return this.field_11863 != null && !this.field_11863.field_9236 ? this.serverData : null;
    }

    public LootableVaultSharedData getSharedData() {
        return this.sharedData;
    }

    public LootableVaultClientData getClientData() {
        return this.clientData;
    }

    public void markAsRewarded(class_3222 serverPlayerEntity, class_1799 itemStack) {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            LootableVaultServerData serverData = this.getServerData();
            LootableVaultSharedData sharedData = this.getSharedData();
            LootableVaultConfig config = this.getConfig((class_1937)serverWorld);
            if (serverData != null && sharedData != null) {
                serverPlayerEntity.method_7259(class_3468.field_15372.method_14956((Object)itemStack.method_7909()));
                itemStack.method_57008(config.keyItem().method_7947(), (class_1309)serverPlayerEntity);
                Server.unlock(serverWorld, serverWorld.method_8320(this.field_11867), this.field_11867, config, serverData, sharedData);
                serverData.markPlayerAsRewarded((class_1657)serverPlayerEntity);
                sharedData.updateConnectedPlayers(serverWorld, this.field_11867, serverData, config, config.deactivationRange());
            }
        }
    }

    public LootableVaultConfig getConfig(class_1937 world) {
        LootableVaultConfig lootableVaultConfig = (LootableVaultConfig)world.method_30349().method_30530(CustomDynamicRegistries.LOOTABLE_VAULT_CONFIG_REGISTRY_KEY).method_10223(class_2960.method_60654((String)this.lootableVaultConfigIdentifier));
        if (lootableVaultConfig != null) {
            return lootableVaultConfig;
        }
        DebuggingHelper.sendLootableVaultLogMessage("Config not valid: " + this.lootableVaultConfigIdentifier, null);
        return LootableVaultConfig.DEFAULT;
    }

    public static final class Server {
        private static final int UNLOCK_TIME = 14;
        private static final int DISPLAY_UPDATE_INTERVAL = 20;
        private static final int FAILED_UNLOCK_COOLDOWN = 15;

        public static void tick(class_3218 world, class_2338 pos, class_2680 state, LootableVaultConfig config, LootableVaultServerData serverData, LootableVaultSharedData sharedData) {
            LootableVaultState vaultState = (LootableVaultState)((Object)state.method_11654(LootableVaultBlock.LOOTABLE_VAULT_STATE));
            if (Server.shouldUpdateDisplayItem(world.method_8510(), vaultState)) {
                Server.updateDisplayItem(world, vaultState, config, sharedData, pos);
            }
            class_2680 blockState = state;
            if (world.method_8510() >= serverData.getStateUpdatingResumeTime() && !state.equals(blockState = (class_2680)state.method_11657(LootableVaultBlock.LOOTABLE_VAULT_STATE, (Comparable)((Object)vaultState.update(world, pos, config, serverData, sharedData))))) {
                Server.changeVaultState(world, pos, state, blockState, config, sharedData);
            }
            if (serverData.isDirty() || sharedData.isDirty()) {
                LootableVaultBlockEntity.method_31663((class_1937)((class_1937)world), (class_2338)pos, (class_2680)state);
                if (sharedData.isDirty()) {
                    world.method_8413(pos, state, blockState, 2);
                }
                serverData.markClean();
                sharedData.markClean();
            }
        }

        public static void tryUnlock(class_3218 world, class_2338 pos, class_2680 state, LootableVaultConfig config, LootableVaultServerData serverData, LootableVaultSharedData sharedData, class_1657 player, class_1799 stack) {
            LootableVaultState vaultState = (LootableVaultState)((Object)state.method_11654(LootableVaultBlock.LOOTABLE_VAULT_STATE));
            if (Server.canBeUnlocked(config, vaultState)) {
                if (!Server.isValidKey(config, stack)) {
                    ScriptBlocks.info("invalid key");
                    Server.playFailedUnlockSound(world, serverData, pos, class_3417.field_48792);
                } else if (serverData.hasRewardedPlayer(player)) {
                    ScriptBlocks.info("player already rewarded");
                    Server.playFailedUnlockSound(world, serverData, pos, class_3417.field_51988);
                } else if (player instanceof class_3222) {
                    class_3222 serverPlayerEntity = (class_3222)player;
                    ScriptBlocks.supplyLootableLoot(class_2960.method_60654((String)config.lootableIdentifier()), world, serverPlayerEntity, class_243.method_24954((class_2382)pos), config.rolls(), config.choices(), config.withChoice(), stack);
                    serverData.markPlayerAsRewarded(player);
                    sharedData.updateConnectedPlayers(world, pos, serverData, config, config.deactivationRange());
                }
            }
        }

        static void changeVaultState(class_3218 world, class_2338 pos, class_2680 oldState, class_2680 newState, LootableVaultConfig config, LootableVaultSharedData sharedData) {
            LootableVaultState vaultState = (LootableVaultState)((Object)oldState.method_11654(LootableVaultBlock.LOOTABLE_VAULT_STATE));
            LootableVaultState vaultState2 = (LootableVaultState)((Object)newState.method_11654(LootableVaultBlock.LOOTABLE_VAULT_STATE));
            world.method_8652(pos, newState, 3);
            vaultState.onStateChange(world, pos, vaultState2, config, sharedData, (Boolean)newState.method_11654((class_2769)class_9197.field_50171));
        }

        public static void updateDisplayItem(class_3218 world, LootableVaultState state, LootableVaultConfig config, LootableVaultSharedData sharedData, class_2338 pos) {
            if (!Server.canBeUnlocked(config, state)) {
                sharedData.setDisplayItem(class_1799.field_8037);
            } else {
                class_1799 itemStack = class_1799.field_8037;
                if (!config.displayLootTableIdentifier().isEmpty()) {
                    itemStack = Server.generateDisplayItem(world, pos, world.method_8503().method_58576().method_58295(class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)class_2960.method_60654((String)config.displayLootTableIdentifier()))));
                }
                sharedData.setDisplayItem(itemStack);
            }
        }

        private static class_1799 generateDisplayItem(class_3218 world, class_2338 pos, class_52 lootTable) {
            class_8567 lootContextParameterSet = new class_8567.class_8568(world).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)pos)).method_51875(class_173.field_48928);
            ObjectArrayList list = lootTable.method_60569(lootContextParameterSet, world.method_8409());
            return list.isEmpty() ? class_1799.field_8037 : (class_1799)class_156.method_32309((List)list, (class_5819)world.method_8409());
        }

        public static void unlock(class_3218 world, class_2680 state, class_2338 pos, LootableVaultConfig config, LootableVaultServerData serverData, LootableVaultSharedData sharedData) {
            sharedData.setDisplayItem(class_1799.field_8037);
            serverData.setStateUpdatingResumeTime(world.method_8510() + 14L);
            Server.changeVaultState(world, pos, state, (class_2680)state.method_11657(LootableVaultBlock.LOOTABLE_VAULT_STATE, (Comparable)((Object)LootableVaultState.UNLOCKING)), config, sharedData);
        }

        private static boolean canBeUnlocked(LootableVaultConfig config, LootableVaultState state) {
            return !Objects.equals(config.lootableIdentifier(), "") && !config.keyItem().method_7960() && state != LootableVaultState.INACTIVE;
        }

        private static boolean isValidKey(LootableVaultConfig config, class_1799 stack) {
            return class_1799.method_31577((class_1799)stack, (class_1799)config.keyItem()) && stack.method_7947() >= config.keyItem().method_7947();
        }

        private static boolean shouldUpdateDisplayItem(long time, LootableVaultState state) {
            return time % 20L == 0L && state == LootableVaultState.ACTIVE;
        }

        private static void playFailedUnlockSound(class_3218 world, LootableVaultServerData serverData, class_2338 pos, class_3414 sound) {
            if (world.method_8510() >= serverData.getLastFailedUnlockTime() + 15L) {
                world.method_45447(null, pos, sound, class_3419.field_15245);
                serverData.setLastFailedUnlockTime(world.method_8510());
            }
        }
    }

    public static final class Client {
        private static final int field_48870 = 20;
        private static final float field_48871 = 0.5f;
        private static final float field_48872 = 0.02f;
        private static final int field_48873 = 20;
        private static final int field_48874 = 20;

        public static void tick(class_1937 world, class_2338 pos, class_2680 state, LootableVaultClientData clientData, LootableVaultSharedData sharedData) {
            clientData.rotateDisplay();
            if (world.method_8510() % 20L == 0L) {
                Client.spawnConnectedParticles(world, pos, state, sharedData);
            }
            Client.spawnAmbientParticles(world, pos, sharedData, (class_2394)((Boolean)state.method_11654((class_2769)class_9197.field_50171) != false ? class_2398.field_22246 : class_2398.field_27783));
            Client.playAmbientSound(world, pos, sharedData);
        }

        public static void spawnActivateParticles(class_1937 world, class_2338 pos, class_2680 state, LootableVaultSharedData sharedData, class_2394 particle) {
            Client.spawnConnectedParticles(world, pos, state, sharedData);
            class_5819 random = world.field_9229;
            for (int i = 0; i < 20; ++i) {
                class_243 vec3d = Client.getRegularParticlesPos(pos, random);
                world.method_8406((class_2394)class_2398.field_11251, vec3d.method_10216(), vec3d.method_10214(), vec3d.method_10215(), 0.0, 0.0, 0.0);
                world.method_8406(particle, vec3d.method_10216(), vec3d.method_10214(), vec3d.method_10215(), 0.0, 0.0, 0.0);
            }
        }

        public static void spawnDeactivateParticles(class_1937 world, class_2338 pos, class_2394 particle) {
            class_5819 random = world.field_9229;
            for (int i = 0; i < 20; ++i) {
                class_243 vec3d = Client.getDeactivateParticlesPos(pos, random);
                class_243 vec3d2 = new class_243(random.method_43059() * 0.02, random.method_43059() * 0.02, random.method_43059() * 0.02);
                world.method_8406(particle, vec3d.method_10216(), vec3d.method_10214(), vec3d.method_10215(), vec3d2.method_10216(), vec3d2.method_10214(), vec3d2.method_10215());
            }
        }

        private static void spawnAmbientParticles(class_1937 world, class_2338 pos, LootableVaultSharedData sharedData, class_2394 particle) {
            class_5819 random = world.method_8409();
            if (random.method_43057() <= 0.5f) {
                class_243 vec3d = Client.getRegularParticlesPos(pos, random);
                world.method_8406((class_2394)class_2398.field_11251, vec3d.method_10216(), vec3d.method_10214(), vec3d.method_10215(), 0.0, 0.0, 0.0);
                if (Client.hasDisplayItem(sharedData)) {
                    world.method_8406(particle, vec3d.method_10216(), vec3d.method_10214(), vec3d.method_10215(), 0.0, 0.0, 0.0);
                }
            }
        }

        private static void spawnConnectedParticlesFor(class_1937 world, class_243 pos, class_1657 player) {
            class_5819 random = world.field_9229;
            class_243 vec3d = pos.method_1035(player.method_19538().method_1031(0.0, (double)(player.method_17682() / 2.0f), 0.0));
            int i = class_3532.method_15395((class_5819)random, (int)2, (int)5);
            for (int j = 0; j < i; ++j) {
                class_243 vec3d2 = vec3d.method_49272(random, 1.0f);
                world.method_8406((class_2394)class_2398.field_48975, pos.method_10216(), pos.method_10214(), pos.method_10215(), vec3d2.method_10216(), vec3d2.method_10214(), vec3d2.method_10215());
            }
        }

        private static void spawnConnectedParticles(class_1937 world, class_2338 pos, class_2680 state, LootableVaultSharedData sharedData) {
            Set<UUID> set = sharedData.getConnectedPlayers();
            if (!set.isEmpty()) {
                class_243 vec3d = Client.getConnectedParticlesOrigin(pos, (class_2350)state.method_11654((class_2769)class_9197.field_48858));
                for (UUID uUID : set) {
                    class_1657 playerEntity = world.method_18470(uUID);
                    if (playerEntity == null || !Client.isPlayerWithinConnectedParticlesRange(pos, sharedData, playerEntity)) continue;
                    Client.spawnConnectedParticlesFor(world, vec3d, playerEntity);
                }
            }
        }

        private static boolean isPlayerWithinConnectedParticlesRange(class_2338 pos, LootableVaultSharedData sharedData, class_1657 player) {
            return player.method_24515().method_10262((class_2382)pos) <= class_3532.method_33723((double)sharedData.getConnectedParticlesRange());
        }

        private static void playAmbientSound(class_1937 world, class_2338 pos, LootableVaultSharedData sharedData) {
            class_5819 random;
            if (Client.hasDisplayItem(sharedData) && (random = world.method_8409()).method_43057() <= 0.02f) {
                world.method_45446(pos, class_3417.field_48797, class_3419.field_15245, random.method_43057() * 0.25f + 0.75f, random.method_43057() + 0.5f, false);
            }
        }

        public static boolean hasDisplayItem(LootableVaultSharedData sharedData) {
            return sharedData.hasDisplayItem();
        }

        private static class_243 getDeactivateParticlesPos(class_2338 pos, class_5819 random) {
            return class_243.method_24954((class_2382)pos).method_1031(class_3532.method_15366((class_5819)random, (double)0.4, (double)0.6), class_3532.method_15366((class_5819)random, (double)0.4, (double)0.6), class_3532.method_15366((class_5819)random, (double)0.4, (double)0.6));
        }

        private static class_243 getRegularParticlesPos(class_2338 pos, class_5819 random) {
            return class_243.method_24954((class_2382)pos).method_1031(class_3532.method_15366((class_5819)random, (double)0.1, (double)0.9), class_3532.method_15366((class_5819)random, (double)0.25, (double)0.75), class_3532.method_15366((class_5819)random, (double)0.1, (double)0.9));
        }

        private static class_243 getConnectedParticlesOrigin(class_2338 pos, class_2350 direction) {
            return class_243.method_24955((class_2382)pos).method_1031((double)direction.method_10148() * 0.5, 1.75, (double)direction.method_10165() * 0.5);
        }
    }
}

