/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.scriptblocks.block.entity;

import com.github.theredbrain.scriptblocks.block.ProvidesData;
import com.github.theredbrain.scriptblocks.block.Resetable;
import com.github.theredbrain.scriptblocks.block.RotatedBlockWithEntity;
import com.github.theredbrain.scriptblocks.block.Triggerable;
import com.github.theredbrain.scriptblocks.block.entity.RotatedBlockEntity;
import com.github.theredbrain.scriptblocks.data.PVPArenaSettings;
import com.github.theredbrain.scriptblocks.registry.CustomDynamicRegistries;
import com.github.theredbrain.scriptblocks.registry.DamageTypesRegistry;
import com.github.theredbrain.scriptblocks.registry.EntityRegistry;
import com.github.theredbrain.scriptblocks.util.BlockRotationUtils;
import com.github.theredbrain.scriptblocks.util.ItemUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_268;
import net.minecraft.class_2680;
import net.minecraft.class_269;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import org.apache.commons.lang3.tuple.MutablePair;
import org.jetbrains.annotations.Nullable;

public class PVPControllerBlockEntity
extends RotatedBlockEntity
implements Resetable,
Triggerable {
    private String pvpArenaSettingsIdentifier = "";
    private HashMap<String, MutablePair<class_2338, MutablePair<Double, Double>>> respawnPositions = new HashMap(Map.of());
    private MutablePair<class_2338, Boolean> triggeredBlock = new MutablePair((Object)class_2338.field_10980, (Object)false);
    private class_2338 dataProvidingBlockPosOffset = class_2338.field_10980;
    private Set<String> teamSet = new HashSet<String>();
    private Set<UUID> playerUUIDSet = new HashSet<UUID>();
    private boolean matchIsActive = false;
    private String matchDurationDataIdentifier = "";
    private int matchDuration = 0;
    private int matchTicker = 0;

    public PVPControllerBlockEntity(class_2338 pos, class_2680 state) {
        super(EntityRegistry.PVP_CONTROLLER_BLOCK_ENTITY, pos, state);
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        if (!this.pvpArenaSettingsIdentifier.isEmpty()) {
            nbt.method_10582("pvpArenaSettingsIdentifier", this.pvpArenaSettingsIdentifier);
        } else {
            nbt.method_10551("pvpArenaSettingsIdentifier");
        }
        List keyList = this.respawnPositions.keySet().stream().toList();
        int respawnPositionsSize = this.respawnPositions.keySet().size();
        nbt.method_10569("respawnPositionsSize", respawnPositionsSize);
        for (int i = 0; i < respawnPositionsSize; ++i) {
            String key = (String)keyList.get(i);
            nbt.method_10582("key_" + i, key);
            nbt.method_10569("respawnPosition_" + i + "_X", ((class_2338)this.respawnPositions.get(key).getLeft()).method_10263());
            nbt.method_10569("respawnPosition_" + i + "_Y", ((class_2338)this.respawnPositions.get(key).getLeft()).method_10264());
            nbt.method_10569("respawnPosition_" + i + "_Z", ((class_2338)this.respawnPositions.get(key).getLeft()).method_10260());
            nbt.method_10549("respawnPosition_" + i + "_Yaw", ((Double)((MutablePair)this.respawnPositions.get(key).getRight()).getLeft()).doubleValue());
            nbt.method_10549("respawnPosition_" + i + "_Pitch", ((Double)((MutablePair)this.respawnPositions.get(key).getRight()).getRight()).doubleValue());
        }
        nbt.method_10569("triggeredBlockPositionOffsetX", ((class_2338)this.triggeredBlock.getLeft()).method_10263());
        nbt.method_10569("triggeredBlockPositionOffsetY", ((class_2338)this.triggeredBlock.getLeft()).method_10264());
        nbt.method_10569("triggeredBlockPositionOffsetZ", ((class_2338)this.triggeredBlock.getLeft()).method_10260());
        nbt.method_10556("triggeredBlockResets", ((Boolean)this.triggeredBlock.getRight()).booleanValue());
        nbt.method_10569("dataProvidingBlockPosOffsetX", this.dataProvidingBlockPosOffset.method_10263());
        nbt.method_10569("dataProvidingBlockPosOffsetY", this.dataProvidingBlockPosOffset.method_10264());
        nbt.method_10569("dataProvidingBlockPosOffsetZ", this.dataProvidingBlockPosOffset.method_10260());
        if (!this.matchDurationDataIdentifier.isEmpty()) {
            nbt.method_10582("matchDurationDataIdentifier", this.matchDurationDataIdentifier);
        } else {
            nbt.method_10551("matchDurationDataIdentifier");
        }
        super.method_11007(nbt, registryLookup);
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        this.pvpArenaSettingsIdentifier = nbt.method_10545("pvpArenaSettingsIdentifier") ? nbt.method_10558("pvpArenaSettingsIdentifier") : "";
        int respawnPositionsSize = nbt.method_10550("respawnPositionsSize");
        this.respawnPositions = new HashMap(Map.of());
        for (int i = 0; i < respawnPositionsSize; ++i) {
            String key = nbt.method_10558("key_" + i);
            int respawnPositionX = nbt.method_10550("respawnPosition_" + i + "_X");
            int respawnPositionY = nbt.method_10550("respawnPosition_" + i + "_Y");
            int respawnPositionZ = nbt.method_10550("respawnPosition_" + i + "_Z");
            double respawnPositionYaw = nbt.method_10574("respawnPosition_" + i + "_Yaw");
            double respawnPositionPitch = nbt.method_10574("respawnPosition_" + i + "_Pitch");
            this.respawnPositions.put(key, (MutablePair<class_2338, MutablePair<Double, Double>>)new MutablePair((Object)new class_2338(respawnPositionX, respawnPositionY, respawnPositionZ), (Object)new MutablePair((Object)respawnPositionYaw, (Object)respawnPositionPitch)));
        }
        int x = class_3532.method_15340((int)nbt.method_10550("triggeredBlockPositionOffsetX"), (int)-48, (int)48);
        int y = class_3532.method_15340((int)nbt.method_10550("triggeredBlockPositionOffsetY"), (int)-48, (int)48);
        int z = class_3532.method_15340((int)nbt.method_10550("triggeredBlockPositionOffsetZ"), (int)-48, (int)48);
        this.triggeredBlock = new MutablePair((Object)new class_2338(x, y, z), (Object)nbt.method_10577("triggeredBlockResets"));
        this.dataProvidingBlockPosOffset = new class_2338(class_3532.method_15340((int)nbt.method_10550("dataProvidingBlockPosOffsetX"), (int)-48, (int)48), class_3532.method_15340((int)nbt.method_10550("dataProvidingBlockPosOffsetY"), (int)-48, (int)48), class_3532.method_15340((int)nbt.method_10550("dataProvidingBlockPosOffsetZ"), (int)-48, (int)48));
        this.matchDurationDataIdentifier = nbt.method_10545("matchDurationDataIdentifier") ? nbt.method_10558("matchDurationDataIdentifier") : "";
        super.method_11014(nbt, registryLookup);
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return this.method_58692(registryLookup);
    }

    public String getPVPArenaSettingsIdentifier() {
        return this.pvpArenaSettingsIdentifier;
    }

    public boolean setPVPArenaSettingsIdentifier(String newPVPArenaSettingsIdentifier) {
        Optional optionalPVPArenaSettingsReference;
        PVPArenaSettings pvpArenaSettings = null;
        class_2960 identifier = class_2960.method_12829((String)newPVPArenaSettingsIdentifier);
        if (identifier != null && this.field_11863 != null && (optionalPVPArenaSettingsReference = this.field_11863.method_30349().method_30530(CustomDynamicRegistries.PVP_ARENA_SETTINGS_REGISTRY_KEY).method_55841(identifier)).isPresent()) {
            pvpArenaSettings = (PVPArenaSettings)((class_6880.class_6883)optionalPVPArenaSettingsReference.get()).comp_349();
        }
        if (newPVPArenaSettingsIdentifier.isEmpty() || pvpArenaSettings != null) {
            this.pvpArenaSettingsIdentifier = newPVPArenaSettingsIdentifier;
            return true;
        }
        return false;
    }

    public HashMap<String, MutablePair<class_2338, MutablePair<Double, Double>>> getRespawnPositions() {
        return this.respawnPositions;
    }

    public void setRespawnPositions(HashMap<String, MutablePair<class_2338, MutablePair<Double, Double>>> respawnPositions) {
        this.respawnPositions.clear();
        this.respawnPositions.putAll(respawnPositions);
    }

    public MutablePair<class_2338, Boolean> getTriggeredBlock() {
        return this.triggeredBlock;
    }

    public void setTriggeredBlock(MutablePair<class_2338, Boolean> triggeredBlock) {
        this.triggeredBlock = triggeredBlock;
    }

    public class_2338 getDataProvidingBlockPosOffset() {
        return this.dataProvidingBlockPosOffset;
    }

    public void setDataProvidingBlockPosOffset(class_2338 firstDataProvidingBlockPosOffset) {
        this.dataProvidingBlockPosOffset = firstDataProvidingBlockPosOffset;
    }

    public String getMatchDurationDataIdentifier() {
        return this.matchDurationDataIdentifier;
    }

    public void setMatchDurationDataIdentifier(String matchDurationDataIdentifier) {
        this.matchDurationDataIdentifier = matchDurationDataIdentifier;
    }

    @Nullable
    public MutablePair<class_2338, MutablePair<Double, Double>> getTeamRespawnPosition(String teamId, boolean endOfBattle) {
        Optional optionalPVPArenaSettingsReference;
        PVPArenaSettings pvpArenaSettings = null;
        class_2960 identifier = class_2960.method_12829((String)this.pvpArenaSettingsIdentifier);
        if (identifier != null && this.field_11863 != null && (optionalPVPArenaSettingsReference = this.field_11863.method_30349().method_30530(CustomDynamicRegistries.PVP_ARENA_SETTINGS_REGISTRY_KEY).method_55841(identifier)).isPresent()) {
            pvpArenaSettings = (PVPArenaSettings)((class_6880.class_6883)optionalPVPArenaSettingsReference.get()).comp_349();
        }
        if (pvpArenaSettings != null) {
            PVPArenaSettings.TeamSettings teamSettings = pvpArenaSettings.team_settings().get(teamId);
            if (teamSettings != null) {
                return this.respawnPositions.get(endOfBattle ? teamSettings.end_of_battle_respawn_pos() : teamSettings.battle_respawn_pos());
            }
            if (!pvpArenaSettings.default_respawn_pos().isEmpty()) {
                return this.respawnPositions.get(pvpArenaSettings.default_respawn_pos());
            }
        }
        return null;
    }

    public void addPlayerAndTeam(class_268 team, class_1657 playerEntity) {
        this.teamSet.add(team.method_1197());
        this.playerUUIDSet.add(playerEntity.method_5667());
    }

    public void removePlayer(class_1657 playerEntity) {
        this.playerUUIDSet.remove(playerEntity.method_5667());
    }

    public void initMatchDuration() {
        class_2338 firstDataProviderBlockPos;
        class_2586 class_25862;
        if (this.field_11863 != null && !this.field_11863.method_8608() && this.dataProvidingBlockPosOffset != class_2338.field_10980 && (class_25862 = this.field_11863.method_8321(firstDataProviderBlockPos = new class_2338(this.field_11867.method_10263() + this.dataProvidingBlockPosOffset.method_10263(), this.field_11867.method_10264() + this.dataProvidingBlockPosOffset.method_10264(), this.field_11867.method_10260() + this.dataProvidingBlockPosOffset.method_10260()))) instanceof ProvidesData) {
            ProvidesData providesDataEntity = (ProvidesData)class_25862;
            this.matchDuration = ItemUtils.parseInt(providesDataEntity.getData(this.matchDurationDataIdentifier));
            return;
        }
        this.matchDuration = 0;
    }

    public void startMatch() {
        this.initMatchDuration();
        this.matchIsActive = true;
    }

    public void endMatch(boolean forceEnd) {
        if (this.field_11863 != null) {
            class_2586 blockEntity;
            if (!forceEnd && (blockEntity = this.field_11863.method_8321(new class_2338(this.field_11867.method_10263() + ((class_2338)this.triggeredBlock.getLeft()).method_10263(), this.field_11867.method_10264() + ((class_2338)this.triggeredBlock.getLeft()).method_10264(), this.field_11867.method_10260() + ((class_2338)this.triggeredBlock.getLeft()).method_10260()))) != this) {
                boolean triggeredBlockResets = (Boolean)this.triggeredBlock.getRight();
                if (triggeredBlockResets && blockEntity instanceof Resetable) {
                    Resetable resetable = (Resetable)blockEntity;
                    resetable.reset();
                } else if (!triggeredBlockResets && blockEntity instanceof Triggerable) {
                    Triggerable triggerable = (Triggerable)blockEntity;
                    triggerable.trigger();
                }
            }
            class_2378 registry = this.field_11863.method_30349().method_30530(class_7924.field_42534);
            class_1282 damageSource = new class_1282((class_6880)registry.method_40290(DamageTypesRegistry.PVP_WINNING_DAMAGE_TYPE));
            Iterator iterator = this.playerUUIDSet.stream().iterator();
            while (iterator.hasNext()) {
                class_1937 class_19372;
                class_1657 playerEntity = this.field_11863.method_18470((UUID)iterator.next());
                if (playerEntity == null) continue;
                playerEntity.method_5643(damageSource, 2048.0f);
                if (forceEnd || !((class_19372 = this.field_11863) instanceof class_3218)) continue;
                class_3218 serverWorld = (class_3218)class_19372;
                serverWorld.method_8503().method_3760().method_43514((class_2561)class_2561.method_43469((String)"hud.message.pvp_controller_block.player_won_match", (Object[])new Object[]{playerEntity.method_5476()}), false);
            }
        }
        this.matchTicker = 0;
        this.matchIsActive = false;
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, PVPControllerBlockEntity pvpControllerBlockEntity) {
        if (!world.field_9236 && pvpControllerBlockEntity.matchIsActive) {
            ++pvpControllerBlockEntity.matchTicker;
            if (pvpControllerBlockEntity.matchTicker > pvpControllerBlockEntity.matchDuration) {
                pvpControllerBlockEntity.endMatch(false);
            }
            if (pvpControllerBlockEntity.matchTicker % 20 == 0) {
                Iterator iterator = pvpControllerBlockEntity.teamSet.stream().iterator();
                class_269 scoreboard = world.method_8428();
                int activeTeamCounter = 0;
                while (iterator.hasNext()) {
                    class_268 team = scoreboard.method_1153((String)iterator.next());
                    if (team == null) continue;
                    if (team.method_1204().isEmpty()) {
                        pvpControllerBlockEntity.teamSet.remove(team.method_1197());
                        continue;
                    }
                    ++activeTeamCounter;
                }
                if (activeTeamCounter <= 1) {
                    pvpControllerBlockEntity.endMatch(false);
                }
            }
        }
    }

    @Override
    public void trigger() {
        this.startMatch();
    }

    @Override
    public void reset() {
        this.endMatch(true);
        this.teamSet.clear();
        this.playerUUIDSet.clear();
    }

    @Override
    protected void onRotate(class_2680 state) {
        if (state.method_26204() instanceof RotatedBlockWithEntity) {
            MutablePair<class_2338, MutablePair<Double, Double>> mirroredEntrance;
            int i;
            List keyList;
            if ((Integer)state.method_11654((class_2769)RotatedBlockWithEntity.ROTATED) != this.rotated) {
                class_2470 blockRotation = BlockRotationUtils.calculateRotationFromDifferentRotatedStates((Integer)state.method_11654((class_2769)RotatedBlockWithEntity.ROTATED), this.rotated);
                List keyList2 = this.respawnPositions.keySet().stream().toList();
                int sideEntrancesSize = this.respawnPositions.keySet().size();
                for (int i2 = 0; i2 < sideEntrancesSize; ++i2) {
                    String key = (String)keyList2.get(i2);
                    MutablePair<class_2338, MutablePair<Double, Double>> rotatedEntrance = BlockRotationUtils.rotateEntrance(this.respawnPositions.get(key), blockRotation);
                    this.respawnPositions.put(key, rotatedEntrance);
                }
                this.triggeredBlock.setLeft((Object)BlockRotationUtils.rotateOffsetBlockPos((class_2338)this.triggeredBlock.getLeft(), blockRotation));
                this.rotated = (Integer)state.method_11654((class_2769)RotatedBlockWithEntity.ROTATED);
            }
            if ((Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.X_MIRRORED) != this.x_mirrored) {
                keyList = this.respawnPositions.keySet().stream().toList();
                int sideEntrancesSize = this.respawnPositions.keySet().size();
                for (i = 0; i < sideEntrancesSize; ++i) {
                    String key = (String)keyList.get(i);
                    mirroredEntrance = BlockRotationUtils.mirrorEntrance(this.respawnPositions.get(key), class_2415.field_11301);
                    this.respawnPositions.put(key, mirroredEntrance);
                }
                this.triggeredBlock.setLeft((Object)BlockRotationUtils.mirrorOffsetBlockPos((class_2338)this.triggeredBlock.getLeft(), class_2415.field_11301));
                this.x_mirrored = (Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.X_MIRRORED);
            }
            if ((Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.Z_MIRRORED) != this.z_mirrored) {
                keyList = this.respawnPositions.keySet().stream().toList();
                int sideEntrancesSize = this.respawnPositions.keySet().size();
                for (i = 0; i < sideEntrancesSize; ++i) {
                    String key = (String)keyList.get(i);
                    mirroredEntrance = BlockRotationUtils.mirrorEntrance(this.respawnPositions.get(key), class_2415.field_11300);
                    this.respawnPositions.put(key, mirroredEntrance);
                }
                this.triggeredBlock.setLeft((Object)BlockRotationUtils.mirrorOffsetBlockPos((class_2338)this.triggeredBlock.getLeft(), class_2415.field_11300));
                this.z_mirrored = (Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.Z_MIRRORED);
            }
        }
    }
}

