/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.scriptblocks.block.entity;

import com.github.theredbrain.scriptblocks.block.ProvidesData;
import com.github.theredbrain.scriptblocks.block.Resetable;
import com.github.theredbrain.scriptblocks.block.RotatedBlockWithEntity;
import com.github.theredbrain.scriptblocks.block.Triggerable;
import com.github.theredbrain.scriptblocks.block.entity.RotatedBlockEntity;
import com.github.theredbrain.scriptblocks.registry.EntityRegistry;
import com.github.theredbrain.scriptblocks.util.BlockRotationUtils;
import com.github.theredbrain.scriptblocks.util.ItemUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_7225;
import org.apache.commons.lang3.tuple.MutablePair;

public class RelayTriggerBlockEntity
extends RotatedBlockEntity
implements Triggerable {
    private SelectionMode selectionMode = SelectionMode.LIST;
    private boolean showArea = false;
    private boolean resetsArea = false;
    private class_2382 areaDimensions = class_2382.field_11176;
    private class_2338 areaPositionOffset = new class_2338(0, 1, 0);
    private List<MutablePair<MutablePair<class_2338, Boolean>, Integer>> triggeredBlocks = new ArrayList<MutablePair<MutablePair<class_2338, Boolean>, Integer>>(List.of());
    private TriggerMode triggerMode = TriggerMode.NORMAL;
    private boolean isTriggerAmountDataDriven = true;
    private class_2338 dataProvidingBlockPosOffset = class_2338.field_10980;
    private String dataIdentifier = "";
    private int triggerAmount = 1;

    public RelayTriggerBlockEntity(class_2338 pos, class_2680 state) {
        super(EntityRegistry.RELAY_TRIGGER_BLOCK_ENTITY, pos, state);
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        nbt.method_10582("selectionMode", this.selectionMode.method_15434());
        nbt.method_10556("showArea", this.showArea);
        nbt.method_10556("resetsArea", this.resetsArea);
        nbt.method_10569("areaDimensionsX", this.areaDimensions.method_10263());
        nbt.method_10569("areaDimensionsY", this.areaDimensions.method_10264());
        nbt.method_10569("areaDimensionsZ", this.areaDimensions.method_10260());
        nbt.method_10569("areaPositionOffsetX", this.areaPositionOffset.method_10263());
        nbt.method_10569("areaPositionOffsetY", this.areaPositionOffset.method_10264());
        nbt.method_10569("areaPositionOffsetZ", this.areaPositionOffset.method_10260());
        nbt.method_10569("triggeredBlocksSize", this.triggeredBlocks.size());
        for (int i = 0; i < this.triggeredBlocks.size(); ++i) {
            class_2338 triggeredBlock = (class_2338)((MutablePair)this.triggeredBlocks.get((int)i).left).left;
            nbt.method_10569("triggeredBlockPositionOffsetX_" + i, triggeredBlock.method_10263());
            nbt.method_10569("triggeredBlockPositionOffsetY_" + i, triggeredBlock.method_10264());
            nbt.method_10569("triggeredBlockPositionOffsetZ_" + i, triggeredBlock.method_10260());
            nbt.method_10556("triggeredBlockResets_" + i, ((Boolean)((MutablePair)this.triggeredBlocks.get((int)i).left).right).booleanValue());
            nbt.method_10569("triggeredBlockChance_" + i, ((Integer)this.triggeredBlocks.get((int)i).right).intValue());
        }
        nbt.method_10582("triggerMode", this.triggerMode.method_15434());
        nbt.method_10556("isTriggerAmountDataDriven", this.isTriggerAmountDataDriven);
        if (this.dataProvidingBlockPosOffset != class_2338.field_10980) {
            nbt.method_10569("dataProvidingBlockPosOffsetX", this.dataProvidingBlockPosOffset.method_10263());
            nbt.method_10569("dataProvidingBlockPosOffsetY", this.dataProvidingBlockPosOffset.method_10264());
            nbt.method_10569("dataProvidingBlockPosOffsetZ", this.dataProvidingBlockPosOffset.method_10260());
        } else {
            nbt.method_10551("dataProvidingBlockPosOffsetX");
            nbt.method_10551("dataProvidingBlockPosOffsetY");
            nbt.method_10551("dataProvidingBlockPosOffsetZ");
        }
        nbt.method_10582("dataIdentifier", this.dataIdentifier);
        nbt.method_10569("triggerAmount", this.triggerAmount);
        super.method_11007(nbt, registryLookup);
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        this.selectionMode = SelectionMode.byName(nbt.method_10558("selectionMode")).orElseGet(() -> SelectionMode.LIST);
        this.showArea = nbt.method_10577("showArea");
        this.resetsArea = nbt.method_10577("resetsArea");
        int i = class_3532.method_15340((int)nbt.method_10550("areaDimensionsX"), (int)0, (int)48);
        int j = class_3532.method_15340((int)nbt.method_10550("areaDimensionsY"), (int)0, (int)48);
        int k = class_3532.method_15340((int)nbt.method_10550("areaDimensionsZ"), (int)0, (int)48);
        this.areaDimensions = new class_2382(i, j, k);
        i = class_3532.method_15340((int)nbt.method_10550("areaPositionOffsetX"), (int)-48, (int)48);
        j = class_3532.method_15340((int)nbt.method_10550("areaPositionOffsetY"), (int)-48, (int)48);
        k = class_3532.method_15340((int)nbt.method_10550("areaPositionOffsetZ"), (int)-48, (int)48);
        this.areaPositionOffset = new class_2338(i, j, k);
        int triggeredBlocksSize = nbt.method_10550("triggeredBlocksSize");
        this.triggeredBlocks = new ArrayList<MutablePair<MutablePair<class_2338, Boolean>, Integer>>(List.of());
        for (i = 0; i < triggeredBlocksSize; ++i) {
            int x = class_3532.method_15340((int)nbt.method_10550("triggeredBlockPositionOffsetX_" + i), (int)-48, (int)48);
            int y = class_3532.method_15340((int)nbt.method_10550("triggeredBlockPositionOffsetY_" + i), (int)-48, (int)48);
            int z = class_3532.method_15340((int)nbt.method_10550("triggeredBlockPositionOffsetZ_" + i), (int)-48, (int)48);
            boolean bl = nbt.method_10577("triggeredBlockResets_" + i);
            int chance = class_3532.method_15340((int)nbt.method_10550("triggeredBlockChance_" + i), (int)0, (int)100);
            this.triggeredBlocks.add((MutablePair<MutablePair<class_2338, Boolean>, Integer>)new MutablePair((Object)new MutablePair((Object)new class_2338(x, y, z), (Object)bl), (Object)chance));
        }
        this.triggerMode = TriggerMode.byName(nbt.method_10558("triggerMode")).orElseGet(() -> TriggerMode.NORMAL);
        this.isTriggerAmountDataDriven = nbt.method_10577("isTriggerAmountDataDriven");
        this.dataProvidingBlockPosOffset = nbt.method_10573("dataProvidingBlockPosOffsetX", 3) && nbt.method_10573("dataProvidingBlockPosOffsetY", 3) && nbt.method_10573("dataProvidingBlockPosOffsetZ", 3) ? new class_2338(class_3532.method_15340((int)nbt.method_10550("dataProvidingBlockPosOffsetX"), (int)-48, (int)48), class_3532.method_15340((int)nbt.method_10550("dataProvidingBlockPosOffsetY"), (int)-48, (int)48), class_3532.method_15340((int)nbt.method_10550("dataProvidingBlockPosOffsetZ"), (int)-48, (int)48)) : class_2338.field_10980;
        this.dataIdentifier = nbt.method_10558("dataIdentifier");
        this.triggerAmount = nbt.method_10550("triggerAmount");
        super.method_11014(nbt, registryLookup);
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return this.method_58692(registryLookup);
    }

    public SelectionMode getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionMode(SelectionMode selectionMode) {
        this.selectionMode = selectionMode;
    }

    public boolean getShowArea() {
        return this.showArea;
    }

    public void setShowArea(boolean showArea) {
        this.showArea = showArea;
    }

    public boolean getResetsArea() {
        return this.resetsArea;
    }

    public void setResetsArea(boolean resetsArea) {
        this.resetsArea = resetsArea;
    }

    public class_2382 getAreaDimensions() {
        return this.areaDimensions;
    }

    public void setAreaDimensions(class_2382 areaDimensions) {
        this.areaDimensions = areaDimensions;
    }

    public class_2338 getAreaPositionOffset() {
        return this.areaPositionOffset;
    }

    public void setAreaPositionOffset(class_2338 areaPositionOffset) {
        this.areaPositionOffset = areaPositionOffset;
    }

    public List<MutablePair<MutablePair<class_2338, Boolean>, Integer>> getTriggeredBlocks() {
        return this.triggeredBlocks;
    }

    public void setTriggeredBlocks(List<MutablePair<MutablePair<class_2338, Boolean>, Integer>> triggeredBlocks) {
        this.triggeredBlocks = triggeredBlocks;
    }

    public TriggerMode getTriggerMode() {
        return this.triggerMode;
    }

    public void setTriggerMode(TriggerMode triggerMode) {
        this.triggerMode = triggerMode;
    }

    public boolean isTriggerAmountDataDriven() {
        return this.isTriggerAmountDataDriven;
    }

    public void setIsTriggerAmountDataDriven(boolean isTriggerAmountDataDriven) {
        this.isTriggerAmountDataDriven = isTriggerAmountDataDriven;
    }

    public class_2338 getDataProvidingBlockPosOffset() {
        return this.dataProvidingBlockPosOffset;
    }

    public void setDataProvidingBlockPosOffset(class_2338 dataProvidingBlockPosOffset) {
        this.dataProvidingBlockPosOffset = dataProvidingBlockPosOffset;
    }

    public String getDataIdentifier() {
        return this.dataIdentifier;
    }

    public void setDataIdentifier(String dataIdentifier) {
        this.dataIdentifier = dataIdentifier;
    }

    public int getTriggerAmount() {
        return this.triggerAmount;
    }

    public void setTriggerAmount(int triggerAmount) {
        this.triggerAmount = triggerAmount;
    }

    private int getActualTriggerAmount() {
        class_2338 dataProviderBlockPos;
        class_2586 blockEntity;
        if (this.field_11863 != null && this.isTriggerAmountDataDriven && this.dataProvidingBlockPosOffset != class_2338.field_10980 && !this.dataIdentifier.isEmpty() && (blockEntity = this.field_11863.method_8321(dataProviderBlockPos = new class_2338(this.field_11867.method_10263() + this.dataProvidingBlockPosOffset.method_10263(), this.field_11867.method_10264() + this.dataProvidingBlockPosOffset.method_10264(), this.field_11867.method_10260() + this.dataProvidingBlockPosOffset.method_10260()))) instanceof ProvidesData) {
            ProvidesData providesDataEntity = (ProvidesData)blockEntity;
            String data = providesDataEntity.getData(this.dataIdentifier);
            return ItemUtils.parseInt(data);
        }
        return this.triggerAmount;
    }

    @Override
    public void trigger() {
        block21: {
            block22: {
                block25: {
                    block24: {
                        block23: {
                            if (this.field_11863 == null) break block21;
                            if (this.selectionMode != SelectionMode.LIST) break block22;
                            if (this.triggerMode != TriggerMode.NORMAL) break block23;
                            for (MutablePair<MutablePair<class_2338, Boolean>, Integer> triggeredBlock : this.triggeredBlocks) {
                                class_2338 triggeredBlockPos = (class_2338)((MutablePair)triggeredBlock.left).left;
                                class_2586 blockEntity = this.field_11863.method_8321(new class_2338(this.field_11867.method_10263() + triggeredBlockPos.method_10263(), this.field_11867.method_10264() + triggeredBlockPos.method_10264(), this.field_11867.method_10260() + triggeredBlockPos.method_10260()));
                                if (blockEntity == this) continue;
                                if (((Boolean)((MutablePair)triggeredBlock.getLeft()).getRight()).booleanValue()) {
                                    if (!(blockEntity instanceof Resetable)) continue;
                                    Resetable resetable = (Resetable)blockEntity;
                                    resetable.reset();
                                    continue;
                                }
                                if (!(blockEntity instanceof Triggerable)) continue;
                                Triggerable triggerable = (Triggerable)blockEntity;
                                triggerable.trigger();
                            }
                            break block21;
                        }
                        if (this.triggerMode != TriggerMode.RANDOM) break block24;
                        for (MutablePair<MutablePair<class_2338, Boolean>, Integer> triggeredBlock : this.triggeredBlocks) {
                            int chance = this.field_11863.field_9229.method_43048(100);
                            if (chance > (Integer)triggeredBlock.right) continue;
                            class_2338 triggeredBlockPos = (class_2338)((MutablePair)triggeredBlock.left).left;
                            class_2586 blockEntity = this.field_11863.method_8321(new class_2338(this.field_11867.method_10263() + triggeredBlockPos.method_10263(), this.field_11867.method_10264() + triggeredBlockPos.method_10264(), this.field_11867.method_10260() + triggeredBlockPos.method_10260()));
                            if (blockEntity == this) continue;
                            if (((Boolean)((MutablePair)triggeredBlock.getLeft()).getRight()).booleanValue()) {
                                if (!(blockEntity instanceof Resetable)) continue;
                                Resetable resetable = (Resetable)blockEntity;
                                resetable.reset();
                                continue;
                            }
                            if (!(blockEntity instanceof Triggerable)) continue;
                            Triggerable triggerable = (Triggerable)blockEntity;
                            triggerable.trigger();
                        }
                        break block21;
                    }
                    if (this.triggerMode != TriggerMode.BINOMIAL) break block25;
                    int totalAmount = 0;
                    for (MutablePair<MutablePair<class_2338, Boolean>, Integer> triggeredBlock : this.triggeredBlocks) {
                        totalAmount += ((Integer)triggeredBlock.getRight()).intValue();
                    }
                    if (totalAmount <= 0) break block21;
                    int triggerAmount = this.getActualTriggerAmount();
                    block3: for (int i = 0; i < triggerAmount; ++i) {
                        int pickedChoice = this.field_11863.field_9229.method_43048(totalAmount);
                        for (MutablePair<MutablePair<class_2338, Boolean>, Integer> mutablePair : this.triggeredBlocks) {
                            if ((pickedChoice -= ((Integer)mutablePair.getRight()).intValue()) > 0) continue;
                            class_2338 triggeredBlockPos = (class_2338)((MutablePair)mutablePair.left).left;
                            class_2586 blockEntity = this.field_11863.method_8321(new class_2338(this.field_11867.method_10263() + triggeredBlockPos.method_10263(), this.field_11867.method_10264() + triggeredBlockPos.method_10264(), this.field_11867.method_10260() + triggeredBlockPos.method_10260()));
                            if (blockEntity == this) continue block3;
                            if (((Boolean)((MutablePair)mutablePair.getLeft()).getRight()).booleanValue()) {
                                if (!(blockEntity instanceof Resetable)) continue block3;
                                Resetable resetable = (Resetable)blockEntity;
                                resetable.reset();
                                continue block3;
                            }
                            if (!(blockEntity instanceof Triggerable)) continue block3;
                            Triggerable triggerable = (Triggerable)blockEntity;
                            triggerable.trigger();
                            continue block3;
                        }
                    }
                    break block21;
                }
                if (this.triggerMode != TriggerMode.HYPER_GEOMETRIC) break block21;
                ArrayList<MutablePair<MutablePair<class_2338, Boolean>, Integer>> list = new ArrayList<MutablePair<MutablePair<class_2338, Boolean>, Integer>>(this.triggeredBlocks);
                int triggerAmount = this.getActualTriggerAmount();
                block5: for (int i = 0; i < triggerAmount; ++i) {
                    int totalAmount = 0;
                    for (MutablePair mutablePair : list) {
                        totalAmount += ((Integer)mutablePair.getRight()).intValue();
                    }
                    if (totalAmount <= 0) continue;
                    int pickedChoice = this.field_11863.field_9229.method_43048(totalAmount);
                    for (MutablePair triggeredBlock3 : list) {
                        if ((pickedChoice -= ((Integer)triggeredBlock3.getRight()).intValue()) > 0) continue;
                        class_2338 triggeredBlockPos = (class_2338)((MutablePair)triggeredBlock3.left).left;
                        class_2586 blockEntity = this.field_11863.method_8321(new class_2338(this.field_11867.method_10263() + triggeredBlockPos.method_10263(), this.field_11867.method_10264() + triggeredBlockPos.method_10264(), this.field_11867.method_10260() + triggeredBlockPos.method_10260()));
                        if (blockEntity != this) {
                            if (((Boolean)((MutablePair)triggeredBlock3.getLeft()).getRight()).booleanValue()) {
                                if (blockEntity instanceof Resetable) {
                                    Resetable resetable = (Resetable)blockEntity;
                                    resetable.reset();
                                }
                            } else if (blockEntity instanceof Triggerable) {
                                Triggerable triggerable = (Triggerable)blockEntity;
                                triggerable.trigger();
                            }
                        }
                        list.remove(triggeredBlock3);
                        continue block5;
                    }
                }
                break block21;
            }
            if (this.selectionMode == SelectionMode.AREA) {
                class_2382 activationAreaDimensions = this.getAreaDimensions();
                class_2338 blockPos = new class_2338(this.field_11867.method_10263() + this.areaPositionOffset.method_10263(), this.field_11867.method_10264() + this.areaPositionOffset.method_10264(), this.field_11867.method_10260() + this.areaPositionOffset.method_10260());
                for (int i = 0; i < activationAreaDimensions.method_10263(); ++i) {
                    for (int j = 0; j < activationAreaDimensions.method_10264(); ++j) {
                        for (int k = 0; k < activationAreaDimensions.method_10260(); ++k) {
                            class_2586 blockEntity = this.field_11863.method_8321(new class_2338(blockPos.method_10263() + i, blockPos.method_10264() + j, blockPos.method_10260() + k));
                            if (blockEntity == this) continue;
                            if (this.resetsArea) {
                                if (!(blockEntity instanceof Resetable)) continue;
                                Resetable resetable = (Resetable)blockEntity;
                                resetable.reset();
                                continue;
                            }
                            if (!(blockEntity instanceof Triggerable)) continue;
                            Triggerable triggerable = (Triggerable)blockEntity;
                            triggerable.trigger();
                        }
                    }
                }
            }
        }
    }

    @Override
    protected void onRotate(class_2680 state) {
        if (state.method_26204() instanceof RotatedBlockWithEntity) {
            ArrayList<MutablePair<MutablePair<class_2338, Boolean>, Integer>> newTriggeredBlocks;
            MutablePair<class_2338, class_2382> offsetArea;
            if ((Integer)state.method_11654((class_2769)RotatedBlockWithEntity.ROTATED) != this.rotated) {
                class_2470 blockRotation = BlockRotationUtils.calculateRotationFromDifferentRotatedStates((Integer)state.method_11654((class_2769)RotatedBlockWithEntity.ROTATED), this.rotated);
                MutablePair<class_2338, class_2382> offsetArea2 = BlockRotationUtils.rotateOffsetArea(this.areaPositionOffset, this.areaDimensions, blockRotation);
                this.areaPositionOffset = (class_2338)offsetArea2.getLeft();
                this.areaDimensions = (class_2382)offsetArea2.getRight();
                ArrayList<MutablePair<MutablePair<class_2338, Boolean>, Integer>> newTriggeredBlocks2 = new ArrayList<MutablePair<MutablePair<class_2338, Boolean>, Integer>>(List.of());
                for (MutablePair<MutablePair<class_2338, Boolean>, Integer> triggeredBlock : this.triggeredBlocks) {
                    newTriggeredBlocks2.add((MutablePair<MutablePair<class_2338, Boolean>, Integer>)new MutablePair((Object)new MutablePair((Object)BlockRotationUtils.rotateOffsetBlockPos((class_2338)((MutablePair)triggeredBlock.getLeft()).getLeft(), blockRotation), (Object)((Boolean)((MutablePair)triggeredBlock.getLeft()).getRight())), (Object)((Integer)triggeredBlock.getRight())));
                }
                this.triggeredBlocks = newTriggeredBlocks2;
                this.rotated = (Integer)state.method_11654((class_2769)RotatedBlockWithEntity.ROTATED);
            }
            if ((Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.X_MIRRORED) != this.x_mirrored) {
                offsetArea = BlockRotationUtils.mirrorOffsetArea(this.areaPositionOffset, this.areaDimensions, class_2415.field_11301);
                this.areaPositionOffset = (class_2338)offsetArea.getLeft();
                this.areaDimensions = (class_2382)offsetArea.getRight();
                newTriggeredBlocks = new ArrayList<MutablePair<MutablePair<class_2338, Boolean>, Integer>>(List.of());
                for (MutablePair<MutablePair<class_2338, Boolean>, Integer> triggeredBlock : this.triggeredBlocks) {
                    newTriggeredBlocks.add((MutablePair<MutablePair<class_2338, Boolean>, Integer>)new MutablePair((Object)new MutablePair((Object)BlockRotationUtils.mirrorOffsetBlockPos((class_2338)((MutablePair)triggeredBlock.getLeft()).getLeft(), class_2415.field_11301), (Object)((Boolean)((MutablePair)triggeredBlock.getLeft()).getRight())), (Object)((Integer)triggeredBlock.getRight())));
                }
                this.triggeredBlocks = newTriggeredBlocks;
                this.x_mirrored = (Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.X_MIRRORED);
            }
            if ((Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.Z_MIRRORED) != this.z_mirrored) {
                offsetArea = BlockRotationUtils.mirrorOffsetArea(this.areaPositionOffset, this.areaDimensions, class_2415.field_11300);
                this.areaPositionOffset = (class_2338)offsetArea.getLeft();
                this.areaDimensions = (class_2382)offsetArea.getRight();
                newTriggeredBlocks = new ArrayList(List.of());
                for (MutablePair<MutablePair<class_2338, Boolean>, Integer> triggeredBlock : this.triggeredBlocks) {
                    newTriggeredBlocks.add((MutablePair<MutablePair<class_2338, Boolean>, Integer>)new MutablePair((Object)new MutablePair((Object)BlockRotationUtils.mirrorOffsetBlockPos((class_2338)((MutablePair)triggeredBlock.getLeft()).getLeft(), class_2415.field_11300), (Object)((Boolean)((MutablePair)triggeredBlock.getLeft()).getRight())), (Object)((Integer)triggeredBlock.getRight())));
                }
                this.triggeredBlocks = newTriggeredBlocks;
                this.z_mirrored = (Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.Z_MIRRORED);
            }
        }
    }

    public static enum SelectionMode implements class_3542
    {
        LIST("list"),
        AREA("area");

        private final String name;

        private SelectionMode(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        public static Optional<SelectionMode> byName(String name) {
            return Arrays.stream(SelectionMode.values()).filter(selectionMode -> selectionMode.method_15434().equals(name)).findFirst();
        }

        public class_2561 asText() {
            return class_2561.method_43471((String)("gui.relay_trigger_block.selectionMode." + this.name));
        }
    }

    public static enum TriggerMode implements class_3542
    {
        NORMAL("normal"),
        RANDOM("random"),
        BINOMIAL("binomial"),
        HYPER_GEOMETRIC("hyper_geometric");

        private final String name;

        private TriggerMode(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        public static Optional<TriggerMode> byName(String name) {
            return Arrays.stream(TriggerMode.values()).filter(triggerMode -> triggerMode.method_15434().equals(name)).findFirst();
        }

        public class_2561 asText() {
            return class_2561.method_43471((String)("gui.relay_trigger_block.triggerMode." + this.name));
        }
    }
}

