/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.scriptblocks.block.entity;

import com.github.theredbrain.scriptblocks.ScriptBlocks;
import com.github.theredbrain.scriptblocks.block.ProvidesData;
import com.github.theredbrain.scriptblocks.block.Resetable;
import com.github.theredbrain.scriptblocks.block.RotatedBlockWithEntity;
import com.github.theredbrain.scriptblocks.block.Triggerable;
import com.github.theredbrain.scriptblocks.block.entity.RotatedBlockEntity;
import com.github.theredbrain.scriptblocks.registry.EntityRegistry;
import com.github.theredbrain.scriptblocks.util.BlockRotationUtils;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.IntFunction;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_4590;
import net.minecraft.class_5250;
import net.minecraft.class_5253;
import net.minecraft.class_5481;
import net.minecraft.class_7225;
import net.minecraft.class_7995;
import net.minecraft.class_8104;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.slf4j.Logger;

public class TriggeredDisplayBlockEntity
extends RotatedBlockEntity
implements Triggerable,
Resetable {
    public static final String TELEPORT_DURATION_KEY = "teleport_duration";
    public static final String INTERPOLATION_DURATION_KEY = "interpolation_duration";
    public static final String START_INTERPOLATION_KEY = "start_interpolation";
    public static final String TRANSFORMATION_NBT_KEY = "transformation";
    public static final String BILLBOARD_NBT_KEY = "billboard";
    public static final String BRIGHTNESS_NBT_KEY = "brightness";
    public static final String VIEW_RANGE_NBT_KEY = "view_range";
    public static final String SHADOW_RADIUS_NBT_KEY = "shadow_radius";
    public static final String SHADOW_STRENGTH_NBT_KEY = "shadow_strength";
    public static final String WIDTH_NBT_KEY = "width";
    public static final String HEIGHT_NBT_KEY = "height";
    public static final String GLOW_COLOR_OVERRIDE_NBT_KEY = "glow_color_override";
    public static final String ERROR_PREFIX = "Triggered Display Block";
    public static final String DISPLAY_MODE_NBT_KEY = "display_mode";
    public static final String IS_TRIGGERED_NBT_KEY = "is_triggered";
    public static final String DISPLAY_OFFSET_X_NBT_KEY = "display_offset_x";
    public static final String DISPLAY_OFFSET_Y_NBT_KEY = "display_offset_y";
    public static final String DISPLAY_OFFSET_Z_NBT_KEY = "display_offset_z";
    public static final String DISPLAY_YAW_NBT_KEY = "display_yaw";
    public static final String DISPLAY_PITCH_NBT_KEY = "display_pitch";
    public static final String DISPLAY_PREV_YAW_NBT_KEY = "display_prev_yaw";
    public static final String DISPLAY_PREV_PITCH_NBT_KEY = "display_prev_pitch";
    public static final String TEXT_STRING_NBT_KEY = "text_string";
    public static final String DATA_PROVIDER_BLOCK_POS_OFFSET_X_NBT_KEY = "data_provider_block_pos_offset_x";
    public static final String DATA_PROVIDER_BLOCK_POS_OFFSET_Y_NBT_KEY = "data_provider_block_pos_offset_y";
    public static final String DATA_PROVIDER_BLOCK_POS_OFFSET_Z_NBT_KEY = "data_provider_block_pos_offset_z";
    public static final String DATA_IDENTIFIER_NBT_KEY = "data_identifier";
    public static final String TEXT_NBT_KEY = "text";
    private static final String LINE_WIDTH_NBT_KEY = "line_width";
    private static final String TEXT_OPACITY_NBT_KEY = "text_opacity";
    private static final String BACKGROUND_NBT_KEY = "background";
    private static final String SHADOW_NBT_KEY = "shadow";
    private static final String SEE_THROUGH_NBT_KEY = "see_through";
    private static final String DEFAULT_BACKGROUND_NBT_KEY = "default_background";
    private static final String ALIGNMENT_NBT_KEY = "alignment";
    public static final byte SHADOW_FLAG = 1;
    public static final byte SEE_THROUGH_FLAG = 2;
    public static final byte DEFAULT_BACKGROUND_FLAG = 4;
    public static final byte LEFT_ALIGNMENT_FLAG = 8;
    public static final byte RIGHT_ALIGNMENT_FLAG = 16;
    private static final class_243 DISPLAY_OFFSET_DEFAULT = new class_243(0.0, 0.0, 0.0);
    private static final class_2338 DATA_PROVIDING_BLOCK_POS_DEFAULT = new class_2338(0, -1, 0);
    private static final class_2561 INITIAL_TEXT = class_2561.method_43470((String)"Loooooooooooooooooong test text");
    private static final int INITIAL_LINE_WIDTH = 200;
    private static final byte INITIAL_TEXT_OPACITY = -1;
    public static final int INITIAL_BACKGROUND = 0x40000000;
    private int teleportDuration = 0;
    private int startInterpolation = 0;
    private int interpolationDuration = 0;
    private Vector3f translation = new Vector3f();
    private Vector3f scale = new Vector3f(1.0f, 1.0f, 1.0f);
    private Quaternionf leftRotation = new Quaternionf();
    private Quaternionf rightRotation = new Quaternionf();
    private Byte billboard = BillboardMode.FIXED.getIndex();
    private int brightness = -1;
    private float viewRange = 1.0f;
    private float shadowRadius = 0.0f;
    private float shadowStrength = 1.0f;
    private float width = 0.0f;
    private float height = 0.0f;
    private int glowColorOverride = -1;
    private long interpolationStart = Integer.MIN_VALUE;
    private int currentInterpolationDuration;
    private float lerpProgress;
    private class_238 visibilityBoundingBox;
    private boolean renderingDataSet;
    private boolean startInterpolationSet;
    private boolean interpolationDurationSet;
    @Nullable
    private RenderState renderState;
    @Nullable
    private InterpolationTarget interpolationTarget;
    private String textString = "";
    private class_2338 dataProvidingBlockPosOffset = DATA_PROVIDING_BLOCK_POS_DEFAULT;
    private String dataIdentifierString = "";
    private class_2561 text = INITIAL_TEXT;
    private int lineWidth = 200;
    private int background = 0x40000000;
    private Byte textOpacity = -1;
    private Byte textDisplayFlags = 0;
    @Nullable
    private TextLines textLines;
    @Nullable
    private Data data;
    private class_243 displayOffset = DISPLAY_OFFSET_DEFAULT;
    private DisplayMode displayMode = DisplayMode.TEXT;
    private boolean isTriggered = true;
    private long age = 0L;
    private float displayYaw = 0.0f;
    private float displayPitch = 0.0f;
    private float displayPrevYaw = 0.0f;
    private float displayPrevPitch = 0.0f;

    public TriggeredDisplayBlockEntity(class_2338 pos, class_2680 state) {
        super(EntityRegistry.TRIGGERED_DISPLAY_BLOCK_ENTITY, pos, state);
    }

    private static class_4590 getTransformation(TriggeredDisplayBlockEntity blockEntity) {
        Vector3f vector3f = blockEntity.getTranslation();
        Quaternionf quaternionf = blockEntity.getLeftRotation();
        Vector3f vector3f2 = blockEntity.getScale();
        Quaternionf quaternionf2 = blockEntity.getRightRotation();
        return new class_4590(vector3f, quaternionf, vector3f2, quaternionf2);
    }

    private void setTransformation(class_4590 transformation) {
        this.setTranslation(transformation.method_35865());
        this.setLeftRotation(transformation.method_22937());
        this.setScale(transformation.method_35866());
        this.setRightRotation(transformation.method_35867());
    }

    @Nullable
    public Data getData() {
        return this.data;
    }

    public void refreshData(boolean shouldLerp, float lerpProgress, class_1937 world) {
        this.data = shouldLerp && this.data != null ? this.getLerpedRenderData(this.data, lerpProgress, world) : this.copyData(world);
        this.textLines = null;
    }

    private Data getLerpedRenderData(Data data, float lerpProgress, class_1937 world) {
        int i = data.backgroundColor.lerp(lerpProgress);
        int j = data.textOpacity.lerp(lerpProgress);
        return new Data(this.getCompleteTextString(world), this.getLineWidth(), new IntLerperImpl(j, this.getTextOpacity()), new ArgbLerper(i, this.getBackground()), this.getDisplayFlags());
    }

    private Data copyData(class_1937 world) {
        return new Data(this.getCompleteTextString(world), this.getLineWidth(), IntLerper.constant(this.getTextOpacity()), IntLerper.constant(this.getBackground()), this.getDisplayFlags());
    }

    public final void resetPosition() {
        this.displayPrevYaw = this.getDisplayYaw();
        this.displayPrevPitch = this.getDisplayPitch();
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, TriggeredDisplayBlockEntity blockEntity) {
        ++blockEntity.age;
        if (world.field_9236) {
            if (blockEntity.startInterpolationSet) {
                blockEntity.startInterpolationSet = false;
                int i = blockEntity.getStartInterpolation();
                blockEntity.interpolationStart = blockEntity.age + (long)i;
            }
            if (blockEntity.interpolationDurationSet) {
                blockEntity.interpolationDurationSet = false;
                blockEntity.currentInterpolationDuration = blockEntity.getInterpolationDuration();
            }
            if (blockEntity.renderingDataSet) {
                blockEntity.renderingDataSet = false;
                boolean bl = blockEntity.currentInterpolationDuration != 0;
                blockEntity.renderState = bl && blockEntity.renderState != null ? blockEntity.getLerpedRenderState(blockEntity.renderState, blockEntity.lerpProgress) : blockEntity.copyRenderState();
                blockEntity.refreshData(bl, blockEntity.lerpProgress, world);
            }
            if (blockEntity.interpolationTarget != null) {
                if (blockEntity.interpolationTarget.step == 0) {
                    blockEntity.interpolationTarget.apply(blockEntity);
                    blockEntity.resetPosition();
                    blockEntity.interpolationTarget = null;
                } else {
                    blockEntity.interpolationTarget.applyInterpolated(blockEntity);
                    --blockEntity.interpolationTarget.step;
                    if (blockEntity.interpolationTarget.step == 0) {
                        blockEntity.interpolationTarget = null;
                    }
                }
            }
        }
    }

    private static byte readFlag(byte flags, class_2487 nbt, String nbtKey, byte flag) {
        return nbt.method_10577(nbtKey) ? (byte)(flags | flag) : flags;
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        int i;
        super.method_11014(nbt, registryLookup);
        if (nbt.method_10545(TRANSFORMATION_NBT_KEY)) {
            class_4590.field_42533.decode((DynamicOps)class_2509.field_11560, (Object)nbt.method_10580(TRANSFORMATION_NBT_KEY)).resultOrPartial(class_156.method_29188((String)ERROR_PREFIX, arg_0 -> ((Logger)ScriptBlocks.LOGGER).error(arg_0))).ifPresent(pair -> this.setTransformation((class_4590)pair.getFirst()));
        }
        if (nbt.method_10573(INTERPOLATION_DURATION_KEY, 99)) {
            i = nbt.method_10550(INTERPOLATION_DURATION_KEY);
            this.setInterpolationDuration(i);
        }
        if (nbt.method_10573(START_INTERPOLATION_KEY, 99)) {
            i = nbt.method_10550(START_INTERPOLATION_KEY);
            this.setStartInterpolation(i);
        }
        if (nbt.method_10573(TELEPORT_DURATION_KEY, 99)) {
            i = nbt.method_10550(TELEPORT_DURATION_KEY);
            this.setTeleportDuration(class_3532.method_15340((int)i, (int)0, (int)59));
        }
        if (nbt.method_10573(BILLBOARD_NBT_KEY, 8)) {
            BillboardMode.CODEC.decode((DynamicOps)class_2509.field_11560, (Object)nbt.method_10580(BILLBOARD_NBT_KEY)).resultOrPartial(class_156.method_29188((String)ERROR_PREFIX, arg_0 -> ((Logger)ScriptBlocks.LOGGER).error(arg_0))).ifPresent(pair -> this.setBillboardMode((BillboardMode)((Object)((Object)pair.getFirst()))));
        }
        if (nbt.method_10573(VIEW_RANGE_NBT_KEY, 99)) {
            this.setViewRange(nbt.method_10583(VIEW_RANGE_NBT_KEY));
        }
        if (nbt.method_10573(SHADOW_RADIUS_NBT_KEY, 99)) {
            this.setShadowRadius(nbt.method_10583(SHADOW_RADIUS_NBT_KEY));
        }
        if (nbt.method_10573(SHADOW_STRENGTH_NBT_KEY, 99)) {
            this.setShadowStrength(nbt.method_10583(SHADOW_STRENGTH_NBT_KEY));
        }
        if (nbt.method_10573(WIDTH_NBT_KEY, 99)) {
            this.setDisplayWidth(nbt.method_10583(WIDTH_NBT_KEY));
        }
        if (nbt.method_10573(HEIGHT_NBT_KEY, 99)) {
            this.setDisplayHeight(nbt.method_10583(HEIGHT_NBT_KEY));
        }
        if (nbt.method_10573(GLOW_COLOR_OVERRIDE_NBT_KEY, 99)) {
            this.setGlowColorOverride(nbt.method_10550(GLOW_COLOR_OVERRIDE_NBT_KEY));
        }
        if (nbt.method_10573(BRIGHTNESS_NBT_KEY, 10)) {
            class_8104.field_42263.decode((DynamicOps)class_2509.field_11560, (Object)nbt.method_10580(BRIGHTNESS_NBT_KEY)).resultOrPartial(class_156.method_29188((String)ERROR_PREFIX, arg_0 -> ((Logger)ScriptBlocks.LOGGER).error(arg_0))).ifPresent(pair -> this.setBrightness((class_8104)pair.getFirst()));
        } else {
            this.setBrightness(null);
        }
        if (nbt.method_10573(DISPLAY_MODE_NBT_KEY, 8)) {
            DisplayMode.CODEC.decode((DynamicOps)class_2509.field_11560, (Object)nbt.method_10580(DISPLAY_MODE_NBT_KEY)).resultOrPartial(class_156.method_29188((String)ERROR_PREFIX, arg_0 -> ((Logger)ScriptBlocks.LOGGER).error(arg_0))).ifPresent(pair -> this.setDisplayMode((DisplayMode)((Object)((Object)pair.getFirst()))));
        }
        if (nbt.method_10573(IS_TRIGGERED_NBT_KEY, 1)) {
            this.isTriggered = nbt.method_10577(IS_TRIGGERED_NBT_KEY);
        }
        if (nbt.method_10573(DISPLAY_OFFSET_X_NBT_KEY, 99) || nbt.method_10573(DISPLAY_OFFSET_Y_NBT_KEY, 99) || nbt.method_10573(DISPLAY_OFFSET_Z_NBT_KEY, 99)) {
            this.setDisplayOffset(new class_243(nbt.method_10574(DISPLAY_OFFSET_X_NBT_KEY), nbt.method_10574(DISPLAY_OFFSET_Y_NBT_KEY), nbt.method_10574(DISPLAY_OFFSET_Z_NBT_KEY)));
        }
        if (nbt.method_10545(DISPLAY_YAW_NBT_KEY)) {
            this.displayYaw = nbt.method_10583(DISPLAY_YAW_NBT_KEY);
        }
        if (nbt.method_10545(DISPLAY_PITCH_NBT_KEY)) {
            this.displayPitch = nbt.method_10583(DISPLAY_PITCH_NBT_KEY);
        }
        if (nbt.method_10545(DISPLAY_PREV_YAW_NBT_KEY)) {
            this.displayPrevYaw = nbt.method_10583(DISPLAY_PREV_YAW_NBT_KEY);
        }
        if (nbt.method_10545(DISPLAY_PREV_PITCH_NBT_KEY)) {
            this.displayPrevPitch = nbt.method_10583(DISPLAY_PREV_PITCH_NBT_KEY);
        }
        if (nbt.method_10573(LINE_WIDTH_NBT_KEY, 99)) {
            this.setLineWidth(nbt.method_10550(LINE_WIDTH_NBT_KEY));
        }
        if (nbt.method_10573(TEXT_OPACITY_NBT_KEY, 99)) {
            this.setTextOpacity(nbt.method_10571(TEXT_OPACITY_NBT_KEY));
        }
        if (nbt.method_10573(BACKGROUND_NBT_KEY, 99)) {
            this.setBackground(nbt.method_10550(BACKGROUND_NBT_KEY));
        }
        byte b = TriggeredDisplayBlockEntity.readFlag((byte)0, nbt, SHADOW_NBT_KEY, (byte)1);
        b = TriggeredDisplayBlockEntity.readFlag(b, nbt, SEE_THROUGH_NBT_KEY, (byte)2);
        b = TriggeredDisplayBlockEntity.readFlag(b, nbt, DEFAULT_BACKGROUND_NBT_KEY, (byte)4);
        Optional<TextAlignment> optional = TextAlignment.CODEC.decode((DynamicOps)class_2509.field_11560, (Object)nbt.method_10580(ALIGNMENT_NBT_KEY)).resultOrPartial(class_156.method_29188((String)ERROR_PREFIX, arg_0 -> ((Logger)ScriptBlocks.LOGGER).error(arg_0))).map(Pair::getFirst);
        if (optional.isPresent()) {
            b = switch (optional.get().ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> b;
                case 1 -> (byte)(b | 8);
                case 2 -> (byte)(b | 0x10);
            };
        }
        this.setDisplayFlags(b);
        if (nbt.method_10573(TEXT_STRING_NBT_KEY, 8)) {
            this.setTextString(nbt.method_10558(TEXT_STRING_NBT_KEY));
        }
        if (nbt.method_10573(DATA_PROVIDER_BLOCK_POS_OFFSET_X_NBT_KEY, 3) && nbt.method_10573(DATA_PROVIDER_BLOCK_POS_OFFSET_Y_NBT_KEY, 3) && nbt.method_10573(DATA_PROVIDER_BLOCK_POS_OFFSET_Z_NBT_KEY, 3)) {
            this.setDataProvidingBlockPosOffset(new class_2338(nbt.method_10550(DATA_PROVIDER_BLOCK_POS_OFFSET_X_NBT_KEY), nbt.method_10550(DATA_PROVIDER_BLOCK_POS_OFFSET_Y_NBT_KEY), nbt.method_10550(DATA_PROVIDER_BLOCK_POS_OFFSET_Z_NBT_KEY)));
        }
        if (nbt.method_10573(DATA_IDENTIFIER_NBT_KEY, 8)) {
            this.setDataIdentifierString(nbt.method_10558(DATA_IDENTIFIER_NBT_KEY));
        }
        if (nbt.method_10573(TEXT_NBT_KEY, 8)) {
            String string = nbt.method_10558(TEXT_NBT_KEY);
            try {
                class_5250 text = class_2561.class_2562.method_10877((String)string, (class_7225.class_7874)registryLookup);
                if (text != null) {
                    class_5250 text2 = class_2564.method_10881(null, (class_2561)text, null, (int)0);
                    this.setText((class_2561)text2);
                } else {
                    this.setText((class_2561)class_2561.method_43473());
                }
            }
            catch (Exception var8) {
                ScriptBlocks.LOGGER.warn("Failed to parse Triggered Display Block text {}", (Object)string, (Object)var8);
            }
        }
    }

    private static void writeFlag(byte flags, class_2487 nbt, String nbtKey, byte flag) {
        nbt.method_10556(nbtKey, (flags & flag) != 0);
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_4590.field_42533.encodeStart((DynamicOps)class_2509.field_11560, (Object)TriggeredDisplayBlockEntity.getTransformation(this)).ifSuccess(transformations -> nbt.method_10566(TRANSFORMATION_NBT_KEY, transformations));
        BillboardMode.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.getBillboardMode()).ifSuccess(billboard -> nbt.method_10566(BILLBOARD_NBT_KEY, billboard));
        nbt.method_10569(INTERPOLATION_DURATION_KEY, this.getInterpolationDuration());
        nbt.method_10569(TELEPORT_DURATION_KEY, this.getTeleportDuration());
        nbt.method_10548(VIEW_RANGE_NBT_KEY, this.getViewRange());
        nbt.method_10548(SHADOW_RADIUS_NBT_KEY, this.getShadowRadius());
        nbt.method_10548(SHADOW_STRENGTH_NBT_KEY, this.getShadowStrength());
        nbt.method_10548(WIDTH_NBT_KEY, this.getDisplayWidth());
        nbt.method_10548(HEIGHT_NBT_KEY, this.getDisplayHeight());
        nbt.method_10569(GLOW_COLOR_OVERRIDE_NBT_KEY, this.getGlowColorOverride());
        class_8104 brightness = this.getBrightnessUnpacked();
        if (brightness != null) {
            class_8104.field_42263.encodeStart((DynamicOps)class_2509.field_11560, (Object)brightness).ifSuccess(brightnessx -> nbt.method_10566(BRIGHTNESS_NBT_KEY, brightnessx));
        }
        if (this.isTriggered) {
            nbt.method_10556(IS_TRIGGERED_NBT_KEY, this.isTriggered);
        }
        if (this.displayOffset != DISPLAY_OFFSET_DEFAULT) {
            nbt.method_10549(DISPLAY_OFFSET_X_NBT_KEY, this.displayOffset.field_1352);
            nbt.method_10549(DISPLAY_OFFSET_Y_NBT_KEY, this.displayOffset.field_1351);
            nbt.method_10549(DISPLAY_OFFSET_Z_NBT_KEY, this.displayOffset.field_1350);
        }
        nbt.method_10548(DISPLAY_YAW_NBT_KEY, this.displayYaw);
        nbt.method_10548(DISPLAY_PITCH_NBT_KEY, this.displayPitch);
        nbt.method_10548(DISPLAY_PREV_YAW_NBT_KEY, this.displayPrevYaw);
        nbt.method_10548(DISPLAY_PREV_PITCH_NBT_KEY, this.displayPrevPitch);
        nbt.method_10582(TEXT_STRING_NBT_KEY, this.textString);
        nbt.method_10569(DATA_PROVIDER_BLOCK_POS_OFFSET_X_NBT_KEY, this.dataProvidingBlockPosOffset.method_10263());
        nbt.method_10569(DATA_PROVIDER_BLOCK_POS_OFFSET_Y_NBT_KEY, this.dataProvidingBlockPosOffset.method_10264());
        nbt.method_10569(DATA_PROVIDER_BLOCK_POS_OFFSET_Z_NBT_KEY, this.dataProvidingBlockPosOffset.method_10260());
        nbt.method_10582(DATA_IDENTIFIER_NBT_KEY, this.dataIdentifierString);
        nbt.method_10582(TEXT_NBT_KEY, class_2561.class_2562.method_10867((class_2561)this.getText(), (class_7225.class_7874)registryLookup));
        nbt.method_10569(LINE_WIDTH_NBT_KEY, this.getLineWidth());
        nbt.method_10567(TEXT_OPACITY_NBT_KEY, this.getTextOpacity());
        nbt.method_10569(BACKGROUND_NBT_KEY, this.getBackground());
        byte b = this.getDisplayFlags();
        TriggeredDisplayBlockEntity.writeFlag(b, nbt, SHADOW_NBT_KEY, (byte)1);
        TriggeredDisplayBlockEntity.writeFlag(b, nbt, SEE_THROUGH_NBT_KEY, (byte)2);
        TriggeredDisplayBlockEntity.writeFlag(b, nbt, DEFAULT_BACKGROUND_NBT_KEY, (byte)4);
        TextAlignment.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)TriggeredDisplayBlockEntity.getAlignment(b)).ifSuccess(nbtElement -> nbt.method_10566(ALIGNMENT_NBT_KEY, nbtElement));
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return this.method_58692(registryLookup);
    }

    public double getLerpTargetX() {
        return this.interpolationTarget != null ? this.interpolationTarget.x : this.getDisplayOffset().field_1352;
    }

    public double getLerpTargetY() {
        return this.interpolationTarget != null ? this.interpolationTarget.y : this.getDisplayOffset().field_1351;
    }

    public double getLerpTargetZ() {
        return this.interpolationTarget != null ? this.interpolationTarget.z : this.getDisplayOffset().field_1350;
    }

    public float getLerpTargetPitch() {
        return this.interpolationTarget != null ? (float)this.interpolationTarget.pitch : this.getDisplayPitch();
    }

    public float getLerpTargetYaw() {
        return this.interpolationTarget != null ? (float)this.interpolationTarget.yaw : this.getDisplayYaw();
    }

    @Nullable
    public RenderState getRenderState() {
        return this.renderState;
    }

    public int getTeleportDuration() {
        return this.teleportDuration;
    }

    public void setTeleportDuration(int teleportDuration) {
        this.teleportDuration = teleportDuration;
    }

    public int getStartInterpolation() {
        return this.startInterpolation;
    }

    public void setStartInterpolation(int startInterpolation) {
        this.startInterpolation = startInterpolation;
    }

    public int getInterpolationDuration() {
        return this.interpolationDuration;
    }

    public void setInterpolationDuration(int interpolationDuration) {
        this.interpolationDuration = interpolationDuration;
    }

    public Vector3f getTranslation() {
        return this.translation;
    }

    public void setTranslation(Vector3f translation) {
        this.translation = translation;
    }

    public Vector3f getScale() {
        return this.scale;
    }

    public void setScale(Vector3f scale) {
        this.scale = scale;
    }

    public Quaternionf getLeftRotation() {
        return this.leftRotation;
    }

    public void setLeftRotation(Quaternionf leftRotation) {
        this.leftRotation = leftRotation;
    }

    public Quaternionf getRightRotation() {
        return this.rightRotation;
    }

    public void setRightRotation(Quaternionf rightRotation) {
        this.rightRotation = rightRotation;
    }

    public void setBillboardMode(BillboardMode billboardMode) {
        this.billboard = billboardMode.getIndex();
    }

    public BillboardMode getBillboardMode() {
        return BillboardMode.FROM_INDEX.apply(this.billboard.byteValue());
    }

    public void setBrightness(@Nullable class_8104 brightness) {
        this.brightness = brightness != null ? brightness.method_48763() : -1;
    }

    @Nullable
    public class_8104 getBrightnessUnpacked() {
        int i = this.brightness;
        return i != -1 ? class_8104.method_48764((int)i) : null;
    }

    public int getBrightness() {
        return this.brightness;
    }

    public void setViewRange(float viewRange) {
        this.viewRange = viewRange;
    }

    public float getViewRange() {
        return this.viewRange;
    }

    public void setShadowRadius(float shadowRadius) {
        this.shadowRadius = shadowRadius;
    }

    public float getShadowRadius() {
        return this.shadowRadius;
    }

    public void setShadowStrength(float shadowStrength) {
        this.shadowStrength = shadowStrength;
    }

    public float getShadowStrength() {
        return this.shadowStrength;
    }

    public void setDisplayWidth(float width) {
        this.width = width;
    }

    public float getDisplayWidth() {
        return this.width;
    }

    public void setDisplayHeight(float height) {
        this.height = height;
    }

    public int getGlowColorOverride() {
        return this.glowColorOverride;
    }

    public void setGlowColorOverride(int glowColorOverride) {
        this.glowColorOverride = glowColorOverride;
    }

    public float getLerpProgress(float delta) {
        float h;
        int i = this.interpolationDuration;
        if (i <= 0) {
            return 1.0f;
        }
        float f = this.age - this.interpolationStart;
        float g = f + delta;
        this.lerpProgress = h = class_3532.method_15363((float)class_3532.method_37960((float)g, (float)0.0f, (float)i), (float)0.0f, (float)1.0f);
        return h;
    }

    protected void lerpDisplayPosAndRotation(int step, double x, double y, double z, double yaw, double pitch) {
        double d = 1.0 / (double)step;
        double e = class_3532.method_16436((double)d, (double)this.getDisplayOffset().field_1352, (double)x);
        double f = class_3532.method_16436((double)d, (double)this.getDisplayOffset().field_1351, (double)y);
        double g = class_3532.method_16436((double)d, (double)this.getDisplayOffset().field_1350, (double)z);
        float h = (float)class_3532.method_52468((double)d, (double)this.getDisplayYaw(), (double)yaw);
        float i = (float)class_3532.method_16436((double)d, (double)this.getDisplayPitch(), (double)pitch);
        this.setDisplayOffset(new class_243(e, f, g));
        this.setDisplayRotation(h, i);
    }

    private float getDisplayHeight() {
        return this.height;
    }

    public String getCompleteTextString(class_1937 world) {
        class_2586 blockEntity;
        Object completeString = this.getTextString();
        class_2338 dataProvidingBlockPosOffset = this.getDataProvidingBlockPosOffset();
        if (dataProvidingBlockPosOffset != class_2338.field_10980 && (blockEntity = world.method_8321(this.method_11016().method_10069(dataProvidingBlockPosOffset.method_10263(), dataProvidingBlockPosOffset.method_10264(), dataProvidingBlockPosOffset.method_10260()))) instanceof ProvidesData) {
            ProvidesData providesDataBlockEntity = (ProvidesData)blockEntity;
            completeString = (String)completeString + providesDataBlockEntity.getData(this.getDataIdentifierString());
        }
        return completeString;
    }

    public String getTextString() {
        return this.textString;
    }

    public void setTextString(String textString) {
        this.textString = textString;
    }

    public class_2338 getDataProvidingBlockPosOffset() {
        return this.dataProvidingBlockPosOffset;
    }

    public void setDataProvidingBlockPosOffset(class_2338 dataProvidingBlockPosOffset) {
        this.dataProvidingBlockPosOffset = dataProvidingBlockPosOffset;
    }

    public String getDataIdentifierString() {
        return this.dataIdentifierString;
    }

    public void setDataIdentifierString(String dataIdentifierString) {
        this.dataIdentifierString = dataIdentifierString;
    }

    public class_2561 getText() {
        return this.text;
    }

    public void setText(class_2561 text) {
        this.text = text;
        this.renderingDataSet = true;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
        this.renderingDataSet = true;
    }

    public byte getTextOpacity() {
        return this.textOpacity;
    }

    public void setTextOpacity(byte textOpacity) {
        this.textOpacity = textOpacity;
        this.renderingDataSet = true;
    }

    public int getBackground() {
        return this.background;
    }

    public void setBackground(int background) {
        this.background = background;
        this.renderingDataSet = true;
    }

    public byte getDisplayFlags() {
        return this.textDisplayFlags;
    }

    public void setDisplayFlags(byte flags) {
        this.textDisplayFlags = flags;
        this.renderingDataSet = true;
    }

    public float getDisplayYaw() {
        return this.displayYaw;
    }

    public float getDisplayPitch() {
        return this.displayPitch;
    }

    public float getPrevDisplayYaw() {
        return this.displayPrevYaw;
    }

    public float getPrevDisplayPitch() {
        return this.displayPrevPitch;
    }

    public class_243 getDisplayOffset() {
        return this.displayOffset;
    }

    public void setDisplayOffset(class_243 displayOffset) {
        this.displayOffset = displayOffset;
    }

    public void setDisplayRotation(float yaw, float pitch) {
        this.displayYaw = yaw;
        this.displayPitch = pitch;
        this.displayPrevYaw = yaw;
        this.displayPrevPitch = pitch;
    }

    public DisplayMode getDisplayMode() {
        return this.displayMode;
    }

    public void setDisplayMode(DisplayMode displayMode) {
        this.displayMode = displayMode;
    }

    public boolean getIsTriggered() {
        return this.isTriggered;
    }

    public void setIsTriggered(boolean isTriggered) {
        this.isTriggered = isTriggered;
    }

    @Override
    protected void onRotate(class_2680 state) {
        if (state.method_26204() instanceof RotatedBlockWithEntity) {
            if ((Integer)state.method_11654((class_2769)RotatedBlockWithEntity.ROTATED) != this.rotated) {
                class_2470 blockRotation = BlockRotationUtils.calculateRotationFromDifferentRotatedStates((Integer)state.method_11654((class_2769)RotatedBlockWithEntity.ROTATED), this.rotated);
                this.rotated = (Integer)state.method_11654((class_2769)RotatedBlockWithEntity.ROTATED);
            }
            if ((Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.X_MIRRORED) != this.x_mirrored) {
                this.x_mirrored = (Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.X_MIRRORED);
            }
            if ((Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.Z_MIRRORED) != this.z_mirrored) {
                this.z_mirrored = (Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.Z_MIRRORED);
            }
        }
    }

    @Override
    public void reset() {
        if (this.isTriggered) {
            this.isTriggered = false;
            this.renderingDataSet = true;
        }
    }

    @Override
    public void trigger() {
        this.isTriggered = true;
        this.renderingDataSet = true;
    }

    private RenderState copyRenderState() {
        return new RenderState(AbstractInterpolator.constant(TriggeredDisplayBlockEntity.getTransformation(this)), this.getBillboardMode(), this.getBrightness(), FloatLerper.constant(this.getShadowRadius()), FloatLerper.constant(this.getShadowStrength()), this.getGlowColorOverride());
    }

    private RenderState getLerpedRenderState(RenderState state, float lerpProgress) {
        class_4590 affineTransformation = state.transformation.interpolate(lerpProgress);
        float f = state.shadowRadius.lerp(lerpProgress);
        float g = state.shadowStrength.lerp(lerpProgress);
        return new RenderState(new AffineTransformationInterpolator(affineTransformation, TriggeredDisplayBlockEntity.getTransformation(this)), this.getBillboardMode(), this.getBrightness(), new FloatLerperImpl(f, this.getShadowRadius()), new FloatLerperImpl(g, this.getShadowStrength()), this.getGlowColorOverride());
    }

    public TextLines splitLines(LineSplitter splitter) {
        if (this.textLines == null) {
            this.textLines = this.data != null ? splitter.split((class_2561)class_2561.method_43471((String)this.data.textString()), this.data.lineWidth()) : new TextLines(List.of(), 0);
        }
        return this.textLines;
    }

    public static TextAlignment getAlignment(byte flags) {
        if ((flags & 8) != 0) {
            return TextAlignment.LEFT;
        }
        return (flags & 0x10) != 0 ? TextAlignment.RIGHT : TextAlignment.CENTER;
    }

    public static enum BillboardMode implements class_3542
    {
        FIXED(0, "fixed"),
        VERTICAL(1, "vertical"),
        HORIZONTAL(2, "horizontal"),
        CENTER(3, "center");

        public static final Codec<BillboardMode> CODEC;
        public static final IntFunction<BillboardMode> FROM_INDEX;
        private final byte index;
        private final String name;

        private BillboardMode(byte index, String name) {
            this.name = name;
            this.index = index;
        }

        public String method_15434() {
            return this.name;
        }

        byte getIndex() {
            return this.index;
        }

        public static Optional<BillboardMode> byName(String name) {
            return Arrays.stream(BillboardMode.values()).filter(billboardMode -> billboardMode.method_15434().equals(name)).findFirst();
        }

        public class_2561 asText() {
            return class_2561.method_43471((String)("gui.triggered_display_block.billboard_mode." + this.name));
        }

        static {
            CODEC = class_3542.method_28140(BillboardMode::values);
            FROM_INDEX = class_7995.method_47914(BillboardMode::getIndex, (Object[])BillboardMode.values(), (class_7995.class_7996)class_7995.class_7996.field_41664);
        }
    }

    public static enum DisplayMode implements class_3542
    {
        BLOCK("block"),
        TEXT("text"),
        ITEM("item");

        private final String name;
        public static final Codec<DisplayMode> CODEC;

        private DisplayMode(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        public static Optional<DisplayMode> byName(String name) {
            return Arrays.stream(DisplayMode.values()).filter(displayMode -> displayMode.method_15434().equals(name)).findFirst();
        }

        public class_2561 asText() {
            return class_2561.method_43471((String)("gui.triggered_display_block.display_mode." + this.name));
        }

        static {
            CODEC = class_3542.method_28140(DisplayMode::values);
        }
    }

    public record Data(String textString, int lineWidth, IntLerper textOpacity, IntLerper backgroundColor, byte flags) {
    }

    public record TextLines(List<TextLine> lines, int width) {
    }

    @FunctionalInterface
    public static interface IntLerper {
        public static IntLerper constant(int value) {
            return delta -> value;
        }

        public int lerp(float var1);
    }

    record IntLerperImpl(int previous, int current) implements IntLerper
    {
        @Override
        public int lerp(float delta) {
            return class_3532.method_48781((float)delta, (int)this.previous, (int)this.current);
        }
    }

    record ArgbLerper(int previous, int current) implements IntLerper
    {
        @Override
        public int lerp(float delta) {
            return class_5253.class_5254.method_48780((float)delta, (int)this.previous, (int)this.current);
        }
    }

    public record RenderState(AbstractInterpolator<class_4590> transformation, BillboardMode billboardConstraints, int brightnessOverride, FloatLerper shadowRadius, FloatLerper shadowStrength, int glowColorOverride) {
    }

    static class InterpolationTarget {
        int step;
        final double x;
        final double y;
        final double z;
        final double yaw;
        final double pitch;

        InterpolationTarget(int step, double x, double y, double z, double yaw, double pitch) {
            this.step = step;
            this.x = x;
            this.y = y;
            this.z = z;
            this.yaw = yaw;
            this.pitch = pitch;
        }

        void apply(TriggeredDisplayBlockEntity entity) {
            entity.setDisplayOffset(new class_243(this.x, this.y, this.z));
            entity.setDisplayRotation((float)this.yaw, (float)this.pitch);
        }

        void applyInterpolated(TriggeredDisplayBlockEntity entity) {
            entity.lerpDisplayPosAndRotation(this.step, this.x, this.y, this.z, this.yaw, this.pitch);
        }
    }

    public static enum TextAlignment implements class_3542
    {
        CENTER("center"),
        LEFT("left"),
        RIGHT("right");

        public static final Codec<TextAlignment> CODEC;
        private final String name;

        private TextAlignment(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        static {
            CODEC = class_3542.method_28140(TextAlignment::values);
        }
    }

    @FunctionalInterface
    public static interface AbstractInterpolator<T> {
        public static <T> AbstractInterpolator<T> constant(T value) {
            return delta -> value;
        }

        public T interpolate(float var1);
    }

    @FunctionalInterface
    public static interface FloatLerper {
        public static FloatLerper constant(float value) {
            return delta -> value;
        }

        public float lerp(float var1);
    }

    record AffineTransformationInterpolator(class_4590 previous, class_4590 current) implements AbstractInterpolator<class_4590>
    {
        @Override
        public class_4590 interpolate(float f) {
            return (double)f >= 1.0 ? this.current : this.previous.method_35864(this.current, f);
        }
    }

    record FloatLerperImpl(float previous, float current) implements FloatLerper
    {
        @Override
        public float lerp(float delta) {
            return class_3532.method_16439((float)delta, (float)this.previous, (float)this.current);
        }
    }

    @FunctionalInterface
    public static interface LineSplitter {
        public TextLines split(class_2561 var1, int var2);
    }

    public record TextLine(class_5481 contents, int width) {
    }
}

