/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.scriptblocks.block.entity;

import com.github.theredbrain.scriptblocks.block.ProvidesData;
import com.github.theredbrain.scriptblocks.block.Resetable;
import com.github.theredbrain.scriptblocks.block.RotatedBlockWithEntity;
import com.github.theredbrain.scriptblocks.block.Triggerable;
import com.github.theredbrain.scriptblocks.block.entity.RotatedBlockEntity;
import com.github.theredbrain.scriptblocks.registry.EntityRegistry;
import com.github.theredbrain.scriptblocks.util.BlockRotationUtils;
import com.github.theredbrain.scriptblocks.util.UUIDUtilities;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_2338;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_268;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.MutablePair;

public class TriggeredRNGBlockEntity
extends RotatedBlockEntity
implements Triggerable {
    private static final class_2338 OVERRIDE_TRIGGERED_BLOCK_POS_DEFAULT = new class_2338(0, -1, 0);
    private static final class_2338 FALLBACK_TRIGGERED_BLOCK_POS_DEFAULT = new class_2338(0, 1, 0);
    private class_2338 dataProvidingBlockPosOffset = class_2338.field_10980;
    private String overrideDataIdentifier = "";
    private String overrideDataValue = "";
    private MutablePair<class_2338, Boolean> overrideTriggeredBlock = new MutablePair((Object)OVERRIDE_TRIGGERED_BLOCK_POS_DEFAULT, (Object)false);
    private String influencingAttributeIdentifierString = "";
    private boolean checksTeamAttributes = true;
    private boolean isAffectedByLuck = true;
    private int randomMinValue = 0;
    private int randomMaxValue = 1;
    private MutablePair<class_2338, Boolean> fallbackTriggeredBlock = new MutablePair((Object)FALLBACK_TRIGGERED_BLOCK_POS_DEFAULT, (Object)false);
    private List<MutablePair<MutablePair<class_2338, Boolean>, Integer>> triggeredBlocks = new ArrayList<MutablePair<MutablePair<class_2338, Boolean>, Integer>>();

    public TriggeredRNGBlockEntity(class_2338 pos, class_2680 state) {
        super(EntityRegistry.TRIGGERED_RNG_BLOCK_ENTITY, pos, state);
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        if (this.dataProvidingBlockPosOffset != class_2338.field_10980) {
            nbt.method_10569("dataProvidingBlockPosOffsetX", this.dataProvidingBlockPosOffset.method_10263());
            nbt.method_10569("dataProvidingBlockPosOffsetY", this.dataProvidingBlockPosOffset.method_10264());
            nbt.method_10569("dataProvidingBlockPosOffsetZ", this.dataProvidingBlockPosOffset.method_10260());
        } else {
            nbt.method_10551("dataProvidingBlockPosOffsetX");
            nbt.method_10551("dataProvidingBlockPosOffsetY");
            nbt.method_10551("dataProvidingBlockPosOffsetZ");
        }
        if (!this.overrideDataIdentifier.isEmpty()) {
            nbt.method_10582("overrideDataIdentifier", this.overrideDataIdentifier);
        } else {
            nbt.method_10551("overrideDataIdentifier");
        }
        if (!this.overrideDataValue.isEmpty()) {
            nbt.method_10582("overrideDataValue", this.overrideDataValue);
        } else {
            nbt.method_10551("overrideDataValue");
        }
        class_2338 overrideTriggeredBlockPositionOffset = (class_2338)this.overrideTriggeredBlock.getLeft();
        if (!overrideTriggeredBlockPositionOffset.equals((Object)OVERRIDE_TRIGGERED_BLOCK_POS_DEFAULT)) {
            nbt.method_10569("overrideTriggeredBlockPositionOffsetX", overrideTriggeredBlockPositionOffset.method_10263());
            nbt.method_10569("overrideTriggeredBlockPositionOffsetY", overrideTriggeredBlockPositionOffset.method_10264());
            nbt.method_10569("overrideTriggeredBlockPositionOffsetZ", overrideTriggeredBlockPositionOffset.method_10260());
            nbt.method_10556("overrideTriggeredBlockResets", ((Boolean)this.overrideTriggeredBlock.getRight()).booleanValue());
        } else {
            nbt.method_10551("overrideTriggeredBlockPositionOffsetX");
            nbt.method_10551("overrideTriggeredBlockPositionOffsetY");
            nbt.method_10551("overrideTriggeredBlockPositionOffsetZ");
            nbt.method_10551("overrideTriggeredBlockResets");
        }
        if (!this.influencingAttributeIdentifierString.isEmpty()) {
            nbt.method_10582("influencingAttributeIdentifierString", this.influencingAttributeIdentifierString);
        } else {
            nbt.method_10551("influencingAttributeIdentifierString");
        }
        if (!this.checksTeamAttributes) {
            nbt.method_10556("checksTeamAttributes", false);
        } else {
            nbt.method_10551("checksTeamAttributes");
        }
        if (!this.isAffectedByLuck) {
            nbt.method_10556("isAffectedByLuck", false);
        } else {
            nbt.method_10551("isAffectedByLuck");
        }
        if (this.randomMinValue != 0) {
            nbt.method_10569("randomMinValue", this.randomMinValue);
        } else {
            nbt.method_10551("randomMinValue");
        }
        if (this.randomMaxValue != 1) {
            nbt.method_10569("randomMaxValue", this.randomMaxValue);
        } else {
            nbt.method_10551("randomMaxValue");
        }
        class_2338 fallbackTriggeredBlockPositionOffset = (class_2338)this.fallbackTriggeredBlock.getLeft();
        if (!fallbackTriggeredBlockPositionOffset.equals((Object)FALLBACK_TRIGGERED_BLOCK_POS_DEFAULT)) {
            nbt.method_10569("fallbackTriggeredBlockPositionOffsetX", fallbackTriggeredBlockPositionOffset.method_10263());
            nbt.method_10569("fallbackTriggeredBlockPositionOffsetY", fallbackTriggeredBlockPositionOffset.method_10264());
            nbt.method_10569("fallbackTriggeredBlockPositionOffsetZ", fallbackTriggeredBlockPositionOffset.method_10260());
            nbt.method_10556("fallbackTriggeredBlockResets", ((Boolean)this.fallbackTriggeredBlock.getRight()).booleanValue());
        } else {
            nbt.method_10551("fallbackTriggeredBlockPositionOffsetX");
            nbt.method_10551("fallbackTriggeredBlockPositionOffsetY");
            nbt.method_10551("fallbackTriggeredBlockPositionOffsetZ");
            nbt.method_10551("fallbackTriggeredBlockResets");
        }
        if (!this.triggeredBlocks.isEmpty()) {
            nbt.method_10569("triggeredBlocksSize", this.triggeredBlocks.size());
            for (int i = 0; i < this.triggeredBlocks.size(); ++i) {
                class_2338 triggeredBlock = (class_2338)((MutablePair)this.triggeredBlocks.get((int)i).left).left;
                nbt.method_10569("triggeredBlockPositionOffsetX_" + i, triggeredBlock.method_10263());
                nbt.method_10569("triggeredBlockPositionOffsetY_" + i, triggeredBlock.method_10264());
                nbt.method_10569("triggeredBlockPositionOffsetZ_" + i, triggeredBlock.method_10260());
                nbt.method_10556("triggeredBlockResets_" + i, ((Boolean)((MutablePair)this.triggeredBlocks.get((int)i).left).right).booleanValue());
                nbt.method_10569("triggeredBlockThreshold_" + i, ((Integer)this.triggeredBlocks.get((int)i).right).intValue());
            }
        }
        super.method_11007(nbt, registryLookup);
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        this.dataProvidingBlockPosOffset = nbt.method_10573("dataProvidingBlockPosOffsetX", 3) && nbt.method_10573("dataProvidingBlockPosOffsetY", 3) && nbt.method_10573("dataProvidingBlockPosOffsetZ", 3) ? new class_2338(class_3532.method_15340((int)nbt.method_10550("dataProvidingBlockPosOffsetX"), (int)-48, (int)48), class_3532.method_15340((int)nbt.method_10550("dataProvidingBlockPosOffsetY"), (int)-48, (int)48), class_3532.method_15340((int)nbt.method_10550("dataProvidingBlockPosOffsetZ"), (int)-48, (int)48)) : class_2338.field_10980;
        this.overrideDataIdentifier = nbt.method_10573("overrideDataIdentifier", 8) ? nbt.method_10558("overrideDataIdentifier") : "";
        this.overrideDataValue = nbt.method_10573("overrideDataValue", 8) ? nbt.method_10558("overrideDataValue") : "";
        this.overrideTriggeredBlock = nbt.method_10573("overrideTriggeredBlockPositionOffsetX", 3) || nbt.method_10573("overrideTriggeredBlockPositionOffsetY", 3) || nbt.method_10573("overrideTriggeredBlockPositionOffsetZ", 3) || nbt.method_10573("overrideTriggeredBlockResets", 1) ? new MutablePair((Object)new class_2338(class_3532.method_15340((int)nbt.method_10550("overrideTriggeredBlockPositionOffsetX"), (int)-48, (int)48), class_3532.method_15340((int)nbt.method_10550("overrideTriggeredBlockPositionOffsetY"), (int)-48, (int)48), class_3532.method_15340((int)nbt.method_10550("overrideTriggeredBlockPositionOffsetZ"), (int)-48, (int)48)), (Object)nbt.method_10577("overrideTriggeredBlockResets")) : new MutablePair((Object)OVERRIDE_TRIGGERED_BLOCK_POS_DEFAULT, (Object)false);
        this.influencingAttributeIdentifierString = nbt.method_10573("influencingAttributeIdentifierString", 8) ? nbt.method_10558("influencingAttributeIdentifierString") : "";
        this.checksTeamAttributes = nbt.method_10573("checksTeamAttributes", 1) ? nbt.method_10577("checksTeamAttributes") : true;
        this.isAffectedByLuck = nbt.method_10573("isAffectedByLuck", 1) ? nbt.method_10577("isAffectedByLuck") : true;
        this.randomMinValue = nbt.method_10573("randomMinValue", 3) ? nbt.method_10550("randomMinValue") : 0;
        this.randomMaxValue = nbt.method_10573("randomMaxValue", 3) ? nbt.method_10550("randomMaxValue") : 1;
        this.fallbackTriggeredBlock = nbt.method_10573("fallbackTriggeredBlockPositionOffsetX", 3) || nbt.method_10573("fallbackTriggeredBlockPositionOffsetY", 3) || nbt.method_10573("fallbackTriggeredBlockPositionOffsetZ", 3) || nbt.method_10573("fallbackTriggeredBlockResets", 1) ? new MutablePair((Object)new class_2338(class_3532.method_15340((int)nbt.method_10550("fallbackTriggeredBlockPositionOffsetX"), (int)-48, (int)48), class_3532.method_15340((int)nbt.method_10550("fallbackTriggeredBlockPositionOffsetY"), (int)-48, (int)48), class_3532.method_15340((int)nbt.method_10550("fallbackTriggeredBlockPositionOffsetZ"), (int)-48, (int)48)), (Object)nbt.method_10577("fallbackTriggeredBlockResets")) : new MutablePair((Object)FALLBACK_TRIGGERED_BLOCK_POS_DEFAULT, (Object)false);
        int triggeredBlocksSize = nbt.method_10550("triggeredBlocksSize");
        this.triggeredBlocks = new ArrayList<MutablePair<MutablePair<class_2338, Boolean>, Integer>>(List.of());
        for (int i = 0; i < triggeredBlocksSize; ++i) {
            this.triggeredBlocks.add((MutablePair<MutablePair<class_2338, Boolean>, Integer>)new MutablePair((Object)new MutablePair((Object)new class_2338(class_3532.method_15340((int)nbt.method_10550("triggeredBlockPositionOffsetX_" + i), (int)-48, (int)48), class_3532.method_15340((int)nbt.method_10550("triggeredBlockPositionOffsetY_" + i), (int)-48, (int)48), class_3532.method_15340((int)nbt.method_10550("triggeredBlockPositionOffsetZ_" + i), (int)-48, (int)48)), (Object)nbt.method_10577("triggeredBlockResets_" + i)), (Object)class_3532.method_15340((int)nbt.method_10550("triggeredBlockThreshold_" + i), (int)0, (int)100)));
        }
        super.method_11014(nbt, registryLookup);
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return this.method_58692(registryLookup);
    }

    public class_2338 getDataProvidingBlockPosOffset() {
        return this.dataProvidingBlockPosOffset;
    }

    public void setDataProvidingBlockPosOffset(class_2338 dataProvidingBlockPosOffset) {
        this.dataProvidingBlockPosOffset = dataProvidingBlockPosOffset;
    }

    public String getOverrideDataIdentifier() {
        return this.overrideDataIdentifier;
    }

    public void setOverrideDataIdentifier(String overrideDataIdentifier) {
        this.overrideDataIdentifier = overrideDataIdentifier;
    }

    public String getOverrideDataValue() {
        return this.overrideDataValue;
    }

    public void setOverrideDataValue(String overrideDataValue) {
        this.overrideDataValue = overrideDataValue;
    }

    public MutablePair<class_2338, Boolean> getOverrideTriggeredBlock() {
        return this.overrideTriggeredBlock;
    }

    public void setOverrideTriggeredBlock(MutablePair<class_2338, Boolean> overrideTriggeredBlock) {
        this.overrideTriggeredBlock = overrideTriggeredBlock;
    }

    public String getInfluencingAttributeIdentifierString() {
        return this.influencingAttributeIdentifierString;
    }

    public void setInfluencingAttributeIdentifierString(String influencingAttributeIdentifierString) {
        this.influencingAttributeIdentifierString = influencingAttributeIdentifierString;
    }

    public boolean checksTeamAttributes() {
        return this.checksTeamAttributes;
    }

    public void setChecksTeamAttributes(boolean checksTeamAttributes) {
        this.checksTeamAttributes = checksTeamAttributes;
    }

    public boolean isAffectedByLuck() {
        return this.isAffectedByLuck;
    }

    public void setIsAffectedByLuck(boolean isAffectedByLuck) {
        this.isAffectedByLuck = isAffectedByLuck;
    }

    public int getRandomMinValue() {
        return this.randomMinValue;
    }

    public void setRandomMinValue(int randomMinValue) {
        this.randomMinValue = randomMinValue;
    }

    public int getRandomMaxValue() {
        return this.randomMaxValue;
    }

    public void setRandomMaxValue(int randomMaxValue) {
        this.randomMaxValue = randomMaxValue;
    }

    public MutablePair<class_2338, Boolean> getFallbackTriggeredBlock() {
        return this.fallbackTriggeredBlock;
    }

    public void setFallbackTriggeredBlock(MutablePair<class_2338, Boolean> fallbackTriggeredBlock) {
        this.fallbackTriggeredBlock = fallbackTriggeredBlock;
    }

    public List<MutablePair<MutablePair<class_2338, Boolean>, Integer>> getTriggeredBlocks() {
        return this.triggeredBlocks;
    }

    public void setTriggeredBlocks(List<MutablePair<MutablePair<class_2338, Boolean>, Integer>> triggeredBlocks) {
        this.triggeredBlocks = triggeredBlocks;
    }

    @Override
    public void trigger() {
        if (this.field_11863 != null) {
            class_2338 dataProviderBlockPos;
            class_2586 blockEntity;
            String worldName = this.field_11863.method_27983().method_29177().method_12832();
            MinecraftServer server = this.field_11863.method_8503();
            boolean overrideIsActive = false;
            if (this.dataProvidingBlockPosOffset != class_2338.field_10980 && !this.overrideDataIdentifier.isEmpty() && !this.overrideDataValue.isEmpty() && (blockEntity = this.field_11863.method_8321(dataProviderBlockPos = new class_2338(this.field_11867.method_10263() + this.dataProvidingBlockPosOffset.method_10263(), this.field_11867.method_10264() + this.dataProvidingBlockPosOffset.method_10264(), this.field_11867.method_10260() + this.dataProvidingBlockPosOffset.method_10260()))) instanceof ProvidesData) {
                ProvidesData providesDataEntity = (ProvidesData)blockEntity;
                overrideIsActive = Objects.equals(providesDataEntity.getData(this.overrideDataIdentifier), this.overrideDataValue);
            }
            if (overrideIsActive) {
                class_2586 blockEntity2 = this.field_11863.method_8321(new class_2338(this.field_11867.method_10263() + ((class_2338)this.overrideTriggeredBlock.getLeft()).method_10263(), this.field_11867.method_10264() + ((class_2338)this.overrideTriggeredBlock.getLeft()).method_10264(), this.field_11867.method_10260() + ((class_2338)this.overrideTriggeredBlock.getLeft()).method_10260()));
                if (blockEntity2 != this) {
                    boolean overrideTriggeredBlockResets = (Boolean)this.overrideTriggeredBlock.getRight();
                    if (overrideTriggeredBlockResets && blockEntity2 instanceof Resetable) {
                        Resetable resetable = (Resetable)blockEntity2;
                        resetable.reset();
                    } else if (!overrideTriggeredBlockResets && blockEntity2 instanceof Triggerable) {
                        Triggerable triggerable = (Triggerable)blockEntity2;
                        triggerable.trigger();
                    }
                }
            } else {
                class_2586 blockEntity3;
                float luck = 0.0f;
                float attributeValue = 0.0f;
                String attributeString = this.influencingAttributeIdentifierString;
                Optional attributeEntry = class_7923.field_41190.method_55841(class_2960.method_12829((String)attributeString));
                class_3222 serverPlayerEntity = null;
                if (server != null && UUIDUtilities.isStringValidUUID(worldName)) {
                    serverPlayerEntity = server.method_3760().method_14602(UUID.fromString(worldName));
                }
                if (serverPlayerEntity != null) {
                    class_268 team;
                    luck += serverPlayerEntity.method_7292();
                    if (attributeEntry.isPresent()) {
                        attributeValue += (float)serverPlayerEntity.method_45325((class_6880)attributeEntry.get());
                    }
                    if (this.checksTeamAttributes && (team = serverPlayerEntity.method_5781()) != null) {
                        for (String playerString : team.method_1204()) {
                            class_3222 teamServerPlayerEntity = server.method_3760().method_14566(playerString);
                            if (teamServerPlayerEntity == null || teamServerPlayerEntity == serverPlayerEntity) continue;
                            luck += teamServerPlayerEntity.method_7292();
                            if (!attributeEntry.isPresent()) continue;
                            attributeValue += (float)serverPlayerEntity.method_45325((class_6880)attributeEntry.get());
                        }
                    }
                }
                int randomNumber = this.field_11863.field_9229.method_39332(this.randomMinValue, this.randomMaxValue);
                if (this.isAffectedByLuck) {
                    boolean rollWithAdvantage = luck > 0.0f;
                    int additionalRollAmount = (int)Math.floor(Math.abs(luck));
                    for (int i = 0; i < additionalRollAmount; ++i) {
                        int newRandomNumber = this.field_11863.field_9229.method_39332(this.randomMinValue, this.randomMaxValue);
                        if (rollWithAdvantage) {
                            if (newRandomNumber <= randomNumber) continue;
                            randomNumber = newRandomNumber;
                            continue;
                        }
                        if (newRandomNumber >= randomNumber) continue;
                        randomNumber = newRandomNumber;
                    }
                }
                randomNumber += (int)Math.floor(Math.abs(attributeValue));
                MutablePair triggeredBlock = new MutablePair((Object)class_2338.field_10980, (Object)false);
                int currentThreshold = this.randomMinValue;
                for (MutablePair<MutablePair<class_2338, Boolean>, Integer> entry : this.triggeredBlocks) {
                    int f = (Integer)entry.right;
                    if (randomNumber < f || f < currentThreshold) continue;
                    triggeredBlock = (MutablePair)entry.left;
                    currentThreshold = f;
                }
                if (Objects.equals(triggeredBlock, new MutablePair((Object)class_2338.field_10980, (Object)false))) {
                    triggeredBlock = this.fallbackTriggeredBlock;
                }
                if ((blockEntity3 = this.field_11863.method_8321((class_2338)triggeredBlock.left)) != this) {
                    if (((Boolean)triggeredBlock.right).booleanValue() && blockEntity3 instanceof Resetable) {
                        Resetable resetable = (Resetable)blockEntity3;
                        resetable.reset();
                    } else if (!((Boolean)triggeredBlock.right).booleanValue() && blockEntity3 instanceof Triggerable) {
                        Triggerable triggerable = (Triggerable)blockEntity3;
                        triggerable.trigger();
                    }
                }
            }
        }
    }

    @Override
    protected void onRotate(class_2680 state) {
        if (state.method_26204() instanceof RotatedBlockWithEntity) {
            ArrayList<MutablePair<MutablePair<class_2338, Boolean>, Integer>> newTriggeredBlocks;
            if ((Integer)state.method_11654((class_2769)RotatedBlockWithEntity.ROTATED) != this.rotated) {
                class_2470 blockRotation = BlockRotationUtils.calculateRotationFromDifferentRotatedStates((Integer)state.method_11654((class_2769)RotatedBlockWithEntity.ROTATED), this.rotated);
                this.dataProvidingBlockPosOffset = BlockRotationUtils.rotateOffsetBlockPos(this.dataProvidingBlockPosOffset, blockRotation);
                this.overrideTriggeredBlock.setLeft((Object)BlockRotationUtils.rotateOffsetBlockPos((class_2338)this.overrideTriggeredBlock.getLeft(), blockRotation));
                this.fallbackTriggeredBlock.setLeft((Object)BlockRotationUtils.rotateOffsetBlockPos((class_2338)this.fallbackTriggeredBlock.getLeft(), blockRotation));
                ArrayList<MutablePair<MutablePair<class_2338, Boolean>, Integer>> newTriggeredBlocks2 = new ArrayList<MutablePair<MutablePair<class_2338, Boolean>, Integer>>(List.of());
                for (MutablePair<MutablePair<class_2338, Boolean>, Integer> triggeredBlock : this.triggeredBlocks) {
                    newTriggeredBlocks2.add((MutablePair<MutablePair<class_2338, Boolean>, Integer>)new MutablePair((Object)new MutablePair((Object)BlockRotationUtils.rotateOffsetBlockPos((class_2338)((MutablePair)triggeredBlock.getLeft()).getLeft(), blockRotation), (Object)((Boolean)((MutablePair)triggeredBlock.getLeft()).getRight())), (Object)((Integer)triggeredBlock.getRight())));
                }
                this.triggeredBlocks = newTriggeredBlocks2;
                this.rotated = (Integer)state.method_11654((class_2769)RotatedBlockWithEntity.ROTATED);
            }
            if ((Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.X_MIRRORED) != this.x_mirrored) {
                this.dataProvidingBlockPosOffset = BlockRotationUtils.mirrorOffsetBlockPos(this.dataProvidingBlockPosOffset, class_2415.field_11301);
                this.overrideTriggeredBlock.setLeft((Object)BlockRotationUtils.mirrorOffsetBlockPos((class_2338)this.overrideTriggeredBlock.getLeft(), class_2415.field_11301));
                this.fallbackTriggeredBlock.setLeft((Object)BlockRotationUtils.mirrorOffsetBlockPos((class_2338)this.fallbackTriggeredBlock.getLeft(), class_2415.field_11301));
                newTriggeredBlocks = new ArrayList<MutablePair<MutablePair<class_2338, Boolean>, Integer>>(List.of());
                for (MutablePair<MutablePair<class_2338, Boolean>, Integer> triggeredBlock : this.triggeredBlocks) {
                    newTriggeredBlocks.add((MutablePair<MutablePair<class_2338, Boolean>, Integer>)new MutablePair((Object)new MutablePair((Object)BlockRotationUtils.mirrorOffsetBlockPos((class_2338)((MutablePair)triggeredBlock.getLeft()).getLeft(), class_2415.field_11301), (Object)((Boolean)((MutablePair)triggeredBlock.getLeft()).getRight())), (Object)((Integer)triggeredBlock.getRight())));
                }
                this.triggeredBlocks = newTriggeredBlocks;
                this.x_mirrored = (Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.X_MIRRORED);
            }
            if ((Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.Z_MIRRORED) != this.z_mirrored) {
                this.dataProvidingBlockPosOffset = BlockRotationUtils.mirrorOffsetBlockPos(this.dataProvidingBlockPosOffset, class_2415.field_11300);
                this.overrideTriggeredBlock.setLeft((Object)BlockRotationUtils.mirrorOffsetBlockPos((class_2338)this.overrideTriggeredBlock.getLeft(), class_2415.field_11300));
                this.fallbackTriggeredBlock.setLeft((Object)BlockRotationUtils.mirrorOffsetBlockPos((class_2338)this.fallbackTriggeredBlock.getLeft(), class_2415.field_11300));
                newTriggeredBlocks = new ArrayList(List.of());
                for (MutablePair<MutablePair<class_2338, Boolean>, Integer> triggeredBlock : this.triggeredBlocks) {
                    newTriggeredBlocks.add((MutablePair<MutablePair<class_2338, Boolean>, Integer>)new MutablePair((Object)new MutablePair((Object)BlockRotationUtils.mirrorOffsetBlockPos((class_2338)((MutablePair)triggeredBlock.getLeft()).getLeft(), class_2415.field_11300), (Object)((Boolean)((MutablePair)triggeredBlock.getLeft()).getRight())), (Object)((Integer)triggeredBlock.getRight())));
                }
                this.triggeredBlocks = newTriggeredBlocks;
                this.z_mirrored = (Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.Z_MIRRORED);
            }
        }
    }
}

