/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.scriptblocks.block.entity;

import com.github.theredbrain.scriptblocks.ScriptBlocks;
import com.github.theredbrain.scriptblocks.block.Resetable;
import com.github.theredbrain.scriptblocks.block.RotatedBlockWithEntity;
import com.github.theredbrain.scriptblocks.block.Triggerable;
import com.github.theredbrain.scriptblocks.block.entity.RotatedBlockEntity;
import com.github.theredbrain.scriptblocks.entity.mob.DuckMobEntityMixin;
import com.github.theredbrain.scriptblocks.registry.EntityRegistry;
import com.github.theredbrain.scriptblocks.util.BlockRotationUtils;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_3730;
import net.minecraft.class_5131;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.apache.commons.lang3.tuple.MutablePair;
import org.jetbrains.annotations.Nullable;

public class TriggeredSpawnerBlockEntity
extends RotatedBlockEntity
implements Triggerable,
Resetable {
    protected static final class_2338 POSITION_OFFSET_DEFAULT = new class_2338(0, 0, 0);
    protected class_2338 entitySpawnPositionOffset = POSITION_OFFSET_DEFAULT;
    protected double entitySpawnOrientationPitch = 0.0;
    protected double entitySpawnOrientationYaw = 0.0;
    @Nullable
    protected UUID boundEntityUuid = null;
    protected SpawningMode spawningMode = SpawningMode.ONCE;
    protected Multimap<class_6880<class_1320>, class_1322> entityAttributeModifiers = Multimaps.newMultimap((Map)Maps.newLinkedHashMap(), ArrayList::new);
    protected class_2338 useRelayBlockPositionOffset = POSITION_OFFSET_DEFAULT;
    protected class_2487 entityTypeCompound = new class_2487();
    private boolean triggered = false;
    private MutablePair<class_2338, Boolean> triggeredBlock = new MutablePair((Object)POSITION_OFFSET_DEFAULT, (Object)false);

    public TriggeredSpawnerBlockEntity(class_2338 pos, class_2680 state) {
        this(EntityRegistry.TRIGGERED_SPAWNER_BLOCK_ENTITY, pos, state);
    }

    public TriggeredSpawnerBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_2338 entitySpawnPositionOffset = this.entitySpawnPositionOffset;
        if (!entitySpawnPositionOffset.equals((Object)POSITION_OFFSET_DEFAULT)) {
            nbt.method_10569("entitySpawnPositionOffsetX", entitySpawnPositionOffset.method_10263());
            nbt.method_10569("entitySpawnPositionOffsetY", entitySpawnPositionOffset.method_10264());
            nbt.method_10569("entitySpawnPositionOffsetZ", entitySpawnPositionOffset.method_10260());
        } else {
            nbt.method_10551("entitySpawnPositionOffsetX");
            nbt.method_10551("entitySpawnPositionOffsetY");
            nbt.method_10551("entitySpawnPositionOffsetZ");
        }
        if (this.entitySpawnOrientationPitch != 0.0) {
            nbt.method_10549("entitySpawnOrientationPitch", this.entitySpawnOrientationPitch);
        } else {
            nbt.method_10551("entitySpawnOrientationPitch");
        }
        if (this.entitySpawnOrientationYaw != 0.0) {
            nbt.method_10549("entitySpawnOrientationYaw", this.entitySpawnOrientationYaw);
        } else {
            nbt.method_10551("entitySpawnOrientationYaw");
        }
        class_2338 triggeredBlockPositionOffset = (class_2338)this.triggeredBlock.getLeft();
        if (!triggeredBlockPositionOffset.equals((Object)POSITION_OFFSET_DEFAULT)) {
            nbt.method_10569("triggeredBlockPositionOffsetX", triggeredBlockPositionOffset.method_10263());
            nbt.method_10569("triggeredBlockPositionOffsetY", triggeredBlockPositionOffset.method_10264());
            nbt.method_10569("triggeredBlockPositionOffsetZ", triggeredBlockPositionOffset.method_10260());
            nbt.method_10556("triggeredBlockResets", ((Boolean)this.triggeredBlock.getRight()).booleanValue());
        } else {
            nbt.method_10551("triggeredBlockPositionOffsetX");
            nbt.method_10551("triggeredBlockPositionOffsetY");
            nbt.method_10551("triggeredBlockPositionOffsetZ");
            nbt.method_10551("triggeredBlockResets");
        }
        class_2338 useRelayBlockPositionOffset = this.useRelayBlockPositionOffset;
        if (!useRelayBlockPositionOffset.equals((Object)POSITION_OFFSET_DEFAULT)) {
            nbt.method_10569("useRelayedBlockPositionOffsetX", useRelayBlockPositionOffset.method_10263());
            nbt.method_10569("useRelayedBlockPositionOffsetY", useRelayBlockPositionOffset.method_10264());
            nbt.method_10569("useRelayedBlockPositionOffsetZ", useRelayBlockPositionOffset.method_10260());
        } else {
            nbt.method_10551("useRelayedBlockPositionOffsetX");
            nbt.method_10551("useRelayedBlockPositionOffsetY");
            nbt.method_10551("useRelayedBlockPositionOffsetZ");
        }
        ArrayList entityAttributeModifiersKeys = new ArrayList(this.entityAttributeModifiers.keySet());
        nbt.method_10569("entityAttributeModifiersKeysSize", entityAttributeModifiersKeys.size());
        for (int i = 0; i < entityAttributeModifiersKeys.size(); ++i) {
            class_6880 key = (class_6880)entityAttributeModifiersKeys.get(i);
            Collection modifierCollection = this.entityAttributeModifiers.get((Object)key);
            nbt.method_10582("entityAttributeModifiers_key" + i, String.valueOf(class_7923.field_41190.method_10221((Object)((class_1320)key.comp_349()))));
            List modifierList = modifierCollection.stream().toList();
            nbt.method_10569("entityAttributeModifiers_modifierListSize_" + i, modifierList.size());
            for (int j = 0; j < modifierList.size(); ++j) {
                nbt.method_10566("entityAttributeModifiers_" + i + "_" + j, (class_2520)((class_1322)modifierList.get(j)).method_26860());
            }
        }
        if (this.spawningMode != SpawningMode.ONCE) {
            nbt.method_10582("spawningMode", this.spawningMode.method_15434());
        } else {
            nbt.method_10551("spawningMode");
        }
        if (this.triggered) {
            nbt.method_10556("triggered", true);
        } else {
            nbt.method_10551("triggered");
        }
        if (!Objects.equals(this.entityTypeCompound, new class_2487())) {
            nbt.method_10566("EntityTypeCompound", (class_2520)this.entityTypeCompound);
        } else {
            nbt.method_10551("EntityTypeCompound");
        }
        if (this.boundEntityUuid != null) {
            nbt.method_25927("boundEntityUuid", this.boundEntityUuid);
        } else {
            nbt.method_10551("boundEntityUuid");
        }
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        if (nbt.method_10573("entitySpawnPositionOffsetX", 3) || nbt.method_10573("entitySpawnPositionOffsetY", 3) || nbt.method_10573("entitySpawnPositionOffsetZ", 3)) {
            this.entitySpawnPositionOffset = new class_2338(class_3532.method_15340((int)nbt.method_10550("entitySpawnPositionOffsetX"), (int)-48, (int)48), class_3532.method_15340((int)nbt.method_10550("entitySpawnPositionOffsetY"), (int)-48, (int)48), class_3532.method_15340((int)nbt.method_10550("entitySpawnPositionOffsetZ"), (int)-48, (int)48));
        }
        if (nbt.method_10573("entitySpawnOrientationPitch", 6)) {
            this.entitySpawnOrientationPitch = nbt.method_10574("entitySpawnOrientationPitch");
        }
        if (nbt.method_10573("entitySpawnOrientationYaw", 6)) {
            this.entitySpawnOrientationYaw = nbt.method_10574("entitySpawnOrientationYaw");
        }
        if (nbt.method_10573("triggeredBlockPositionOffsetX", 3) || nbt.method_10573("triggeredBlockPositionOffsetY", 3) || nbt.method_10573("triggeredBlockPositionOffsetZ", 3) || nbt.method_10573("triggeredBlockResets", 1)) {
            this.triggeredBlock = new MutablePair((Object)new class_2338(class_3532.method_15340((int)nbt.method_10550("triggeredBlockPositionOffsetX"), (int)-48, (int)48), class_3532.method_15340((int)nbt.method_10550("triggeredBlockPositionOffsetY"), (int)-48, (int)48), class_3532.method_15340((int)nbt.method_10550("triggeredBlockPositionOffsetZ"), (int)-48, (int)48)), (Object)nbt.method_10577("triggeredBlockResets"));
        }
        if (nbt.method_10573("useRelayedBlockPositionOffsetX", 3) || nbt.method_10573("useRelayedBlockPositionOffsetY", 3) || nbt.method_10573("useRelayedBlockPositionOffsetZ", 3)) {
            this.useRelayBlockPositionOffset = new class_2338(class_3532.method_15340((int)nbt.method_10550("useRelayedBlockPositionOffsetX"), (int)-48, (int)48), class_3532.method_15340((int)nbt.method_10550("useRelayedBlockPositionOffsetY"), (int)-48, (int)48), class_3532.method_15340((int)nbt.method_10550("useRelayedBlockPositionOffsetZ"), (int)-48, (int)48));
        }
        this.entityAttributeModifiers.clear();
        int entityAttributeModifiersKeysSize = nbt.method_10550("entityAttributeModifiersKeysSize");
        for (int i = 0; i < entityAttributeModifiersKeysSize; ++i) {
            Optional optional = class_7923.field_41190.method_55841(class_2960.method_12829((String)nbt.method_10558("entityAttributeModifiers_key" + i)));
            if (!optional.isPresent()) continue;
            class_6880.class_6883 key = (class_6880.class_6883)optional.get();
            int modifierListSize = nbt.method_10550("entityAttributeModifiers_modifierListSize_" + i);
            for (int j = 0; j < modifierListSize; ++j) {
                this.entityAttributeModifiers.put((Object)key, (Object)class_1322.method_26859((class_2487)nbt.method_10562("entityAttributeModifiers_" + i + "_" + j)));
            }
        }
        if (nbt.method_10573("spawningMode", 8)) {
            this.spawningMode = SpawningMode.byName(nbt.method_10558("spawningMode")).orElseGet(() -> SpawningMode.ONCE);
        }
        if (nbt.method_10573("triggered", 1)) {
            this.triggered = nbt.method_10577("triggered");
        }
        if (nbt.method_10573("EntityTypeCompound", 10)) {
            this.entityTypeCompound = nbt.method_10562("EntityTypeCompound");
        }
        if (nbt.method_25928("boundEntityUuid")) {
            this.boundEntityUuid = nbt.method_25926("boundEntityUuid");
        }
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return this.method_58692(registryLookup);
    }

    public class_2338 getEntitySpawnPositionOffset() {
        return this.entitySpawnPositionOffset;
    }

    public boolean setEntitySpawnPositionOffset(class_2338 entitySpawnPositionOffset) {
        this.entitySpawnPositionOffset = entitySpawnPositionOffset;
        return true;
    }

    public double getEntitySpawnOrientationPitch() {
        return this.entitySpawnOrientationPitch;
    }

    public boolean setEntitySpawnPositionPitch(double entitySpawnPositionPitch) {
        this.entitySpawnOrientationPitch = entitySpawnPositionPitch;
        return true;
    }

    public double getEntitySpawnOrientationYaw() {
        return this.entitySpawnOrientationYaw;
    }

    public boolean setEntitySpawnPositionYaw(double entitySpawnPositionYaw) {
        this.entitySpawnOrientationYaw = entitySpawnPositionYaw;
        return true;
    }

    public Multimap<class_6880<class_1320>, class_1322> getEntityAttributeModifiers() {
        return this.entityAttributeModifiers;
    }

    public boolean setEntityAttributeModifiers(Multimap<class_6880<class_1320>, class_1322> entityAttributeModifiers) {
        this.entityAttributeModifiers = entityAttributeModifiers;
        return true;
    }

    public SpawningMode getSpawningMode() {
        return this.spawningMode;
    }

    public boolean setSpawningMode(SpawningMode spawningMode) {
        this.spawningMode = spawningMode;
        return true;
    }

    public String getEntityTypeId() {
        if (this.entityTypeCompound != null && this.entityTypeCompound.method_10545("id")) {
            return this.entityTypeCompound.method_10558("id");
        }
        return "";
    }

    public boolean setEntityType(String entityTypeId) {
        Optional optional = class_1299.method_5898((String)entityTypeId);
        if (optional.isPresent()) {
            class_1299 entityType = (class_1299)optional.get();
            this.entityTypeCompound.method_10582("id", class_7923.field_41177.method_10221((Object)entityType).toString());
            return true;
        }
        return entityTypeId.isEmpty();
    }

    public MutablePair<class_2338, Boolean> getTriggeredBlock() {
        return this.triggeredBlock;
    }

    public void setTriggeredBlock(MutablePair<class_2338, Boolean> triggeredBlock) {
        this.triggeredBlock = triggeredBlock;
    }

    public class_2338 getUseRelayBlockPositionOffset() {
        return this.useRelayBlockPositionOffset;
    }

    public void setUseRelayBlockPositionOffset(class_2338 useRelayedBlockPositionOffset) {
        this.useRelayBlockPositionOffset = useRelayedBlockPositionOffset;
    }

    @Override
    protected void onRotate(class_2680 state) {
        if (state.method_26204() instanceof RotatedBlockWithEntity) {
            if ((Integer)state.method_11654((class_2769)RotatedBlockWithEntity.ROTATED) != this.rotated) {
                class_2470 blockRotation = BlockRotationUtils.calculateRotationFromDifferentRotatedStates((Integer)state.method_11654((class_2769)RotatedBlockWithEntity.ROTATED), this.rotated);
                this.entitySpawnPositionOffset = BlockRotationUtils.rotateOffsetBlockPos(this.entitySpawnPositionOffset, blockRotation);
                this.entitySpawnOrientationYaw = BlockRotationUtils.rotateYaw(this.entitySpawnOrientationYaw, blockRotation);
                this.triggeredBlock.setLeft((Object)BlockRotationUtils.rotateOffsetBlockPos((class_2338)this.triggeredBlock.getLeft(), blockRotation));
                this.useRelayBlockPositionOffset = BlockRotationUtils.rotateOffsetBlockPos(this.useRelayBlockPositionOffset, blockRotation);
                this.rotated = (Integer)state.method_11654((class_2769)RotatedBlockWithEntity.ROTATED);
            }
            if ((Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.X_MIRRORED) != this.x_mirrored) {
                this.entitySpawnPositionOffset = BlockRotationUtils.mirrorOffsetBlockPos(this.entitySpawnPositionOffset, class_2415.field_11301);
                this.entitySpawnOrientationYaw = BlockRotationUtils.mirrorYaw(this.entitySpawnOrientationYaw, class_2415.field_11301);
                this.triggeredBlock.setLeft((Object)BlockRotationUtils.mirrorOffsetBlockPos((class_2338)this.triggeredBlock.getLeft(), class_2415.field_11301));
                this.useRelayBlockPositionOffset = BlockRotationUtils.mirrorOffsetBlockPos(this.useRelayBlockPositionOffset, class_2415.field_11301);
                this.x_mirrored = (Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.X_MIRRORED);
            }
            if ((Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.Z_MIRRORED) != this.z_mirrored) {
                this.entitySpawnPositionOffset = BlockRotationUtils.mirrorOffsetBlockPos(this.entitySpawnPositionOffset, class_2415.field_11300);
                this.entitySpawnOrientationYaw = BlockRotationUtils.mirrorYaw(this.entitySpawnOrientationYaw, class_2415.field_11300);
                this.triggeredBlock.setLeft((Object)BlockRotationUtils.mirrorOffsetBlockPos((class_2338)this.triggeredBlock.getLeft(), class_2415.field_11300));
                this.useRelayBlockPositionOffset = BlockRotationUtils.mirrorOffsetBlockPos(this.useRelayBlockPositionOffset, class_2415.field_11300);
                this.z_mirrored = (Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.Z_MIRRORED);
            }
        }
    }

    @Override
    public void reset() {
        if (this.triggered) {
            this.triggered = false;
        }
        ScriptBlocks.info("TriggeredSpawnerBlock reset");
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            ScriptBlocks.info("world instanceof ServerWorld");
            if (this.boundEntityUuid != null) {
                ScriptBlocks.info("boundEntityUuid != null");
                class_1297 entity = serverWorld.method_14190(this.boundEntityUuid);
                if (entity != null) {
                    ScriptBlocks.info("TriggeredSpawnerBlock discard mobEntity");
                    entity.method_31472();
                }
                this.boundEntityUuid = null;
            } else {
                ScriptBlocks.info("boundEntityUuid == null");
            }
        }
    }

    @Override
    public void trigger() {
        if (((this.spawningMode == SpawningMode.BOUND || this.spawningMode == SpawningMode.ONCE) && !this.triggered || this.spawningMode == SpawningMode.CONTINUOUS || this.spawningMode == SpawningMode.BOUND_RESPAWN && this.boundEntityUuid == null) && this.spawnEntity()) {
            this.triggered = true;
        }
    }

    public void onBoundEntityKilled() {
        if (this.field_11863 != null) {
            this.boundEntityUuid = null;
            class_2586 blockEntity = this.field_11863.method_8321(new class_2338(this.field_11867.method_10263() + ((class_2338)this.triggeredBlock.getLeft()).method_10263(), this.field_11867.method_10264() + ((class_2338)this.triggeredBlock.getLeft()).method_10264(), this.field_11867.method_10260() + ((class_2338)this.triggeredBlock.getLeft()).method_10260()));
            if (blockEntity != this) {
                boolean triggeredBlockResets = (Boolean)this.triggeredBlock.getRight();
                if (triggeredBlockResets && blockEntity instanceof Resetable) {
                    Resetable resetable = (Resetable)blockEntity;
                    resetable.reset();
                } else if (!triggeredBlockResets && blockEntity instanceof Triggerable) {
                    Triggerable triggerable = (Triggerable)blockEntity;
                    triggerable.trigger();
                }
            }
            if (this.spawningMode == SpawningMode.BOUND_RESPAWN) {
                this.trigger();
            }
        }
    }

    protected boolean spawnEntity() {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            Optional optional = class_1299.method_17684((class_2487)this.entityTypeCompound);
            if (optional.isEmpty()) {
                return false;
            }
            double d = (double)this.field_11867.method_10263() + (double)this.entitySpawnPositionOffset.method_10263() + 0.5;
            double e = (double)this.field_11867.method_10264() + (double)this.entitySpawnPositionOffset.method_10264();
            double f = (double)this.field_11867.method_10260() + (double)this.entitySpawnPositionOffset.method_10260() + 0.5;
            if (!serverWorld.method_18026(((class_1299)optional.get()).method_58629(d, e, f))) {
                return false;
            }
            class_2338 blockPos = class_2338.method_49637((double)d, (double)e, (double)f);
            class_1297 entity2 = class_1299.method_17842((class_2487)this.entityTypeCompound, (class_1937)this.field_11863, entity -> {
                entity.method_5808(d, e, f, entity.method_36454(), entity.method_36455());
                return entity;
            });
            if (entity2 == null) {
                return false;
            }
            entity2.method_5636((float)this.entitySpawnOrientationYaw);
            entity2.method_5847((float)this.entitySpawnOrientationYaw);
            entity2.method_5808(entity2.method_23317(), entity2.method_23318(), entity2.method_23321(), (float)this.entitySpawnOrientationYaw, (float)this.entitySpawnOrientationPitch);
            if (entity2 instanceof class_1308 && this.entityTypeCompound.method_10573("id", 8)) {
                ((class_1308)entity2).method_5943((class_5425)serverWorld, serverWorld.method_8404(entity2.method_24515()), class_3730.field_16469, null);
            }
            if (!serverWorld.method_30736(entity2)) {
                return false;
            }
            serverWorld.method_20290(2004, this.field_11867, 0);
            serverWorld.method_33596(entity2, (class_6880)class_5712.field_28738, blockPos);
            if (entity2 instanceof class_1309) {
                this.boundEntityUuid = ((class_1309)entity2).method_5667();
                if (!this.entityAttributeModifiers.isEmpty()) {
                    class_5131 attributeContainer = ((class_1309)entity2).method_6127();
                    this.entityAttributeModifiers.forEach((attribute, attributeModifier) -> {
                        class_1324 entityAttributeInstance = attributeContainer.method_45329(attribute);
                        if (entityAttributeInstance != null) {
                            entityAttributeInstance.method_6202(attributeModifier);
                            entityAttributeInstance.method_26837(attributeModifier);
                        }
                        if (attribute == class_5134.field_23716) {
                            ((class_1309)entity2).method_6033((float)((class_1309)entity2).method_6127().method_26852(class_5134.field_23716));
                        }
                    });
                }
                if (entity2 instanceof class_1308) {
                    class_1308 mobEntity = (class_1308)entity2;
                    ((class_1308)entity2).method_5990();
                    if (this.spawningMode == SpawningMode.BOUND || this.spawningMode == SpawningMode.BOUND_RESPAWN) {
                        mobEntity.method_5971();
                        ((DuckMobEntityMixin)mobEntity).scriptblocks$setControllerBlockPos(this.field_11867);
                    }
                    if (!this.useRelayBlockPositionOffset.equals((Object)POSITION_OFFSET_DEFAULT)) {
                        ((DuckMobEntityMixin)mobEntity).scriptblocks$setUseRelayBlockPos(this.field_11867.method_10081((class_2382)this.useRelayBlockPositionOffset));
                    }
                }
            }
            return true;
        }
        return false;
    }

    public static enum SpawningMode implements class_3542
    {
        BOUND("bound"),
        BOUND_RESPAWN("bound_respawn"),
        CONTINUOUS("continuous"),
        ONCE("once");

        private final String name;

        private SpawningMode(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        public static Optional<SpawningMode> byName(String name) {
            return Arrays.stream(SpawningMode.values()).filter(spawningMode -> spawningMode.method_15434().equals(name)).findFirst();
        }

        public class_2561 asText() {
            return class_2561.method_43471((String)("gui.triggered_spawner_block.spawning_mode." + this.name));
        }
    }
}

