/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.scriptblocks.block.lootable_vault;

import com.github.theredbrain.scriptblocks.block.lootable_vault.LootableVaultServerData;
import com.github.theredbrain.scriptblocks.data.LootableVaultConfig;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_4844;
import net.minecraft.class_8962;

public class LootableVaultSharedData {
    static final String SHARED_DATA_KEY = "shared_data";
    public static Codec<LootableVaultSharedData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1799.method_56702((String)"display_item").forGetter(data -> data.displayItem), (App)class_4844.field_48974.lenientOptionalFieldOf("connected_players", Set.of()).forGetter(data -> data.connectedPlayers), (App)Codec.DOUBLE.lenientOptionalFieldOf("connected_particles_range", (Object)LootableVaultConfig.DEFAULT.deactivationRange()).forGetter(data -> data.connectedParticlesRange)).apply((Applicative)instance, LootableVaultSharedData::new));
    private class_1799 displayItem = class_1799.field_8037;
    private Set<UUID> connectedPlayers = new ObjectLinkedOpenHashSet();
    private double connectedParticlesRange = LootableVaultConfig.DEFAULT.deactivationRange();
    boolean dirty;

    LootableVaultSharedData(class_1799 displayItem, Set<UUID> connectedPlayers, double connectedParticlesRange) {
        this.displayItem = displayItem;
        this.connectedPlayers.addAll(connectedPlayers);
        this.connectedParticlesRange = connectedParticlesRange;
    }

    public LootableVaultSharedData() {
    }

    public class_1799 getDisplayItem() {
        return this.displayItem;
    }

    public boolean hasDisplayItem() {
        return !this.displayItem.method_7960();
    }

    public void setDisplayItem(class_1799 stack) {
        if (!class_1799.method_7973((class_1799)this.displayItem, (class_1799)stack)) {
            this.displayItem = stack.method_7972();
            this.markDirty();
        }
    }

    boolean hasConnectedPlayers() {
        return !this.connectedPlayers.isEmpty();
    }

    public Set<UUID> getConnectedPlayers() {
        return this.connectedPlayers;
    }

    public double getConnectedParticlesRange() {
        return this.connectedParticlesRange;
    }

    public void updateConnectedPlayers(class_3218 world, class_2338 pos, LootableVaultServerData serverData, LootableVaultConfig config, double radius) {
        Set set = class_8962.field_48861.detect(world, class_8962.class_9198.field_48862, pos, radius, false).stream().filter(uuid -> !serverData.getRewardedPlayers().contains(uuid)).collect(Collectors.toSet());
        if (!this.connectedPlayers.equals(set)) {
            this.connectedPlayers = set;
            this.markDirty();
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void markDirty() {
        this.dirty = true;
    }

    public void markClean() {
        this.dirty = false;
    }

    public void copyFrom(LootableVaultSharedData data) {
        this.displayItem = data.displayItem;
        this.connectedPlayers = data.connectedPlayers;
        this.connectedParticlesRange = data.connectedParticlesRange;
    }
}

