/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.scriptblocks.block.lootable_vault;

import com.github.theredbrain.scriptblocks.block.entity.LootableVaultBlockEntity;
import com.github.theredbrain.scriptblocks.block.lootable_vault.LootableVaultServerData;
import com.github.theredbrain.scriptblocks.block.lootable_vault.LootableVaultSharedData;
import com.github.theredbrain.scriptblocks.data.LootableVaultConfig;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3542;

public enum LootableVaultState implements class_3542
{
    INACTIVE("inactive", Light.HALF_LIT){

        @Override
        protected void onChangedTo(class_3218 world, class_2338 pos, LootableVaultConfig config, LootableVaultSharedData sharedData, boolean ominous) {
            sharedData.setDisplayItem(class_1799.field_8037);
            world.method_20290(3016, pos, ominous ? 1 : 0);
        }
    }
    ,
    ACTIVE("active", Light.LIT){

        @Override
        protected void onChangedTo(class_3218 world, class_2338 pos, LootableVaultConfig config, LootableVaultSharedData sharedData, boolean ominous) {
            if (!sharedData.hasDisplayItem()) {
                LootableVaultBlockEntity.Server.updateDisplayItem(world, this, config, sharedData, pos);
            }
            world.method_20290(3015, pos, ominous ? 1 : 0);
        }
    }
    ,
    UNLOCKING("unlocking", Light.LIT){

        @Override
        protected void onChangedTo(class_3218 world, class_2338 pos, LootableVaultConfig config, LootableVaultSharedData sharedData, boolean ominous) {
            world.method_45447(null, pos, class_3417.field_48791, class_3419.field_15245);
        }
    }
    ,
    EJECTING("ejecting", Light.LIT){

        @Override
        protected void onChangedTo(class_3218 world, class_2338 pos, LootableVaultConfig config, LootableVaultSharedData sharedData, boolean ominous) {
            world.method_45447(null, pos, class_3417.field_48793, class_3419.field_15245);
        }

        @Override
        protected void onChangedFrom(class_3218 world, class_2338 pos, LootableVaultConfig config, LootableVaultSharedData sharedData) {
            world.method_45447(null, pos, class_3417.field_48799, class_3419.field_15245);
        }
    };

    private static final int field_48903 = 20;
    private static final int field_48904 = 20;
    private static final int field_48905 = 20;
    private static final int field_48906 = 20;
    private final String id;
    private final Light light;

    private LootableVaultState(String id, Light light) {
        this.id = id;
        this.light = light;
    }

    public String method_15434() {
        return this.id;
    }

    public int getLuminance() {
        return this.light.luminance;
    }

    public LootableVaultState update(class_3218 world, class_2338 pos, LootableVaultConfig config, LootableVaultServerData serverData, LootableVaultSharedData sharedData) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> LootableVaultState.updateActiveState(world, pos, config, serverData, sharedData, config.activationRange());
            case 1 -> LootableVaultState.updateActiveState(world, pos, config, serverData, sharedData, config.deactivationRange());
            case 2 -> {
                serverData.setStateUpdatingResumeTime(world.method_8510() + 20L);
                yield EJECTING;
            }
            case 3 -> {
                this.ejectReward(world, pos);
                serverData.setStateUpdatingResumeTime(world.method_8510() + 20L);
                yield LootableVaultState.updateActiveState(world, pos, config, serverData, sharedData, config.deactivationRange());
            }
        };
    }

    private static LootableVaultState updateActiveState(class_3218 world, class_2338 pos, LootableVaultConfig config, LootableVaultServerData serverData, LootableVaultSharedData sharedData, double radius) {
        sharedData.updateConnectedPlayers(world, pos, serverData, config, radius);
        serverData.setStateUpdatingResumeTime(world.method_8510() + 20L);
        return sharedData.hasConnectedPlayers() ? ACTIVE : INACTIVE;
    }

    public void onStateChange(class_3218 world, class_2338 pos, LootableVaultState newState, LootableVaultConfig config, LootableVaultSharedData sharedData, boolean ominous) {
        this.onChangedFrom(world, pos, config, sharedData);
        newState.onChangedTo(world, pos, config, sharedData, ominous);
    }

    protected void onChangedTo(class_3218 world, class_2338 pos, LootableVaultConfig config, LootableVaultSharedData sharedData, boolean ominous) {
    }

    protected void onChangedFrom(class_3218 world, class_2338 pos, LootableVaultConfig config, LootableVaultSharedData sharedData) {
    }

    private void ejectReward(class_3218 world, class_2338 pos) {
        world.method_20290(3017, pos, 0);
        world.method_8396(null, pos, class_3417.field_48801, class_3419.field_15245, 1.0f, 1.2f);
    }

    static enum Light {
        HALF_LIT(6),
        LIT(12);

        final int luminance;

        private Light(int luminance) {
            this.luminance = luminance;
        }
    }
}

