/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.scriptblocks.gui.screen.ingame;

import com.github.theredbrain.scriptblocks.ScriptBlocks;
import com.github.theredbrain.scriptblocks.block.entity.DialogueBlockEntity;
import com.github.theredbrain.scriptblocks.data.Dialogue;
import com.github.theredbrain.scriptblocks.network.packet.UpdateDialogueBlockPacket;
import com.github.theredbrain.scriptblocks.registry.CustomDynamicRegistries;
import com.github.theredbrain.scriptblocks.util.ItemUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_333;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5676;
import net.minecraft.class_6880;
import net.minecraft.class_8710;
import org.apache.commons.lang3.tuple.MutablePair;

@Environment(value=EnvType.CLIENT)
public class DialogueBlockScreen
extends class_437 {
    private static final class_2561 ADD_ENTRY_BUTTON_LABEL_TEXT = class_2561.method_43471((String)"gui.list_entry.add");
    private static final class_2561 REMOVE_ENTRY_BUTTON_LABEL_TEXT = class_2561.method_43471((String)"gui.list_entry.remove");
    private static final class_2561 ENTRY_ALREADY_IN_LIST_TEXT = class_2561.method_43471((String)"gui.dialogue_block.entry_already_in_list");
    public static final class_2960 BACKGROUND_218_197_TEXTURE = ScriptBlocks.identifier("textures/gui/container/generic_218_197_background.png");
    private static final class_2960 SCROLL_BAR_BACKGROUND_8_35_TEXTURE = ScriptBlocks.identifier("scroll_bar/scroll_bar_background_8_35");
    private static final class_2960 SCROLL_BAR_BACKGROUND_8_87_TEXTURE = ScriptBlocks.identifier("scroll_bar/scroll_bar_background_8_87");
    private static final class_2960 SCROLL_BAR_BACKGROUND_8_92_TEXTURE = ScriptBlocks.identifier("scroll_bar/scroll_bar_background_8_92");
    private static final class_2960 SCROLL_BAR_BACKGROUND_8_96_TEXTURE = ScriptBlocks.identifier("scroll_bar/scroll_bar_background_8_96");
    private static final class_2960 SCROLLER_VERTICAL_6_7_TEXTURE = ScriptBlocks.identifier("scroll_bar/scroller_vertical_6_7");
    private DialogueBlockEntity dialogueBlockEntity;
    private class_5676<CreativeScreenPage> creativeScreenPageButton;
    private class_4185 removeDialogueUsedBlockEntryButton0;
    private class_4185 removeDialogueUsedBlockEntryButton1;
    private class_4185 removeDialogueUsedBlockEntryButton2;
    private class_4185 removeDialogueUsedBlockEntryButton3;
    private class_342 newDialogueUsedBlockIdentifierField;
    private class_342 newDialogueUsedBlockPositionOffsetXField;
    private class_342 newDialogueUsedBlockPositionOffsetYField;
    private class_342 newDialogueUsedBlockPositionOffsetZField;
    private class_4185 addDialogueUsedBlockButton;
    private class_4185 removeDialogueTriggeredBlockEntryButton0;
    private class_4185 removeDialogueTriggeredBlockEntryButton1;
    private class_4185 removeDialogueTriggeredBlockEntryButton2;
    private class_4185 removeDialogueTriggeredBlockEntryButton3;
    private class_342 newDialogueTriggeredBlockIdentifierField;
    private class_342 newDialogueTriggeredBlockPositionOffsetXField;
    private class_342 newDialogueTriggeredBlockPositionOffsetYField;
    private class_342 newDialogueTriggeredBlockPositionOffsetZField;
    private class_5676<Boolean> toggleNewDialogueTriggeredBlockResetsButton;
    private boolean newDialogueTriggeredBlockResets;
    private class_4185 addDialogueTriggeredBlockButton;
    private class_4185 removeStartingDialogueEntryButton;
    private class_342 newStartingDialogueIdentifierField;
    private class_4185 addStartingDialogueButton;
    private class_342 dataBlockOffsetXField;
    private class_342 dataBlockOffsetYField;
    private class_342 dataBlockOffsetZField;
    private class_4185 saveCreativeButton;
    private class_4185 cancelCreativeButton;
    private CreativeScreenPage creativeScreenPage;
    private List<MutablePair<String, class_2338>> dialogueUsedBlocksList = new ArrayList<MutablePair<String, class_2338>>(List.of());
    private List<MutablePair<String, MutablePair<class_2338, Boolean>>> dialogueTriggeredBlocksList = new ArrayList<MutablePair<String, MutablePair<class_2338, Boolean>>>(List.of());
    private List<String> startingDialogueList = new ArrayList<String>(List.of());
    private int scrollPosition = 0;
    private float scrollAmount = 0.0f;
    private boolean mouseClicked = false;

    public DialogueBlockScreen(DialogueBlockEntity dialogueBlockEntity) {
        super(class_333.field_18967);
        this.dialogueBlockEntity = dialogueBlockEntity;
        this.creativeScreenPage = CreativeScreenPage.STARTING_DIALOGUES;
    }

    private void removeDialogueUsedBlockEntry(int index) {
        if (index + this.scrollPosition < this.dialogueUsedBlocksList.size()) {
            this.dialogueUsedBlocksList.remove(index + this.scrollPosition);
        }
        this.scrollPosition = 0;
        this.scrollAmount = 0.0f;
        this.updateWidgets();
    }

    private void addDialogueUsedBlockEntry() {
        String newDialogueUsedBlockIdentifier = this.newDialogueUsedBlockIdentifierField.method_1882();
        for (MutablePair<String, class_2338> entry : this.dialogueUsedBlocksList) {
            if (!((String)entry.getLeft()).equals(newDialogueUsedBlockIdentifier)) continue;
            if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                this.field_22787.field_1724.method_43496(ENTRY_ALREADY_IN_LIST_TEXT);
            }
            return;
        }
        this.dialogueUsedBlocksList.add((MutablePair<String, class_2338>)new MutablePair((Object)newDialogueUsedBlockIdentifier, (Object)new class_2338(ItemUtils.parseInt(this.newDialogueUsedBlockPositionOffsetXField.method_1882()), ItemUtils.parseInt(this.newDialogueUsedBlockPositionOffsetYField.method_1882()), ItemUtils.parseInt(this.newDialogueUsedBlockPositionOffsetZField.method_1882()))));
        this.scrollPosition = 0;
        this.scrollAmount = 0.0f;
        this.updateWidgets();
    }

    private void removeDialogueTriggeredBlockEntry(int index) {
        if (index + this.scrollPosition < this.dialogueTriggeredBlocksList.size()) {
            this.dialogueTriggeredBlocksList.remove(index + this.scrollPosition);
        }
        this.scrollPosition = 0;
        this.scrollAmount = 0.0f;
        this.updateWidgets();
    }

    private void addDialogueTriggeredBlockEntry() {
        String newDialogueTriggeredBlockIdentifier = this.newDialogueTriggeredBlockIdentifierField.method_1882();
        for (MutablePair<String, MutablePair<class_2338, Boolean>> entry : this.dialogueTriggeredBlocksList) {
            if (!((String)entry.getLeft()).equals(newDialogueTriggeredBlockIdentifier)) continue;
            if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                this.field_22787.field_1724.method_43496(ENTRY_ALREADY_IN_LIST_TEXT);
            }
            return;
        }
        this.dialogueTriggeredBlocksList.add((MutablePair<String, MutablePair<class_2338, Boolean>>)new MutablePair((Object)newDialogueTriggeredBlockIdentifier, (Object)new MutablePair((Object)new class_2338(ItemUtils.parseInt(this.newDialogueTriggeredBlockPositionOffsetXField.method_1882()), ItemUtils.parseInt(this.newDialogueTriggeredBlockPositionOffsetYField.method_1882()), ItemUtils.parseInt(this.newDialogueTriggeredBlockPositionOffsetZField.method_1882())), (Object)this.newDialogueTriggeredBlockResets)));
        this.scrollPosition = 0;
        this.scrollAmount = 0.0f;
        this.updateWidgets();
    }

    private void removeStartingDialogueEntry() {
        if (this.scrollPosition < this.startingDialogueList.size()) {
            this.startingDialogueList.remove(this.scrollPosition);
        }
        this.scrollPosition = 0;
        this.scrollAmount = 0.0f;
        this.updateWidgets();
    }

    private void addStartingDialogueEntry() {
        Optional optionalDialogueReference;
        String message = "";
        String newStartingDialogueIdentifier = this.newStartingDialogueIdentifierField.method_1882();
        Dialogue newStartingDialogue = null;
        class_1937 world = this.dialogueBlockEntity.method_10997();
        if (world != null && (optionalDialogueReference = world.method_30349().method_30530(CustomDynamicRegistries.DIALOGUE_REGISTRY_KEY).method_55841(class_2960.method_12829((String)newStartingDialogueIdentifier))).isPresent()) {
            newStartingDialogue = (Dialogue)((class_6880.class_6883)optionalDialogueReference.get()).comp_349();
        }
        if (newStartingDialogue == null) {
            message = "gui.dialogue_block.invalid_dialogue_identifier";
        }
        if (message.isEmpty()) {
            for (String entry : this.startingDialogueList) {
                if (!entry.equals(newStartingDialogueIdentifier)) continue;
                message = "gui.dialogue_block.entry_already_in_list";
                break;
            }
        }
        if (this.field_22787 != null && this.field_22787.field_1724 != null && !message.isEmpty()) {
            this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43471((String)message));
            return;
        }
        this.startingDialogueList.add(newStartingDialogueIdentifier);
        this.scrollPosition = 0;
        this.scrollAmount = 0.0f;
        this.updateWidgets();
    }

    private void saveCreative() {
        if (this.updateDialogueBlockCreative()) {
            this.method_25419();
        }
    }

    private void cancel() {
        this.method_25419();
    }

    protected void method_25426() {
        this.dialogueUsedBlocksList.clear();
        this.dialogueTriggeredBlocksList.clear();
        this.startingDialogueList.clear();
        ArrayList<String> keyList = new ArrayList<String>(this.dialogueBlockEntity.getDialogueUsedBlocksMap().keySet());
        for (String key : keyList) {
            this.dialogueUsedBlocksList.add((MutablePair<String, class_2338>)new MutablePair((Object)key, (Object)this.dialogueBlockEntity.getDialogueUsedBlocksMap().get(key)));
        }
        keyList = new ArrayList<String>(this.dialogueBlockEntity.getDialogueTriggeredBlocksMap().keySet());
        for (String key : keyList) {
            this.dialogueTriggeredBlocksList.add((MutablePair<String, MutablePair<class_2338, Boolean>>)new MutablePair((Object)key, this.dialogueBlockEntity.getDialogueTriggeredBlocksMap().get(key)));
        }
        this.startingDialogueList.addAll(this.dialogueBlockEntity.getStartingDialogueList());
        super.method_25426();
        this.creativeScreenPageButton = (class_5676)this.method_37063((class_364)class_5676.method_32606(CreativeScreenPage::asText).method_32624((Object[])CreativeScreenPage.values()).method_32619((Object)this.creativeScreenPage).method_32616().method_32617(this.field_22789 / 2 - 154, 20, 300, 20, (class_2561)class_2561.method_43473(), (button, creativeScreenPage) -> {
            this.creativeScreenPage = creativeScreenPage;
            this.updateWidgets();
        }));
        this.removeDialogueUsedBlockEntryButton0 = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)REMOVE_ENTRY_BUTTON_LABEL_TEXT, button -> this.removeDialogueUsedBlockEntry(0)).method_46434(this.field_22789 / 2 + 54, 42, 100, 20).method_46431());
        this.removeDialogueUsedBlockEntryButton1 = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)REMOVE_ENTRY_BUTTON_LABEL_TEXT, button -> this.removeDialogueUsedBlockEntry(1)).method_46434(this.field_22789 / 2 + 54, 66, 100, 20).method_46431());
        this.removeDialogueUsedBlockEntryButton2 = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)REMOVE_ENTRY_BUTTON_LABEL_TEXT, button -> this.removeDialogueUsedBlockEntry(2)).method_46434(this.field_22789 / 2 + 54, 90, 100, 20).method_46431());
        this.removeDialogueUsedBlockEntryButton3 = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)REMOVE_ENTRY_BUTTON_LABEL_TEXT, button -> this.removeDialogueUsedBlockEntry(3)).method_46434(this.field_22789 / 2 + 54, 114, 100, 20).method_46431());
        this.newDialogueUsedBlockIdentifierField = new class_342(this.field_22793, this.field_22789 / 2 - 154, 138, 300, 20, (class_2561)class_2561.method_43473());
        this.newDialogueUsedBlockIdentifierField.method_1880(128);
        this.method_25429((class_364)this.newDialogueUsedBlockIdentifierField);
        this.newDialogueUsedBlockPositionOffsetXField = new class_342(this.field_22793, this.field_22789 / 2 - 154, 162, 100, 20, (class_2561)class_2561.method_43473());
        this.newDialogueUsedBlockPositionOffsetXField.method_1880(128);
        this.method_25429((class_364)this.newDialogueUsedBlockPositionOffsetXField);
        this.newDialogueUsedBlockPositionOffsetYField = new class_342(this.field_22793, this.field_22789 / 2 - 50, 162, 100, 20, (class_2561)class_2561.method_43473());
        this.newDialogueUsedBlockPositionOffsetYField.method_1880(128);
        this.method_25429((class_364)this.newDialogueUsedBlockPositionOffsetYField);
        this.newDialogueUsedBlockPositionOffsetZField = new class_342(this.field_22793, this.field_22789 / 2 + 54, 162, 100, 20, (class_2561)class_2561.method_43473());
        this.newDialogueUsedBlockPositionOffsetZField.method_1880(128);
        this.method_25429((class_364)this.newDialogueUsedBlockPositionOffsetZField);
        this.addDialogueUsedBlockButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)ADD_ENTRY_BUTTON_LABEL_TEXT, button -> this.addDialogueUsedBlockEntry()).method_46434(this.field_22789 / 2 - 4 - 150, 186, 300, 20).method_46431());
        this.removeDialogueTriggeredBlockEntryButton0 = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)REMOVE_ENTRY_BUTTON_LABEL_TEXT, button -> this.removeDialogueTriggeredBlockEntry(0)).method_46434(this.field_22789 / 2 + 54, 42, 100, 20).method_46431());
        this.removeDialogueTriggeredBlockEntryButton1 = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)REMOVE_ENTRY_BUTTON_LABEL_TEXT, button -> this.removeDialogueTriggeredBlockEntry(1)).method_46434(this.field_22789 / 2 + 54, 66, 100, 20).method_46431());
        this.removeDialogueTriggeredBlockEntryButton2 = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)REMOVE_ENTRY_BUTTON_LABEL_TEXT, button -> this.removeDialogueTriggeredBlockEntry(2)).method_46434(this.field_22789 / 2 + 54, 90, 100, 20).method_46431());
        this.removeDialogueTriggeredBlockEntryButton3 = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)REMOVE_ENTRY_BUTTON_LABEL_TEXT, button -> this.removeDialogueTriggeredBlockEntry(3)).method_46434(this.field_22789 / 2 + 54, 114, 100, 20).method_46431());
        this.newDialogueTriggeredBlockIdentifierField = new class_342(this.field_22793, this.field_22789 / 2 - 154, 138, 300, 20, (class_2561)class_2561.method_43473());
        this.newDialogueTriggeredBlockIdentifierField.method_1880(128);
        this.method_25429((class_364)this.newDialogueTriggeredBlockIdentifierField);
        this.newDialogueTriggeredBlockPositionOffsetXField = new class_342(this.field_22793, this.field_22789 / 2 - 154, 162, 50, 20, (class_2561)class_2561.method_43473());
        this.newDialogueTriggeredBlockPositionOffsetXField.method_1880(128);
        this.method_25429((class_364)this.newDialogueTriggeredBlockPositionOffsetXField);
        this.newDialogueTriggeredBlockPositionOffsetYField = new class_342(this.field_22793, this.field_22789 / 2 - 100, 162, 50, 20, (class_2561)class_2561.method_43473());
        this.newDialogueTriggeredBlockPositionOffsetYField.method_1880(128);
        this.method_25429((class_364)this.newDialogueTriggeredBlockPositionOffsetYField);
        this.newDialogueTriggeredBlockPositionOffsetZField = new class_342(this.field_22793, this.field_22789 / 2 - 46, 162, 50, 20, (class_2561)class_2561.method_43473());
        this.newDialogueTriggeredBlockPositionOffsetZField.method_1880(128);
        this.method_25429((class_364)this.newDialogueTriggeredBlockPositionOffsetZField);
        this.newDialogueTriggeredBlockResets = false;
        this.toggleNewDialogueTriggeredBlockResetsButton = (class_5676)this.method_37063((class_364)class_5676.method_32607((class_2561)class_2561.method_43471((String)"gui.triggered_block.toggle_triggered_block_resets_button_label.on"), (class_2561)class_2561.method_43471((String)"gui.triggered_block.toggle_triggered_block_resets_button_label.off")).method_32619((Object)this.newDialogueTriggeredBlockResets).method_32616().method_32617(this.field_22789 / 2 + 8, 162, 150, 20, (class_2561)class_2561.method_43473(), (button, triggeredBlockResets) -> {
            this.newDialogueTriggeredBlockResets = triggeredBlockResets;
        }));
        this.addDialogueTriggeredBlockButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)ADD_ENTRY_BUTTON_LABEL_TEXT, button -> this.addDialogueTriggeredBlockEntry()).method_46434(this.field_22789 / 2 - 4 - 150, 186, 300, 20).method_46431());
        this.removeStartingDialogueEntryButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)REMOVE_ENTRY_BUTTON_LABEL_TEXT, button -> this.removeStartingDialogueEntry()).method_46434(this.field_22789 / 2 + 54, 78, 100, 20).method_46431());
        this.newStartingDialogueIdentifierField = new class_342(this.field_22793, this.field_22789 / 2 - 154, 162, 300, 20, (class_2561)class_2561.method_43473());
        this.newStartingDialogueIdentifierField.method_1880(128);
        this.method_25429((class_364)this.newStartingDialogueIdentifierField);
        this.addStartingDialogueButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)ADD_ENTRY_BUTTON_LABEL_TEXT, button -> this.addStartingDialogueEntry()).method_46434(this.field_22789 / 2 - 4 - 150, 186, 300, 20).method_46431());
        this.dataBlockOffsetXField = new class_342(this.field_22793, this.field_22789 / 2 - 154, 162, 100, 20, (class_2561)class_2561.method_43473());
        this.dataBlockOffsetXField.method_1880(128);
        this.dataBlockOffsetXField.method_1852(Integer.toString(this.dialogueBlockEntity.getDataBlockOffset().method_10263()));
        this.method_25429((class_364)this.dataBlockOffsetXField);
        this.dataBlockOffsetYField = new class_342(this.field_22793, this.field_22789 / 2 - 50, 162, 100, 20, (class_2561)class_2561.method_43473());
        this.dataBlockOffsetYField.method_1880(128);
        this.dataBlockOffsetYField.method_1852(Integer.toString(this.dialogueBlockEntity.getDataBlockOffset().method_10264()));
        this.method_25429((class_364)this.dataBlockOffsetYField);
        this.dataBlockOffsetZField = new class_342(this.field_22793, this.field_22789 / 2 + 54, 162, 100, 20, (class_2561)class_2561.method_43473());
        this.dataBlockOffsetZField.method_1880(128);
        this.dataBlockOffsetZField.method_1852(Integer.toString(this.dialogueBlockEntity.getDataBlockOffset().method_10260()));
        this.method_25429((class_364)this.dataBlockOffsetZField);
        this.saveCreativeButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.saveCreative()).method_46434(this.field_22789 / 2 - 4 - 150, 210, 150, 20).method_46431());
        this.cancelCreativeButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24335, button -> this.cancel()).method_46434(this.field_22789 / 2 + 4, 210, 150, 20).method_46431());
        this.updateWidgets();
    }

    private void updateWidgets() {
        this.creativeScreenPageButton.field_22764 = false;
        this.removeDialogueUsedBlockEntryButton0.field_22764 = false;
        this.removeDialogueUsedBlockEntryButton1.field_22764 = false;
        this.removeDialogueUsedBlockEntryButton2.field_22764 = false;
        this.removeDialogueUsedBlockEntryButton3.field_22764 = false;
        this.newDialogueUsedBlockIdentifierField.method_1862(false);
        this.newDialogueUsedBlockPositionOffsetXField.method_1862(false);
        this.newDialogueUsedBlockPositionOffsetYField.method_1862(false);
        this.newDialogueUsedBlockPositionOffsetZField.method_1862(false);
        this.addDialogueUsedBlockButton.field_22764 = false;
        this.removeDialogueTriggeredBlockEntryButton0.field_22764 = false;
        this.removeDialogueTriggeredBlockEntryButton1.field_22764 = false;
        this.removeDialogueTriggeredBlockEntryButton2.field_22764 = false;
        this.removeDialogueTriggeredBlockEntryButton3.field_22764 = false;
        this.newDialogueTriggeredBlockIdentifierField.method_1862(false);
        this.newDialogueTriggeredBlockPositionOffsetXField.method_1862(false);
        this.newDialogueTriggeredBlockPositionOffsetYField.method_1862(false);
        this.newDialogueTriggeredBlockPositionOffsetZField.method_1862(false);
        this.toggleNewDialogueTriggeredBlockResetsButton.field_22764 = false;
        this.addDialogueTriggeredBlockButton.field_22764 = false;
        this.removeStartingDialogueEntryButton.field_22764 = false;
        this.newStartingDialogueIdentifierField.method_1862(false);
        this.addStartingDialogueButton.field_22764 = false;
        this.dataBlockOffsetXField.method_1862(false);
        this.dataBlockOffsetYField.method_1862(false);
        this.dataBlockOffsetZField.method_1862(false);
        this.saveCreativeButton.field_22764 = false;
        this.cancelCreativeButton.field_22764 = false;
        this.creativeScreenPageButton.field_22764 = true;
        if (this.creativeScreenPage == CreativeScreenPage.DIALOGUE_USED_BLOCKS) {
            int index = 0;
            for (int i = 0; i < Math.min(4, this.dialogueUsedBlocksList.size()); ++i) {
                if (index == 0) {
                    this.removeDialogueUsedBlockEntryButton0.field_22764 = true;
                } else if (index == 1) {
                    this.removeDialogueUsedBlockEntryButton1.field_22764 = true;
                } else if (index == 2) {
                    this.removeDialogueUsedBlockEntryButton2.field_22764 = true;
                } else if (index == 3) {
                    this.removeDialogueUsedBlockEntryButton3.field_22764 = true;
                }
                ++index;
            }
            this.newDialogueUsedBlockIdentifierField.method_1862(true);
            this.newDialogueUsedBlockPositionOffsetXField.method_1862(true);
            this.newDialogueUsedBlockPositionOffsetYField.method_1862(true);
            this.newDialogueUsedBlockPositionOffsetZField.method_1862(true);
            this.addDialogueUsedBlockButton.field_22764 = true;
        } else if (this.creativeScreenPage == CreativeScreenPage.DIALOGUE_TRIGGERED_BLOCKS) {
            int index = 0;
            for (int i = 0; i < Math.min(4, this.dialogueTriggeredBlocksList.size()); ++i) {
                if (index == 0) {
                    this.removeDialogueTriggeredBlockEntryButton0.field_22764 = true;
                } else if (index == 1) {
                    this.removeDialogueTriggeredBlockEntryButton1.field_22764 = true;
                } else if (index == 2) {
                    this.removeDialogueTriggeredBlockEntryButton2.field_22764 = true;
                } else if (index == 3) {
                    this.removeDialogueTriggeredBlockEntryButton3.field_22764 = true;
                }
                ++index;
            }
            this.newDialogueTriggeredBlockIdentifierField.method_1862(true);
            this.newDialogueTriggeredBlockPositionOffsetXField.method_1862(true);
            this.newDialogueTriggeredBlockPositionOffsetYField.method_1862(true);
            this.newDialogueTriggeredBlockPositionOffsetZField.method_1862(true);
            this.toggleNewDialogueTriggeredBlockResetsButton.field_22764 = true;
            this.addDialogueTriggeredBlockButton.field_22764 = true;
        } else if (this.creativeScreenPage == CreativeScreenPage.STARTING_DIALOGUES) {
            if (!this.startingDialogueList.isEmpty()) {
                this.removeStartingDialogueEntryButton.field_22764 = true;
            }
            this.newStartingDialogueIdentifierField.method_1862(true);
            this.addStartingDialogueButton.field_22764 = true;
        } else if (this.creativeScreenPage == CreativeScreenPage.DATA_BLOCK_OFFSET) {
            this.dataBlockOffsetXField.method_1862(true);
            this.dataBlockOffsetYField.method_1862(true);
            this.dataBlockOffsetZField.method_1862(true);
        }
        this.saveCreativeButton.field_22764 = true;
        this.cancelCreativeButton.field_22764 = true;
        this.scrollPosition = 0;
        this.scrollAmount = 0.0f;
    }

    public void method_25410(class_310 client, int width, int height) {
        ArrayList<MutablePair<String, class_2338>> list = new ArrayList<MutablePair<String, class_2338>>(this.dialogueUsedBlocksList);
        ArrayList<MutablePair<String, MutablePair<class_2338, Boolean>>> list1 = new ArrayList<MutablePair<String, MutablePair<class_2338, Boolean>>>(this.dialogueTriggeredBlocksList);
        ArrayList<String> list2 = new ArrayList<String>(this.startingDialogueList);
        int number4 = this.scrollPosition;
        float number5 = this.scrollAmount;
        CreativeScreenPage var = this.creativeScreenPage;
        String string = this.newDialogueUsedBlockIdentifierField.method_1882();
        String string1 = this.newDialogueUsedBlockPositionOffsetXField.method_1882();
        String string2 = this.newDialogueUsedBlockPositionOffsetYField.method_1882();
        String string3 = this.newDialogueUsedBlockPositionOffsetZField.method_1882();
        String string4 = this.newDialogueTriggeredBlockIdentifierField.method_1882();
        String string5 = this.newDialogueTriggeredBlockPositionOffsetXField.method_1882();
        String string6 = this.newDialogueTriggeredBlockPositionOffsetYField.method_1882();
        String string7 = this.newDialogueTriggeredBlockPositionOffsetZField.method_1882();
        String string8 = this.newStartingDialogueIdentifierField.method_1882();
        String string9 = this.dataBlockOffsetXField.method_1882();
        String string10 = this.dataBlockOffsetYField.method_1882();
        String string11 = this.dataBlockOffsetZField.method_1882();
        this.method_25423(client, width, height);
        this.dialogueUsedBlocksList.clear();
        this.dialogueTriggeredBlocksList.clear();
        this.startingDialogueList.clear();
        this.dialogueUsedBlocksList.addAll(list);
        this.dialogueTriggeredBlocksList.addAll(list1);
        this.startingDialogueList.addAll(list2);
        this.scrollPosition = number4;
        this.scrollAmount = number5;
        this.creativeScreenPage = var;
        this.newDialogueUsedBlockIdentifierField.method_1852(string);
        this.newDialogueUsedBlockPositionOffsetXField.method_1852(string1);
        this.newDialogueUsedBlockPositionOffsetYField.method_1852(string2);
        this.newDialogueUsedBlockPositionOffsetZField.method_1852(string3);
        this.newDialogueTriggeredBlockIdentifierField.method_1852(string4);
        this.newDialogueTriggeredBlockPositionOffsetXField.method_1852(string5);
        this.newDialogueTriggeredBlockPositionOffsetYField.method_1852(string6);
        this.newDialogueTriggeredBlockPositionOffsetZField.method_1852(string7);
        this.newStartingDialogueIdentifierField.method_1852(string8);
        this.dataBlockOffsetXField.method_1852(string9);
        this.dataBlockOffsetYField.method_1852(string10);
        this.dataBlockOffsetZField.method_1852(string11);
        this.updateWidgets();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int j;
        int i;
        this.mouseClicked = false;
        if (this.creativeScreenPage == CreativeScreenPage.DIALOGUE_USED_BLOCKS && this.dialogueUsedBlocksList.size() > 4) {
            i = this.field_22789 / 2 - 153;
            j = 43;
            if (mouseX >= (double)i && mouseX < (double)(i + 6) && mouseY >= (double)j && mouseY < (double)(j + 94)) {
                this.mouseClicked = true;
            }
        }
        if (this.creativeScreenPage == CreativeScreenPage.DIALOGUE_TRIGGERED_BLOCKS && this.dialogueTriggeredBlocksList.size() > 4) {
            i = this.field_22789 / 2 - 153;
            j = 43;
            if (mouseX >= (double)i && mouseX < (double)(i + 6) && mouseY >= (double)j && mouseY < (double)(j + 94)) {
                this.mouseClicked = true;
            }
        }
        if (this.creativeScreenPage == CreativeScreenPage.STARTING_DIALOGUES && this.startingDialogueList.size() > 1) {
            i = this.field_22789 / 2 - 153;
            j = 72;
            if (mouseX >= (double)i && mouseX < (double)(i + 6) && mouseY >= (double)j && mouseY < (double)(j + 33)) {
                this.mouseClicked = true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        float f;
        int i;
        if (this.creativeScreenPage == CreativeScreenPage.DIALOGUE_USED_BLOCKS && this.dialogueUsedBlocksList.size() > 4 && this.mouseClicked) {
            i = this.dialogueUsedBlocksList.size() - 4;
            f = (float)deltaY / (float)i;
            this.scrollAmount = class_3532.method_15363((float)(this.scrollAmount + f), (float)0.0f, (float)1.0f);
            this.scrollPosition = (int)(this.scrollAmount * (float)i);
        }
        if (this.creativeScreenPage == CreativeScreenPage.DIALOGUE_TRIGGERED_BLOCKS && this.dialogueTriggeredBlocksList.size() > 4 && this.mouseClicked) {
            i = this.dialogueTriggeredBlocksList.size() - 4;
            f = (float)deltaY / (float)i;
            this.scrollAmount = class_3532.method_15363((float)(this.scrollAmount + f), (float)0.0f, (float)1.0f);
            this.scrollPosition = (int)(this.scrollAmount * (float)i);
        }
        if (this.creativeScreenPage == CreativeScreenPage.STARTING_DIALOGUES && this.startingDialogueList.size() > 1 && this.mouseClicked) {
            i = this.startingDialogueList.size() - 1;
            f = (float)deltaY / (float)i;
            this.scrollAmount = class_3532.method_15363((float)(this.scrollAmount + f), (float)0.0f, (float)1.0f);
            this.scrollPosition = (int)(this.scrollAmount * (float)i);
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        float f;
        int i;
        if (this.creativeScreenPage == CreativeScreenPage.DIALOGUE_USED_BLOCKS && this.dialogueUsedBlocksList.size() > 4 && mouseX >= (double)(this.field_22789 / 2 - 154) && mouseX <= (double)(this.field_22789 / 2 + 50) && mouseY >= 42.0 && mouseY <= 138.0) {
            i = this.dialogueUsedBlocksList.size() - 4;
            f = (float)verticalAmount / (float)i;
            this.scrollAmount = class_3532.method_15363((float)(this.scrollAmount - f), (float)0.0f, (float)1.0f);
            this.scrollPosition = (int)(this.scrollAmount * (float)i);
        }
        if (this.creativeScreenPage == CreativeScreenPage.DIALOGUE_TRIGGERED_BLOCKS && this.dialogueTriggeredBlocksList.size() > 4 && mouseX >= (double)(this.field_22789 / 2 - 154) && mouseX <= (double)(this.field_22789 / 2 + 50) && mouseY >= 42.0 && mouseY <= 138.0) {
            i = this.dialogueTriggeredBlocksList.size() - 4;
            f = (float)verticalAmount / (float)i;
            this.scrollAmount = class_3532.method_15363((float)(this.scrollAmount - f), (float)0.0f, (float)1.0f);
            this.scrollPosition = (int)(this.scrollAmount * (float)i);
        }
        if (this.creativeScreenPage == CreativeScreenPage.STARTING_DIALOGUES && this.startingDialogueList.size() > 1 && mouseX >= (double)(this.field_22789 / 2 - 154) && mouseX <= (double)(this.field_22789 / 2 + 50) && mouseY >= 71.0 && mouseY <= 106.0) {
            i = this.startingDialogueList.size() - 1;
            f = (float)verticalAmount / (float)i;
            this.scrollAmount = class_3532.method_15363((float)(this.scrollAmount - f), (float)0.0f, (float)1.0f);
            this.scrollPosition = (int)(this.scrollAmount * (float)i);
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257 || keyCode == 335) {
            this.saveCreative();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        if (this.creativeScreenPage == CreativeScreenPage.DIALOGUE_USED_BLOCKS) {
            int x = this.dialogueUsedBlocksList.size() > 4 ? this.field_22789 / 2 - 142 : this.field_22789 / 2 - 153;
            for (int i = this.scrollPosition; i < Math.min(this.scrollPosition + 4, this.dialogueUsedBlocksList.size()); ++i) {
                context.method_25303(this.field_22793, (String)this.dialogueUsedBlocksList.get(i).getLeft() + ": " + ((class_2338)this.dialogueUsedBlocksList.get(i).getRight()).toString(), x, 48 + (i - this.scrollPosition) * 24, 0xA0A0A0);
            }
            if (this.dialogueUsedBlocksList.size() > 4) {
                context.method_52706(SCROLL_BAR_BACKGROUND_8_96_TEXTURE, this.field_22789 / 2 - 154, 42, 8, 96);
                int k = (int)(85.0f * this.scrollAmount);
                context.method_52706(SCROLLER_VERTICAL_6_7_TEXTURE, this.field_22789 / 2 - 153, 43 + k, 6, 7);
            }
            this.newDialogueUsedBlockIdentifierField.method_25394(context, mouseX, mouseY, delta);
            this.newDialogueUsedBlockPositionOffsetXField.method_25394(context, mouseX, mouseY, delta);
            this.newDialogueUsedBlockPositionOffsetYField.method_25394(context, mouseX, mouseY, delta);
            this.newDialogueUsedBlockPositionOffsetZField.method_25394(context, mouseX, mouseY, delta);
        } else if (this.creativeScreenPage == CreativeScreenPage.DIALOGUE_TRIGGERED_BLOCKS) {
            int x = this.dialogueTriggeredBlocksList.size() > 4 ? this.field_22789 / 2 - 142 : this.field_22789 / 2 - 153;
            for (int i = this.scrollPosition; i < Math.min(this.scrollPosition + 4, this.dialogueTriggeredBlocksList.size()); ++i) {
                context.method_25303(this.field_22793, (String)this.dialogueTriggeredBlocksList.get(i).getLeft() + ": " + ((MutablePair)this.dialogueTriggeredBlocksList.get(i).getRight()).toString(), x, 48 + (i - this.scrollPosition) * 24, 0xA0A0A0);
            }
            if (this.dialogueTriggeredBlocksList.size() > 4) {
                context.method_52706(SCROLL_BAR_BACKGROUND_8_96_TEXTURE, this.field_22789 / 2 - 154, 42, 8, 96);
                int k = (int)(85.0f * this.scrollAmount);
                context.method_52706(SCROLLER_VERTICAL_6_7_TEXTURE, this.field_22789 / 2 - 153, 43 + k, 6, 7);
            }
            this.newDialogueTriggeredBlockIdentifierField.method_25394(context, mouseX, mouseY, delta);
            this.newDialogueTriggeredBlockPositionOffsetXField.method_25394(context, mouseX, mouseY, delta);
            this.newDialogueTriggeredBlockPositionOffsetYField.method_25394(context, mouseX, mouseY, delta);
            this.newDialogueTriggeredBlockPositionOffsetZField.method_25394(context, mouseX, mouseY, delta);
        } else if (this.creativeScreenPage == CreativeScreenPage.STARTING_DIALOGUES) {
            int x = this.startingDialogueList.size() > 1 ? this.field_22789 / 2 - 142 : this.field_22789 / 2 - 153;
            for (int i = this.scrollPosition; i < Math.min(this.scrollPosition + 1, this.startingDialogueList.size()); ++i) {
                context.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)this.startingDialogueList.get(i)), x, 71, 0xA0A0A0);
            }
            if (this.startingDialogueList.size() > 1) {
                context.method_52706(SCROLL_BAR_BACKGROUND_8_35_TEXTURE, this.field_22789 / 2 - 154, 71, 8, 35);
                int k = (int)(26.0f * this.scrollAmount);
                context.method_52706(SCROLLER_VERTICAL_6_7_TEXTURE, this.field_22789 / 2 - 153, 72 + k, 6, 7);
            }
            this.newStartingDialogueIdentifierField.method_25394(context, mouseX, mouseY, delta);
        } else if (this.creativeScreenPage == CreativeScreenPage.DATA_BLOCK_OFFSET) {
            this.dataBlockOffsetXField.method_25394(context, mouseX, mouseY, delta);
            this.dataBlockOffsetYField.method_25394(context, mouseX, mouseY, delta);
            this.dataBlockOffsetZField.method_25394(context, mouseX, mouseY, delta);
        }
    }

    public boolean method_25422() {
        return true;
    }

    private boolean updateDialogueBlockCreative() {
        ClientPlayNetworking.send((class_8710)new UpdateDialogueBlockPacket(this.dialogueBlockEntity.method_11016(), this.dialogueUsedBlocksList, this.dialogueTriggeredBlocksList, this.startingDialogueList, new class_2338(ItemUtils.parseInt(this.dataBlockOffsetXField.method_1882()), ItemUtils.parseInt(this.dataBlockOffsetYField.method_1882()), ItemUtils.parseInt(this.dataBlockOffsetZField.method_1882()))));
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public static enum CreativeScreenPage implements class_3542
    {
        DATA_BLOCK_OFFSET("data_block_offset"),
        DIALOGUE_USED_BLOCKS("dialogue_used_blocks"),
        DIALOGUE_TRIGGERED_BLOCKS("dialogue_triggered_blocks"),
        STARTING_DIALOGUES("starting_dialogues");

        private final String name;

        private CreativeScreenPage(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        public static Optional<CreativeScreenPage> byName(String name) {
            return Arrays.stream(CreativeScreenPage.values()).filter(creativeScreenPage -> creativeScreenPage.method_15434().equals(name)).findFirst();
        }

        public class_2561 asText() {
            return class_2561.method_43471((String)("gui.dialogue_screen.creativeScreenPage." + this.name));
        }
    }
}

