/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.scriptblocks.gui.screen.ingame;

import com.github.theredbrain.scriptblocks.ScriptBlocks;
import com.github.theredbrain.scriptblocks.block.entity.HousingBlockEntity;
import com.github.theredbrain.scriptblocks.network.packet.AddStatusEffectPacket;
import com.github.theredbrain.scriptblocks.network.packet.LeaveHouseFromHousingScreenPacket;
import com.github.theredbrain.scriptblocks.network.packet.ResetHouseHousingBlockPacket;
import com.github.theredbrain.scriptblocks.network.packet.SetHousingBlockOwnerPacket;
import com.github.theredbrain.scriptblocks.network.packet.UpdateHousingBlockAdventurePacket;
import com.github.theredbrain.scriptblocks.registry.StatusEffectsRegistry;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_333;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_6880;
import net.minecraft.class_7919;
import net.minecraft.class_7923;
import net.minecraft.class_8710;

@Environment(value=EnvType.CLIENT)
public class HousingScreen
extends class_437 {
    private static final class_2561 TITLE_OWNER_LABEL_TEXT = class_2561.method_43471((String)"gui.housing_screen.title.owner");
    private static final class_2561 TITLE_CO_OWNER_LABEL_TEXT = class_2561.method_43471((String)"gui.housing_screen.title.co_owner");
    private static final class_2561 TITLE_CO_OWNER_LIST_LABEL_TEXT = class_2561.method_43471((String)"gui.housing_screen.co_owner_list.title");
    private static final class_2561 TITLE_CO_OWNER_LIST_DESCRIPTION_LABEL_TEXT = class_2561.method_43471((String)"gui.housing_screen.co_owner_list.description");
    private static final class_2561 TITLE_TRUSTED_LABEL_TEXT = class_2561.method_43471((String)"gui.housing_screen.title.trusted");
    private static final class_2561 TITLE_TRUSTED_LIST_LABEL_TEXT = class_2561.method_43471((String)"gui.housing_screen.trusted_list.title");
    private static final class_2561 TITLE_TRUSTED_LIST_DESCRIPTION_LABEL_TEXT = class_2561.method_43471((String)"gui.housing_screen.trusted_list.description");
    private static final class_2561 TITLE_GUEST_LABEL_TEXT = class_2561.method_43471((String)"gui.housing_screen.title.guest");
    private static final class_2561 TITLE_GUEST_LIST_LABEL_TEXT = class_2561.method_43471((String)"gui.housing_screen.guest_list.title");
    private static final class_2561 TITLE_GUEST_LIST_DESCRIPTION_LABEL_TEXT = class_2561.method_43471((String)"gui.housing_screen.guest_list.description");
    private static final class_2561 TITLE_STRANGER_LABEL_TEXT = class_2561.method_43471((String)"gui.housing_screen.title.stranger");
    private static final class_2561 LEAVE_CURRENT_HOUSE_BUTTON_LABEL_TEXT = class_2561.method_43471((String)"gui.housing_screen.leave_current_house_button_label");
    private static final class_2561 CLOSE_HOUSING_SCREEN_BUTTON_LABEL_TEXT = class_2561.method_43471((String)"gui.housing_screen.close_housing_screen_button_label");
    private static final class_2561 OPEN_RESET_HOUSE_SCREEN_BUTTON_LABEL_TEXT = class_2561.method_43471((String)"gui.housing_screen.open_reset_house_screen_button_label");
    private static final class_2561 TOGGLE_ADVENTURE_BUILDING_OFF_BUTTON_LABEL_TEXT = class_2561.method_43471((String)"gui.housing_screen.toggle_adventure_building_off_button_label");
    private static final class_2561 TOGGLE_ADVENTURE_BUILDING_ON_BUTTON_LABEL_TEXT = class_2561.method_43471((String)"gui.housing_screen.toggle_adventure_building_on_button_label");
    private static final class_2561 UNCLAIM_HOUSE_BUTTON_LABEL_TEXT = class_2561.method_43471((String)"gui.housing_screen.unclaim_house_button_label");
    private static final class_2561 CLAIM_HOUSE_BUTTON_LABEL_TEXT = class_2561.method_43471((String)"gui.housing_screen.claim_house_button_label");
    private static final class_2561 OPEN_CO_OWNER_LIST_BUTTON_LABEL_TEXT = class_2561.method_43471((String)"gui.housing_screen.open_co_owner_list_button_label");
    private static final class_2561 NEW_CO_OWNER_FIELD_PLACEHOLDER_TEXT = class_2561.method_43471((String)"gui.housing_screen.new_co_owner_field.place_holder");
    private static final class_2561 ADD_NEW_CO_OWNER_BUTTON_LABEL_TEXT = class_2561.method_43471((String)"gui.housing_screen.add_new_co_owner_button.label");
    private static final class_2561 ADD_NEW_CO_OWNER_BUTTON_TOOLTIP_TEXT = class_2561.method_43471((String)"gui.housing_screen.add_new_co_owner_button.tooltip");
    private static final class_2561 OPEN_TRUSTED_PERSONS_LIST_BUTTON_LABEL_TEXT = class_2561.method_43471((String)"gui.housing_screen.open_trusted_list_button_label");
    private static final class_2561 NEW_TRUSTED_PERSON_FIELD_PLACEHOLDER_TEXT = class_2561.method_43471((String)"gui.housing_screen.new_trusted_person_field.place_holder");
    private static final class_2561 ADD_NEW_TRUSTED_PERSON_BUTTON_LABEL_TEXT = class_2561.method_43471((String)"gui.housing_screen.add_new_trusted_person_button.label");
    private static final class_2561 ADD_NEW_TRUSTED_PERSON_BUTTON_TOOLTIP_TEXT = class_2561.method_43471((String)"gui.housing_screen.add_new_trusted_person_button.tooltip");
    private static final class_2561 OPEN_GUEST_LIST_BUTTON_LABEL_TEXT = class_2561.method_43471((String)"gui.housing_screen.open_guest_list_button_label");
    private static final class_2561 NEW_GUEST_FIELD_PLACEHOLDER_TEXT = class_2561.method_43471((String)"gui.housing_screen.new_guest_field.place_holder");
    private static final class_2561 ADD_NEW_GUEST_BUTTON_LABEL_TEXT = class_2561.method_43471((String)"gui.housing_screen.add_new_guest_button.label");
    private static final class_2561 ADD_NEW_GUEST_BUTTON_TOOLTIP_TEXT = class_2561.method_43471((String)"gui.housing_screen.add_new_guest_button.tooltip");
    private static final class_2561 REMOVE_LIST_ENTRY_BUTTON_LABEL_TEXT = class_2561.method_43471((String)"gui.housing_screen.remove_list_entry_button_label");
    public static final class_2960 BACKGROUND_218_215_TEXTURE = ScriptBlocks.identifier("textures/gui/container/generic_218_215_background.png");
    public static final class_2960 BACKGROUND_218_95_TEXTURE = ScriptBlocks.identifier("textures/gui/container/generic_218_95_background.png");
    public static final class_2960 BACKGROUND_218_71_TEXTURE = ScriptBlocks.identifier("textures/gui/container/generic_218_71_background.png");
    private static final class_2960 PLAYER_LISTS_SCROLLER_BACKGROUND_TEXTURE = ScriptBlocks.identifier("container/housing_screen/player_lists_scroller_background");
    private static final class_2960 SCROLLER_TEXTURE = ScriptBlocks.identifier("container/scroller");
    private final HousingBlockEntity housingBlockEntity;
    private class_4185 leaveCurrentHouseButton;
    private class_4185 openResetHouseScreenButton;
    private class_4185 resetHouseButton;
    private class_4185 closeResetHouseScreenButton;
    private class_4185 toggleAdventureBuildingEffectButton;
    private class_4185 unclaimHouseButton;
    private class_4185 claimHouseButton;
    private class_4185 openCoOwnerListScreenButton;
    private class_342 newCoOwnerField;
    private class_4185 addNewCoOwnerButton;
    private class_4185 removeCoOwnerListEntryButton0;
    private class_4185 removeCoOwnerListEntryButton1;
    private class_4185 removeCoOwnerListEntryButton2;
    private class_4185 removeCoOwnerListEntryButton3;
    private class_4185 removeCoOwnerListEntryButton4;
    private class_4185 openTrustedPersonsListScreenButton;
    private class_342 newTrustedPersonField;
    private class_4185 addNewTrustedPersonButton;
    private class_4185 removeTrustedPersonListEntryButton0;
    private class_4185 removeTrustedPersonListEntryButton1;
    private class_4185 removeTrustedPersonListEntryButton2;
    private class_4185 removeTrustedPersonListEntryButton3;
    private class_4185 removeTrustedPersonListEntryButton4;
    private class_4185 openGuestListScreenButton;
    private class_342 newGuestField;
    private class_4185 addNewGuestButton;
    private class_4185 removeGuestListEntryButton0;
    private class_4185 removeGuestListEntryButton1;
    private class_4185 removeGuestListEntryButton2;
    private class_4185 removeGuestListEntryButton3;
    private class_4185 removeGuestListEntryButton4;
    private class_4185 closeListEditScreensButton;
    private class_4185 closeAdventureScreenButton;
    private final int currentPermissionLevel;
    private List<String> coOwnerList = new ArrayList<String>(List.of());
    private List<String> trustedPersonsList = new ArrayList<String>(List.of());
    private List<String> guestList = new ArrayList<String>(List.of());
    private boolean showResetHouseScreen = false;
    private boolean showCoOwnerListScreen = false;
    private boolean showTrustedListScreen = false;
    private boolean showGuestListScreen = false;
    private int backgroundWidth;
    private int backgroundHeight;
    private int x;
    private int y;
    private int scrollPosition = 0;
    private float scrollAmount = 0.0f;
    private boolean mouseClicked = false;
    private HousingBlockEntity.OwnerMode ownerMode = HousingBlockEntity.OwnerMode.DIMENSION_OWNER;

    public HousingScreen(HousingBlockEntity housingBlockEntity, int currentPermissionLevel) {
        super(class_333.field_18967);
        this.housingBlockEntity = housingBlockEntity;
        this.currentPermissionLevel = currentPermissionLevel;
    }

    private void openResetHouseScreen() {
        this.showResetHouseScreen = true;
        this.updateWidgets();
    }

    private void closeResetHouseScreen() {
        this.showResetHouseScreen = false;
        this.updateWidgets();
    }

    private void openListScreen(int listType) {
        if (listType == 0) {
            this.showCoOwnerListScreen = true;
        } else if (listType == 1) {
            this.showTrustedListScreen = true;
        } else if (listType == 2) {
            this.showGuestListScreen = true;
        }
        this.scrollPosition = 0;
        this.scrollAmount = 0.0f;
        this.updateWidgets();
    }

    private void closeListScreens() {
        this.showCoOwnerListScreen = false;
        this.showTrustedListScreen = false;
        this.showGuestListScreen = false;
        this.scrollPosition = 0;
        this.scrollAmount = 0.0f;
        this.updateHousingBlockAdventure();
        this.updateWidgets();
    }

    private void addNewEntryToList(String newEntry, int listType) {
        if (listType == 0) {
            this.coOwnerList.add(newEntry);
        } else if (listType == 1) {
            this.trustedPersonsList.add(newEntry);
        } else if (listType == 2) {
            this.guestList.add(newEntry);
        }
        this.updateWidgets();
    }

    private void removeEntryFromList(int index, int listType) {
        if (listType == 0 && index + this.scrollPosition < this.coOwnerList.size()) {
            this.coOwnerList.remove(index + this.scrollPosition);
        } else if (listType == 1 && index + this.scrollPosition < this.trustedPersonsList.size()) {
            this.trustedPersonsList.remove(index + this.scrollPosition);
        } else if (listType == 2 && index + this.scrollPosition < this.guestList.size()) {
            this.guestList.remove(index + this.scrollPosition);
        }
        this.updateWidgets();
    }

    private void cancel() {
        this.method_25419();
    }

    private void leaveCurrentHouse() {
        ClientPlayNetworking.send((class_8710)new LeaveHouseFromHousingScreenPacket());
        this.method_25419();
    }

    protected void method_25426() {
        this.coOwnerList.addAll(this.housingBlockEntity.getCoOwnerList());
        this.trustedPersonsList.addAll(this.housingBlockEntity.getTrustedList());
        this.guestList.addAll(this.housingBlockEntity.getGuestList());
        this.ownerMode = this.housingBlockEntity.getOwnerMode();
        if (this.currentPermissionLevel == 0) {
            this.backgroundWidth = 218;
            this.backgroundHeight = 215;
            this.x = (this.field_22789 - this.backgroundWidth) / 2;
            this.y = (this.field_22790 - this.backgroundHeight) / 2;
        } else if (this.currentPermissionLevel == 1) {
            this.backgroundWidth = 218;
            this.backgroundHeight = 95;
            this.x = (this.field_22789 - this.backgroundWidth) / 2;
            this.y = (this.field_22790 - this.backgroundHeight) / 2;
        } else if (this.currentPermissionLevel == 2 || this.currentPermissionLevel == 3) {
            this.backgroundWidth = 218;
            this.backgroundHeight = 71;
            this.x = (this.field_22789 - this.backgroundWidth) / 2;
            this.y = (this.field_22790 - this.backgroundHeight) / 2;
        } else {
            this.backgroundWidth = 218;
            this.backgroundHeight = this.ownerMode == HousingBlockEntity.OwnerMode.INTERACTION ? 95 : 71;
            this.x = (this.field_22789 - this.backgroundWidth) / 2;
            this.y = (this.field_22790 - this.backgroundHeight) / 2;
        }
        super.method_25426();
        this.resetHouseButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24338, button -> this.resetHouse()).method_46434(this.x + 7, this.y + this.backgroundHeight - 27, this.backgroundWidth / 2 - 18, 20).method_46431());
        this.closeResetHouseScreenButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24335, button -> this.closeResetHouseScreen()).method_46434(this.x + this.backgroundWidth / 2 - 18 + 7, this.y + this.backgroundHeight - 27, this.backgroundWidth / 2 - 18, 20).method_46431());
        this.removeCoOwnerListEntryButton0 = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)REMOVE_LIST_ENTRY_BUTTON_LABEL_TEXT, button -> this.removeEntryFromList(0, 0)).method_46434(this.x + this.backgroundWidth - 57, this.y + 33, 50, 20).method_46431());
        this.removeCoOwnerListEntryButton1 = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)REMOVE_LIST_ENTRY_BUTTON_LABEL_TEXT, button -> this.removeEntryFromList(1, 0)).method_46434(this.x + this.backgroundWidth - 57, this.y + 57, 50, 20).method_46431());
        this.removeCoOwnerListEntryButton2 = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)REMOVE_LIST_ENTRY_BUTTON_LABEL_TEXT, button -> this.removeEntryFromList(2, 0)).method_46434(this.x + this.backgroundWidth - 57, this.y + 81, 50, 20).method_46431());
        this.removeCoOwnerListEntryButton3 = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)REMOVE_LIST_ENTRY_BUTTON_LABEL_TEXT, button -> this.removeEntryFromList(3, 0)).method_46434(this.x + this.backgroundWidth - 57, this.y + 105, 50, 20).method_46431());
        this.removeCoOwnerListEntryButton4 = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)REMOVE_LIST_ENTRY_BUTTON_LABEL_TEXT, button -> this.removeEntryFromList(4, 0)).method_46434(this.x + this.backgroundWidth - 57, this.y + 129, 50, 20).method_46431());
        this.newCoOwnerField = new class_342(this.field_22793, this.x + 7, this.y + this.backgroundHeight - 27 - 24, this.backgroundWidth - 57 - 7 - 4, 20, (class_2561)class_2561.method_43473());
        this.newCoOwnerField.method_1880(128);
        this.newCoOwnerField.method_47404(NEW_CO_OWNER_FIELD_PLACEHOLDER_TEXT);
        this.method_25429((class_364)this.newCoOwnerField);
        this.addNewCoOwnerButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)ADD_NEW_CO_OWNER_BUTTON_LABEL_TEXT, button -> this.addNewEntryToList(this.newCoOwnerField.method_1882(), 0)).method_46434(this.x + this.backgroundWidth - 57, this.y + this.backgroundHeight - 27 - 24, 50, 20).method_46431());
        this.addNewCoOwnerButton.method_47400(class_7919.method_47407((class_2561)ADD_NEW_CO_OWNER_BUTTON_TOOLTIP_TEXT));
        this.removeTrustedPersonListEntryButton0 = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)REMOVE_LIST_ENTRY_BUTTON_LABEL_TEXT, button -> this.removeEntryFromList(0, 1)).method_46434(this.x + this.backgroundWidth - 57, this.y + 33, 50, 20).method_46431());
        this.removeTrustedPersonListEntryButton1 = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)REMOVE_LIST_ENTRY_BUTTON_LABEL_TEXT, button -> this.removeEntryFromList(1, 1)).method_46434(this.x + this.backgroundWidth - 57, this.y + 57, 50, 20).method_46431());
        this.removeTrustedPersonListEntryButton2 = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)REMOVE_LIST_ENTRY_BUTTON_LABEL_TEXT, button -> this.removeEntryFromList(2, 1)).method_46434(this.x + this.backgroundWidth - 57, this.y + 81, 50, 20).method_46431());
        this.removeTrustedPersonListEntryButton3 = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)REMOVE_LIST_ENTRY_BUTTON_LABEL_TEXT, button -> this.removeEntryFromList(3, 1)).method_46434(this.x + this.backgroundWidth - 57, this.y + 105, 50, 20).method_46431());
        this.removeTrustedPersonListEntryButton4 = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)REMOVE_LIST_ENTRY_BUTTON_LABEL_TEXT, button -> this.removeEntryFromList(4, 1)).method_46434(this.x + this.backgroundWidth - 57, this.y + 129, 50, 20).method_46431());
        this.newTrustedPersonField = new class_342(this.field_22793, this.x + 7, this.y + this.backgroundHeight - 27 - 24, this.backgroundWidth - 57 - 7 - 4, 20, (class_2561)class_2561.method_43473());
        this.newTrustedPersonField.method_1880(128);
        this.newTrustedPersonField.method_47404(NEW_TRUSTED_PERSON_FIELD_PLACEHOLDER_TEXT);
        this.method_25429((class_364)this.newTrustedPersonField);
        this.addNewTrustedPersonButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)ADD_NEW_TRUSTED_PERSON_BUTTON_LABEL_TEXT, button -> this.addNewEntryToList(this.newTrustedPersonField.method_1882(), 1)).method_46434(this.x + this.backgroundWidth - 57, this.y + this.backgroundHeight - 27 - 24, 50, 20).method_46431());
        this.addNewTrustedPersonButton.method_47400(class_7919.method_47407((class_2561)ADD_NEW_TRUSTED_PERSON_BUTTON_TOOLTIP_TEXT));
        this.removeGuestListEntryButton0 = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)REMOVE_LIST_ENTRY_BUTTON_LABEL_TEXT, button -> this.removeEntryFromList(0, 2)).method_46434(this.x + this.backgroundWidth - 57, this.y + 33, 50, 20).method_46431());
        this.removeGuestListEntryButton1 = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)REMOVE_LIST_ENTRY_BUTTON_LABEL_TEXT, button -> this.removeEntryFromList(1, 2)).method_46434(this.x + this.backgroundWidth - 57, this.y + 57, 50, 20).method_46431());
        this.removeGuestListEntryButton2 = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)REMOVE_LIST_ENTRY_BUTTON_LABEL_TEXT, button -> this.removeEntryFromList(2, 2)).method_46434(this.x + this.backgroundWidth - 57, this.y + 81, 50, 20).method_46431());
        this.removeGuestListEntryButton3 = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)REMOVE_LIST_ENTRY_BUTTON_LABEL_TEXT, button -> this.removeEntryFromList(3, 2)).method_46434(this.x + this.backgroundWidth - 57, this.y + 105, 50, 20).method_46431());
        this.removeGuestListEntryButton4 = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)REMOVE_LIST_ENTRY_BUTTON_LABEL_TEXT, button -> this.removeEntryFromList(4, 2)).method_46434(this.x + this.backgroundWidth - 57, this.y + 129, 50, 20).method_46431());
        this.newGuestField = new class_342(this.field_22793, this.x + 7, this.y + this.backgroundHeight - 27 - 24, this.backgroundWidth - 57 - 7 - 4, 20, (class_2561)class_2561.method_43473());
        this.newGuestField.method_1880(128);
        this.newGuestField.method_47404(NEW_GUEST_FIELD_PLACEHOLDER_TEXT);
        this.method_25429((class_364)this.newGuestField);
        this.addNewGuestButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)ADD_NEW_GUEST_BUTTON_LABEL_TEXT, button -> this.addNewEntryToList(this.newGuestField.method_1882(), 2)).method_46434(this.x + this.backgroundWidth - 57, this.y + this.backgroundHeight - 27 - 24, 50, 20).method_46431());
        this.addNewGuestButton.method_47400(class_7919.method_47407((class_2561)ADD_NEW_GUEST_BUTTON_TOOLTIP_TEXT));
        this.closeListEditScreensButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24335, button -> this.closeListScreens()).method_46434(this.x + 7, this.y + this.backgroundHeight - 27, this.backgroundWidth - 14, 20).method_46431());
        boolean isAdventureBuilding = false;
        class_6880 building_mode_status_effect = class_7923.field_41174.method_47983((Object)StatusEffectsRegistry.BUILDING_MODE);
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            isAdventureBuilding = this.field_22787.field_1724.method_6059(building_mode_status_effect);
        }
        this.toggleAdventureBuildingEffectButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)(isAdventureBuilding ? TOGGLE_ADVENTURE_BUILDING_OFF_BUTTON_LABEL_TEXT : TOGGLE_ADVENTURE_BUILDING_ON_BUTTON_LABEL_TEXT), button -> this.toggleAdventureBuildingEffect()).method_46434(this.x + 7, this.y + 20, this.backgroundWidth - 14, 20).method_46431());
        this.openCoOwnerListScreenButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)OPEN_CO_OWNER_LIST_BUTTON_LABEL_TEXT, button -> this.openListScreen(0)).method_46434(this.x + 7, this.y + 44, this.backgroundWidth - 14, 20).method_46431());
        this.openTrustedPersonsListScreenButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)OPEN_TRUSTED_PERSONS_LIST_BUTTON_LABEL_TEXT, button -> this.openListScreen(1)).method_46434(this.x + 7, this.y + 68, this.backgroundWidth - 14, 20).method_46431());
        this.openGuestListScreenButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)OPEN_GUEST_LIST_BUTTON_LABEL_TEXT, button -> this.openListScreen(2)).method_46434(this.x + 7, this.y + 92, this.backgroundWidth - 14, 20).method_46431());
        this.openResetHouseScreenButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)OPEN_RESET_HOUSE_SCREEN_BUTTON_LABEL_TEXT, button -> this.openResetHouseScreen()).method_46434(this.x + 7, this.y + 116, this.backgroundWidth - 14, 20).method_46431());
        this.unclaimHouseButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)UNCLAIM_HOUSE_BUTTON_LABEL_TEXT, button -> this.trySetHouseOwner(false)).method_46434(this.x + 7, this.y + this.backgroundHeight - 27 - 48, this.backgroundWidth - 14, 20).method_46431());
        this.claimHouseButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)CLAIM_HOUSE_BUTTON_LABEL_TEXT, button -> this.trySetHouseOwner(true)).method_46434(this.x + 7, this.y + this.backgroundHeight - 27 - 48, this.backgroundWidth - 14, 20).method_46431());
        this.leaveCurrentHouseButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)LEAVE_CURRENT_HOUSE_BUTTON_LABEL_TEXT, button -> this.leaveCurrentHouse()).method_46434(this.x + 7, this.y + this.backgroundHeight - 27 - 24, this.backgroundWidth - 14, 20).method_46431());
        this.closeAdventureScreenButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)CLOSE_HOUSING_SCREEN_BUTTON_LABEL_TEXT, button -> this.cancel()).method_46434(this.x + 7, this.y + this.backgroundHeight - 27, this.backgroundWidth - 14, 20).method_46431());
        this.updateWidgets();
    }

    private void updateWidgets() {
        this.leaveCurrentHouseButton.field_22764 = false;
        this.openResetHouseScreenButton.field_22764 = false;
        this.resetHouseButton.field_22764 = false;
        this.closeResetHouseScreenButton.field_22764 = false;
        this.toggleAdventureBuildingEffectButton.field_22764 = false;
        this.unclaimHouseButton.field_22764 = false;
        this.claimHouseButton.field_22764 = false;
        this.openCoOwnerListScreenButton.field_22764 = false;
        this.newCoOwnerField.method_1862(false);
        this.addNewCoOwnerButton.field_22764 = false;
        this.removeCoOwnerListEntryButton0.field_22764 = false;
        this.removeCoOwnerListEntryButton1.field_22764 = false;
        this.removeCoOwnerListEntryButton2.field_22764 = false;
        this.removeCoOwnerListEntryButton3.field_22764 = false;
        this.removeCoOwnerListEntryButton4.field_22764 = false;
        this.openTrustedPersonsListScreenButton.field_22764 = false;
        this.newTrustedPersonField.method_1862(false);
        this.addNewTrustedPersonButton.field_22764 = false;
        this.removeTrustedPersonListEntryButton0.field_22764 = false;
        this.removeTrustedPersonListEntryButton1.field_22764 = false;
        this.removeTrustedPersonListEntryButton2.field_22764 = false;
        this.removeTrustedPersonListEntryButton3.field_22764 = false;
        this.removeTrustedPersonListEntryButton4.field_22764 = false;
        this.openGuestListScreenButton.field_22764 = false;
        this.newGuestField.method_1862(false);
        this.addNewGuestButton.field_22764 = false;
        this.removeGuestListEntryButton0.field_22764 = false;
        this.removeGuestListEntryButton1.field_22764 = false;
        this.removeGuestListEntryButton2.field_22764 = false;
        this.removeGuestListEntryButton3.field_22764 = false;
        this.removeGuestListEntryButton4.field_22764 = false;
        this.closeListEditScreensButton.field_22764 = false;
        this.closeAdventureScreenButton.field_22764 = false;
        if (this.showCoOwnerListScreen) {
            this.newCoOwnerField.method_1862(true);
            this.addNewCoOwnerButton.field_22764 = true;
            int index = 0;
            for (int i = 0; i < Math.min(5, this.coOwnerList.size()); ++i) {
                if (index == 0) {
                    this.removeCoOwnerListEntryButton0.field_22764 = true;
                } else if (index == 1) {
                    this.removeCoOwnerListEntryButton1.field_22764 = true;
                } else if (index == 2) {
                    this.removeCoOwnerListEntryButton2.field_22764 = true;
                } else if (index == 3) {
                    this.removeCoOwnerListEntryButton3.field_22764 = true;
                } else if (index == 4) {
                    this.removeCoOwnerListEntryButton4.field_22764 = true;
                }
                ++index;
            }
            this.closeListEditScreensButton.field_22764 = true;
        } else if (this.showTrustedListScreen) {
            this.newTrustedPersonField.method_1862(true);
            this.addNewTrustedPersonButton.field_22764 = true;
            int index = 0;
            for (int i = 0; i < Math.min(5, this.trustedPersonsList.size()); ++i) {
                if (index == 0) {
                    this.removeTrustedPersonListEntryButton0.field_22764 = true;
                } else if (index == 1) {
                    this.removeTrustedPersonListEntryButton1.field_22764 = true;
                } else if (index == 2) {
                    this.removeTrustedPersonListEntryButton2.field_22764 = true;
                } else if (index == 3) {
                    this.removeTrustedPersonListEntryButton3.field_22764 = true;
                } else if (index == 4) {
                    this.removeTrustedPersonListEntryButton4.field_22764 = true;
                }
                ++index;
            }
            this.closeListEditScreensButton.field_22764 = true;
        } else if (this.showGuestListScreen) {
            this.newGuestField.method_1862(true);
            this.addNewGuestButton.field_22764 = true;
            int index = 0;
            for (int i = 0; i < Math.min(5, this.guestList.size()); ++i) {
                if (index == 0) {
                    this.removeGuestListEntryButton0.field_22764 = true;
                } else if (index == 1) {
                    this.removeGuestListEntryButton1.field_22764 = true;
                } else if (index == 2) {
                    this.removeGuestListEntryButton2.field_22764 = true;
                } else if (index == 3) {
                    this.removeGuestListEntryButton3.field_22764 = true;
                } else if (index == 4) {
                    this.removeGuestListEntryButton4.field_22764 = true;
                }
                ++index;
            }
            this.closeListEditScreensButton.field_22764 = true;
        } else if (this.showResetHouseScreen) {
            this.resetHouseButton.field_22764 = true;
            this.closeResetHouseScreenButton.field_22764 = true;
        } else {
            if (this.currentPermissionLevel == 0) {
                this.toggleAdventureBuildingEffectButton.field_22764 = true;
                this.openCoOwnerListScreenButton.field_22764 = true;
                this.openTrustedPersonsListScreenButton.field_22764 = true;
                this.openGuestListScreenButton.field_22764 = true;
                this.openResetHouseScreenButton.field_22764 = true;
                if (this.housingBlockEntity != null && this.housingBlockEntity.getOwnerMode() == HousingBlockEntity.OwnerMode.INTERACTION) {
                    this.unclaimHouseButton.field_22764 = true;
                }
            } else if (this.currentPermissionLevel == 1) {
                this.toggleAdventureBuildingEffectButton.field_22764 = true;
            } else if (this.currentPermissionLevel == 4 && this.housingBlockEntity != null && this.housingBlockEntity.getOwnerMode() == HousingBlockEntity.OwnerMode.INTERACTION && !this.housingBlockEntity.isOwnerSet()) {
                this.claimHouseButton.field_22764 = true;
            }
            this.leaveCurrentHouseButton.field_22764 = true;
            this.closeAdventureScreenButton.field_22764 = true;
        }
    }

    public void method_25410(class_310 client, int width, int height) {
        ArrayList<String> list = new ArrayList<String>(this.coOwnerList);
        ArrayList<String> list1 = new ArrayList<String>(this.trustedPersonsList);
        ArrayList<String> list2 = new ArrayList<String>(this.guestList);
        HousingBlockEntity.OwnerMode var = this.ownerMode;
        int number = this.scrollPosition;
        float number1 = this.scrollAmount;
        String string = this.newCoOwnerField.method_1882();
        String string1 = this.newTrustedPersonField.method_1882();
        String string2 = this.newGuestField.method_1882();
        this.method_25423(client, width, height);
        this.coOwnerList.clear();
        this.trustedPersonsList.clear();
        this.guestList.clear();
        this.coOwnerList.addAll(list);
        this.trustedPersonsList.addAll(list1);
        this.guestList.addAll(list2);
        this.ownerMode = var;
        this.scrollPosition = number;
        this.scrollAmount = number1;
        this.newCoOwnerField.method_1852(string);
        this.newTrustedPersonField.method_1852(string1);
        this.newGuestField.method_1852(string2);
        this.updateWidgets();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.mouseClicked = false;
        if (this.showCoOwnerListScreen && this.coOwnerList.size() > 5 || this.showTrustedListScreen && this.coOwnerList.size() > 5 || this.showGuestListScreen && this.coOwnerList.size() > 5) {
            int i = this.x + 8;
            int j = this.y + 34;
            if (mouseX >= (double)i && mouseX < (double)(i + 6) && mouseY >= (double)j && mouseY < (double)(j + 115)) {
                this.mouseClicked = true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        float f;
        int i;
        if (this.showCoOwnerListScreen && this.coOwnerList.size() > 5 && this.mouseClicked) {
            i = this.coOwnerList.size() - 5;
            f = (float)deltaY / (float)i;
            this.scrollAmount = class_3532.method_15363((float)(this.scrollAmount + f), (float)0.0f, (float)1.0f);
            this.scrollPosition = (int)(this.scrollAmount * (float)i);
        }
        if (this.showTrustedListScreen && this.trustedPersonsList.size() > 5 && this.mouseClicked) {
            i = this.trustedPersonsList.size() - 5;
            f = (float)deltaY / (float)i;
            this.scrollAmount = class_3532.method_15363((float)(this.scrollAmount + f), (float)0.0f, (float)1.0f);
            this.scrollPosition = (int)(this.scrollAmount * (float)i);
        }
        if (this.showGuestListScreen && this.guestList.size() > 5 && this.mouseClicked) {
            i = this.guestList.size() - 5;
            f = (float)deltaY / (float)i;
            this.scrollAmount = class_3532.method_15363((float)(this.scrollAmount + f), (float)0.0f, (float)1.0f);
            this.scrollPosition = (int)(this.scrollAmount * (float)i);
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        float f;
        int i;
        if (this.showCoOwnerListScreen && this.coOwnerList.size() > 5 && mouseX >= (double)(this.x + 7) && mouseX <= (double)(this.x + this.backgroundWidth - 61) && mouseY >= 34.0 && mouseY <= 148.0) {
            i = this.coOwnerList.size() - 5;
            f = (float)verticalAmount / (float)i;
            this.scrollAmount = class_3532.method_15363((float)(this.scrollAmount - f), (float)0.0f, (float)1.0f);
            this.scrollPosition = (int)(this.scrollAmount * (float)i);
        }
        if (this.showTrustedListScreen && this.trustedPersonsList.size() > 5 && mouseX >= (double)(this.x + 7) && mouseX <= (double)(this.x + this.backgroundWidth - 61) && mouseY >= 34.0 && mouseY <= 148.0) {
            i = this.trustedPersonsList.size() - 5;
            f = (float)verticalAmount / (float)i;
            this.scrollAmount = class_3532.method_15363((float)(this.scrollAmount - f), (float)0.0f, (float)1.0f);
            this.scrollPosition = (int)(this.scrollAmount * (float)i);
        }
        if (this.showGuestListScreen && this.guestList.size() > 5 && mouseX >= (double)(this.x + 7) && mouseX <= (double)(this.x + this.backgroundWidth - 61) && mouseY >= 34.0 && mouseY <= 148.0) {
            i = this.guestList.size() - 5;
            f = (float)verticalAmount / (float)i;
            this.scrollAmount = class_3532.method_15363((float)(this.scrollAmount - f), (float)0.0f, (float)1.0f);
            this.scrollPosition = (int)(this.scrollAmount * (float)i);
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        if (!this.showResetHouseScreen) {
            if (this.showCoOwnerListScreen) {
                context.method_51439(this.field_22793, TITLE_CO_OWNER_LIST_LABEL_TEXT, this.x + 8, this.y + 7, 0x404040, false);
                context.method_51439(this.field_22793, TITLE_CO_OWNER_LIST_DESCRIPTION_LABEL_TEXT, this.x + 8, this.y + 20, 0x404040, false);
                for (int i = this.scrollPosition; i < Math.min(this.scrollPosition + 5, this.coOwnerList.size()); ++i) {
                    String text = this.coOwnerList.get(i);
                    context.method_51433(this.field_22793, text, this.x + 19, this.y + 39 + (i - this.scrollPosition) * 24, 0x404040, false);
                }
                if (this.coOwnerList.size() > 5) {
                    context.method_52706(PLAYER_LISTS_SCROLLER_BACKGROUND_TEXTURE, this.x + 7, this.y + 33, 8, 116);
                    int k = (int)(107.0f * this.scrollAmount);
                    context.method_52706(SCROLLER_TEXTURE, this.x + 8, this.y + 33 + 1 + k, 6, 7);
                }
                this.newCoOwnerField.method_25394(context, mouseX, mouseY, delta);
            } else if (this.showTrustedListScreen) {
                context.method_51439(this.field_22793, TITLE_TRUSTED_LIST_LABEL_TEXT, this.x + 8, this.y + 7, 0x404040, false);
                context.method_51439(this.field_22793, TITLE_TRUSTED_LIST_DESCRIPTION_LABEL_TEXT, this.x + 8, this.y + 20, 0x404040, false);
                for (int i = this.scrollPosition; i < Math.min(this.scrollPosition + 5, this.trustedPersonsList.size()); ++i) {
                    String text = this.trustedPersonsList.get(i);
                    context.method_51433(this.field_22793, text, this.x + 19, this.y + 39 + (i - this.scrollPosition) * 24, 0x404040, false);
                }
                if (this.trustedPersonsList.size() > 5) {
                    context.method_52706(PLAYER_LISTS_SCROLLER_BACKGROUND_TEXTURE, this.x + 7, this.y + 33, 8, 116);
                    int k = (int)(107.0f * this.scrollAmount);
                    context.method_52706(SCROLLER_TEXTURE, this.x + 8, this.y + 33 + 1 + k, 6, 7);
                }
                this.newTrustedPersonField.method_25394(context, mouseX, mouseY, delta);
            } else if (this.showGuestListScreen) {
                context.method_51439(this.field_22793, TITLE_GUEST_LIST_LABEL_TEXT, this.x + 8, this.y + 7, 0x404040, false);
                context.method_51439(this.field_22793, TITLE_GUEST_LIST_DESCRIPTION_LABEL_TEXT, this.x + 8, this.y + 20, 0x404040, false);
                for (int i = this.scrollPosition; i < Math.min(this.scrollPosition + 5, this.guestList.size()); ++i) {
                    String text = this.guestList.get(i);
                    context.method_51433(this.field_22793, text, this.x + 19, this.y + 39 + (i - this.scrollPosition) * 24, 0x404040, false);
                }
                if (this.guestList.size() > 5) {
                    context.method_52706(PLAYER_LISTS_SCROLLER_BACKGROUND_TEXTURE, this.x + 7, this.y + 33, 8, 116);
                    int k = (int)(107.0f * this.scrollAmount);
                    context.method_52706(SCROLLER_TEXTURE, this.x + 8, this.y + 33 + 1 + k, 6, 7);
                }
                this.newGuestField.method_25394(context, mouseX, mouseY, delta);
            } else if (this.currentPermissionLevel == 0) {
                context.method_51439(this.field_22793, TITLE_OWNER_LABEL_TEXT, this.x + 8, this.y + 7, 0x404040, false);
            } else if (this.currentPermissionLevel == 1) {
                context.method_51439(this.field_22793, TITLE_CO_OWNER_LABEL_TEXT, this.x + 8, this.y + 7, 0x404040, false);
            } else if (this.currentPermissionLevel == 2) {
                context.method_51439(this.field_22793, TITLE_TRUSTED_LABEL_TEXT, this.x + 8, this.y + 7, 0x404040, false);
            } else if (this.currentPermissionLevel == 3) {
                context.method_51439(this.field_22793, TITLE_GUEST_LABEL_TEXT, this.x + 8, this.y + 7, 0x404040, false);
            } else if (this.currentPermissionLevel == 4) {
                context.method_51439(this.field_22793, TITLE_STRANGER_LABEL_TEXT, this.x + 8, this.y + 7, 0x404040, false);
            }
        }
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25420(context, mouseX, mouseY, delta);
        this.drawBackground(context, mouseX, mouseY, delta);
    }

    public void drawBackground(class_332 context, int mouseX, int mouseY, float delta) {
        int i = this.x;
        int j = this.y;
        if (this.currentPermissionLevel == 0) {
            context.method_25290(BACKGROUND_218_215_TEXTURE, i, j, 0.0f, 0.0f, this.backgroundWidth, this.backgroundHeight, this.backgroundWidth, this.backgroundHeight);
        } else if (this.currentPermissionLevel == 1 || this.ownerMode == HousingBlockEntity.OwnerMode.INTERACTION) {
            context.method_25290(BACKGROUND_218_95_TEXTURE, i, j, 0.0f, 0.0f, this.backgroundWidth, this.backgroundHeight, this.backgroundWidth, this.backgroundHeight);
        } else {
            context.method_25290(BACKGROUND_218_71_TEXTURE, i, j, 0.0f, 0.0f, this.backgroundWidth, this.backgroundHeight, this.backgroundWidth, this.backgroundHeight);
        }
    }

    private void updateHousingBlockAdventure() {
        if (this.housingBlockEntity != null) {
            ClientPlayNetworking.send((class_8710)new UpdateHousingBlockAdventurePacket(this.housingBlockEntity.method_11016(), this.coOwnerList, this.trustedPersonsList, this.guestList));
        }
    }

    private void toggleAdventureBuildingEffect() {
        ClientPlayNetworking.send((class_8710)new AddStatusEffectPacket(class_7923.field_41174.method_10221((Object)StatusEffectsRegistry.BUILDING_MODE), -1, 0, false, false, true, true));
        this.method_25419();
    }

    private void resetHouse() {
        if (this.housingBlockEntity != null) {
            ClientPlayNetworking.send((class_8710)new ResetHouseHousingBlockPacket(this.housingBlockEntity.method_11016()));
        }
        this.method_25419();
    }

    private void trySetHouseOwner(boolean claim) {
        if (this.housingBlockEntity != null && this.field_22787 != null && this.field_22787.field_1724 != null) {
            ClientPlayNetworking.send((class_8710)new SetHousingBlockOwnerPacket(this.housingBlockEntity.method_11016(), claim ? this.field_22787.field_1724.method_5845() : ""));
        }
        this.method_25419();
    }
}

