/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.scriptblocks.gui.screen.ingame;

import com.github.theredbrain.scriptblocks.ScriptBlocks;
import com.github.theredbrain.scriptblocks.block.entity.ShopBlockEntity;
import com.github.theredbrain.scriptblocks.data.Shop;
import com.github.theredbrain.scriptblocks.network.packet.UpdateShopBlockPacket;
import com.github.theredbrain.scriptblocks.screen.ShopScreenHandler;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_465;
import net.minecraft.class_5244;
import net.minecraft.class_8710;

@Environment(value=EnvType.CLIENT)
public class ShopScreen
extends class_465<ShopScreenHandler> {
    private static final class_2561 TRADE_BUTTON_LABEL_TEXT = class_2561.method_43471((String)"gui.shop_block.trade_button_label");
    public static final class_2960 SHOP_BACKGROUND_TEXTURE = ScriptBlocks.identifier("textures/gui/container/shop_background.png");
    private static final class_2960 SCROLL_BAR_BACKGROUND_8_68_TEXTURE = ScriptBlocks.identifier("scroll_bar/scroll_bar_background_8_68");
    private static final class_2960 OUT_OF_STOCK_TEXTURE = class_2960.method_60656((String)"container/villager/out_of_stock");
    private static final class_2960 HAS_STOCK_TEXTURE = ScriptBlocks.identifier("container/shop_screen/has_stock");
    private static final class_2960 SCROLLER_VERTICAL_6_7_TEXTURE = ScriptBlocks.identifier("scroll_bar/scroller_vertical_6_7");
    private ShopBlockEntity shopBlockEntity;
    private class_4185 tradeButton0;
    private class_4185 tradeButton1;
    private class_4185 tradeButton2;
    private class_342 shopIdentifierField;
    private class_4185 saveCreativeButton;
    private class_4185 cancelCreativeButton;
    private class_2561 shopTitle = class_2561.method_43473();
    private class_2561 playerOffersTitle = class_2561.method_43473();
    private int scrollPosition = 0;
    private float scrollAmount = 0.0f;
    private boolean mouseClicked = false;

    public ShopScreen(ShopScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        handler.setContentsChangedListener(this::onInventoryChange);
        this.shopBlockEntity = handler.getShopBlockEntity();
    }

    private void trade(int index) {
        Shop.Deal currentDeal;
        if (index + this.scrollPosition < ((ShopScreenHandler)this.field_2797).getStockedDealsList().size() && (currentDeal = ((ShopScreenHandler)this.field_2797).getStockedDealsList().get(index + this.scrollPosition)) != null && this.field_22787 != null && this.field_22787.field_1761 != null && ((ShopScreenHandler)this.field_2797).method_7604((class_1657)this.field_22787.field_1724, index + this.scrollPosition)) {
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_17711, (float)1.0f));
            this.field_22787.field_1761.method_2900(((ShopScreenHandler)this.field_2797).field_7763, index + this.scrollPosition);
        }
    }

    private void calculateActiveDeals() {
        if (this.tradeButton0 != null && this.tradeButton1 != null && this.tradeButton2 != null) {
            this.tradeButton0.field_22763 = false;
            this.tradeButton1.field_22763 = false;
            this.tradeButton2.field_22763 = false;
            class_1277 inventory = new class_1277(9);
            int index = 0;
            List<Shop.Deal> stockedDealsList = ((ShopScreenHandler)this.field_2797).getStockedDealsList();
            for (int i = this.scrollPosition; i < Math.min(this.scrollPosition + 3, ((ShopScreenHandler)this.field_2797).getStockedDealsCounter()) && i <= stockedDealsList.size(); ++i) {
                Shop.Deal deal = stockedDealsList.get(i);
                if (deal == null) continue;
                for (int k = 0; k < 9; ++k) {
                    class_1799 itemStack = ((ShopScreenHandler)this.field_2797).getInventory().method_5438(k);
                    inventory.method_5447(k, itemStack.method_7972());
                }
                boolean bl = true;
                List<class_1799> priceList = deal.price();
                for (class_1799 priceStack : priceList) {
                    int priceCount = priceStack.method_7947();
                    for (int j = 0; j < inventory.method_5439(); ++j) {
                        if (!class_1799.method_31577((class_1799)inventory.method_5438(j), (class_1799)priceStack)) continue;
                        int stackCount = inventory.method_5438(j).method_7947();
                        if (stackCount >= priceCount) {
                            inventory.method_5434(j, priceCount);
                            priceCount = 0;
                            break;
                        }
                        inventory.method_5447(j, class_1799.field_8037);
                        priceCount -= stackCount;
                    }
                    if (priceCount <= 0) continue;
                    bl = false;
                }
                if (bl) {
                    if (index == 0) {
                        this.tradeButton0.field_22763 = true;
                    } else if (index == 1) {
                        this.tradeButton1.field_22763 = true;
                    } else if (index == 2) {
                        this.tradeButton2.field_22763 = true;
                    }
                }
                ++index;
            }
            this.updateWidgets();
        }
    }

    private void saveCreative() {
        if (this.updateShopBlockCreative()) {
            this.method_25419();
        }
    }

    private void cancel() {
        this.method_25419();
    }

    protected void method_25426() {
        class_2586 blockEntity;
        if (this.field_22787 != null && this.field_22787.field_1687 != null && (blockEntity = this.field_22787.field_1687.method_8321(((ShopScreenHandler)this.field_2797).getBlockPos())) instanceof ShopBlockEntity) {
            this.shopBlockEntity = (ShopBlockEntity)blockEntity;
        }
        if (((ShopScreenHandler)this.field_2797).getShop() == null && this.field_22787 != null) {
            this.field_22787.method_1507(null);
            return;
        }
        this.field_2792 = 176;
        this.field_2779 = 212;
        this.field_25270 = 118;
        super.method_25426();
        this.tradeButton0 = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)TRADE_BUTTON_LABEL_TEXT, button -> this.trade(0)).method_46434(this.field_2776 + 107, this.field_2800 + 16, 50, 20).method_46431());
        this.tradeButton1 = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)TRADE_BUTTON_LABEL_TEXT, button -> this.trade(1)).method_46434(this.field_2776 + 107, this.field_2800 + 40, 50, 20).method_46431());
        this.tradeButton2 = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)TRADE_BUTTON_LABEL_TEXT, button -> this.trade(2)).method_46434(this.field_2776 + 107, this.field_2800 + 64, 50, 20).method_46431());
        this.shopIdentifierField = new class_342(this.field_22793, this.field_22789 / 2 - 154, 114, 300, 20, (class_2561)class_2561.method_43473());
        this.shopIdentifierField.method_1880(128);
        this.shopIdentifierField.method_1852(this.shopBlockEntity.getShopIdentifier());
        this.method_25429((class_364)this.shopIdentifierField);
        this.saveCreativeButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.saveCreative()).method_46434(this.field_22789 / 2 - 4 - 150, 210, 150, 20).method_46431());
        this.cancelCreativeButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24335, button -> this.cancel()).method_46434(this.field_22789 / 2 + 4, 210, 150, 20).method_46431());
        Shop shop = ((ShopScreenHandler)this.field_2797).getShop();
        if (shop != null) {
            ((ShopScreenHandler)this.field_2797).calculateUnlockedAndStockedDeals();
            this.calculateActiveDeals();
            this.shopTitle = class_2561.method_43471((String)shop.shopTitle());
            this.playerOffersTitle = class_2561.method_43471((String)shop.offersTitle());
        } else {
            this.updateWidgets();
        }
    }

    private void updateWidgets() {
        this.tradeButton0.field_22764 = false;
        this.tradeButton1.field_22764 = false;
        this.tradeButton2.field_22764 = false;
        this.shopIdentifierField.method_1862(false);
        this.saveCreativeButton.field_22764 = false;
        this.cancelCreativeButton.field_22764 = false;
        int index = 0;
        for (int i = 0; i < Math.min(3, ((ShopScreenHandler)this.field_2797).getUnlockedDealsCounter()); ++i) {
            if (index == 0) {
                this.tradeButton0.field_22764 = true;
            } else if (index == 1) {
                this.tradeButton1.field_22764 = true;
            } else if (index == 2) {
                this.tradeButton2.field_22764 = true;
            }
            ++index;
        }
        this.scrollPosition = 0;
        this.scrollAmount = 0.0f;
    }

    public void method_25410(class_310 client, int width, int height) {
        String string = this.shopIdentifierField.method_1882();
        this.method_25423(client, width, height);
        this.shopIdentifierField.method_1852(string);
        this.updateWidgets();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.mouseClicked = false;
        if (((ShopScreenHandler)this.field_2797).getUnlockedDealsCounter() > 3) {
            int i = this.field_2776 + this.field_2792 - 14;
            int j = this.field_2800 + 99;
            if (mouseX >= (double)i && mouseX < (double)(i + 6) && mouseY >= (double)j && mouseY < (double)(j + 90)) {
                this.mouseClicked = true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (((ShopScreenHandler)this.field_2797).getUnlockedDealsCounter() > 3 && this.mouseClicked) {
            int i = ((ShopScreenHandler)this.field_2797).getUnlockedDealsCounter() - 3;
            float f = (float)deltaY / (float)i;
            this.scrollAmount = class_3532.method_15363((float)(this.scrollAmount + f), (float)0.0f, (float)1.0f);
            this.scrollPosition = (int)(this.scrollAmount * (float)i);
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (((ShopScreenHandler)this.field_2797).getUnlockedDealsCounter() > 3 && mouseX >= (double)(this.field_2776 + 7) && mouseX <= (double)(this.field_2776 + this.field_2792 - 7) && mouseY >= (double)(this.field_2800 + 98) && mouseY <= (double)(this.field_2800 + 190)) {
            int i = ((ShopScreenHandler)this.field_2797).getUnlockedDealsCounter() - 3;
            float f = (float)verticalAmount / (float)i;
            this.scrollAmount = class_3532.method_15363((float)(this.scrollAmount - f), (float)0.0f, (float)1.0f);
            this.scrollPosition = (int)(this.scrollAmount * (float)i);
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        int index = 0;
        for (int i = this.scrollPosition; i < Math.min(this.scrollPosition + 3, ((ShopScreenHandler)this.field_2797).getUnlockedDealsCounter()) && i <= ((ShopScreenHandler)this.field_2797).getUnlockedDealsList().size(); ++i) {
            int k;
            Shop.Deal deal = ((ShopScreenHandler)this.field_2797).getUnlockedDealsList().get(i);
            if (deal != null) {
                int y;
                int x;
                int j;
                for (j = 0; j < deal.offer().size(); ++j) {
                    class_1799 offerStack = deal.offer().get(j);
                    x = this.field_2776 + 85 + j * 18;
                    y = this.field_2800 + 18 + index * 24;
                    k = x + y * this.field_2792;
                    context.method_55231(offerStack, x, y, k);
                    context.method_51431(this.field_22793, offerStack, x, y);
                }
                for (j = 0; j < deal.price().size(); ++j) {
                    class_1799 priceStack = deal.price().get(j);
                    x = this.field_2776 + 8 + j * 18;
                    y = this.field_2800 + 18 + index * 24;
                    k = x + y * this.field_2792;
                    context.method_55231(priceStack, x, y, k);
                    context.method_51431(this.field_22793, priceStack, x, y);
                }
                context.method_52706(((ShopScreenHandler)this.field_2797).getStockedDealsList().get(i) != null ? HAS_STOCK_TEXTURE : OUT_OF_STOCK_TEXTURE, this.field_2776 + 55, this.field_2800 + 16 + index * 24, 28, 21);
                ++index;
            }
            if (((ShopScreenHandler)this.field_2797).getUnlockedDealsCounter() <= 3) continue;
            context.method_52706(SCROLL_BAR_BACKGROUND_8_68_TEXTURE, this.field_2776 + 161, this.field_2800 + 16, 8, 68);
            k = (int)(59.0f * this.scrollAmount);
            context.method_52706(SCROLLER_VERTICAL_6_7_TEXTURE, this.field_2776 + 161 + 1, this.field_2800 + 16 + 1 + k, 6, 7);
        }
    }

    protected void method_2388(class_332 context, int mouseX, int mouseY) {
        context.method_51439(this.field_22793, this.shopTitle, this.field_25267, this.field_25268, 0x404040, false);
        context.method_51439(this.field_22793, this.playerOffersTitle, this.field_25267, this.field_25268 + 80, 0x404040, false);
        context.method_51439(this.field_22793, this.field_29347, this.field_25269, this.field_25270, 0x404040, false);
    }

    public void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        int i = this.field_2776;
        int j = this.field_2800;
        context.method_25290(SHOP_BACKGROUND_TEXTURE, i, j, 0.0f, 0.0f, this.field_2792, this.field_2779, this.field_2792, this.field_2779);
    }

    private boolean updateShopBlockCreative() {
        ClientPlayNetworking.send((class_8710)new UpdateShopBlockPacket(this.shopBlockEntity.method_11016(), this.shopIdentifierField.method_1882()));
        return true;
    }

    private void onInventoryChange() {
        this.calculateActiveDeals();
    }
}

