/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.scriptblocks.gui.screen.ingame;

import com.github.theredbrain.scriptblocks.ScriptBlocks;
import com.github.theredbrain.scriptblocks.block.entity.TeleporterBlockEntity;
import com.github.theredbrain.scriptblocks.data.CommonDataStructures;
import com.github.theredbrain.scriptblocks.data.Location;
import com.github.theredbrain.scriptblocks.network.DuckClientAdvancementManagerMixin;
import com.github.theredbrain.scriptblocks.network.packet.AddStatusEffectPacket;
import com.github.theredbrain.scriptblocks.network.packet.SetManualResetLocationControlBlockPacket;
import com.github.theredbrain.scriptblocks.network.packet.TeleportFromTeleporterBlockPacket;
import com.github.theredbrain.scriptblocks.registry.CustomDynamicRegistries;
import com.github.theredbrain.scriptblocks.registry.StatusEffectsRegistry;
import com.github.theredbrain.scriptblocks.screen.TeleporterBlockScreenHandler;
import com.github.theredbrain.scriptblocks.util.LocationUtils;
import com.github.theredbrain.slotcustomizationapi.api.SlotCustomization;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1277;
import net.minecraft.class_161;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_268;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_632;
import net.minecraft.class_640;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import net.minecraft.class_8779;
import org.apache.commons.lang3.tuple.MutablePair;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class TeleporterBlockScreen
extends class_465<TeleporterBlockScreenHandler> {
    private static final class_2561 EDIT_BUTTON_LABEL_TEXT = class_2561.method_43471((String)"gui.edit");
    private static final class_2561 CANCEL_BUTTON_LABEL_TEXT = class_2561.method_43471((String)"gui.cancel");
    private static final class_2561 CHOOSE_BUTTON_LABEL_TEXT = class_2561.method_43471((String)"gui.choose");
    private static final class_2561 KEY_ITEM_IS_CONSUMED_TEXT = class_2561.method_43471((String)"gui.teleporter_block.key_item_is_consumed");
    private static final class_2561 KEY_ITEM_IS_REQUIRED_TEXT = class_2561.method_43471((String)"gui.teleporter_block.key_item_is_required");
    private static final class_2561 LOCATION_IS_PUBLIC_TEXT = class_2561.method_43471((String)"gui.teleporter_block.location_is_public");
    private static final class_2960 SCROLL_BAR_BACKGROUND_8_95_TEXTURE = ScriptBlocks.identifier("scroll_bar/scroll_bar_background_8_95");
    private static final class_2960 SCROLLER_TEXTURE = ScriptBlocks.identifier("scroll_bar/scroller_vertical_6_7");
    public static final class_2960 ADVENTURE_TELEPORTER_SCREEN_BACKGROUND_TEXTURE = ScriptBlocks.identifier("textures/gui/container/teleporter_block/adventure_teleporter_screen.png");
    public static final class_2960 ADVENTURE_TELEPORTER_LOCATIONS_SCREEN_BACKGROUND_TEXTURE = ScriptBlocks.identifier("textures/gui/container/teleporter_block/adventure_teleporter_locations_screen.png");
    private final TeleporterBlockScreenHandler handler;
    private TeleporterBlockEntity teleporterBlock;
    private class_640 currentTargetOwner;
    private class_4185 openChooseTargetOwnerScreenButton;
    private class_4185 confirmChoosePublicButton;
    private class_4185 confirmChooseCurrentPlayerButton;
    private class_4185 confirmChooseTeamMember0Button;
    private class_4185 confirmChooseTeamMember1Button;
    private class_4185 confirmChooseTeamMember2Button;
    private class_4185 confirmChooseTeamMember3Button;
    private class_4185 cancelChooseTargetOwnerButton;
    private String currentTargetIdentifier;
    private String currentTargetDisplayName;
    private class_4185 openChooseTargetIdentifierScreenButton;
    private class_4185 confirmChooseTargetIdentifier0Button;
    private class_4185 confirmChooseTargetIdentifier1Button;
    private class_4185 confirmChooseTargetIdentifier2Button;
    private class_4185 confirmChooseTargetIdentifier3Button;
    private class_4185 cancelChooseTargetIdentifierButton;
    private String currentTargetEntrance;
    private String currentTargetEntranceDisplayName;
    private String currentTargetEntranceDataId;
    private String currentTargetEntranceData;
    private class_4185 teleportButton;
    private class_4185 cancelTeleportButton;
    private class_4185 openDungeonRegenerationScreenButton;
    private class_4185 confirmDungeonRegenerationButton;
    private class_4185 cancelDungeonRegenerationButton;
    private boolean showCurrentEntranceDisplayNameFirst;
    private boolean showChooseTargetOwnerScreen;
    private boolean showChooseTargetIdentifierScreen;
    private boolean showRegenerationConfirmScreen;
    private boolean canOwnerBeChosen;
    private boolean showAdventureScreen;
    private boolean showRegenerateButton;
    private TeleporterBlockEntity.TeleportationMode teleportationMode;
    List<MutablePair<MutablePair<String, String>, MutablePair<String, String>>> locationsList = new ArrayList<MutablePair<MutablePair<String, String>, MutablePair<String, String>>>();
    List<MutablePair<MutablePair<String, String>, MutablePair<String, String>>> visibleLocationsList = new ArrayList<MutablePair<MutablePair<String, String>, MutablePair<String, String>>>();
    List<MutablePair<MutablePair<String, String>, MutablePair<String, String>>> unlockedLocationsList = new ArrayList<MutablePair<MutablePair<String, String>, MutablePair<String, String>>>();
    MutablePair<MutablePair<String, String>, MutablePair<String, String>> dataDrivenLocation = new MutablePair();
    List<class_640> partyMemberList = new ArrayList<class_640>();
    private int partyMemberListScrollPosition = 0;
    private int visibleLocationsListScrollPosition = 0;
    private float partyMemberListScrollAmount = 0.0f;
    private float visibleLocationsListScrollAmount = 0.0f;
    private boolean partyMemberListMouseClicked = false;
    private boolean visibleLocationsListMouseClicked = false;
    private boolean isTeleportButtonActive = true;
    private boolean canLocationBeRegenerated = false;
    private boolean isRegenerateButtonActive = true;
    private boolean showCurrentLockAdvancement;
    private boolean showCurrentUnlockAdvancement;
    private boolean isCurrentLocationUnlocked;
    @Nullable
    private class_161 currentLockAdvancement;
    @Nullable
    private class_161 currentUnlockAdvancement;
    private boolean isCurrentLocationPublic;
    private boolean showCurrentLocationOwner;
    private List<CommonDataStructures.ItemCost> currentKeys;

    public TeleporterBlockScreen(TeleporterBlockScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        this.handler = handler;
    }

    private void cancelTeleport() {
        this.method_25419();
    }

    private void openChooseCurrentTargetOwnerScreen() {
        class_268 team;
        this.partyMemberList.clear();
        if (this.field_22787 != null && this.field_22787.field_1724 != null && (team = this.field_22787.field_1724.method_5781()) != null) {
            for (String name : team.method_1204()) {
                if (this.field_22787.field_1724.method_5477().getString().equals(name)) continue;
                this.partyMemberList.add(this.field_22787.field_1724.field_3944.method_2874(name));
            }
        }
        this.showChooseTargetOwnerScreen = true;
        this.updateWidgets();
    }

    private void chooseTargetOwner(int index) {
        this.canLocationBeRegenerated = false;
        if (index == -2) {
            this.currentTargetOwner = null;
        } else if (index == -1 && this.field_22787 != null && this.field_22787.field_1724 != null) {
            this.currentTargetOwner = this.field_22787.field_1724.field_3944.method_2871(this.field_22787.field_1724.method_5667());
            this.canLocationBeRegenerated = true;
        } else {
            this.currentTargetOwner = this.partyMemberList.get(this.partyMemberListScrollPosition + index);
        }
        this.showChooseTargetOwnerScreen = false;
        this.calculateUnlockedAndVisibleLocations(false);
        this.updateWidgets();
    }

    private void cancelChooseCurrentTargetOwner() {
        this.showChooseTargetOwnerScreen = false;
        this.updateWidgets();
    }

    private void openChooseTargetIdentifierScreen() {
        this.showChooseTargetIdentifierScreen = true;
        this.updateWidgets();
    }

    private void chooseTargetIdentifier(int index) {
        this.currentTargetIdentifier = (String)((MutablePair)this.visibleLocationsList.get(this.visibleLocationsListScrollPosition + index).getLeft()).getLeft();
        this.currentTargetEntrance = (String)((MutablePair)this.visibleLocationsList.get(this.visibleLocationsListScrollPosition + index).getLeft()).getRight();
        this.currentTargetEntranceDataId = (String)((MutablePair)this.visibleLocationsList.getFirst().getRight()).getLeft();
        this.currentTargetEntranceData = (String)((MutablePair)this.visibleLocationsList.getFirst().getRight()).getRight();
        this.showChooseTargetIdentifierScreen = false;
        this.calculateUnlockedAndVisibleLocations(false);
        this.updateWidgets();
    }

    private void cancelChooseTargetLocation() {
        this.showChooseTargetIdentifierScreen = false;
        this.updateWidgets();
    }

    private void openDungeonRegenerationConfirmScreen() {
        this.showRegenerationConfirmScreen = true;
        this.updateWidgets();
    }

    private void confirmDungeonRegeneration() {
        if (this.tryDungeonRegeneration()) {
            this.showRegenerationConfirmScreen = false;
            this.updateWidgets();
        }
    }

    private void cancelDungeonRegeneration() {
        this.showRegenerationConfirmScreen = false;
        this.updateWidgets();
    }

    public void method_25419() {
        this.givePortalResistanceEffect();
        super.method_25419();
    }

    protected void method_25426() {
        if (this.field_22787 != null && this.field_22787.field_1687 != null) {
            class_2586 blockEntity = this.field_22787.field_1687.method_8321(this.handler.getBlockPos());
            if (blockEntity instanceof TeleporterBlockEntity) {
                this.teleporterBlock = (TeleporterBlockEntity)blockEntity;
            }
            if (this.field_22787.field_1724 != null) {
                this.currentTargetOwner = this.field_22787.field_1724.field_3944.method_2871(this.field_22787.field_1724.method_5667());
                this.canLocationBeRegenerated = true;
            }
        }
        this.locationsList.clear();
        this.locationsList.addAll(this.teleporterBlock.getLocationsList());
        this.dataDrivenLocation = this.teleporterBlock.getDataDrivenLocation();
        this.canOwnerBeChosen = this.teleporterBlock.canOwnerBeChosen();
        this.showAdventureScreen = this.teleporterBlock.getShowAdventureScreen();
        this.teleportationMode = this.teleporterBlock.getTeleportationMode();
        this.showRegenerateButton = this.teleporterBlock.showRegenerateButton();
        this.currentTargetIdentifier = "";
        this.currentTargetDisplayName = "";
        this.currentTargetEntrance = "";
        this.currentTargetEntranceDisplayName = "";
        this.currentTargetEntranceDataId = "";
        this.currentTargetEntranceData = "";
        if (this.teleportationMode == TeleporterBlockEntity.TeleportationMode.DIRECT || this.teleportationMode == TeleporterBlockEntity.TeleportationMode.SPAWN_POINTS) {
            if (!this.showAdventureScreen) {
                this.teleport();
            }
        } else {
            this.calculateUnlockedAndVisibleLocations(true);
            if (this.visibleLocationsList.isEmpty()) {
                this.method_25419();
            }
            if (!this.showAdventureScreen && this.teleportationMode == TeleporterBlockEntity.TeleportationMode.LOCATION && !this.unlockedLocationsList.isEmpty()) {
                this.teleport();
            }
        }
        this.field_2792 = 218;
        this.field_2779 = this.teleporterBlock.getTeleportationMode() == TeleporterBlockEntity.TeleportationMode.LOCATIONS ? 171 : 47;
        super.method_25426();
        this.openChooseTargetIdentifierScreenButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)EDIT_BUTTON_LABEL_TEXT, button -> this.openChooseTargetIdentifierScreen()).method_46434(this.field_2776 + this.field_2792 - 57, this.field_2800 + 21, 50, 20).method_46431());
        this.confirmChooseTargetIdentifier0Button = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)CHOOSE_BUTTON_LABEL_TEXT, button -> this.chooseTargetIdentifier(0)).method_46434(this.field_2776 + this.field_2792 - 57, this.field_2800 + 20, 50, 20).method_46431());
        this.confirmChooseTargetIdentifier1Button = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)CHOOSE_BUTTON_LABEL_TEXT, button -> this.chooseTargetIdentifier(1)).method_46434(this.field_2776 + this.field_2792 - 57, this.field_2800 + 44, 50, 20).method_46431());
        this.confirmChooseTargetIdentifier2Button = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)CHOOSE_BUTTON_LABEL_TEXT, button -> this.chooseTargetIdentifier(2)).method_46434(this.field_2776 + this.field_2792 - 57, this.field_2800 + 68, 50, 20).method_46431());
        this.confirmChooseTargetIdentifier3Button = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)CHOOSE_BUTTON_LABEL_TEXT, button -> this.chooseTargetIdentifier(3)).method_46434(this.field_2776 + this.field_2792 - 57, this.field_2800 + 92, 50, 20).method_46431());
        this.cancelChooseTargetIdentifierButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)CANCEL_BUTTON_LABEL_TEXT, button -> this.cancelChooseTargetLocation()).method_46434(this.field_2776 + 7, this.field_2800 + this.field_2779 - 27, this.field_2792 - 14, 20).method_46431());
        this.openChooseTargetOwnerScreenButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)EDIT_BUTTON_LABEL_TEXT, button -> this.openChooseCurrentTargetOwnerScreen()).method_46434(this.field_2776 + this.field_2792 - 57, this.field_2800 + 71, 50, 20).method_46431());
        this.confirmChoosePublicButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)CHOOSE_BUTTON_LABEL_TEXT, button -> this.chooseTargetOwner(-2)).method_46434(this.field_2776 + this.field_2792 - 57, this.field_2800 + 20, 50, 20).method_46431());
        this.confirmChooseCurrentPlayerButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)CHOOSE_BUTTON_LABEL_TEXT, button -> this.chooseTargetOwner(-1)).method_46434(this.field_2776 + this.field_2792 - 57, this.field_2800 + 44, 50, 20).method_46431());
        this.confirmChooseTeamMember0Button = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)CHOOSE_BUTTON_LABEL_TEXT, button -> this.chooseTargetOwner(0)).method_46434(this.field_2776 + this.field_2792 - 57, this.field_2800 + 68, 50, 20).method_46431());
        this.confirmChooseTeamMember1Button = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)CHOOSE_BUTTON_LABEL_TEXT, button -> this.chooseTargetOwner(1)).method_46434(this.field_2776 + this.field_2792 - 57, this.field_2800 + 92, 50, 20).method_46431());
        this.confirmChooseTeamMember2Button = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)CHOOSE_BUTTON_LABEL_TEXT, button -> this.chooseTargetOwner(2)).method_46434(this.field_2776 + this.field_2792 - 57, this.field_2800 + 116, 50, 20).method_46431());
        this.confirmChooseTeamMember3Button = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)CHOOSE_BUTTON_LABEL_TEXT, button -> this.chooseTargetOwner(3)).method_46434(this.field_2776 + this.field_2792 - 57, this.field_2800 + 140, 50, 20).method_46431());
        this.cancelChooseTargetOwnerButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)CANCEL_BUTTON_LABEL_TEXT, button -> this.cancelChooseCurrentTargetOwner()).method_46434(this.field_2776 + 7, this.field_2800 + this.field_2779 - 27, this.field_2792 - 14, 20).method_46431());
        this.openDungeonRegenerationScreenButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)EDIT_BUTTON_LABEL_TEXT, button -> this.openDungeonRegenerationConfirmScreen()).method_46434(this.field_2776 + 7, this.field_2800 + this.field_2779 - 51, this.field_2792 - 14, 20).method_46431());
        this.confirmDungeonRegenerationButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)CHOOSE_BUTTON_LABEL_TEXT, button -> this.confirmDungeonRegeneration()).method_46434(this.field_2776 + 7, this.field_2800 + this.field_2779 - 27, (this.field_2792 - 18) / 2, 20).method_46431());
        this.cancelDungeonRegenerationButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)CANCEL_BUTTON_LABEL_TEXT, button -> this.cancelDungeonRegeneration()).method_46434(this.field_2776 + this.field_2792 / 2 + 2, this.field_2800 + this.field_2779 - 27, (this.field_2792 - 18) / 2, 20).method_46431());
        this.teleportButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)this.teleporterBlock.getTeleportButtonLabel()), button -> this.teleport()).method_46434(this.field_2776 + 7, this.field_2800 + this.field_2779 - 27, 100, 20).method_46431());
        this.cancelTeleportButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)this.teleporterBlock.getCancelTeleportButtonLabel()), button -> this.cancelTeleport()).method_46434(this.field_2776 + this.field_2792 - 107, this.field_2800 + this.field_2779 - 27, 100, 20).method_46431());
        this.updateWidgets();
    }

    protected void method_56131() {
        this.method_48265((class_364)this.teleportButton);
    }

    private void updateWidgets() {
        this.openChooseTargetIdentifierScreenButton.field_22764 = false;
        this.confirmChooseTargetIdentifier0Button.field_22764 = false;
        this.confirmChooseTargetIdentifier1Button.field_22764 = false;
        this.confirmChooseTargetIdentifier2Button.field_22764 = false;
        this.confirmChooseTargetIdentifier3Button.field_22764 = false;
        this.cancelChooseTargetIdentifierButton.field_22764 = false;
        this.openChooseTargetOwnerScreenButton.field_22764 = false;
        this.confirmChoosePublicButton.field_22764 = false;
        this.confirmChooseCurrentPlayerButton.field_22764 = false;
        this.confirmChooseTeamMember0Button.field_22764 = false;
        this.confirmChooseTeamMember1Button.field_22764 = false;
        this.confirmChooseTeamMember2Button.field_22764 = false;
        this.confirmChooseTeamMember3Button.field_22764 = false;
        this.cancelChooseTargetOwnerButton.field_22764 = false;
        this.openDungeonRegenerationScreenButton.field_22764 = false;
        this.confirmDungeonRegenerationButton.field_22764 = false;
        this.cancelDungeonRegenerationButton.field_22764 = false;
        this.teleportButton.field_22764 = false;
        this.cancelTeleportButton.field_22764 = false;
        for (class_1735 slot : this.handler.field_7761) {
            ((SlotCustomization)slot).slotcustomizationapi$setDisabledOverride(true);
        }
        if (this.showChooseTargetIdentifierScreen) {
            int index = 0;
            for (int i = 0; i < Math.min(4, this.visibleLocationsList.size()); ++i) {
                if (index == 0) {
                    this.confirmChooseTargetIdentifier0Button.field_22764 = true;
                } else if (index == 1) {
                    this.confirmChooseTargetIdentifier1Button.field_22764 = true;
                } else if (index == 2) {
                    this.confirmChooseTargetIdentifier2Button.field_22764 = true;
                } else if (index == 3) {
                    this.confirmChooseTargetIdentifier3Button.field_22764 = true;
                }
                ++index;
            }
            this.cancelChooseTargetIdentifierButton.field_22764 = true;
        } else if (this.showChooseTargetOwnerScreen) {
            if (this.isCurrentLocationPublic) {
                this.confirmChooseCurrentPlayerButton.method_46419(this.field_2800 + 44);
                this.confirmChooseTeamMember0Button.method_46419(this.field_2800 + 68);
                this.confirmChooseTeamMember1Button.method_46419(this.field_2800 + 92);
                this.confirmChooseTeamMember2Button.method_46419(this.field_2800 + 116);
                this.confirmChooseTeamMember3Button.method_46419(this.field_2800 + 140);
                this.confirmChoosePublicButton.field_22764 = true;
            } else {
                this.confirmChooseCurrentPlayerButton.method_46419(this.field_2800 + 20);
                this.confirmChooseTeamMember0Button.method_46419(this.field_2800 + 44);
                this.confirmChooseTeamMember1Button.method_46419(this.field_2800 + 68);
                this.confirmChooseTeamMember2Button.method_46419(this.field_2800 + 92);
                this.confirmChooseTeamMember3Button.method_46419(this.field_2800 + 116);
            }
            if (!this.isCurrentLocationPublic) {
                this.confirmChooseCurrentPlayerButton.field_22764 = true;
                int index = 0;
                for (int i = 0; i < Math.min(4, this.partyMemberList.size()); ++i) {
                    if (index == 0) {
                        this.confirmChooseTeamMember0Button.field_22764 = true;
                    } else if (index == 1) {
                        this.confirmChooseTeamMember1Button.field_22764 = true;
                    } else if (index == 2) {
                        this.confirmChooseTeamMember2Button.field_22764 = true;
                    } else if (index == 3) {
                        this.confirmChooseTeamMember3Button.field_22764 = true;
                    }
                    ++index;
                }
            }
            this.cancelChooseTargetOwnerButton.field_22764 = true;
        } else if (this.showRegenerationConfirmScreen) {
            this.confirmDungeonRegenerationButton.field_22764 = true;
            this.cancelDungeonRegenerationButton.field_22764 = true;
        } else if (this.showAdventureScreen) {
            if (this.teleportationMode == TeleporterBlockEntity.TeleportationMode.LOCATIONS) {
                this.openChooseTargetIdentifierScreenButton.field_22764 = this.visibleLocationsList.size() > 1;
                this.openChooseTargetOwnerScreenButton.field_22764 = this.canOwnerBeChosen && !this.isCurrentLocationPublic;
                this.openDungeonRegenerationScreenButton.field_22764 = this.showRegenerateButton;
                this.openDungeonRegenerationScreenButton.field_22763 = this.isRegenerateButtonActive;
            }
            this.teleportButton.field_22764 = true;
            this.cancelTeleportButton.field_22764 = true;
            this.teleportButton.field_22763 = this.isTeleportButtonActive;
        }
    }

    private void calculateUnlockedAndVisibleLocations(boolean shouldInit) {
        Optional optionalLocationReference;
        class_1937 world;
        Object location;
        class_2960 unlockAdvancementIdentifier;
        class_2960 lockAdvancementIdentifier;
        class_632 advancementHandler = null;
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            advancementHandler = this.field_22787.field_1724.field_3944.method_2869();
        }
        if (shouldInit && (this.teleporterBlock.getTeleportationMode() == TeleporterBlockEntity.TeleportationMode.LOCATIONS || this.teleporterBlock.getTeleportationMode() == TeleporterBlockEntity.TeleportationMode.LOCATION)) {
            this.unlockedLocationsList.clear();
            this.visibleLocationsList.clear();
            if (this.teleporterBlock.getTeleportationMode() == TeleporterBlockEntity.TeleportationMode.LOCATIONS) {
                for (MutablePair<MutablePair<String, String>, MutablePair<String, String>> entry : this.locationsList) {
                    Optional optionalLocationReference2;
                    Location location2 = null;
                    class_1937 world2 = this.teleporterBlock.method_10997();
                    if (world2 != null && (optionalLocationReference2 = world2.method_30349().method_30530(CustomDynamicRegistries.LOCATION_REGISTRY_KEY).method_55841(class_2960.method_60654((String)((String)((MutablePair)entry.getLeft()).getLeft())))).isPresent()) {
                        location2 = (Location)((class_6880.class_6883)optionalLocationReference2.get()).comp_349();
                    }
                    if (location2 == null) continue;
                    String entrance = (String)((MutablePair)entry.getLeft()).getRight();
                    lockAdvancementIdentifier = LocationUtils.lockAdvancementForEntrance(location2, entrance);
                    unlockAdvancementIdentifier = LocationUtils.unlockAdvancementForEntrance(location2, entrance);
                    showLockedLocation = LocationUtils.showLockedLocationForEntrance(location2, entrance);
                    if (advancementHandler == null) continue;
                    class_8779 lockAdvancementEntry = null;
                    if (lockAdvancementIdentifier != null) {
                        lockAdvancementEntry = advancementHandler.method_53815(lockAdvancementIdentifier);
                    }
                    class_8779 unlockAdvancementEntry = null;
                    if (unlockAdvancementIdentifier != null) {
                        unlockAdvancementEntry = advancementHandler.method_53815(unlockAdvancementIdentifier);
                    }
                    if ((lockAdvancementIdentifier == null || lockAdvancementEntry != null && !((DuckClientAdvancementManagerMixin)advancementHandler).scriptblocks$getAdvancementProgress(lockAdvancementEntry.comp_1920()).method_740()) && (unlockAdvancementIdentifier == null || unlockAdvancementEntry != null && ((DuckClientAdvancementManagerMixin)advancementHandler).scriptblocks$getAdvancementProgress(unlockAdvancementEntry.comp_1920()).method_740())) {
                        this.unlockedLocationsList.add(entry);
                        this.visibleLocationsList.add(entry);
                        continue;
                    }
                    if (!showLockedLocation) continue;
                    this.visibleLocationsList.add(entry);
                }
            } else if (this.teleporterBlock.getTeleportationMode() == TeleporterBlockEntity.TeleportationMode.LOCATION) {
                location = null;
                world = this.teleporterBlock.method_10997();
                if (world != null && (optionalLocationReference = world.method_30349().method_30530(CustomDynamicRegistries.LOCATION_REGISTRY_KEY).method_55841(class_2960.method_60654((String)((String)((MutablePair)this.dataDrivenLocation.getLeft()).getLeft())))).isPresent()) {
                    location = (Location)((class_6880.class_6883)optionalLocationReference.get()).comp_349();
                }
                if (location != null) {
                    String entrance = (String)((MutablePair)this.dataDrivenLocation.getLeft()).getRight();
                    lockAdvancementIdentifier = LocationUtils.lockAdvancementForEntrance((Location)location, entrance);
                    unlockAdvancementIdentifier = LocationUtils.unlockAdvancementForEntrance((Location)location, entrance);
                    showLockedLocation = LocationUtils.showLockedLocationForEntrance((Location)location, entrance);
                    if (advancementHandler != null) {
                        class_8779 lockAdvancementEntry = null;
                        if (lockAdvancementIdentifier != null) {
                            lockAdvancementEntry = advancementHandler.method_53815(lockAdvancementIdentifier);
                        }
                        class_8779 unlockAdvancementEntry = null;
                        if (unlockAdvancementIdentifier != null) {
                            unlockAdvancementEntry = advancementHandler.method_53815(unlockAdvancementIdentifier);
                        }
                        if ((lockAdvancementIdentifier == null || lockAdvancementEntry != null && !((DuckClientAdvancementManagerMixin)advancementHandler).scriptblocks$getAdvancementProgress(lockAdvancementEntry.comp_1920()).method_740()) && (unlockAdvancementIdentifier == null || unlockAdvancementEntry != null && ((DuckClientAdvancementManagerMixin)advancementHandler).scriptblocks$getAdvancementProgress(unlockAdvancementEntry.comp_1920()).method_740())) {
                            this.unlockedLocationsList.add(this.dataDrivenLocation);
                            this.visibleLocationsList.add(this.dataDrivenLocation);
                        } else if (showLockedLocation) {
                            this.visibleLocationsList.add(this.dataDrivenLocation);
                        }
                    }
                }
            }
            if (!this.visibleLocationsList.isEmpty()) {
                this.currentTargetIdentifier = (String)((MutablePair)this.visibleLocationsList.getFirst().getLeft()).getLeft();
                this.currentTargetEntrance = (String)((MutablePair)this.visibleLocationsList.getFirst().getLeft()).getRight();
                this.currentTargetEntranceDataId = (String)((MutablePair)this.visibleLocationsList.getFirst().getRight()).getLeft();
                this.currentTargetEntranceData = (String)((MutablePair)this.visibleLocationsList.getFirst().getRight()).getRight();
            }
        }
        for (MutablePair<MutablePair<String, String>, MutablePair<String, String>> dungeonLocation : this.unlockedLocationsList) {
            if (!Objects.equals(((MutablePair)dungeonLocation.getLeft()).getLeft(), this.currentTargetIdentifier)) continue;
            this.isCurrentLocationUnlocked = true;
        }
        location = null;
        world = this.teleporterBlock.method_10997();
        if (world != null && (optionalLocationReference = world.method_30349().method_30530(CustomDynamicRegistries.LOCATION_REGISTRY_KEY).method_55841(class_2960.method_12829((String)this.currentTargetIdentifier))).isPresent()) {
            location = (Location)((class_6880.class_6883)optionalLocationReference.get()).comp_349();
        }
        if (location != null) {
            lockAdvancementIdentifier = LocationUtils.lockAdvancementForEntrance(location, this.currentTargetEntrance);
            unlockAdvancementIdentifier = LocationUtils.unlockAdvancementForEntrance(location, this.currentTargetEntrance);
            this.currentTargetDisplayName = ((Location)location).displayName();
            this.currentTargetEntranceDisplayName = LocationUtils.getEntranceDisplayName((Location)location, this.currentTargetEntrance);
            this.showCurrentEntranceDisplayNameFirst = LocationUtils.isEntranceNameShownFirst((Location)location, this.currentTargetEntrance);
            this.isCurrentLocationPublic = ((Location)location).isPublic();
            this.currentKeys = LocationUtils.getKeyForEntrance((Location)location, this.currentTargetEntrance);
            this.showCurrentLocationOwner = LocationUtils.showLocationOwnerForEntrance((Location)location, this.currentTargetEntrance);
            if (advancementHandler != null) {
                class_8779 lockAdvancementEntry = null;
                if (lockAdvancementIdentifier != null) {
                    lockAdvancementEntry = advancementHandler.method_53815(lockAdvancementIdentifier);
                }
                class_8779 unlockAdvancementEntry = null;
                if (unlockAdvancementIdentifier != null) {
                    unlockAdvancementEntry = advancementHandler.method_53815(unlockAdvancementIdentifier);
                }
                if (lockAdvancementEntry != null) {
                    this.currentLockAdvancement = lockAdvancementEntry.comp_1920();
                }
                if (unlockAdvancementEntry != null) {
                    this.currentUnlockAdvancement = unlockAdvancementEntry.comp_1920();
                }
                class_1277 inventory = new class_1277(36);
                for (int k = 0; k < 36; ++k) {
                    class_1799 itemStack = this.handler.getPlayerInventory().method_5438(k);
                    inventory.method_5447(k, itemStack.method_7972());
                }
                boolean bl = true;
                if (!this.currentKeys.isEmpty()) {
                    for (CommonDataStructures.ItemCost itemCost : this.currentKeys) {
                        class_1799 currentKeyItemStack = itemCost.itemStack();
                        int keyCount = currentKeyItemStack.method_7947();
                        for (int j = 0; j < inventory.method_5439(); ++j) {
                            class_1799 itemStack = inventory.method_5438(j);
                            if (!class_1799.method_31577((class_1799)currentKeyItemStack, (class_1799)itemStack)) continue;
                            int stackCount = inventory.method_5438(j).method_7947();
                            if (stackCount >= keyCount) {
                                inventory.method_5434(j, keyCount);
                                keyCount = 0;
                                break;
                            }
                            inventory.method_5447(j, class_1799.field_8037);
                            keyCount -= stackCount;
                        }
                        if (keyCount <= 0) continue;
                        bl = false;
                    }
                }
                this.isRegenerateButtonActive = this.isCurrentLocationUnlocked && this.canLocationBeRegenerated && this.currentTargetOwner != null;
                this.isTeleportButtonActive = this.isCurrentLocationUnlocked && bl;
            }
        }
    }

    public void method_25410(class_310 client, int width, int height) {
        String string = this.currentTargetIdentifier;
        String string1 = this.currentTargetDisplayName;
        String string2 = this.currentTargetEntrance;
        String string3 = this.currentTargetEntranceDisplayName;
        String string4 = this.currentTargetEntranceDataId;
        String string5 = this.currentTargetEntranceData;
        ArrayList<MutablePair<MutablePair<String, String>, MutablePair<String, String>>> list = new ArrayList<MutablePair<MutablePair<String, String>, MutablePair<String, String>>>(this.locationsList);
        ArrayList<MutablePair<MutablePair<String, String>, MutablePair<String, String>>> list1 = new ArrayList<MutablePair<MutablePair<String, String>, MutablePair<String, String>>>(this.visibleLocationsList);
        ArrayList<MutablePair<MutablePair<String, String>, MutablePair<String, String>>> list2 = new ArrayList<MutablePair<MutablePair<String, String>, MutablePair<String, String>>>(this.unlockedLocationsList);
        ArrayList<class_640> list3 = new ArrayList<class_640>(this.partyMemberList);
        this.method_25423(client, width, height);
        this.currentTargetIdentifier = string;
        this.currentTargetDisplayName = string1;
        this.currentTargetEntrance = string2;
        this.currentTargetEntranceDisplayName = string3;
        this.currentTargetEntranceDataId = string4;
        this.currentTargetEntranceData = string5;
        this.locationsList.clear();
        this.visibleLocationsList.clear();
        this.unlockedLocationsList.clear();
        this.partyMemberList.clear();
        this.locationsList.addAll(list);
        this.visibleLocationsList.addAll(list1);
        this.unlockedLocationsList.addAll(list2);
        this.partyMemberList.addAll(list3);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int j;
        int i;
        this.partyMemberListMouseClicked = false;
        this.visibleLocationsListMouseClicked = false;
        if (this.showChooseTargetOwnerScreen) {
            i = this.field_2776 - 13;
            j = this.field_2800 + 134;
            if (mouseX >= (double)i && mouseX < (double)(i + 6) && mouseY >= (double)j && mouseY < (double)(j + 30)) {
                this.partyMemberListMouseClicked = true;
            }
        }
        if (this.showChooseTargetIdentifierScreen && this.teleportationMode == TeleporterBlockEntity.TeleportationMode.LOCATIONS && this.visibleLocationsList.size() > 4) {
            i = this.field_2776 + 8;
            j = this.field_2800 + 21;
            if (mouseX >= (double)i && mouseX < (double)(i + 6) && mouseY >= (double)j && mouseY < (double)(j + 90)) {
                this.visibleLocationsListMouseClicked = true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        float f;
        int i;
        if (this.showChooseTargetOwnerScreen && this.partyMemberList.size() > 4 && this.partyMemberListMouseClicked) {
            i = this.partyMemberList.size() - 4;
            f = (float)deltaY / (float)i;
            this.partyMemberListScrollAmount = class_3532.method_15363((float)(this.partyMemberListScrollAmount + f), (float)0.0f, (float)1.0f);
            this.partyMemberListScrollPosition = (int)(this.partyMemberListScrollAmount * (float)i);
        }
        if (this.showChooseTargetIdentifierScreen && this.teleportationMode == TeleporterBlockEntity.TeleportationMode.LOCATIONS && this.visibleLocationsList.size() > 4 && this.visibleLocationsListMouseClicked) {
            i = this.visibleLocationsList.size() - 4;
            f = (float)deltaY / (float)i;
            this.visibleLocationsListScrollAmount = class_3532.method_15363((float)(this.visibleLocationsListScrollAmount + f), (float)0.0f, (float)1.0f);
            this.visibleLocationsListScrollPosition = (int)(this.visibleLocationsListScrollAmount * (float)i);
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        float f;
        int i;
        if (this.showChooseTargetOwnerScreen && this.partyMemberList.size() > 4 && mouseX >= (double)(this.field_2776 + 7) && mouseX <= (double)(this.field_2776 + this.field_2792 - 61) && mouseY >= (double)(this.field_2800 + 20) && mouseY <= (double)(this.field_2800 + 112)) {
            i = this.partyMemberList.size() - 4;
            f = (float)verticalAmount / (float)i;
            this.partyMemberListScrollAmount = class_3532.method_15363((float)(this.partyMemberListScrollAmount - f), (float)0.0f, (float)1.0f);
            this.partyMemberListScrollPosition = (int)(this.partyMemberListScrollAmount * (float)i);
        }
        if (this.showChooseTargetIdentifierScreen && this.teleportationMode == TeleporterBlockEntity.TeleportationMode.LOCATIONS && this.visibleLocationsList.size() > 4 && mouseX >= (double)(this.field_2776 + 7) && mouseX <= (double)(this.field_2776 + this.field_2792 - 61) && mouseY >= (double)(this.field_2800 + 20) && mouseY <= (double)(this.field_2800 + 112)) {
            i = this.visibleLocationsList.size() - 4;
            f = (float)verticalAmount / (float)i;
            this.visibleLocationsListScrollAmount = class_3532.method_15363((float)(this.visibleLocationsListScrollAmount - f), (float)0.0f, (float)1.0f);
            this.visibleLocationsListScrollPosition = (int)(this.visibleLocationsListScrollAmount * (float)i);
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.method_2380(context, mouseX, mouseY);
    }

    protected void method_2388(class_332 context, int mouseX, int mouseY) {
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        int x = this.field_2776;
        int y = this.field_2800;
        TeleporterBlockEntity.TeleportationMode mode = this.teleporterBlock.getTeleportationMode();
        if (this.showChooseTargetIdentifierScreen) {
            context.method_25290(ADVENTURE_TELEPORTER_LOCATIONS_SCREEN_BACKGROUND_TEXTURE, x, y, 0.0f, 0.0f, this.field_2792, this.field_2779, this.field_2792, this.field_2779);
            for (int i = this.visibleLocationsListScrollPosition; i < Math.min(this.visibleLocationsListScrollPosition + 4, this.visibleLocationsList.size()); ++i) {
                context.method_51433(this.field_22793, (String)((MutablePair)this.visibleLocationsList.get(i).getLeft()).getLeft(), x + 19, y + 26 + (i - this.visibleLocationsListScrollPosition) * 24, 0x404040, false);
            }
            if (this.visibleLocationsList.size() > 4) {
                context.method_52706(SCROLL_BAR_BACKGROUND_8_95_TEXTURE, x + 7, y + 20, 8, 92);
                int k = (int)(83.0f * this.visibleLocationsListScrollAmount);
                context.method_52706(SCROLLER_TEXTURE, x + 8, y + 20 + 1 + k, 6, 7);
            }
        } else if (this.showChooseTargetOwnerScreen) {
            if (!this.isCurrentLocationPublic) {
                context.method_25290(ADVENTURE_TELEPORTER_LOCATIONS_SCREEN_BACKGROUND_TEXTURE, x, y, 0.0f, 0.0f, this.field_2792, this.field_2779, this.field_2792, this.field_2779);
                for (int i = this.partyMemberListScrollPosition; i < Math.min(this.partyMemberListScrollPosition + 4, this.partyMemberList.size()); ++i) {
                    context.method_25293(this.partyMemberList.get(i).method_52810().comp_1626(), x + 7, y + 26 + (i - this.partyMemberListScrollPosition) * 24, 8, 8, 8.0f, 8.0f, 8, 8, 64, 64);
                    context.method_51433(this.field_22793, this.partyMemberList.get(i).method_2966().getName(), x + 19, y + 26 + (i - this.partyMemberListScrollPosition) * 24, 0x404040, false);
                }
                if (this.partyMemberList.size() > 4) {
                    context.method_52706(SCROLL_BAR_BACKGROUND_8_95_TEXTURE, x + 7, y + 20, 8, 92);
                    int k = (int)(83.0f * this.partyMemberListScrollAmount);
                    context.method_52706(SCROLLER_TEXTURE, x + 8, y + 20 + 1 + k, 6, 7);
                }
            }
        } else if (!this.showRegenerationConfirmScreen && this.showAdventureScreen) {
            if (mode == TeleporterBlockEntity.TeleportationMode.LOCATIONS) {
                context.method_25290(ADVENTURE_TELEPORTER_LOCATIONS_SCREEN_BACKGROUND_TEXTURE, x, y, 0.0f, 0.0f, this.field_2792, this.field_2779, this.field_2792, this.field_2779);
                class_5250 teleporterName = class_2561.method_43471((String)this.teleporterBlock.getTeleporterName());
                int teleporterNameOffset = this.field_2792 / 2 - this.field_22793.method_27525((class_5348)teleporterName) / 2;
                context.method_51439(this.field_22793, (class_2561)teleporterName, x + teleporterNameOffset, y + 7, 0x404040, false);
                if (!this.currentTargetDisplayName.isEmpty() || this.visibleLocationsList.size() > 1) {
                    if (!this.currentTargetEntrance.isEmpty() && !this.currentTargetEntranceDisplayName.isEmpty()) {
                        if (this.showCurrentEntranceDisplayNameFirst) {
                            context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)this.currentTargetEntranceDisplayName), x + 8, y + 20, 0x404040, false);
                            context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)this.currentTargetDisplayName), x + 8, y + 33, 0x404040, false);
                        } else {
                            context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)this.currentTargetDisplayName), x + 8, y + 20, 0x404040, false);
                            context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)this.currentTargetEntranceDisplayName), x + 8, y + 33, 0x404040, false);
                        }
                    } else {
                        context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)this.currentTargetDisplayName), x + 8, y + 27, 0x404040, false);
                    }
                }
                if (this.isCurrentLocationPublic && this.showCurrentLocationOwner) {
                    context.method_51439(this.field_22793, LOCATION_IS_PUBLIC_TEXT, x + 19, y + 77, 0x404040, false);
                } else if (this.currentTargetOwner != null && this.showCurrentLocationOwner) {
                    context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)this.teleporterBlock.getCurrentTargetOwnerLabel()), x + 8, y + 58, 0x404040, false);
                    context.method_25293(this.currentTargetOwner.method_52810().comp_1626(), x + 7, y + 77, 8, 8, 8.0f, 8.0f, 8, 8, 64, 64);
                    context.method_51433(this.field_22793, this.currentTargetOwner.method_2966().getName(), x + 19, y + 77, 0x404040, false);
                }
            } else {
                context.method_25290(ADVENTURE_TELEPORTER_SCREEN_BACKGROUND_TEXTURE, x, y, 0.0f, 0.0f, this.field_2792, this.field_2779, this.field_2792, this.field_2779);
                class_5250 teleporterName = class_2561.method_43471((String)this.teleporterBlock.getTeleporterName());
                int teleporterNameOffset = this.field_2792 / 2 - this.field_22793.method_27525((class_5348)teleporterName) / 2;
                context.method_51439(this.field_22793, (class_2561)teleporterName, x + teleporterNameOffset, y + 7, 0x404040, false);
            }
        }
    }

    protected boolean isValidCharacterForDisplayName(String name, char character, int cursorPos) {
        int i = name.indexOf(58);
        int j = name.indexOf(47);
        if (character == ':') {
            return (j == -1 || cursorPos <= j) && i == -1;
        }
        if (character == '/') {
            return cursorPos > i;
        }
        return character == '_' || character == '-' || character >= 'a' && character <= 'z' || character >= 'A' && character <= 'Z' || character >= '0' && character <= '9' || character == '.' || character == ' ';
    }

    private void renderSlotTooltip(class_332 context, int mouseX, int mouseY) {
        class_1799 itemStack;
        Optional<Object> optional = Optional.empty();
        if (this.field_2787 != null && (itemStack = this.handler.method_7611(37).method_7677()).method_7960() && this.field_2787.field_7874 == 37) {
            optional = Optional.of(class_2561.method_43471((String)"gui.teleporter_block.requiredItemStackSlot.tooltip"));
        }
        optional.ifPresent(text -> context.method_51447(this.field_22793, this.field_22793.method_1728((class_5348)text, 115), mouseX, mouseY));
    }

    private boolean tryDungeonRegeneration() {
        if (this.canLocationBeRegenerated) {
            Optional optionalLocationReference;
            Location location = null;
            class_1937 world = this.teleporterBlock.method_10997();
            if (world != null && (optionalLocationReference = world.method_30349().method_30530(CustomDynamicRegistries.LOCATION_REGISTRY_KEY).method_55841(class_2960.method_12829((String)this.currentTargetIdentifier))).isPresent()) {
                location = (Location)((class_6880.class_6883)optionalLocationReference.get()).comp_349();
            }
            if (location != null) {
                ClientPlayNetworking.send((class_8710)new SetManualResetLocationControlBlockPacket(LocationUtils.getControlBlockPosForLocation(location), true));
                return true;
            }
        }
        return false;
    }

    private void teleport() {
        String currentWorld = "";
        String currentTargetOwnerName = "";
        if (this.teleporterBlock.method_10997() != null) {
            currentWorld = this.teleporterBlock.method_10997().method_27983().method_29177().toString();
        }
        if (this.currentTargetOwner != null) {
            currentTargetOwnerName = this.currentTargetOwner.method_2966().getName();
        }
        if (this.isCurrentLocationPublic) {
            currentTargetOwnerName = "";
        }
        ClientPlayNetworking.send((class_8710)new TeleportFromTeleporterBlockPacket(this.teleporterBlock.method_11016(), currentWorld, this.teleporterBlock.getAccessPositionOffset(), this.teleporterBlock.getSetAccessPosition(), this.teleporterBlock.teleportTeam(), this.teleporterBlock.getTeleportationMode().method_15434(), this.teleporterBlock.getDirectTeleportPositionOffset(), this.teleporterBlock.getDirectTeleportOrientationYaw(), this.teleporterBlock.getDirectTeleportOrientationPitch(), this.teleporterBlock.getSpawnPointType().method_15434(), currentTargetOwnerName, this.currentTargetIdentifier, this.currentTargetEntrance, this.teleporterBlock.getStatusEffectsToDecrementLevelOnTeleport(), this.currentTargetEntranceDataId, this.currentTargetEntranceData));
    }

    private void givePortalResistanceEffect() {
        ClientPlayNetworking.send((class_8710)new AddStatusEffectPacket(class_7923.field_41174.method_10221((Object)StatusEffectsRegistry.PORTAL_RESISTANCE_EFFECT), 40, 0, false, false, false, false));
    }
}

