/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.scriptblocks.screen;

import com.github.theredbrain.scriptblocks.data.Dialogue;
import com.github.theredbrain.scriptblocks.registry.CustomDynamicRegistries;
import com.github.theredbrain.scriptblocks.registry.ScreenHandlerTypesRegistry;
import com.github.theredbrain.scriptblocks.util.CustomPacketCodecs;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9141;
import net.minecraft.class_9142;
import org.apache.commons.lang3.tuple.MutablePair;
import org.jetbrains.annotations.Nullable;

public class DialogueScreenHandler
extends class_1703 {
    public class_1937 world;
    @Nullable
    public Dialogue dialogue;
    public class_2338 dataBlockPos;
    public List<MutablePair<String, class_2338>> dialogueUsedBlocksList;
    public List<MutablePair<String, MutablePair<class_2338, Boolean>>> dialogueTriggeredBlocksList;
    public List<String> unlockedAnswersList;
    public List<String> visibleAnswersList;
    public List<String> dialogueTextList = new ArrayList<String>(List.of());
    public int dialogueTextsStartingIndex;
    public int answersStartingIndex;

    public DialogueScreenHandler(int syncId, class_1661 playerInventory, DialogueData data) {
        this(syncId, playerInventory, data.dialogueIdentifierString, data.dataBlockPos, data.dialogueUsedBlocks, data.dialogueTriggeredBlocks, data.unlockedAnswersList, data.visibleAnswersList);
    }

    public DialogueScreenHandler(int syncId, class_1661 playerInventory, String dialogueIdentifierString, class_2338 dataBlockPos, List<MutablePair<String, class_2338>> dialogueUsedBlocks, List<MutablePair<String, MutablePair<class_2338, Boolean>>> dialogueTriggeredBlocks, List<String> unlockedAnswersList, List<String> visibleAnswersList) {
        super(ScreenHandlerTypesRegistry.DIALOGUE_SCREEN_HANDLER, syncId);
        this.world = playerInventory.field_7546.method_37908();
        this.dataBlockPos = dataBlockPos;
        this.dialogueUsedBlocksList = dialogueUsedBlocks;
        this.dialogueTriggeredBlocksList = dialogueTriggeredBlocks;
        this.unlockedAnswersList = unlockedAnswersList;
        this.visibleAnswersList = visibleAnswersList;
        Optional optionalDialogueReference = this.world.method_30349().method_30530(CustomDynamicRegistries.DIALOGUE_REGISTRY_KEY).method_55841(class_2960.method_12829((String)dialogueIdentifierString));
        if (optionalDialogueReference.isPresent()) {
            this.dialogue = (Dialogue)((class_6880.class_6883)optionalDialogueReference.get()).comp_349();
            this.dialogueTextList = this.dialogue.dialogueTextList();
            this.dialogueTextsStartingIndex = this.dialogue.dialogueTextsStartingIndex();
            this.answersStartingIndex = this.dialogue.answersStartingIndex();
        }
    }

    public class_1799 method_7601(class_1657 player, int slot) {
        return class_1799.field_8037;
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }

    public int getDialogueTextsStartingIndex() {
        return Math.max(0, Math.min(7, this.dialogueTextsStartingIndex));
    }

    public int getAnswersStartingIndex() {
        return Math.max(0, Math.min(7, this.answersStartingIndex));
    }

    public record DialogueData(String dialogueIdentifierString, class_2338 dataBlockPos, List<MutablePair<String, class_2338>> dialogueUsedBlocks, List<MutablePair<String, MutablePair<class_2338, Boolean>>> dialogueTriggeredBlocks, List<String> unlockedAnswersList, List<String> visibleAnswersList) {
        public static final class_9139<class_9129, DialogueData> PACKET_CODEC = class_9139.method_56438(DialogueData::write, DialogueData::new);

        public DialogueData(class_9129 registryByteBuf) {
            this(registryByteBuf.method_19772(), registryByteBuf.method_10811(), registryByteBuf.method_34066(CustomPacketCodecs.MUTABLE_PAIR_STRING_BLOCK_POS), registryByteBuf.method_34066(CustomPacketCodecs.MUTABLE_PAIR_STRING_MUTABLE_PAIR_BLOCK_POS_BOOLEAN), registryByteBuf.method_34066((class_9141)class_9135.field_48554), registryByteBuf.method_34066((class_9141)class_9135.field_48554));
        }

        private void write(class_9129 registryByteBuf) {
            registryByteBuf.method_10814(this.dialogueIdentifierString);
            registryByteBuf.method_10807(this.dataBlockPos);
            registryByteBuf.method_34062(this.dialogueUsedBlocks, CustomPacketCodecs.MUTABLE_PAIR_STRING_BLOCK_POS);
            registryByteBuf.method_34062(this.dialogueTriggeredBlocks, CustomPacketCodecs.MUTABLE_PAIR_STRING_MUTABLE_PAIR_BLOCK_POS_BOOLEAN);
            registryByteBuf.method_34062(this.unlockedAnswersList, (class_9142)class_9135.field_48554);
            registryByteBuf.method_34062(this.visibleAnswersList, (class_9142)class_9135.field_48554);
        }
    }
}

