/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.scriptblocks.screen;

import com.github.theredbrain.scriptblocks.ScriptBlocks;
import com.github.theredbrain.scriptblocks.block.entity.ShopBlockEntity;
import com.github.theredbrain.scriptblocks.data.Shop;
import com.github.theredbrain.scriptblocks.network.packet.TradeWithShopPacket;
import com.github.theredbrain.scriptblocks.registry.CustomDynamicRegistries;
import com.github.theredbrain.scriptblocks.registry.ScreenHandlerTypesRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_2985;
import net.minecraft.class_2989;
import net.minecraft.class_3222;
import net.minecraft.class_6880;
import net.minecraft.class_8710;
import net.minecraft.class_8779;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class ShopScreenHandler
extends class_1703 {
    private class_1661 playerInventory;
    private final class_1937 world;
    private ShopBlockEntity shopBlockEntity;
    @Nullable
    private Shop shop;
    private List<Shop.Deal> dealsList = new ArrayList<Shop.Deal>(List.of());
    private List<Shop.Deal> unlockedDealsList = new ArrayList<Shop.Deal>(List.of());
    private List<Shop.Deal> stockedDealsList = new ArrayList<Shop.Deal>(List.of());
    private int unlockedDealsCounter = 0;
    private int stockedDealsCounter = 0;
    Runnable contentsChangedListener = () -> {};
    public final class_1263 inventory = new class_1277(9){

        public int method_5444() {
            return 999;
        }

        public void method_5431() {
            super.method_5431();
            ShopScreenHandler.this.method_7609((class_1263)this);
            ShopScreenHandler.this.contentsChangedListener.run();
        }
    };
    private class_2338 blockPos;

    public ShopScreenHandler(int syncId, class_1661 playerInventory, ShopBlockData data) {
        this(syncId, playerInventory, data.blockPos());
    }

    public ShopScreenHandler(int syncId, class_1661 playerInventory, class_2338 blockPos) {
        super(ScreenHandlerTypesRegistry.SHOP_BLOCK_SCREEN_HANDLER, syncId);
        int i;
        this.playerInventory = playerInventory;
        this.world = playerInventory.field_7546.method_37908();
        this.blockPos = blockPos;
        class_2586 blockEntity = this.world.method_8321(this.blockPos);
        if (blockEntity instanceof ShopBlockEntity) {
            Optional optionalShopReference;
            this.shopBlockEntity = (ShopBlockEntity)blockEntity;
            Shop shop = null;
            String shopIdentifier = this.shopBlockEntity.getShopIdentifier();
            if (!shopIdentifier.isEmpty() && (optionalShopReference = this.world.method_30349().method_30530(CustomDynamicRegistries.SHOP_REGISTRY_KEY).method_55841(class_2960.method_60654((String)shopIdentifier))).isPresent()) {
                shop = (Shop)((class_6880.class_6883)optionalShopReference.get()).comp_349();
            }
            this.shop = shop;
            if (shop != null) {
                this.dealsList = shop.dealList();
            }
        }
        for (i = 0; i < 9; ++i) {
            this.method_7621(new class_1735((class_1263)playerInventory, i, 8 + i * 18, 188));
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.method_7621(new class_1735((class_1263)playerInventory, j + (i + 1) * 9, 8 + j * 18, 130 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.method_7621(new class_1735(this.inventory, i, 8 + i * 18, 98));
        }
    }

    public class_2338 getBlockPos() {
        return this.blockPos;
    }

    public ShopBlockEntity getShopBlockEntity() {
        return this.shopBlockEntity;
    }

    @Nullable
    public Shop getShop() {
        return this.shop;
    }

    public List<Shop.Deal> getDealsList() {
        return this.dealsList;
    }

    public List<Shop.Deal> getUnlockedDealsList() {
        return this.unlockedDealsList;
    }

    public List<Shop.Deal> getStockedDealsList() {
        return this.stockedDealsList;
    }

    public int getUnlockedDealsCounter() {
        return this.unlockedDealsCounter;
    }

    public int getStockedDealsCounter() {
        return this.stockedDealsCounter;
    }

    public class_1263 getInventory() {
        return this.inventory;
    }

    public void setContentsChangedListener(Runnable contentsChangedListener) {
        this.contentsChangedListener = contentsChangedListener;
    }

    public class_1799 method_7601(class_1657 player, int slot) {
        class_1799 itemStack = class_1799.field_8037;
        return itemStack;
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }

    public boolean method_7604(class_1657 player, int id) {
        Shop.Deal currentDeal;
        if (id < this.stockedDealsList.size() && (currentDeal = this.stockedDealsList.get(id)) != null && player instanceof class_3222) {
            class_3222 serverPlayerEntity = (class_3222)player;
            ServerPlayNetworking.send((class_3222)serverPlayerEntity, (class_8710)new TradeWithShopPacket(this.shopBlockEntity.getShopIdentifier(), id));
        }
        return true;
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        if (player instanceof class_3222) {
            this.method_7607(player, this.inventory);
        }
    }

    public void calculateUnlockedAndStockedDeals() {
        ScriptBlocks.info("calculateUnlockedAndStockedDeals");
        class_2985 playerAdvancementTracker = null;
        class_2989 serverAdvancementLoader = null;
        class_1657 class_16572 = this.playerInventory.field_7546;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayerEntity = (class_3222)class_16572;
            playerAdvancementTracker = serverPlayerEntity.method_14236();
            MinecraftServer minecraftServer = serverPlayerEntity.method_5682();
            if (minecraftServer != null) {
                serverAdvancementLoader = minecraftServer.method_3851();
            }
        }
        if (playerAdvancementTracker != null && serverAdvancementLoader != null) {
            this.unlockedDealsList.clear();
            this.unlockedDealsCounter = 0;
            ScriptBlocks.info("advancementHandler != null");
            ScriptBlocks.info("this.dealsList.size(): " + this.dealsList.size());
            for (int i = 0; i < this.dealsList.size(); ++i) {
                Shop.Deal deal = this.dealsList.get(i);
                String lockAdvancement = deal.lockAdvancement();
                String unlockAdvancement = deal.unlockAdvancement();
                class_8779 lockAdvancementEntry = null;
                lockAdvancementEntry = serverAdvancementLoader.method_12896(class_2960.method_60654((String)lockAdvancement));
                class_8779 unlockAdvancementEntry = null;
                unlockAdvancementEntry = serverAdvancementLoader.method_12896(class_2960.method_60654((String)unlockAdvancement));
                if (lockAdvancementEntry != null && !playerAdvancementTracker.method_12882(lockAdvancementEntry).method_740() && unlockAdvancementEntry != null && playerAdvancementTracker.method_12882(unlockAdvancementEntry).method_740()) {
                    this.unlockedDealsList.add(deal);
                    ++this.unlockedDealsCounter;
                    continue;
                }
                this.unlockedDealsList.add(null);
            }
        }
        this.stockedDealsList.clear();
        this.stockedDealsCounter = 0;
        for (Shop.Deal deal : this.unlockedDealsList) {
            if (deal != null) {
                this.stockedDealsList.add(deal);
                ++this.stockedDealsCounter;
                continue;
            }
            this.stockedDealsList.add(null);
        }
    }

    public record ShopBlockData(class_2338 blockPos) {
        public static final class_9139<class_9129, ShopBlockData> PACKET_CODEC = class_9139.method_56438(ShopBlockData::write, ShopBlockData::new);

        public ShopBlockData(class_9129 registryByteBuf) {
            this(registryByteBuf.method_10811());
        }

        private void write(class_9129 registryByteBuf) {
            registryByteBuf.method_10807(this.blockPos);
        }
    }
}

