/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.scriptblocks.block.entity;

import com.github.theredbrain.scriptblocks.ScriptBlocks;
import com.github.theredbrain.scriptblocks.block.Resetable;
import com.github.theredbrain.scriptblocks.block.RotatedBlockWithEntity;
import com.github.theredbrain.scriptblocks.block.Triggerable;
import com.github.theredbrain.scriptblocks.block.entity.RotatedBlockEntity;
import com.github.theredbrain.scriptblocks.entity.player.DuckPlayerEntityMixin;
import com.github.theredbrain.scriptblocks.registry.EntityRegistry;
import com.github.theredbrain.scriptblocks.util.BlockRotationUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.apache.commons.lang3.tuple.MutablePair;

public class AreaBlockEntity
extends RotatedBlockEntity
implements Triggerable,
Resetable {
    private static final class_2338 TRIGGERED_BLOCK_POS_DEFAULT = new class_2338(0, 0, 0);
    private boolean calculateAreaBox = true;
    private class_238 area = null;
    private boolean showArea = false;
    private class_2382 areaDimensions = class_2382.field_11176;
    private class_2338 areaPositionOffset = new class_2338(0, 1, 0);
    private String appliedStatusEffectIdentifier = "";
    private int appliedStatusEffectAmplifier = 0;
    private boolean appliedStatusEffectAmbient = false;
    private boolean appliedStatusEffectShowParticles = false;
    private boolean appliedStatusEffectShowIcon = false;
    private boolean hasTriggered = false;
    private boolean wasTriggered = false;
    private TriggerMode triggerMode = TriggerMode.ALWAYS;
    private TriggeredMode triggeredMode = TriggeredMode.ONCE;
    private MutablePair<class_2338, Boolean> triggeredBlock = new MutablePair((Object)TRIGGERED_BLOCK_POS_DEFAULT, (Object)false);
    private MessageMode messageMode = MessageMode.OVERLAY;
    private String joinMessage = "";
    private String leaveMessage = "";
    private String triggeredMessage = "";
    private ArrayList<UUID> playerList = new ArrayList();
    private ArrayList<UUID> playerList2 = new ArrayList();
    private HashMap<UUID, Integer> playerMap = new HashMap();
    private int maxTimer = 1;

    public AreaBlockEntity(class_2338 pos, class_2680 state) {
        super(EntityRegistry.AREA_BLOCK_ENTITY, pos, state);
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        if (this.showArea) {
            nbt.method_10556("showArea", true);
        } else {
            nbt.method_10551("showArea");
        }
        if (this.area != null) {
            nbt.method_10549("areaMinX", this.area.field_1323);
            nbt.method_10549("areaMaxX", this.area.field_1320);
            nbt.method_10549("areaMinY", this.area.field_1322);
            nbt.method_10549("areaMaxY", this.area.field_1325);
            nbt.method_10549("areaMinZ", this.area.field_1321);
            nbt.method_10549("areaMaxZ", this.area.field_1324);
        } else {
            nbt.method_10551("areaMinX");
            nbt.method_10551("areaMaxX");
            nbt.method_10551("areaMinY");
            nbt.method_10551("areaMaxY");
            nbt.method_10551("areaMinZ");
            nbt.method_10551("areaMaxZ");
        }
        if (this.areaDimensions.method_10263() != 0) {
            nbt.method_10569("areaDimensionsX", this.areaDimensions.method_10263());
        } else {
            nbt.method_10551("areaDimensionsX");
        }
        if (this.areaDimensions.method_10264() != 0) {
            nbt.method_10569("areaDimensionsY", this.areaDimensions.method_10264());
        } else {
            nbt.method_10551("areaDimensionsY");
        }
        if (this.areaDimensions.method_10260() != 0) {
            nbt.method_10569("areaDimensionsZ", this.areaDimensions.method_10260());
        } else {
            nbt.method_10551("areaDimensionsZ");
        }
        if (this.areaPositionOffset.method_10263() != 0) {
            nbt.method_10569("areaPositionOffsetX", this.areaPositionOffset.method_10263());
        } else {
            nbt.method_10551("areaPositionOffsetX");
        }
        if (this.areaPositionOffset.method_10264() != 0) {
            nbt.method_10569("areaPositionOffsetY", this.areaPositionOffset.method_10264());
        } else {
            nbt.method_10551("areaPositionOffsetY");
        }
        if (this.areaPositionOffset.method_10260() != 0) {
            nbt.method_10569("areaPositionOffsetZ", this.areaPositionOffset.method_10260());
        } else {
            nbt.method_10551("areaPositionOffsetZ");
        }
        if (!this.appliedStatusEffectIdentifier.isEmpty()) {
            nbt.method_10582("appliedStatusEffectIdentifier", this.appliedStatusEffectIdentifier);
        } else {
            nbt.method_10551("appliedStatusEffectIdentifier");
        }
        if (this.appliedStatusEffectAmplifier != 0) {
            nbt.method_10569("appliedStatusEffectAmplifier", this.appliedStatusEffectAmplifier);
        } else {
            nbt.method_10551("appliedStatusEffectAmplifier");
        }
        if (this.appliedStatusEffectAmbient) {
            nbt.method_10556("appliedStatusEffectAmbient", true);
        } else {
            nbt.method_10551("appliedStatusEffectAmbient");
        }
        if (this.appliedStatusEffectShowParticles) {
            nbt.method_10556("appliedStatusEffectShowParticles", true);
        } else {
            nbt.method_10551("appliedStatusEffectShowParticles");
        }
        if (this.appliedStatusEffectShowIcon) {
            nbt.method_10556("appliedStatusEffectShowIcon", true);
        } else {
            nbt.method_10551("appliedStatusEffectShowIcon");
        }
        if (this.messageMode != MessageMode.OVERLAY) {
            nbt.method_10582("messageMode", this.messageMode.method_15434());
        } else {
            nbt.method_10551("messageMode");
        }
        if (!this.joinMessage.isEmpty()) {
            nbt.method_10582("joinMessage", this.joinMessage);
        } else {
            nbt.method_10551("joinMessage");
        }
        if (!this.leaveMessage.isEmpty()) {
            nbt.method_10582("leaveMessage", this.leaveMessage);
        } else {
            nbt.method_10551("leaveMessage");
        }
        if (!this.triggeredMessage.isEmpty()) {
            nbt.method_10582("triggeredMessage", this.triggeredMessage);
        } else {
            nbt.method_10551("triggeredMessage");
        }
        if (this.hasTriggered) {
            nbt.method_10556("hasTriggered", true);
        } else {
            nbt.method_10551("hasTriggered");
        }
        if (this.wasTriggered) {
            nbt.method_10556("wasTriggered", true);
        } else {
            nbt.method_10551("wasTriggered");
        }
        if (this.triggerMode != TriggerMode.ALWAYS) {
            nbt.method_10582("triggerMode", this.triggerMode.method_15434());
        } else {
            nbt.method_10551("triggerMode");
        }
        if (this.triggeredMode != TriggeredMode.ONCE) {
            nbt.method_10582("triggeredMode", this.triggeredMode.method_15434());
        } else {
            nbt.method_10551("triggeredMode");
        }
        if (this.maxTimer > 1) {
            nbt.method_10569("maxTimer", this.maxTimer);
        } else {
            nbt.method_10551("maxTimer");
        }
        if (this.triggeredBlock.getLeft() != TRIGGERED_BLOCK_POS_DEFAULT || !((Boolean)this.triggeredBlock.getRight()).booleanValue()) {
            nbt.method_10569("triggeredBlockPositionOffsetX", ((class_2338)this.triggeredBlock.getLeft()).method_10263());
            nbt.method_10569("triggeredBlockPositionOffsetY", ((class_2338)this.triggeredBlock.getLeft()).method_10264());
            nbt.method_10569("triggeredBlockPositionOffsetZ", ((class_2338)this.triggeredBlock.getLeft()).method_10260());
            nbt.method_10556("triggeredBlockResets", ((Boolean)this.triggeredBlock.getRight()).booleanValue());
        } else {
            nbt.method_10551("triggeredBlockPositionOffsetX");
            nbt.method_10551("triggeredBlockPositionOffsetY");
            nbt.method_10551("triggeredBlockPositionOffsetZ");
            nbt.method_10551("triggeredBlockResets");
        }
        int playerListSize = this.playerList.size();
        nbt.method_10569("playerListSize", playerListSize);
        for (int i = 0; i < playerListSize; ++i) {
            nbt.method_25927("playerListEntry_" + i, this.playerList.get(i));
        }
        int playerList2Size = this.playerList2.size();
        nbt.method_10569("playerList2Size", playerList2Size);
        for (int i = 0; i < playerList2Size; ++i) {
            nbt.method_25927("playerList2Entry_" + i, this.playerList2.get(i));
        }
        List keyList = this.playerMap.keySet().stream().toList();
        int playerMapSize = this.playerMap.keySet().size();
        nbt.method_10569("playerMapSize", playerMapSize);
        for (int i = 0; i < playerMapSize; ++i) {
            UUID key = (UUID)keyList.get(i);
            nbt.method_25927("key_" + i, key);
            nbt.method_10569("timer_" + i, this.playerMap.get(key).intValue());
        }
        super.method_11007(nbt, registryLookup);
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        this.showArea = nbt.method_10577("showArea");
        if (nbt.method_10545("areaMinX") && nbt.method_10545("areaMinY") && nbt.method_10545("areaMinZ") && nbt.method_10545("areaMaxX") && nbt.method_10545("areaMaxY") && nbt.method_10545("areaMaxZ")) {
            this.area = new class_238(nbt.method_10574("areaMinX"), nbt.method_10574("areaMinY"), nbt.method_10574("areaMinZ"), nbt.method_10574("areaMaxX"), nbt.method_10574("areaMaxY"), nbt.method_10574("areaMaxZ"));
            this.calculateAreaBox = true;
        }
        int i = class_3532.method_15340((int)nbt.method_10550("areaDimensionsX"), (int)0, (int)48);
        int j = class_3532.method_15340((int)nbt.method_10550("areaDimensionsY"), (int)0, (int)48);
        int k = class_3532.method_15340((int)nbt.method_10550("areaDimensionsZ"), (int)0, (int)48);
        this.areaDimensions = new class_2382(i, j, k);
        int l = class_3532.method_15340((int)nbt.method_10550("areaPositionOffsetX"), (int)-48, (int)48);
        int m = class_3532.method_15340((int)nbt.method_10550("areaPositionOffsetY"), (int)-48, (int)48);
        int n = class_3532.method_15340((int)nbt.method_10550("areaPositionOffsetZ"), (int)-48, (int)48);
        this.areaPositionOffset = new class_2338(l, m, n);
        this.appliedStatusEffectIdentifier = nbt.method_10558("appliedStatusEffectIdentifier");
        this.appliedStatusEffectAmplifier = nbt.method_10550("appliedStatusEffectAmplifier");
        this.appliedStatusEffectAmbient = nbt.method_10577("appliedStatusEffectAmbient");
        this.appliedStatusEffectShowParticles = nbt.method_10577("appliedStatusEffectShowParticles");
        this.appliedStatusEffectShowIcon = nbt.method_10577("appliedStatusEffectShowIcon");
        this.messageMode = MessageMode.byName(nbt.method_10558("messageMode")).orElse(MessageMode.OVERLAY);
        this.joinMessage = nbt.method_10558("joinMessage");
        this.leaveMessage = nbt.method_10558("leaveMessage");
        this.triggeredMessage = nbt.method_10558("triggeredMessage");
        this.hasTriggered = nbt.method_10577("hasTriggered");
        this.wasTriggered = nbt.method_10577("wasTriggered");
        this.triggerMode = TriggerMode.byName(nbt.method_10558("triggerMode")).orElse(TriggerMode.ALWAYS);
        this.triggeredMode = TriggeredMode.byName(nbt.method_10558("triggeredMode")).orElse(TriggeredMode.ONCE);
        this.maxTimer = nbt.method_10573("maxTimer", 3) ? nbt.method_10550("maxTimer") : 1;
        if (nbt.method_10573("triggeredBlockPositionOffsetX", 3) && nbt.method_10573("triggeredBlockPositionOffsetY", 3) && nbt.method_10573("triggeredBlockPositionOffsetZ", 3) && nbt.method_10573("triggeredBlockResets", 1)) {
            this.triggeredBlock = new MutablePair((Object)new class_2338(class_3532.method_15340((int)nbt.method_10550("triggeredBlockPositionOffsetX"), (int)-48, (int)48), class_3532.method_15340((int)nbt.method_10550("triggeredBlockPositionOffsetY"), (int)-48, (int)48), class_3532.method_15340((int)nbt.method_10550("triggeredBlockPositionOffsetZ"), (int)-48, (int)48)), (Object)nbt.method_10577("triggeredBlockResets"));
        }
        int playerListSize = nbt.method_10550("playerListSize");
        for (i = 0; i < playerListSize; ++i) {
            this.playerList.add(nbt.method_25926("playerListSize" + i));
        }
        int playerList2Size = nbt.method_10550("playerList2Size");
        for (i = 0; i < playerList2Size; ++i) {
            this.playerList2.add(nbt.method_25926("playerList2Size" + i));
        }
        int playerMapSize = nbt.method_10550("playerMapSize");
        this.playerMap = new HashMap();
        for (i = 0; i < playerMapSize; ++i) {
            UUID key = nbt.method_25926("key_" + i);
            int timer = nbt.method_10550("timer_" + i);
            this.playerMap.put(key, timer);
        }
        super.method_11014(nbt, registryLookup);
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return this.method_58692(registryLookup);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, AreaBlockEntity areaBlockEntity) {
        if (!world.field_9236 && world.method_8510() % 20L == 0L && areaBlockEntity.wasTriggered) {
            class_1657 playerEntity;
            if (areaBlockEntity.calculateAreaBox || areaBlockEntity.area == null) {
                class_2338 areaPositionOffset = areaBlockEntity.areaPositionOffset;
                class_2382 areaDimensions = areaBlockEntity.areaDimensions;
                class_243 areaStart = new class_243((double)(pos.method_10263() + areaPositionOffset.method_10263()), (double)(pos.method_10264() + areaPositionOffset.method_10264()), (double)(pos.method_10260() + areaPositionOffset.method_10260()));
                class_243 areaEnd = new class_243(areaStart.method_10216() + (double)areaDimensions.method_10263(), areaStart.method_10214() + (double)areaDimensions.method_10264(), areaStart.method_10215() + (double)areaDimensions.method_10260());
                areaBlockEntity.area = new class_238(areaStart, areaEnd);
                areaBlockEntity.calculateAreaBox = false;
            }
            boolean shouldTriggerBlock = false;
            Optional statusEffect = class_7923.field_41174.method_55841(class_2960.method_12829((String)areaBlockEntity.appliedStatusEffectIdentifier));
            List newPlayerList = world.method_18467(class_1657.class, areaBlockEntity.area);
            ArrayList<UUID> newPLayerUuidList = new ArrayList<UUID>();
            for (class_1657 player : newPlayerList) {
                newPLayerUuidList.add(player.method_5667());
            }
            ArrayList<UUID> tempList = new ArrayList<UUID>();
            for (UUID uuid : areaBlockEntity.playerList) {
                playerEntity = world.method_18470(uuid);
                if (playerEntity == null) continue;
                if (newPLayerUuidList.contains(uuid)) {
                    tempList.add(uuid);
                    newPLayerUuidList.remove(uuid);
                    if (!statusEffect.isPresent() || !areaBlockEntity.wasTriggered) continue;
                    playerEntity.method_6092(new class_1293((class_6880)statusEffect.get(), 100, areaBlockEntity.appliedStatusEffectAmplifier, areaBlockEntity.appliedStatusEffectAmbient, areaBlockEntity.appliedStatusEffectShowParticles, areaBlockEntity.appliedStatusEffectShowIcon));
                    continue;
                }
                if (areaBlockEntity.triggerMode == TriggerMode.ALWAYS) {
                    areaBlockEntity.playerList2.clear();
                }
                if (areaBlockEntity.playerList2.contains(uuid)) continue;
                if (!areaBlockEntity.leaveMessage.isEmpty()) {
                    if (areaBlockEntity.messageMode == MessageMode.ANNOUNCEMENT) {
                        ((DuckPlayerEntityMixin)playerEntity).scriptblocks$sendAnnouncement((class_2561)class_2561.method_43471((String)areaBlockEntity.leaveMessage));
                    } else {
                        playerEntity.method_7353((class_2561)class_2561.method_43471((String)areaBlockEntity.leaveMessage), areaBlockEntity.messageMode == MessageMode.OVERLAY);
                    }
                }
                if (areaBlockEntity.triggerMode == TriggerMode.ALWAYS) continue;
                areaBlockEntity.playerList2.add(playerEntity.method_5667());
            }
            if (areaBlockEntity.triggerMode == TriggerMode.TIMED) {
                HashMap newPlayerMap = new HashMap();
                areaBlockEntity.playerMap.forEach((uuid1, integer) -> {
                    int newInteger = integer = Integer.valueOf(integer - 1);
                    if (newInteger > 0) {
                        newPlayerMap.put(uuid1, newInteger);
                    }
                });
                areaBlockEntity.playerMap.clear();
                areaBlockEntity.playerMap.putAll(newPlayerMap);
            } else if (areaBlockEntity.triggerMode == TriggerMode.ALWAYS) {
                areaBlockEntity.playerMap.clear();
            }
            for (UUID uuid2 : newPLayerUuidList) {
                playerEntity = world.method_18470(uuid2);
                if (playerEntity == null) continue;
                tempList.add(uuid2);
                if (statusEffect.isPresent()) {
                    playerEntity.method_6092(new class_1293((class_6880)statusEffect.get(), 100, areaBlockEntity.appliedStatusEffectAmplifier, areaBlockEntity.appliedStatusEffectAmbient, areaBlockEntity.appliedStatusEffectShowParticles, areaBlockEntity.appliedStatusEffectShowIcon));
                }
                if (areaBlockEntity.triggerMode != TriggerMode.ALWAYS && areaBlockEntity.playerMap.containsKey(playerEntity.method_5667())) continue;
                if (!areaBlockEntity.joinMessage.isEmpty()) {
                    if (areaBlockEntity.messageMode == MessageMode.ANNOUNCEMENT) {
                        ((DuckPlayerEntityMixin)playerEntity).scriptblocks$sendAnnouncement((class_2561)class_2561.method_43471((String)areaBlockEntity.joinMessage));
                    } else {
                        playerEntity.method_7353((class_2561)class_2561.method_43471((String)areaBlockEntity.joinMessage), areaBlockEntity.messageMode == MessageMode.OVERLAY);
                    }
                }
                areaBlockEntity.playerList2.remove(playerEntity.method_5667());
                if (areaBlockEntity.triggerMode != TriggerMode.ALWAYS) {
                    areaBlockEntity.playerMap.put(playerEntity.method_5667(), areaBlockEntity.triggerMode == TriggerMode.ONCE ? 1 : areaBlockEntity.maxTimer);
                }
                shouldTriggerBlock = true;
            }
            areaBlockEntity.playerList.clear();
            areaBlockEntity.playerList.addAll(tempList);
            if (shouldTriggerBlock && (areaBlockEntity.triggerMode == TriggerMode.ALWAYS || !areaBlockEntity.hasTriggered)) {
                areaBlockEntity.triggerBlock();
                areaBlockEntity.hasTriggered = true;
            }
        }
    }

    private void triggerBlock() {
        class_2586 blockEntity;
        ScriptBlocks.info("areablock triggerBlock");
        int x = ((class_2338)this.triggeredBlock.getLeft()).method_10263();
        int y = ((class_2338)this.triggeredBlock.getLeft()).method_10264();
        int z = ((class_2338)this.triggeredBlock.getLeft()).method_10260();
        if (this.field_11863 != null && (x != 0 || y != 0 || z != 0) && (blockEntity = this.field_11863.method_8321(new class_2338(this.field_11867.method_10263() + x, this.field_11867.method_10264() + y, this.field_11867.method_10260() + z))) != this) {
            boolean triggeredBlockResets = (Boolean)this.triggeredBlock.getRight();
            if (triggeredBlockResets && blockEntity instanceof Resetable) {
                Resetable resetable = (Resetable)blockEntity;
                resetable.reset();
            } else if (!triggeredBlockResets && blockEntity instanceof Triggerable) {
                Triggerable triggerable = (Triggerable)blockEntity;
                triggerable.trigger();
            }
        }
    }

    private void sendMessage(String message) {
        if (this.field_11863 instanceof class_3218) {
            ScriptBlocks.info("areablock sendMessage");
            if (this.calculateAreaBox || this.area == null) {
                class_2338 messageAreaPositionOffset = this.areaPositionOffset;
                class_2382 messageAreaDimensions = this.areaDimensions;
                class_243 messageAreaStart = new class_243((double)(this.field_11867.method_10263() + messageAreaPositionOffset.method_10263()), (double)(this.field_11867.method_10264() + messageAreaPositionOffset.method_10264()), (double)(this.field_11867.method_10260() + messageAreaPositionOffset.method_10260()));
                class_243 messageAreaEnd = new class_243(messageAreaStart.method_10216() + (double)messageAreaDimensions.method_10263(), messageAreaStart.method_10214() + (double)messageAreaDimensions.method_10264(), messageAreaStart.method_10215() + (double)messageAreaDimensions.method_10260());
                this.area = new class_238(messageAreaStart, messageAreaEnd);
                this.calculateAreaBox = false;
            }
            List list = this.field_11863.method_18467(class_1657.class, this.area);
            for (class_1657 playerEntity : list) {
                if (this.messageMode == MessageMode.ANNOUNCEMENT) {
                    ((DuckPlayerEntityMixin)playerEntity).scriptblocks$sendAnnouncement((class_2561)class_2561.method_43471((String)message));
                    continue;
                }
                playerEntity.method_7353((class_2561)class_2561.method_43471((String)message), this.messageMode == MessageMode.OVERLAY);
            }
        }
    }

    public boolean showArea() {
        return this.showArea;
    }

    public void setShowArea(boolean showArea) {
        this.showArea = showArea;
    }

    public class_2382 getAreaDimensions() {
        return this.areaDimensions;
    }

    public boolean setAreaDimensions(class_2382 areaDimensions) {
        this.areaDimensions = areaDimensions;
        this.calculateAreaBox = true;
        return true;
    }

    public class_2338 getAreaPositionOffset() {
        return this.areaPositionOffset;
    }

    public boolean setAreaPositionOffset(class_2338 areaPositionOffset) {
        this.areaPositionOffset = areaPositionOffset;
        this.calculateAreaBox = true;
        return true;
    }

    public String getAppliedStatusEffectIdentifier() {
        return this.appliedStatusEffectIdentifier;
    }

    public boolean setAppliedStatusEffectIdentifier(String appliedStatusEffectIdentifier) {
        if (class_7923.field_41174.method_10223(class_2960.method_12829((String)appliedStatusEffectIdentifier)) != null || appliedStatusEffectIdentifier.equals("")) {
            this.appliedStatusEffectIdentifier = appliedStatusEffectIdentifier;
            return true;
        }
        return false;
    }

    public int getAppliedStatusEffectAmplifier() {
        return this.appliedStatusEffectAmplifier;
    }

    public boolean setAppliedStatusEffectAmplifier(int appliedStatusEffectAmplifier) {
        if (appliedStatusEffectAmplifier >= 0 && appliedStatusEffectAmplifier < 127) {
            this.appliedStatusEffectAmplifier = appliedStatusEffectAmplifier;
            return true;
        }
        return false;
    }

    public boolean getAppliedStatusEffectAmbient() {
        return this.appliedStatusEffectAmbient;
    }

    public void setAppliedStatusEffectAmbient(boolean appliedStatusEffectAmbient) {
        this.appliedStatusEffectAmbient = appliedStatusEffectAmbient;
    }

    public boolean getAppliedStatusEffectShowParticles() {
        return this.appliedStatusEffectShowParticles;
    }

    public void setAppliedStatusEffectShowParticles(boolean appliedStatusEffectShowParticles) {
        this.appliedStatusEffectShowParticles = appliedStatusEffectShowParticles;
    }

    public boolean getAppliedStatusEffectShowIcon() {
        return this.appliedStatusEffectShowIcon;
    }

    public void setAppliedStatusEffectShowIcon(boolean appliedStatusEffectShowIcon) {
        this.appliedStatusEffectShowIcon = appliedStatusEffectShowIcon;
    }

    public MutablePair<class_2338, Boolean> getTriggeredBlock() {
        return this.triggeredBlock;
    }

    public void setTriggeredBlock(MutablePair<class_2338, Boolean> triggeredBlock) {
        this.triggeredBlock = triggeredBlock;
    }

    public boolean getWasTriggered() {
        return this.wasTriggered;
    }

    public void setWasTriggered(boolean wasTriggered) {
        this.wasTriggered = wasTriggered;
    }

    public String getJoinMessage() {
        return this.joinMessage;
    }

    public void setJoinMessage(String joinMessage) {
        this.joinMessage = joinMessage;
    }

    public String getLeaveMessage() {
        return this.leaveMessage;
    }

    public void setLeaveMessage(String leaveMessage) {
        this.leaveMessage = leaveMessage;
    }

    public String getTriggeredMessage() {
        return this.triggeredMessage;
    }

    public void setTriggeredMessage(String triggeredMessage) {
        this.triggeredMessage = triggeredMessage;
    }

    public MessageMode getMessageMode() {
        return this.messageMode;
    }

    public void setMessageMode(MessageMode messageMode) {
        this.messageMode = messageMode;
    }

    public TriggerMode getTriggerMode() {
        return this.triggerMode;
    }

    public void setTriggerMode(TriggerMode triggerMode) {
        this.triggerMode = triggerMode;
    }

    public TriggeredMode getTriggeredMode() {
        return this.triggeredMode;
    }

    public void setTriggeredMode(TriggeredMode triggeredMode) {
        this.triggeredMode = triggeredMode;
    }

    public int getMaxTimer() {
        return this.maxTimer;
    }

    public void setMaxTimer(int maxTimer) {
        this.maxTimer = maxTimer;
    }

    @Override
    public void reset() {
        if (this.hasTriggered) {
            this.hasTriggered = false;
        }
        if (this.wasTriggered) {
            this.wasTriggered = false;
        }
        this.playerMap.clear();
        this.playerList.clear();
        this.playerList2.clear();
    }

    @Override
    public void trigger() {
        if (this.triggeredMode == TriggeredMode.ONCE && !this.wasTriggered || this.triggeredMode == TriggeredMode.CONTINUOUS) {
            this.sendMessage(this.triggeredMessage);
            this.wasTriggered = true;
        }
    }

    @Override
    protected void onRotate(class_2680 state) {
        if (state.method_26204() instanceof RotatedBlockWithEntity) {
            MutablePair<class_2338, class_2382> offsetArea;
            if ((Integer)state.method_11654((class_2769)RotatedBlockWithEntity.ROTATED) != this.rotated) {
                class_2470 blockRotation = BlockRotationUtils.calculateRotationFromDifferentRotatedStates((Integer)state.method_11654((class_2769)RotatedBlockWithEntity.ROTATED), this.rotated);
                MutablePair<class_2338, class_2382> offsetArea2 = BlockRotationUtils.rotateOffsetArea(this.areaPositionOffset, this.areaDimensions, blockRotation);
                this.areaPositionOffset = (class_2338)offsetArea2.getLeft();
                this.areaDimensions = (class_2382)offsetArea2.getRight();
                this.triggeredBlock.setLeft((Object)BlockRotationUtils.rotateOffsetBlockPos((class_2338)this.triggeredBlock.getLeft(), blockRotation));
                this.rotated = (Integer)state.method_11654((class_2769)RotatedBlockWithEntity.ROTATED);
            }
            if ((Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.X_MIRRORED) != this.x_mirrored) {
                offsetArea = BlockRotationUtils.mirrorOffsetArea(this.areaPositionOffset, this.areaDimensions, class_2415.field_11301);
                this.areaPositionOffset = (class_2338)offsetArea.getLeft();
                this.areaDimensions = (class_2382)offsetArea.getRight();
                this.triggeredBlock.setLeft((Object)BlockRotationUtils.mirrorOffsetBlockPos((class_2338)this.triggeredBlock.getLeft(), class_2415.field_11301));
                this.x_mirrored = (Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.X_MIRRORED);
            }
            if ((Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.Z_MIRRORED) != this.z_mirrored) {
                offsetArea = BlockRotationUtils.mirrorOffsetArea(this.areaPositionOffset, this.areaDimensions, class_2415.field_11300);
                this.areaPositionOffset = (class_2338)offsetArea.getLeft();
                this.areaDimensions = (class_2382)offsetArea.getRight();
                this.triggeredBlock.setLeft((Object)BlockRotationUtils.mirrorOffsetBlockPos((class_2338)this.triggeredBlock.getLeft(), class_2415.field_11300));
                this.z_mirrored = (Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.Z_MIRRORED);
            }
        }
    }

    public static enum TriggerMode implements class_3542
    {
        ALWAYS("always"),
        ONCE("once"),
        TIMED("timed");

        private final String name;

        private TriggerMode(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        public static Optional<TriggerMode> byName(String name) {
            return Arrays.stream(TriggerMode.values()).filter(triggerMode -> triggerMode.method_15434().equals(name)).findFirst();
        }

        public class_2561 asText() {
            return class_2561.method_43471((String)("gui.area_block.trigger_mode." + this.name));
        }
    }

    public static enum TriggeredMode implements class_3542
    {
        CONTINUOUS("continuous"),
        ONCE("once");

        private final String name;

        private TriggeredMode(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        public static Optional<TriggeredMode> byName(String name) {
            return Arrays.stream(TriggeredMode.values()).filter(triggeredMode -> triggeredMode.method_15434().equals(name)).findFirst();
        }

        public class_2561 asText() {
            return class_2561.method_43471((String)("gui.area_block.triggered_mode." + this.name));
        }
    }

    public static enum MessageMode implements class_3542
    {
        ANNOUNCEMENT("announcement"),
        CHAT("chat"),
        OVERLAY("overlay");

        private final String name;

        private MessageMode(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        public static Optional<MessageMode> byName(String name) {
            return Arrays.stream(MessageMode.values()).filter(messageMode -> messageMode.method_15434().equals(name)).findFirst();
        }

        public class_2561 asText() {
            return class_2561.method_43471((String)("gui.area_block.message_mode." + this.name));
        }
    }
}

