/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.scriptblocks.block.entity;

import com.github.theredbrain.scriptblocks.ScriptBlocks;
import com.github.theredbrain.scriptblocks.block.RotatedBlockWithEntity;
import com.github.theredbrain.scriptblocks.block.Triggerable;
import com.github.theredbrain.scriptblocks.block.entity.RotatedBlockEntity;
import com.github.theredbrain.scriptblocks.registry.EntityRegistry;
import com.github.theredbrain.scriptblocks.util.BlockRotationUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.MutablePair;

public class AreaFillerBlockEntity
extends RotatedBlockEntity
implements Triggerable {
    private boolean showArea = false;
    private class_2382 areaDimensions = class_2382.field_11176;
    private class_2338 areaPositionOffset = new class_2338(0, 1, 0);
    private String blockIdentifierString = "";
    private List<MutablePair<class_2338, class_2382>> subAreasList = new ArrayList<MutablePair<class_2338, class_2382>>();

    public AreaFillerBlockEntity(class_2338 pos, class_2680 state) {
        super(EntityRegistry.AREA_FILLER_BLOCK_ENTITY, pos, state);
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        if (this.showArea) {
            nbt.method_10556("showArea", true);
        } else {
            nbt.method_10551("showArea");
        }
        if (this.areaDimensions.method_10263() != 0) {
            nbt.method_10569("areaDimensionsX", this.areaDimensions.method_10263());
        } else {
            nbt.method_10551("areaDimensionsX");
        }
        if (this.areaDimensions.method_10264() != 0) {
            nbt.method_10569("areaDimensionsY", this.areaDimensions.method_10264());
        } else {
            nbt.method_10551("areaDimensionsY");
        }
        if (this.areaDimensions.method_10260() != 0) {
            nbt.method_10569("areaDimensionsZ", this.areaDimensions.method_10260());
        } else {
            nbt.method_10551("areaDimensionsZ");
        }
        if (this.areaPositionOffset.method_10263() != 0) {
            nbt.method_10569("areaPositionOffsetX", this.areaPositionOffset.method_10263());
        } else {
            nbt.method_10551("areaPositionOffsetX");
        }
        if (this.areaPositionOffset.method_10264() != 0) {
            nbt.method_10569("areaPositionOffsetY", this.areaPositionOffset.method_10264());
        } else {
            nbt.method_10551("areaPositionOffsetY");
        }
        if (this.areaPositionOffset.method_10260() != 0) {
            nbt.method_10569("areaPositionOffsetZ", this.areaPositionOffset.method_10260());
        } else {
            nbt.method_10551("areaPositionOffsetZ");
        }
        if (!this.subAreasList.isEmpty()) {
            int previousSize = nbt.method_10550("subAreasListSize");
            nbt.method_10569("subAreasListSize", this.subAreasList.size());
            for (int i = 0; i < Math.max(this.subAreasList.size(), previousSize); ++i) {
                if (i < this.subAreasList.size()) {
                    class_2338 areaPositionOffset = (class_2338)this.subAreasList.get(i).getLeft();
                    class_2382 areaDimension = (class_2382)this.subAreasList.get(i).getRight();
                    nbt.method_10569("subAreaPositionOffsetX_" + i, areaPositionOffset.method_10263());
                    nbt.method_10569("subAreaPositionOffsetY_" + i, areaPositionOffset.method_10264());
                    nbt.method_10569("subAreaPositionOffsetZ_" + i, areaPositionOffset.method_10260());
                    nbt.method_10569("subAreaDimensionX_" + i, areaDimension.method_10263());
                    nbt.method_10569("subAreaDimensionY_" + i, areaDimension.method_10264());
                    nbt.method_10569("subAreaDimensionZ_" + i, areaDimension.method_10260());
                    continue;
                }
                nbt.method_10551("subAreaPositionOffsetX_" + i);
                nbt.method_10551("subAreaPositionOffsetY_" + i);
                nbt.method_10551("subAreaPositionOffsetZ_" + i);
                nbt.method_10551("subAreaDimensionX_" + i);
                nbt.method_10551("subAreaDimensionY_" + i);
                nbt.method_10551("subAreaDimensionZ_" + i);
            }
        }
        if (!this.blockIdentifierString.isEmpty()) {
            nbt.method_10582("blockIdentifierString", this.blockIdentifierString);
        } else {
            nbt.method_10551("blockIdentifierString");
        }
        super.method_11007(nbt, registryLookup);
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        this.showArea = nbt.method_10577("showArea");
        int i = Math.max(0, nbt.method_10550("areaDimensionsX"));
        int j = Math.max(0, nbt.method_10550("areaDimensionsY"));
        int k = Math.max(0, nbt.method_10550("areaDimensionsZ"));
        this.areaDimensions = new class_2382(i, j, k);
        int l = nbt.method_10550("areaPositionOffsetX");
        int m = nbt.method_10550("areaPositionOffsetY");
        int n = nbt.method_10550("areaPositionOffsetZ");
        this.areaPositionOffset = new class_2338(l, m, n);
        int subAreasListSize = nbt.method_10550("subAreasListSize");
        this.subAreasList = new ArrayList<MutablePair<class_2338, class_2382>>(List.of());
        for (i = 0; i < subAreasListSize; ++i) {
            this.subAreasList.add((MutablePair<class_2338, class_2382>)new MutablePair((Object)new class_2338(nbt.method_10550("subAreaPositionOffsetX_" + i), nbt.method_10550("subAreaPositionOffsetY_" + i), nbt.method_10550("subAreaPositionOffsetZ_" + i)), (Object)new class_2382(nbt.method_10550("subAreaDimensionX_" + i), nbt.method_10550("subAreaDimensionY_" + i), nbt.method_10550("subAreaDimensionZ_" + i))));
        }
        this.blockIdentifierString = nbt.method_10558("blockIdentifierString");
        super.method_11014(nbt, registryLookup);
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return this.method_58692(registryLookup);
    }

    public boolean showArea() {
        return this.showArea;
    }

    public void setShowArea(boolean showArea) {
        this.showArea = showArea;
    }

    public class_2382 getAreaDimensions() {
        return this.areaDimensions;
    }

    public boolean setAreaDimensions(class_2382 areaDimensions) {
        this.areaDimensions = areaDimensions;
        this.subAreasList.clear();
        return true;
    }

    public class_2338 getAreaPositionOffset() {
        return this.areaPositionOffset;
    }

    public boolean setAreaPositionOffset(class_2338 areaPositionOffset) {
        this.areaPositionOffset = areaPositionOffset;
        this.subAreasList.clear();
        return true;
    }

    public String getBlockIdentifierString() {
        return this.blockIdentifierString;
    }

    public boolean setBlockIdentifierString(String blockIdentifierString) {
        Optional optionalBlockReference;
        if (this.field_11863 != null && (optionalBlockReference = this.field_11863.method_30349().method_30530(class_7924.field_41254).method_55841(class_2960.method_12829((String)blockIdentifierString))).isPresent()) {
            this.blockIdentifierString = blockIdentifierString;
            return true;
        }
        return false;
    }

    @Override
    public void trigger() {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            MinecraftServer server = serverWorld.method_8503();
            if (this.subAreasList.isEmpty()) {
                this.subAreasList = this.splitArea(this.areaPositionOffset, this.areaDimensions, ((class_1928.class_4312)server.method_3767().method_20746(class_1928.field_41766)).method_20763(), 16);
            }
            for (MutablePair<class_2338, class_2382> pair : this.subAreasList) {
                class_2338 startPos = this.field_11867.method_10081((class_2382)pair.getLeft());
                class_2338 endPos = startPos.method_10069(((class_2382)pair.getRight()).method_10263() - 1, ((class_2382)pair.getRight()).method_10264() - 1, ((class_2382)pair.getRight()).method_10260() - 1);
                String commandString = "/execute in " + String.valueOf(this.field_11863.method_27983().method_29177()) + " run fill " + startPos.method_10263() + " " + startPos.method_10264() + " " + startPos.method_10260() + " " + endPos.method_10263() + " " + endPos.method_10264() + " " + endPos.method_10260() + " " + this.blockIdentifierString;
                ScriptBlocks.info(commandString);
                server.method_3734().method_44252(server.method_3739(), commandString);
            }
        }
    }

    private List<MutablePair<class_2338, class_2382>> splitArea(class_2338 areaPos, class_2382 areaDimensions, int maxVolume, int maxIterations) {
        ArrayList<MutablePair<class_2338, class_2382>> list = new ArrayList<MutablePair<class_2338, class_2382>>();
        if (maxIterations > 0) {
            int z;
            int y;
            int x = areaDimensions.method_10263();
            if (x * (y = areaDimensions.method_10264()) * (z = areaDimensions.method_10260()) <= maxVolume) {
                list.add((MutablePair<class_2338, class_2382>)new MutablePair((Object)areaPos, (Object)areaDimensions));
            } else {
                int n;
                int m = x;
                int index = 0;
                if (y > m) {
                    m = y;
                    index = 1;
                }
                if (z > m) {
                    m = z;
                    index = 2;
                }
                if (m % 2 == 0) {
                    n = m /= 2;
                } else {
                    m = (int)Math.ceil((double)m / 2.0);
                    n = m - 1;
                }
                int[] new_array_1 = new int[]{x, y, z};
                int[] new_array_2 = new int[]{x, y, z};
                int[] second_pos_offset = new int[]{0, 0, 0};
                new_array_1[index] = m;
                new_array_2[index] = n;
                second_pos_offset[index] = m;
                list.addAll(this.splitArea(areaPos, new class_2382(new_array_1[0], new_array_1[1], new_array_1[2]), maxVolume, maxIterations - 1));
                list.addAll(this.splitArea(areaPos.method_10069(second_pos_offset[0], second_pos_offset[1], second_pos_offset[2]), new class_2382(new_array_2[0], new_array_2[1], new_array_2[2]), maxVolume, maxIterations - 1));
            }
        } else if (this.field_11863 != null) {
            ScriptBlocks.info("AreaFillerBlock in " + String.valueOf(this.field_11863.method_27983().method_29177()) + " at " + this.field_11867.method_23854() + " ran out of iteration attempts!");
        }
        return list;
    }

    @Override
    protected void onRotate(class_2680 state) {
        if (state.method_26204() instanceof RotatedBlockWithEntity) {
            MutablePair<class_2338, class_2382> offsetArea;
            if ((Integer)state.method_11654((class_2769)RotatedBlockWithEntity.ROTATED) != this.rotated) {
                class_2470 blockRotation = BlockRotationUtils.calculateRotationFromDifferentRotatedStates((Integer)state.method_11654((class_2769)RotatedBlockWithEntity.ROTATED), this.rotated);
                MutablePair<class_2338, class_2382> offsetArea2 = BlockRotationUtils.rotateOffsetArea(this.areaPositionOffset, this.areaDimensions, blockRotation);
                this.areaPositionOffset = (class_2338)offsetArea2.getLeft();
                this.areaDimensions = (class_2382)offsetArea2.getRight();
                this.rotated = (Integer)state.method_11654((class_2769)RotatedBlockWithEntity.ROTATED);
            }
            if ((Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.X_MIRRORED) != this.x_mirrored) {
                offsetArea = BlockRotationUtils.mirrorOffsetArea(this.areaPositionOffset, this.areaDimensions, class_2415.field_11301);
                this.areaPositionOffset = (class_2338)offsetArea.getLeft();
                this.areaDimensions = (class_2382)offsetArea.getRight();
                this.x_mirrored = (Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.X_MIRRORED);
            }
            if ((Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.Z_MIRRORED) != this.z_mirrored) {
                offsetArea = BlockRotationUtils.mirrorOffsetArea(this.areaPositionOffset, this.areaDimensions, class_2415.field_11300);
                this.areaPositionOffset = (class_2338)offsetArea.getLeft();
                this.areaDimensions = (class_2382)offsetArea.getRight();
                this.z_mirrored = (Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.Z_MIRRORED);
            }
            this.subAreasList.clear();
        }
    }
}

