/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.scriptblocks.block.entity;

import com.github.theredbrain.scriptblocks.block.DialogueAnchor;
import com.github.theredbrain.scriptblocks.block.RotatedBlockWithEntity;
import com.github.theredbrain.scriptblocks.block.entity.RotatedBlockEntity;
import com.github.theredbrain.scriptblocks.registry.EntityRegistry;
import com.github.theredbrain.scriptblocks.util.BlockRotationUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_7225;
import org.apache.commons.lang3.tuple.MutablePair;

public class DialogueBlockEntity
extends RotatedBlockEntity
implements DialogueAnchor {
    private class_2338 dataBlockOffset = class_2338.field_10980;
    private HashMap<String, class_2338> dialogueUsedBlocksMap = new HashMap();
    private HashMap<String, MutablePair<class_2338, Boolean>> dialogueTriggeredBlocksMap = new HashMap();
    private List<String> startingDialogueList = new ArrayList<String>();

    public DialogueBlockEntity(class_2338 pos, class_2680 state) {
        super(EntityRegistry.DIALOGUE_BLOCK_ENTITY, pos, state);
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        int i;
        ArrayList<String> dialogueUsedBlocksKeys = new ArrayList<String>(this.dialogueUsedBlocksMap.keySet());
        nbt.method_10569("dialogueUsedBlocksKeysSize", dialogueUsedBlocksKeys.size());
        for (int i2 = 0; i2 < dialogueUsedBlocksKeys.size(); ++i2) {
            String key = (String)dialogueUsedBlocksKeys.get(i2);
            nbt.method_10582("dialogueUsedBlocks_key_" + i2, key);
            nbt.method_10569("dialogueUsedBlocks_entry_X_" + i2, this.dialogueUsedBlocksMap.get(key).method_10263());
            nbt.method_10569("dialogueUsedBlocks_entry_Y_" + i2, this.dialogueUsedBlocksMap.get(key).method_10264());
            nbt.method_10569("dialogueUsedBlocks_entry_Z_" + i2, this.dialogueUsedBlocksMap.get(key).method_10260());
        }
        ArrayList<String> dialogueTriggeredBlocksKeys = new ArrayList<String>(this.dialogueTriggeredBlocksMap.keySet());
        nbt.method_10569("dialogueTriggeredBlocksKeysSize", dialogueTriggeredBlocksKeys.size());
        for (i = 0; i < dialogueTriggeredBlocksKeys.size(); ++i) {
            String key = (String)dialogueTriggeredBlocksKeys.get(i);
            nbt.method_10582("dialogueTriggeredBlocks_key_" + i, key);
            nbt.method_10569("dialogueTriggeredBlocks_entry_X_" + i, ((class_2338)this.dialogueTriggeredBlocksMap.get(key).getLeft()).method_10263());
            nbt.method_10569("dialogueTriggeredBlocks_entry_Y_" + i, ((class_2338)this.dialogueTriggeredBlocksMap.get(key).getLeft()).method_10264());
            nbt.method_10569("dialogueTriggeredBlocks_entry_Z_" + i, ((class_2338)this.dialogueTriggeredBlocksMap.get(key).getLeft()).method_10260());
            nbt.method_10556("dialogueTriggeredBlocks_entry_resets_" + i, ((Boolean)this.dialogueTriggeredBlocksMap.get(key).getRight()).booleanValue());
        }
        nbt.method_10569("dataBlockOffsetX", this.dataBlockOffset.method_10263());
        nbt.method_10569("dataBlockOffsetY", this.dataBlockOffset.method_10264());
        nbt.method_10569("dataBlockOffsetZ", this.dataBlockOffset.method_10260());
        nbt.method_10569("startingDialogueListSize", this.startingDialogueList.size());
        for (i = 0; i < this.startingDialogueList.size(); ++i) {
            nbt.method_10582("startingDialogueList_name_" + i, this.startingDialogueList.get(i));
        }
        super.method_11007(nbt, registryLookup);
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        this.dialogueUsedBlocksMap.clear();
        int dialogueUsedBlocksKeysSize = nbt.method_10550("dialogueUsedBlocksKeysSize");
        for (int i = 0; i < dialogueUsedBlocksKeysSize; ++i) {
            this.dialogueUsedBlocksMap.put(nbt.method_10558("dialogueUsedBlocks_key_" + i), new class_2338(class_3532.method_15340((int)nbt.method_10550("dialogueUsedBlocks_entry_X_" + i), (int)-48, (int)48), class_3532.method_15340((int)nbt.method_10550("dialogueUsedBlocks_entry_Y_" + i), (int)-48, (int)48), class_3532.method_15340((int)nbt.method_10550("dialogueUsedBlocks_entry_Z_" + i), (int)-48, (int)48)));
        }
        this.dialogueTriggeredBlocksMap.clear();
        int dialogueTriggeredBlocksKeysSize = nbt.method_10550("dialogueTriggeredBlocksKeysSize");
        for (int i = 0; i < dialogueTriggeredBlocksKeysSize; ++i) {
            this.dialogueTriggeredBlocksMap.put(nbt.method_10558("dialogueTriggeredBlocks_key_" + i), (MutablePair<class_2338, Boolean>)new MutablePair((Object)new class_2338(class_3532.method_15340((int)nbt.method_10550("dialogueTriggeredBlocks_entry_X_" + i), (int)-48, (int)48), class_3532.method_15340((int)nbt.method_10550("dialogueTriggeredBlocks_entry_Y_" + i), (int)-48, (int)48), class_3532.method_15340((int)nbt.method_10550("dialogueTriggeredBlocks_entry_Z_" + i), (int)-48, (int)48)), (Object)nbt.method_10577("dialogueTriggeredBlocks_entry_resets_" + i)));
        }
        this.dataBlockOffset = new class_2338(class_3532.method_15340((int)nbt.method_10550("dataBlockOffsetX"), (int)-48, (int)48), class_3532.method_15340((int)nbt.method_10550("dataBlockOffsetY"), (int)-48, (int)48), class_3532.method_15340((int)nbt.method_10550("dataBlockOffsetZ"), (int)-48, (int)48));
        this.startingDialogueList.clear();
        int startingDialogueListSize = nbt.method_10550("startingDialogueListSize");
        for (int i = 0; i < startingDialogueListSize; ++i) {
            this.startingDialogueList.add(nbt.method_10558("startingDialogueList_name_" + i));
        }
        super.method_11014(nbt, registryLookup);
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return this.method_58692(registryLookup);
    }

    public HashMap<String, class_2338> getDialogueUsedBlocksMap() {
        return this.dialogueUsedBlocksMap;
    }

    public void setDialogueUsedBlocksMap(HashMap<String, class_2338> dialogueUsedBlocks) {
        this.dialogueUsedBlocksMap = dialogueUsedBlocks;
    }

    public HashMap<String, MutablePair<class_2338, Boolean>> getDialogueTriggeredBlocksMap() {
        return this.dialogueTriggeredBlocksMap;
    }

    public void setDialogueTriggeredBlocksMap(HashMap<String, MutablePair<class_2338, Boolean>> dialogueTriggeredBlocks) {
        this.dialogueTriggeredBlocksMap = dialogueTriggeredBlocks;
    }

    public List<String> getStartingDialogueList() {
        return this.startingDialogueList;
    }

    public void setStartingDialogueList(List<String> startingDialogueList) {
        this.startingDialogueList = startingDialogueList;
    }

    public class_2338 getDataBlockOffset() {
        return this.dataBlockOffset;
    }

    public void setDataBlockOffset(class_2338 dataBlockOffset) {
        this.dataBlockOffset = dataBlockOffset;
    }

    @Override
    public class_2338 getDataBlockPos() {
        return new class_2338((class_2382)this.field_11867.method_10081((class_2382)this.dataBlockOffset));
    }

    @Override
    public List<MutablePair<String, class_2338>> getDialogueUsedBlocks() {
        ArrayList<MutablePair<String, class_2338>> dialogueUsedBlocks = new ArrayList<MutablePair<String, class_2338>>();
        ArrayList<String> dialogueUsedBlocksKeys = new ArrayList<String>(this.dialogueUsedBlocksMap.keySet());
        for (String key : dialogueUsedBlocksKeys) {
            dialogueUsedBlocks.add((MutablePair<String, class_2338>)new MutablePair((Object)key, (Object)this.field_11867.method_10081((class_2382)this.dialogueUsedBlocksMap.get(key))));
        }
        return dialogueUsedBlocks;
    }

    @Override
    public List<MutablePair<String, MutablePair<class_2338, Boolean>>> getDialogueTriggeredBlocks() {
        ArrayList<MutablePair<String, MutablePair<class_2338, Boolean>>> dialogueTriggeredBlocks = new ArrayList<MutablePair<String, MutablePair<class_2338, Boolean>>>();
        ArrayList<String> dialogueTriggeredBlocksKeys = new ArrayList<String>(this.dialogueTriggeredBlocksMap.keySet());
        for (String key : dialogueTriggeredBlocksKeys) {
            dialogueTriggeredBlocks.add((MutablePair<String, MutablePair<class_2338, Boolean>>)new MutablePair((Object)key, (Object)new MutablePair((Object)this.field_11867.method_10081((class_2382)this.dialogueTriggeredBlocksMap.get(key).getLeft()), (Object)((Boolean)this.dialogueTriggeredBlocksMap.get(key).getRight()))));
        }
        return dialogueTriggeredBlocks;
    }

    @Override
    protected void onRotate(class_2680 state) {
        if (state.method_26204() instanceof RotatedBlockWithEntity) {
            MutablePair<class_2338, Boolean> oldBlockPos2;
            ArrayList<String> keys;
            if ((Integer)state.method_11654((class_2769)RotatedBlockWithEntity.ROTATED) != this.rotated) {
                class_2470 blockRotation = BlockRotationUtils.calculateRotationFromDifferentRotatedStates((Integer)state.method_11654((class_2769)RotatedBlockWithEntity.ROTATED), this.rotated);
                ArrayList<String> keys2 = new ArrayList<String>(this.dialogueUsedBlocksMap.keySet());
                for (String key : keys2) {
                    this.dialogueUsedBlocksMap.compute(key, (k, oldBlockPos) -> BlockRotationUtils.rotateOffsetBlockPos(oldBlockPos, blockRotation));
                }
                keys2 = new ArrayList<String>(this.dialogueTriggeredBlocksMap.keySet());
                for (String key : keys2) {
                    MutablePair<class_2338, Boolean> oldBlockPos3 = this.dialogueTriggeredBlocksMap.get(key);
                    oldBlockPos3.setLeft((Object)BlockRotationUtils.rotateOffsetBlockPos((class_2338)oldBlockPos3.getLeft(), blockRotation));
                    this.dialogueTriggeredBlocksMap.put(key, oldBlockPos3);
                }
                this.rotated = (Integer)state.method_11654((class_2769)RotatedBlockWithEntity.ROTATED);
            }
            if ((Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.X_MIRRORED) != this.x_mirrored) {
                keys = new ArrayList<String>(this.dialogueUsedBlocksMap.keySet());
                for (String key : keys) {
                    this.dialogueUsedBlocksMap.compute(key, (k, oldBlockPos) -> BlockRotationUtils.mirrorOffsetBlockPos(oldBlockPos, class_2415.field_11301));
                }
                keys = new ArrayList<String>(this.dialogueTriggeredBlocksMap.keySet());
                for (String key : keys) {
                    oldBlockPos2 = this.dialogueTriggeredBlocksMap.get(key);
                    oldBlockPos2.setLeft((Object)BlockRotationUtils.mirrorOffsetBlockPos((class_2338)oldBlockPos2.getLeft(), class_2415.field_11301));
                    this.dialogueTriggeredBlocksMap.put(key, oldBlockPos2);
                }
                this.x_mirrored = (Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.X_MIRRORED);
            }
            if ((Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.Z_MIRRORED) != this.z_mirrored) {
                keys = new ArrayList<String>(this.dialogueUsedBlocksMap.keySet());
                for (String key : keys) {
                    this.dialogueUsedBlocksMap.compute(key, (k, oldBlockPos) -> BlockRotationUtils.mirrorOffsetBlockPos(oldBlockPos, class_2415.field_11300));
                }
                keys = new ArrayList<String>(this.dialogueTriggeredBlocksMap.keySet());
                for (String key : keys) {
                    oldBlockPos2 = this.dialogueTriggeredBlocksMap.get(key);
                    oldBlockPos2.setLeft((Object)BlockRotationUtils.mirrorOffsetBlockPos((class_2338)oldBlockPos2.getLeft(), class_2415.field_11300));
                    this.dialogueTriggeredBlocksMap.put(key, oldBlockPos2);
                }
                this.z_mirrored = (Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.Z_MIRRORED);
            }
        }
    }
}

