/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.scriptblocks.block.entity;

import com.github.theredbrain.scriptblocks.block.Resetable;
import com.github.theredbrain.scriptblocks.block.RotatedBlockWithEntity;
import com.github.theredbrain.scriptblocks.block.Triggerable;
import com.github.theredbrain.scriptblocks.block.entity.RotatedBlockEntity;
import com.github.theredbrain.scriptblocks.entity.player.DuckPlayerEntityMixin;
import com.github.theredbrain.scriptblocks.registry.EntityRegistry;
import com.github.theredbrain.scriptblocks.registry.StatusEffectsRegistry;
import com.github.theredbrain.scriptblocks.util.BlockRotationUtils;
import com.github.theredbrain.scriptblocks.util.UUIDUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_268;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.apache.commons.lang3.tuple.MutablePair;

public class HousingBlockEntity
extends RotatedBlockEntity {
    private String ownerUuid = "";
    private boolean isOwnerSet = false;
    private List<String> coOwnerList = new ArrayList<String>(List.of());
    private List<String> trustedList = new ArrayList<String>(List.of());
    private List<String> guestList = new ArrayList<String>(List.of());
    private boolean showInfluenceArea = false;
    private class_2382 influenceAreaDimensions = class_2382.field_11176;
    private class_2338 influenceAreaPositionOffset = new class_2338(0, 1, 0);
    private OwnerMode ownerMode = OwnerMode.DIMENSION_OWNER;
    private MutablePair<class_2338, Boolean> triggeredBlock = new MutablePair((Object)new class_2338(0, 0, 0), (Object)false);

    public HousingBlockEntity(class_2338 pos, class_2680 state) {
        super(EntityRegistry.HOUSING_BLOCK_ENTITY, pos, state);
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        nbt.method_10582("ownerUuid", this.ownerUuid);
        nbt.method_10556("isOwnerSet", this.isOwnerSet);
        int coOwnerListSize = this.coOwnerList.size();
        nbt.method_10569("coOwnerListSize", coOwnerListSize);
        for (int i = 0; i < coOwnerListSize; ++i) {
            nbt.method_10582("coOwnerListEntry" + i, this.coOwnerList.get(i));
        }
        int trustedListSize = this.trustedList.size();
        nbt.method_10569("trustedListSize", trustedListSize);
        for (int i = 0; i < trustedListSize; ++i) {
            nbt.method_10582("trustedListEntry" + i, this.trustedList.get(i));
        }
        int guestListSize = this.guestList.size();
        nbt.method_10569("guestListSize", guestListSize);
        for (int i = 0; i < guestListSize; ++i) {
            nbt.method_10582("guestListEntry" + i, this.guestList.get(i));
        }
        nbt.method_10556("showInfluenceArea", this.showInfluenceArea);
        nbt.method_10569("influenceAreaDimensionsX", this.influenceAreaDimensions.method_10263());
        nbt.method_10569("influenceAreaDimensionsY", this.influenceAreaDimensions.method_10264());
        nbt.method_10569("influenceAreaDimensionsZ", this.influenceAreaDimensions.method_10260());
        nbt.method_10569("influenceAreaPositionOffsetX", this.influenceAreaPositionOffset.method_10263());
        nbt.method_10569("influenceAreaPositionOffsetY", this.influenceAreaPositionOffset.method_10264());
        nbt.method_10569("influenceAreaPositionOffsetZ", this.influenceAreaPositionOffset.method_10260());
        nbt.method_10582("ownerMode", this.ownerMode.method_15434());
        nbt.method_10569("triggeredBlockPositionOffsetX", ((class_2338)this.triggeredBlock.getLeft()).method_10263());
        nbt.method_10569("triggeredBlockPositionOffsetY", ((class_2338)this.triggeredBlock.getLeft()).method_10264());
        nbt.method_10569("triggeredBlockPositionOffsetZ", ((class_2338)this.triggeredBlock.getLeft()).method_10260());
        nbt.method_10556("triggeredBlockResets", ((Boolean)this.triggeredBlock.getRight()).booleanValue());
        super.method_11007(nbt, registryLookup);
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        int i;
        this.ownerUuid = nbt.method_10558("ownerUuid");
        this.isOwnerSet = nbt.method_10577("isOwnerSet");
        int coOwnerListSize = nbt.method_10550("coOwnerListSize");
        this.coOwnerList.clear();
        for (int i2 = 0; i2 < coOwnerListSize; ++i2) {
            this.coOwnerList.add(nbt.method_10558("coOwnerListEntry" + i2));
        }
        int trustedListSize = nbt.method_10550("trustedListSize");
        this.trustedList.clear();
        for (int i3 = 0; i3 < trustedListSize; ++i3) {
            this.trustedList.add(nbt.method_10558("trustedListEntry" + i3));
        }
        int guestListSize = nbt.method_10550("guestListSize");
        this.guestList.clear();
        for (i = 0; i < guestListSize; ++i) {
            this.guestList.add(nbt.method_10558("guestListEntry" + i));
        }
        this.showInfluenceArea = nbt.method_10577("showInfluenceArea");
        i = class_3532.method_15340((int)nbt.method_10550("influenceAreaDimensionsX"), (int)0, (int)48);
        int j = class_3532.method_15340((int)nbt.method_10550("influenceAreaDimensionsY"), (int)0, (int)48);
        int k = class_3532.method_15340((int)nbt.method_10550("influenceAreaDimensionsZ"), (int)0, (int)48);
        this.influenceAreaDimensions = new class_2382(i, j, k);
        int l = class_3532.method_15340((int)nbt.method_10550("influenceAreaPositionOffsetX"), (int)-48, (int)48);
        int m = class_3532.method_15340((int)nbt.method_10550("influenceAreaPositionOffsetY"), (int)-48, (int)48);
        int n = class_3532.method_15340((int)nbt.method_10550("influenceAreaPositionOffsetZ"), (int)-48, (int)48);
        this.influenceAreaPositionOffset = new class_2338(l, m, n);
        this.ownerMode = OwnerMode.byName(nbt.method_10558("ownerMode")).orElseGet(() -> OwnerMode.DIMENSION_OWNER);
        int x = class_3532.method_15340((int)nbt.method_10550("triggeredBlockPositionOffsetX"), (int)-48, (int)48);
        int y = class_3532.method_15340((int)nbt.method_10550("triggeredBlockPositionOffsetY"), (int)-48, (int)48);
        int z = class_3532.method_15340((int)nbt.method_10550("triggeredBlockPositionOffsetZ"), (int)-48, (int)48);
        this.triggeredBlock = new MutablePair((Object)new class_2338(x, y, z), (Object)nbt.method_10577("triggeredBlockResets"));
        super.method_11014(nbt, registryLookup);
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return this.method_58692(registryLookup);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, HousingBlockEntity blockEntity) {
        if (!world.field_9236 && world.method_8510() % 20L == 0L) {
            class_268 ownerTeam = null;
            if (blockEntity.method_11002() && !blockEntity.isOwnerSet && blockEntity.ownerMode == OwnerMode.DIMENSION_OWNER) {
                blockEntity.ownerUuid = HousingBlockEntity.initOwner(blockEntity.field_11863);
                if (UUIDUtilities.isStringValidUUID(blockEntity.ownerUuid)) {
                    blockEntity.isOwnerSet = true;
                    class_1657 owner = world.method_18470(UUID.fromString(blockEntity.ownerUuid));
                    if (owner != null) {
                        ownerTeam = owner.method_5781();
                    }
                }
            }
            class_238 box = new class_238((double)(blockEntity.field_11867.method_10263() + blockEntity.influenceAreaPositionOffset.method_10263()), (double)(blockEntity.field_11867.method_10264() + blockEntity.influenceAreaPositionOffset.method_10264()), (double)(blockEntity.field_11867.method_10260() + blockEntity.influenceAreaPositionOffset.method_10260()), (double)(blockEntity.field_11867.method_10263() + blockEntity.influenceAreaPositionOffset.method_10263() + blockEntity.influenceAreaDimensions.method_10263()), (double)(blockEntity.field_11867.method_10264() + blockEntity.influenceAreaPositionOffset.method_10264() + blockEntity.influenceAreaDimensions.method_10264()), (double)(blockEntity.field_11867.method_10260() + blockEntity.influenceAreaPositionOffset.method_10260() + blockEntity.influenceAreaDimensions.method_10260()));
            List list = world.method_18467(class_1657.class, box);
            for (class_1657 playerEntity : list) {
                String playerName = playerEntity.method_5477().getString();
                String playerUuid = playerEntity.method_5845();
                if (Objects.equals(playerUuid, blockEntity.getOwnerUuid())) {
                    playerEntity.method_6092(new class_1293(class_7923.field_41174.method_47983((Object)StatusEffectsRegistry.HOUSING_OWNER_EFFECT), 100, 0, true, false, false));
                } else if (blockEntity.getCoOwnerList().contains(playerName)) {
                    playerEntity.method_6092(new class_1293(class_7923.field_41174.method_47983((Object)StatusEffectsRegistry.HOUSING_CO_OWNER_EFFECT), 100, 0, true, false, false));
                } else if (blockEntity.getTrustedList().contains(playerName)) {
                    playerEntity.method_6092(new class_1293(class_7923.field_41174.method_47983((Object)StatusEffectsRegistry.HOUSING_TRUSTED_EFFECT), 100, 0, true, false, false));
                } else if (blockEntity.getGuestList().contains(playerName) || ownerTeam != null && ownerTeam.method_1204().contains(playerName)) {
                    playerEntity.method_6092(new class_1293(class_7923.field_41174.method_47983((Object)StatusEffectsRegistry.HOUSING_GUEST_EFFECT), 100, 0, true, false, false));
                } else {
                    playerEntity.method_6092(new class_1293(class_7923.field_41174.method_47983((Object)StatusEffectsRegistry.HOUSING_STRANGER_EFFECT), 100, 0, true, false, false));
                }
                ((DuckPlayerEntityMixin)playerEntity).scriptblocks$setCurrentHousingBlockPosition(Optional.of(blockEntity.field_11867));
            }
        }
    }

    public String getOwnerUuid() {
        return this.ownerUuid;
    }

    public boolean setOwnerUuid(String ownerUuid) {
        if (ownerUuid.isEmpty()) {
            this.ownerUuid = ownerUuid;
            return true;
        }
        if (UUIDUtilities.isStringValidUUID(ownerUuid)) {
            this.ownerUuid = ownerUuid;
            return true;
        }
        return false;
    }

    public List<String> getCoOwnerList() {
        return this.coOwnerList;
    }

    public void setCoOwnerList(List<String> coOwnerList) {
        this.coOwnerList = coOwnerList;
    }

    public List<String> getTrustedList() {
        return this.trustedList;
    }

    public void setTrustedList(List<String> trustedList) {
        this.trustedList = trustedList;
    }

    public List<String> getGuestList() {
        return this.guestList;
    }

    public void setGuestList(List<String> guestList) {
        this.guestList = guestList;
    }

    public boolean getShowInfluenceArea() {
        return this.showInfluenceArea;
    }

    public boolean setShowInfluenceArea(boolean showInfluenceArea) {
        this.showInfluenceArea = showInfluenceArea;
        return true;
    }

    public class_2382 getInfluenceAreaDimensions() {
        return this.influenceAreaDimensions;
    }

    public boolean setInfluenceAreaDimensions(class_2382 influenceAreaDimensions) {
        this.influenceAreaDimensions = influenceAreaDimensions;
        return true;
    }

    public class_2338 getRestrictBlockBreakingAreaPositionOffset() {
        return this.influenceAreaPositionOffset;
    }

    public boolean setRestrictBlockBreakingAreaPositionOffset(class_2338 influenceAreaPositionOffset) {
        this.influenceAreaPositionOffset = influenceAreaPositionOffset;
        return true;
    }

    public MutablePair<class_2338, Boolean> getTriggeredBlock() {
        return this.triggeredBlock;
    }

    public void setTriggeredBlock(MutablePair<class_2338, Boolean> triggeredBlock) {
        this.triggeredBlock = triggeredBlock;
    }

    public OwnerMode getOwnerMode() {
        return this.ownerMode;
    }

    public boolean setOwnerMode(OwnerMode ownerMode) {
        this.ownerMode = ownerMode;
        return true;
    }

    public boolean isOwnerSet() {
        return this.isOwnerSet;
    }

    public void setIsOwnerSet(boolean isOwnerSet) {
        this.isOwnerSet = isOwnerSet;
    }

    private static String initOwner(class_1937 world) {
        String worldRegistryKey;
        String[] parts;
        String uuidString;
        if (world != null && UUIDUtilities.isStringValidUUID(uuidString = (parts = (worldRegistryKey = world.method_27983().method_29177().method_12832()).split("_"))[0])) {
            return uuidString;
        }
        return "";
    }

    public boolean influenceAreaContains(class_2338 pos) {
        return (double)(pos.method_10263() + 1) > (double)(this.field_11867.method_10263() + this.influenceAreaPositionOffset.method_10263()) && (double)pos.method_10263() < (double)(this.field_11867.method_10263() + this.influenceAreaPositionOffset.method_10263() + this.influenceAreaDimensions.method_10263()) && (double)(pos.method_10264() + 1) > (double)(this.field_11867.method_10264() + this.influenceAreaPositionOffset.method_10264()) && (double)pos.method_10264() < (double)(this.field_11867.method_10264() + this.influenceAreaPositionOffset.method_10264() + this.influenceAreaDimensions.method_10264()) && (double)(pos.method_10260() + 1) > (double)(this.field_11867.method_10260() + this.influenceAreaPositionOffset.method_10260()) && (double)pos.method_10260() < (double)(this.field_11867.method_10260() + this.influenceAreaPositionOffset.method_10260() + this.influenceAreaDimensions.method_10260());
    }

    public void trigger() {
        class_2586 blockEntity;
        if (this.field_11863 != null && (blockEntity = this.field_11863.method_8321(new class_2338(this.field_11867.method_10263() + ((class_2338)this.triggeredBlock.getLeft()).method_10263(), this.field_11867.method_10264() + ((class_2338)this.triggeredBlock.getLeft()).method_10264(), this.field_11867.method_10260() + ((class_2338)this.triggeredBlock.getLeft()).method_10260()))) != this) {
            boolean triggeredBlockResets = (Boolean)this.triggeredBlock.getRight();
            if (triggeredBlockResets && blockEntity instanceof Resetable) {
                Resetable resetable = (Resetable)blockEntity;
                resetable.reset();
            } else if (!triggeredBlockResets && blockEntity instanceof Triggerable) {
                Triggerable triggerable = (Triggerable)blockEntity;
                triggerable.trigger();
            }
        }
    }

    @Override
    protected void onRotate(class_2680 state) {
        if (state.method_26204() instanceof RotatedBlockWithEntity) {
            MutablePair<class_2338, class_2382> offsetArea;
            if ((Integer)state.method_11654((class_2769)RotatedBlockWithEntity.ROTATED) != this.rotated) {
                class_2470 blockRotation = BlockRotationUtils.calculateRotationFromDifferentRotatedStates((Integer)state.method_11654((class_2769)RotatedBlockWithEntity.ROTATED), this.rotated);
                this.triggeredBlock.setLeft((Object)BlockRotationUtils.rotateOffsetBlockPos((class_2338)this.triggeredBlock.getLeft(), blockRotation));
                MutablePair<class_2338, class_2382> offsetArea2 = BlockRotationUtils.rotateOffsetArea(this.influenceAreaPositionOffset, this.influenceAreaDimensions, blockRotation);
                this.influenceAreaPositionOffset = (class_2338)offsetArea2.getLeft();
                this.influenceAreaDimensions = (class_2382)offsetArea2.getRight();
                this.rotated = (Integer)state.method_11654((class_2769)RotatedBlockWithEntity.ROTATED);
            }
            if ((Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.X_MIRRORED) != this.x_mirrored) {
                this.triggeredBlock.setLeft((Object)BlockRotationUtils.mirrorOffsetBlockPos((class_2338)this.triggeredBlock.getLeft(), class_2415.field_11301));
                offsetArea = BlockRotationUtils.mirrorOffsetArea(this.influenceAreaPositionOffset, this.influenceAreaDimensions, class_2415.field_11301);
                this.influenceAreaPositionOffset = (class_2338)offsetArea.getLeft();
                this.influenceAreaDimensions = (class_2382)offsetArea.getRight();
                this.x_mirrored = (Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.X_MIRRORED);
            }
            if ((Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.Z_MIRRORED) != this.z_mirrored) {
                this.triggeredBlock.setLeft((Object)BlockRotationUtils.mirrorOffsetBlockPos((class_2338)this.triggeredBlock.getLeft(), class_2415.field_11300));
                offsetArea = BlockRotationUtils.mirrorOffsetArea(this.influenceAreaPositionOffset, this.influenceAreaDimensions, class_2415.field_11300);
                this.influenceAreaPositionOffset = (class_2338)offsetArea.getLeft();
                this.influenceAreaDimensions = (class_2382)offsetArea.getRight();
                this.z_mirrored = (Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.Z_MIRRORED);
            }
        }
    }

    public static enum OwnerMode implements class_3542
    {
        DIMENSION_OWNER("dimension_owner"),
        INTERACTION("interaction");

        private final String name;

        private OwnerMode(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        public static Optional<OwnerMode> byName(String name) {
            return Arrays.stream(OwnerMode.values()).filter(ownerMode -> ownerMode.method_15434().equals(name)).findFirst();
        }

        public class_2561 asText() {
            return class_2561.method_43471((String)("gui.housing_block.ownerMode." + this.name));
        }
    }
}

