/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.scriptblocks.block.entity;

import com.github.theredbrain.scriptblocks.block.InteractiveTriggerBlock;
import com.github.theredbrain.scriptblocks.block.Resetable;
import com.github.theredbrain.scriptblocks.block.RotatedBlockWithEntity;
import com.github.theredbrain.scriptblocks.block.Triggerable;
import com.github.theredbrain.scriptblocks.block.entity.RotatedBlockEntity;
import com.github.theredbrain.scriptblocks.component.type.InteractiveKeyComponent;
import com.github.theredbrain.scriptblocks.registry.EntityRegistry;
import com.github.theredbrain.scriptblocks.registry.ItemComponentRegistry;
import com.github.theredbrain.scriptblocks.util.BlockRotationUtils;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_7225;
import org.apache.commons.lang3.tuple.MutablePair;

public class InteractiveTriggerBlockEntity
extends RotatedBlockEntity
implements Resetable {
    private MutablePair<class_2338, Boolean> triggeredBlock = new MutablePair((Object)new class_2338(0, 0, 0), (Object)false);
    private String keyIdentifierString = "";
    private String lockedMessage = "";
    private String lockedSound = "";
    private String unlockedMessage = "";
    private String unlockedSound = "";

    public InteractiveTriggerBlockEntity(class_2338 pos, class_2680 state) {
        super(EntityRegistry.INTERACTIVE_TRIGGER_BLOCK_ENTITY, pos, state);
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        nbt.method_10569("triggeredBlockPositionOffsetX", ((class_2338)this.triggeredBlock.getLeft()).method_10263());
        nbt.method_10569("triggeredBlockPositionOffsetY", ((class_2338)this.triggeredBlock.getLeft()).method_10264());
        nbt.method_10569("triggeredBlockPositionOffsetZ", ((class_2338)this.triggeredBlock.getLeft()).method_10260());
        nbt.method_10556("triggeredBlockResets", ((Boolean)this.triggeredBlock.getRight()).booleanValue());
        nbt.method_10582("keyIdentifierString", this.keyIdentifierString);
        nbt.method_10582("lockedMessage", this.lockedMessage);
        nbt.method_10582("lockedSound", this.lockedSound);
        nbt.method_10582("unlockedMessage", this.unlockedMessage);
        nbt.method_10582("unlockedSound", this.unlockedSound);
        super.method_11007(nbt, registryLookup);
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        int x = class_3532.method_15340((int)nbt.method_10550("triggeredBlockPositionOffsetX"), (int)-48, (int)48);
        int y = class_3532.method_15340((int)nbt.method_10550("triggeredBlockPositionOffsetY"), (int)-48, (int)48);
        int z = class_3532.method_15340((int)nbt.method_10550("triggeredBlockPositionOffsetZ"), (int)-48, (int)48);
        this.triggeredBlock = new MutablePair((Object)new class_2338(x, y, z), (Object)nbt.method_10577("triggeredBlockResets"));
        this.keyIdentifierString = nbt.method_10558("keyIdentifierString");
        this.lockedMessage = nbt.method_10558("lockedMessage");
        this.lockedSound = nbt.method_10558("lockedSound");
        this.unlockedMessage = nbt.method_10558("unlockedMessage");
        this.unlockedSound = nbt.method_10558("unlockedSound");
        super.method_11014(nbt, registryLookup);
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return this.method_58692(registryLookup);
    }

    public MutablePair<class_2338, Boolean> getTriggeredBlock() {
        return this.triggeredBlock;
    }

    public void setTriggeredBlock(MutablePair<class_2338, Boolean> triggeredBlock) {
        this.triggeredBlock = triggeredBlock;
    }

    public String getKeyIdentifierString() {
        return this.keyIdentifierString;
    }

    public void setKeyIdentifierString(String keyIdentifierString) {
        this.keyIdentifierString = keyIdentifierString;
    }

    public String getLockedMessage() {
        return this.lockedMessage;
    }

    public void setLockedMessage(String lockedMessage) {
        this.lockedMessage = lockedMessage;
    }

    public String getLockedSound() {
        return this.lockedSound;
    }

    public void setLockedSound(String lockedSound) {
        this.lockedSound = lockedSound;
    }

    public String getUnlockedMessage() {
        return this.unlockedMessage;
    }

    public void setUnlockedMessage(String unlockedMessage) {
        this.unlockedMessage = unlockedMessage;
    }

    public String getUnlockedSound() {
        return this.unlockedSound;
    }

    public void setUnlockedSound(String unlockedSound) {
        this.unlockedSound = unlockedSound;
    }

    public boolean canTrigger(class_1657 playerEntity) {
        if (!this.keyIdentifierString.isEmpty()) {
            InteractiveKeyComponent interactiveKeyComponent = (InteractiveKeyComponent)playerEntity.method_6030().method_57824(ItemComponentRegistry.INTERACTIVE_KEY);
            if (interactiveKeyComponent != null) {
                return interactiveKeyComponent.identifier_list().contains(class_2960.method_60654((String)this.keyIdentifierString));
            }
            return false;
        }
        return true;
    }

    public void tryToConsumeKeyItem(class_1657 playerEntity) {
        class_1268 hand;
        class_1799 stack;
        InteractiveKeyComponent interactiveKeyComponent;
        if (!this.keyIdentifierString.isEmpty() && (interactiveKeyComponent = (InteractiveKeyComponent)(stack = playerEntity.method_5998(hand = playerEntity.method_6058())).method_57824(ItemComponentRegistry.INTERACTIVE_KEY)) != null && interactiveKeyComponent.is_consumed()) {
            if (stack.method_7914() > 1) {
                stack.method_57008(1, (class_1309)playerEntity);
                if (stack.method_7947() > 0) {
                    playerEntity.method_6122(hand, stack);
                } else {
                    playerEntity.method_6122(hand, class_1799.field_8037);
                }
            } else {
                stack.method_7970(1, (class_1309)playerEntity, hand == class_1268.field_5808 ? class_1304.field_6173 : class_1304.field_6171);
            }
        }
    }

    public void trigger() {
        class_2586 blockEntity;
        if (this.field_11863 != null && (blockEntity = this.field_11863.method_8321(new class_2338(this.field_11867.method_10263() + ((class_2338)this.triggeredBlock.getLeft()).method_10263(), this.field_11867.method_10264() + ((class_2338)this.triggeredBlock.getLeft()).method_10264(), this.field_11867.method_10260() + ((class_2338)this.triggeredBlock.getLeft()).method_10260()))) != this) {
            boolean triggeredBlockResets = (Boolean)this.triggeredBlock.getRight();
            if (triggeredBlockResets && blockEntity instanceof Resetable) {
                Resetable resetable = (Resetable)blockEntity;
                resetable.reset();
            } else if (!triggeredBlockResets && blockEntity instanceof Triggerable) {
                Triggerable triggerable = (Triggerable)blockEntity;
                triggerable.trigger();
            }
        }
    }

    @Override
    protected void onRotate(class_2680 state) {
        if (state.method_26204() instanceof RotatedBlockWithEntity) {
            if ((Integer)state.method_11654((class_2769)RotatedBlockWithEntity.ROTATED) != this.rotated) {
                class_2470 blockRotation = BlockRotationUtils.calculateRotationFromDifferentRotatedStates((Integer)state.method_11654((class_2769)RotatedBlockWithEntity.ROTATED), this.rotated);
                this.triggeredBlock.setLeft((Object)BlockRotationUtils.rotateOffsetBlockPos((class_2338)this.triggeredBlock.getLeft(), blockRotation));
                this.rotated = (Integer)state.method_11654((class_2769)RotatedBlockWithEntity.ROTATED);
            }
            if ((Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.X_MIRRORED) != this.x_mirrored) {
                this.triggeredBlock.setLeft((Object)BlockRotationUtils.mirrorOffsetBlockPos((class_2338)this.triggeredBlock.getLeft(), class_2415.field_11301));
                this.x_mirrored = (Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.X_MIRRORED);
            }
            if ((Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.Z_MIRRORED) != this.z_mirrored) {
                this.triggeredBlock.setLeft((Object)BlockRotationUtils.mirrorOffsetBlockPos((class_2338)this.triggeredBlock.getLeft(), class_2415.field_11300));
                this.z_mirrored = (Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.Z_MIRRORED);
            }
        }
    }

    @Override
    public void reset() {
        class_2680 state;
        class_2248 class_22482;
        if (this.field_11863 != null && (class_22482 = (state = this.field_11863.method_8320(this.field_11867)).method_26204()) instanceof InteractiveTriggerBlock) {
            InteractiveTriggerBlock interactiveTriggerBlock = (InteractiveTriggerBlock)class_22482;
            interactiveTriggerBlock.reset(state, this.field_11863, this.field_11867);
        }
    }
}

