/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.scriptblocks.block.entity;

import com.github.theredbrain.scriptblocks.ScriptBlocks;
import com.github.theredbrain.scriptblocks.block.Resetable;
import com.github.theredbrain.scriptblocks.block.RotatedBlockWithEntity;
import com.github.theredbrain.scriptblocks.block.Triggerable;
import com.github.theredbrain.scriptblocks.block.entity.RotatedBlockEntity;
import com.github.theredbrain.scriptblocks.registry.EntityRegistry;
import com.github.theredbrain.scriptblocks.util.BlockRotationUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_7225;
import org.apache.commons.lang3.tuple.MutablePair;

public class PlayerDetectorBlockEntity
extends RotatedBlockEntity {
    private static final class_2338 AREA_POSITION_OFFSET_DEFAULT = new class_2338(0, 0, 0);
    private static final class_2338 TRIGGERED_BLOCK_POS_DEFAULT = new class_2338(0, 0, 0);
    private boolean calculateAreaBox = true;
    private class_238 area = null;
    private boolean showArea = false;
    private class_2382 areaDimensions = class_2382.field_11176;
    private class_2338 areaPositionOffset = new class_2338(0, 1, 0);
    private MutablePair<class_2338, Boolean> triggeredBlock = new MutablePair((Object)TRIGGERED_BLOCK_POS_DEFAULT, (Object)false);
    private ArrayList<UUID> playerList = new ArrayList();

    public PlayerDetectorBlockEntity(class_2338 pos, class_2680 state) {
        super(EntityRegistry.PLAYER_DETECTOR_BLOCK_ENTITY, pos, state);
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        if (this.showArea) {
            nbt.method_10556("showArea", true);
        } else {
            nbt.method_10551("showArea");
        }
        if (this.area != null) {
            nbt.method_10549("areaMinX", this.area.field_1323);
            nbt.method_10549("areaMaxX", this.area.field_1320);
            nbt.method_10549("areaMinY", this.area.field_1322);
            nbt.method_10549("areaMaxY", this.area.field_1325);
            nbt.method_10549("areaMinZ", this.area.field_1321);
            nbt.method_10549("areaMaxZ", this.area.field_1324);
        } else {
            nbt.method_10551("areaMinX");
            nbt.method_10551("areaMaxX");
            nbt.method_10551("areaMinY");
            nbt.method_10551("areaMaxY");
            nbt.method_10551("areaMinZ");
            nbt.method_10551("areaMaxZ");
        }
        if (this.areaDimensions != class_2382.field_11176) {
            nbt.method_10569("areaDimensionsX", this.areaDimensions.method_10263());
            nbt.method_10569("areaDimensionsY", this.areaDimensions.method_10264());
            nbt.method_10569("areaDimensionsZ", this.areaDimensions.method_10260());
        } else {
            nbt.method_10551("areaDimensionsX");
            nbt.method_10551("areaDimensionsY");
            nbt.method_10551("areaDimensionsZ");
        }
        class_2338 areaPositionOffset = this.areaPositionOffset;
        if (!areaPositionOffset.equals((Object)AREA_POSITION_OFFSET_DEFAULT)) {
            nbt.method_10569("areaPositionOffsetX", this.areaPositionOffset.method_10263());
            nbt.method_10569("areaPositionOffsetY", this.areaPositionOffset.method_10264());
            nbt.method_10569("areaPositionOffsetZ", this.areaPositionOffset.method_10260());
        } else {
            nbt.method_10551("areaPositionOffsetX");
            nbt.method_10551("areaPositionOffsetY");
            nbt.method_10551("areaPositionOffsetZ");
        }
        if (this.triggeredBlock.getLeft() != TRIGGERED_BLOCK_POS_DEFAULT || !((Boolean)this.triggeredBlock.getRight()).booleanValue()) {
            nbt.method_10569("triggeredBlockPositionOffsetX", ((class_2338)this.triggeredBlock.getLeft()).method_10263());
            nbt.method_10569("triggeredBlockPositionOffsetY", ((class_2338)this.triggeredBlock.getLeft()).method_10264());
            nbt.method_10569("triggeredBlockPositionOffsetZ", ((class_2338)this.triggeredBlock.getLeft()).method_10260());
            nbt.method_10556("triggeredBlockResets", ((Boolean)this.triggeredBlock.getRight()).booleanValue());
        } else {
            nbt.method_10551("triggeredBlockPositionOffsetX");
            nbt.method_10551("triggeredBlockPositionOffsetY");
            nbt.method_10551("triggeredBlockPositionOffsetZ");
            nbt.method_10551("triggeredBlockResets");
        }
        int playerListSize = this.playerList.size();
        nbt.method_10569("playerListSize", playerListSize);
        for (int i = 0; i < playerListSize; ++i) {
            nbt.method_25927("playerListEntry_" + i, this.playerList.get(i));
        }
        super.method_11007(nbt, registryLookup);
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        this.showArea = nbt.method_10577("showArea");
        if (nbt.method_10545("areaMinX") && nbt.method_10545("areaMinY") && nbt.method_10545("areaMinZ") && nbt.method_10545("areaMaxX") && nbt.method_10545("areaMaxY") && nbt.method_10545("areaMaxZ")) {
            this.area = new class_238(nbt.method_10574("areaMinX"), nbt.method_10574("areaMinY"), nbt.method_10574("areaMinZ"), nbt.method_10574("areaMaxX"), nbt.method_10574("areaMaxY"), nbt.method_10574("areaMaxZ"));
            this.calculateAreaBox = true;
        }
        int i = class_3532.method_15340((int)nbt.method_10550("areaDimensionsX"), (int)0, (int)48);
        int j = class_3532.method_15340((int)nbt.method_10550("areaDimensionsY"), (int)0, (int)48);
        int k = class_3532.method_15340((int)nbt.method_10550("areaDimensionsZ"), (int)0, (int)48);
        this.areaDimensions = new class_2382(i, j, k);
        int l = class_3532.method_15340((int)nbt.method_10550("areaPositionOffsetX"), (int)-48, (int)48);
        int m = class_3532.method_15340((int)nbt.method_10550("areaPositionOffsetY"), (int)-48, (int)48);
        int n = class_3532.method_15340((int)nbt.method_10550("areaPositionOffsetZ"), (int)-48, (int)48);
        this.areaPositionOffset = new class_2338(l, m, n);
        if (nbt.method_10573("triggeredBlockPositionOffsetX", 3) && nbt.method_10573("triggeredBlockPositionOffsetY", 3) && nbt.method_10573("triggeredBlockPositionOffsetZ", 3) && nbt.method_10573("triggeredBlockResets", 1)) {
            this.triggeredBlock = new MutablePair((Object)new class_2338(class_3532.method_15340((int)nbt.method_10550("triggeredBlockPositionOffsetX"), (int)-48, (int)48), class_3532.method_15340((int)nbt.method_10550("triggeredBlockPositionOffsetY"), (int)-48, (int)48), class_3532.method_15340((int)nbt.method_10550("triggeredBlockPositionOffsetZ"), (int)-48, (int)48)), (Object)nbt.method_10577("triggeredBlockResets"));
        }
        int playerListSize = nbt.method_10550("playerListSize");
        for (i = 0; i < playerListSize; ++i) {
            if (!nbt.method_10545("playerListEntry_" + i)) continue;
            this.playerList.add(nbt.method_25926("playerListEntry_" + i));
        }
        super.method_11014(nbt, registryLookup);
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return this.method_58692(registryLookup);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, PlayerDetectorBlockEntity areaBlockEntity) {
        if (!world.field_9236 && world.method_8510() % 20L == 0L) {
            class_1657 playerEntity;
            if (areaBlockEntity.calculateAreaBox || areaBlockEntity.area == null) {
                class_2338 areaPositionOffset = areaBlockEntity.areaPositionOffset;
                class_2382 areaDimensions = areaBlockEntity.areaDimensions;
                class_243 areaStart = new class_243((double)(pos.method_10263() + areaPositionOffset.method_10263()), (double)(pos.method_10264() + areaPositionOffset.method_10264()), (double)(pos.method_10260() + areaPositionOffset.method_10260()));
                class_243 areaEnd = new class_243(areaStart.method_10216() + (double)areaDimensions.method_10263(), areaStart.method_10214() + (double)areaDimensions.method_10264(), areaStart.method_10215() + (double)areaDimensions.method_10260());
                areaBlockEntity.area = new class_238(areaStart, areaEnd);
                areaBlockEntity.calculateAreaBox = false;
            }
            boolean shouldTriggerBlock = false;
            List newPlayerList = world.method_18467(class_1657.class, areaBlockEntity.area);
            ArrayList<UUID> newPLayerUuidList = new ArrayList<UUID>();
            for (class_1657 player : newPlayerList) {
                if (player.method_7337() && !ScriptBlocks.SERVER_CONFIG.enable_creative_player_detection) continue;
                newPLayerUuidList.add(player.method_5667());
            }
            ArrayList<UUID> tempList = new ArrayList<UUID>();
            for (UUID uuid : areaBlockEntity.playerList) {
                playerEntity = world.method_18470(uuid);
                if (playerEntity == null || !newPLayerUuidList.contains(uuid)) continue;
                tempList.add(uuid);
                newPLayerUuidList.remove(uuid);
            }
            for (UUID uuid2 : newPLayerUuidList) {
                playerEntity = world.method_18470(uuid2);
                if (playerEntity == null) continue;
                tempList.add(uuid2);
                shouldTriggerBlock = true;
            }
            areaBlockEntity.playerList.clear();
            areaBlockEntity.playerList.addAll(tempList);
            if (shouldTriggerBlock) {
                areaBlockEntity.triggerBlock();
            }
        }
    }

    private void triggerBlock() {
        class_2586 blockEntity;
        int x = ((class_2338)this.triggeredBlock.getLeft()).method_10263();
        int y = ((class_2338)this.triggeredBlock.getLeft()).method_10264();
        int z = ((class_2338)this.triggeredBlock.getLeft()).method_10260();
        if (this.field_11863 != null && (x != 0 || y != 0 || z != 0) && (blockEntity = this.field_11863.method_8321(new class_2338(this.field_11867.method_10263() + x, this.field_11867.method_10264() + y, this.field_11867.method_10260() + z))) != this) {
            boolean triggeredBlockResets = (Boolean)this.triggeredBlock.getRight();
            if (triggeredBlockResets && blockEntity instanceof Resetable) {
                Resetable resetable = (Resetable)blockEntity;
                resetable.reset();
            } else if (!triggeredBlockResets && blockEntity instanceof Triggerable) {
                Triggerable triggerable = (Triggerable)blockEntity;
                triggerable.trigger();
            }
        }
    }

    public boolean showArea() {
        return this.showArea;
    }

    public void setShowArea(boolean showArea) {
        this.showArea = showArea;
    }

    public class_2382 getAreaDimensions() {
        return this.areaDimensions;
    }

    public void setAreaDimensions(class_2382 areaDimensions) {
        this.areaDimensions = areaDimensions;
        this.calculateAreaBox = true;
    }

    public class_2338 getAreaPositionOffset() {
        return this.areaPositionOffset;
    }

    public void setAreaPositionOffset(class_2338 areaPositionOffset) {
        this.areaPositionOffset = areaPositionOffset;
        this.calculateAreaBox = true;
    }

    public MutablePair<class_2338, Boolean> getTriggeredBlock() {
        return this.triggeredBlock;
    }

    public void setTriggeredBlock(MutablePair<class_2338, Boolean> triggeredBlock) {
        this.triggeredBlock = triggeredBlock;
    }

    @Override
    protected void onRotate(class_2680 state) {
        if (state.method_26204() instanceof RotatedBlockWithEntity) {
            MutablePair<class_2338, class_2382> offsetArea;
            if ((Integer)state.method_11654((class_2769)RotatedBlockWithEntity.ROTATED) != this.rotated) {
                class_2470 blockRotation = BlockRotationUtils.calculateRotationFromDifferentRotatedStates((Integer)state.method_11654((class_2769)RotatedBlockWithEntity.ROTATED), this.rotated);
                MutablePair<class_2338, class_2382> offsetArea2 = BlockRotationUtils.rotateOffsetArea(this.areaPositionOffset, this.areaDimensions, blockRotation);
                this.areaPositionOffset = (class_2338)offsetArea2.getLeft();
                this.areaDimensions = (class_2382)offsetArea2.getRight();
                this.triggeredBlock.setLeft((Object)BlockRotationUtils.rotateOffsetBlockPos((class_2338)this.triggeredBlock.getLeft(), blockRotation));
                this.rotated = (Integer)state.method_11654((class_2769)RotatedBlockWithEntity.ROTATED);
            }
            if ((Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.X_MIRRORED) != this.x_mirrored) {
                offsetArea = BlockRotationUtils.mirrorOffsetArea(this.areaPositionOffset, this.areaDimensions, class_2415.field_11301);
                this.areaPositionOffset = (class_2338)offsetArea.getLeft();
                this.areaDimensions = (class_2382)offsetArea.getRight();
                this.triggeredBlock.setLeft((Object)BlockRotationUtils.mirrorOffsetBlockPos((class_2338)this.triggeredBlock.getLeft(), class_2415.field_11301));
                this.x_mirrored = (Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.X_MIRRORED);
            }
            if ((Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.Z_MIRRORED) != this.z_mirrored) {
                offsetArea = BlockRotationUtils.mirrorOffsetArea(this.areaPositionOffset, this.areaDimensions, class_2415.field_11300);
                this.areaPositionOffset = (class_2338)offsetArea.getLeft();
                this.areaDimensions = (class_2382)offsetArea.getRight();
                this.triggeredBlock.setLeft((Object)BlockRotationUtils.mirrorOffsetBlockPos((class_2338)this.triggeredBlock.getLeft(), class_2415.field_11300));
                this.z_mirrored = (Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.Z_MIRRORED);
            }
        }
    }
}

