/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.scriptblocks.block.entity;

import com.github.theredbrain.scriptblocks.block.ProvidesData;
import com.github.theredbrain.scriptblocks.block.RotatedBlockWithEntity;
import com.github.theredbrain.scriptblocks.block.Triggerable;
import com.github.theredbrain.scriptblocks.block.entity.RotatedBlockEntity;
import com.github.theredbrain.scriptblocks.registry.BlockRegistry;
import com.github.theredbrain.scriptblocks.registry.EntityRegistry;
import com.github.theredbrain.scriptblocks.registry.StatusEffectsRegistry;
import com.github.theredbrain.scriptblocks.screen.TeleporterBlockScreenHandler;
import com.github.theredbrain.scriptblocks.util.BlockRotationUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.apache.commons.lang3.tuple.MutablePair;
import org.jetbrains.annotations.Nullable;

public class TeleporterBlockEntity
extends RotatedBlockEntity
implements ExtendedScreenHandlerFactory,
Triggerable {
    private boolean calculateActivationBox = true;
    private class_238 activationArea = null;
    private boolean showAdventureScreen = true;
    private boolean showActivationArea = false;
    private class_2382 activationAreaDimensions = class_2382.field_11176;
    private class_2338 activationAreaPositionOffset = new class_2338(0, 1, 0);
    private boolean triggerActivation = false;
    private class_2338 accessPositionOffset = new class_2338(0, 0, 0);
    private boolean setAccessPosition = false;
    private String statusEffectsToDecrementLevelOnTeleport = "";
    private boolean onlyTeleportDimensionOwner = false;
    private boolean teleportTeam = false;
    private CreativeScreenPage creativeScreenPage = CreativeScreenPage.ACTIVATION;
    private TeleportationMode teleportationMode = TeleportationMode.DIRECT;
    private class_2338 directTeleportPositionOffset = new class_2338(0, 0, 0);
    private double directTeleportOrientationYaw = 0.0;
    private double directTeleportOrientationPitch = 0.0;
    private SpawnPointType spawnPointType = SpawnPointType.WORLD_SPAWN;
    private List<MutablePair<MutablePair<String, String>, MutablePair<String, String>>> locationsList = new ArrayList<MutablePair<MutablePair<String, String>, MutablePair<String, String>>>(List.of());
    private MutablePair<MutablePair<String, String>, MutablePair<String, String>> location = new MutablePair((Object)new MutablePair((Object)"", (Object)""), (Object)new MutablePair((Object)"", (Object)""));
    private class_2338 dataProvidingBlockPosOffset = class_2338.field_10980;
    private String locationDataIdentifier = "";
    private String entranceDataIdentifier = "";
    private String sendDataIdentifierDataIdentifier = "";
    private String sendDataValueDataIdentifier = "";
    private String teleporterName = "gui.teleporter_block.teleporter_name_field.label";
    private String currentTargetOwnerLabel = "gui.teleporter_block.target_owner_field.label";
    private String currentTargetIdentifierLabel = "gui.teleporter_block.target_identifier_field.label";
    private boolean showRegenerateButton = true;
    private boolean canOwnerBeChosen = true;
    private String teleportButtonLabel = "gui.teleporter_block.teleport_button.label";
    private String cancelTeleportButtonLabel = "gui.teleporter_block.cancel_teleport_button.label";

    public TeleporterBlockEntity(class_2338 pos, class_2680 state) {
        super(EntityRegistry.TELEPORTER_BLOCK_ENTITY, pos, state);
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        nbt.method_10582("teleporterName", this.teleporterName);
        nbt.method_10556("showAdventureScreen", this.showAdventureScreen);
        nbt.method_10582("creativeScreenPage", this.creativeScreenPage.method_15434());
        nbt.method_10556("showActivationArea", this.showActivationArea);
        nbt.method_10569("activationAreaDimensionsX", this.activationAreaDimensions.method_10263());
        nbt.method_10569("activationAreaDimensionsY", this.activationAreaDimensions.method_10264());
        nbt.method_10569("activationAreaDimensionsZ", this.activationAreaDimensions.method_10260());
        nbt.method_10569("activationAreaPositionOffsetX", this.activationAreaPositionOffset.method_10263());
        nbt.method_10569("activationAreaPositionOffsetY", this.activationAreaPositionOffset.method_10264());
        nbt.method_10569("activationAreaPositionOffsetZ", this.activationAreaPositionOffset.method_10260());
        nbt.method_10556("triggerActivation", this.triggerActivation);
        nbt.method_10569("accessPositionOffsetX", this.accessPositionOffset.method_10263());
        nbt.method_10569("accessPositionOffsetY", this.accessPositionOffset.method_10264());
        nbt.method_10569("accessPositionOffsetZ", this.accessPositionOffset.method_10260());
        nbt.method_10556("setAccessPosition", this.setAccessPosition);
        nbt.method_10582("statusEffectsToDecrementLevelOnTeleport", this.statusEffectsToDecrementLevelOnTeleport);
        nbt.method_10556("onlyTeleportDimensionOwner", this.onlyTeleportDimensionOwner);
        nbt.method_10556("teleportTeam", this.teleportTeam);
        nbt.method_10582("teleportationMode", this.teleportationMode.method_15434());
        nbt.method_10569("directTeleportPositionOffsetX", this.directTeleportPositionOffset.method_10263());
        nbt.method_10569("directTeleportPositionOffsetY", this.directTeleportPositionOffset.method_10264());
        nbt.method_10569("directTeleportPositionOffsetZ", this.directTeleportPositionOffset.method_10260());
        nbt.method_10549("directTeleportPositionOffsetYaw", this.directTeleportOrientationYaw);
        nbt.method_10549("directTeleportPositionOffsetPitch", this.directTeleportOrientationPitch);
        nbt.method_10582("spawnPointType", this.spawnPointType.method_15434());
        nbt.method_10569("locationsListSize", this.locationsList.size());
        for (int i = 0; i < this.locationsList.size(); ++i) {
            nbt.method_10582("locationsListIdentifier_" + i, (String)((MutablePair)this.locationsList.get(i).getLeft()).getLeft());
            nbt.method_10582("locationsListEntrance_" + i, (String)((MutablePair)this.locationsList.get(i).getLeft()).getRight());
            nbt.method_10582("locationsListDataId_" + i, (String)((MutablePair)this.locationsList.get(i).getRight()).getLeft());
            nbt.method_10582("locationsListData_" + i, (String)((MutablePair)this.locationsList.get(i).getRight()).getRight());
        }
        nbt.method_10582("locationIdentifier", (String)((MutablePair)this.location.getLeft()).getLeft());
        nbt.method_10582("locationEntrance", (String)((MutablePair)this.location.getLeft()).getRight());
        nbt.method_10582("locationDataId", (String)((MutablePair)this.location.getRight()).getLeft());
        nbt.method_10582("locationData", (String)((MutablePair)this.location.getRight()).getRight());
        nbt.method_10569("dataProvidingBlockPosOffsetX", this.dataProvidingBlockPosOffset.method_10263());
        nbt.method_10569("dataProvidingBlockPosOffsetY", this.dataProvidingBlockPosOffset.method_10264());
        nbt.method_10569("dataProvidingBlockPosOffsetZ", this.dataProvidingBlockPosOffset.method_10260());
        nbt.method_10582("locationDataIdentifier", this.locationDataIdentifier);
        nbt.method_10582("entranceDataIdentifier", this.entranceDataIdentifier);
        nbt.method_10582("sendDataIdentifierDataIdentifier", this.sendDataIdentifierDataIdentifier);
        nbt.method_10582("sendDataValueDataIdentifier", this.sendDataValueDataIdentifier);
        nbt.method_10582("currentTargetIdentifierLabel", this.currentTargetIdentifierLabel);
        nbt.method_10582("currentTargetOwnerLabel", this.currentTargetOwnerLabel);
        nbt.method_10556("showRegenerateButton", this.showRegenerateButton);
        nbt.method_10556("canOwnerBeChosen", this.canOwnerBeChosen);
        nbt.method_10582("teleportButtonLabel", this.teleportButtonLabel);
        nbt.method_10582("cancelTeleportButtonLabel", this.cancelTeleportButtonLabel);
        if (this.activationArea != null) {
            nbt.method_10549("activationAreaMinX", this.activationArea.field_1323);
            nbt.method_10549("activationAreaMaxX", this.activationArea.field_1320);
            nbt.method_10549("activationAreaMinY", this.activationArea.field_1322);
            nbt.method_10549("activationAreaMaxY", this.activationArea.field_1325);
            nbt.method_10549("activationAreaMinZ", this.activationArea.field_1321);
            nbt.method_10549("activationAreaMaxZ", this.activationArea.field_1324);
        }
        super.method_11007(nbt, registryLookup);
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        this.teleporterName = nbt.method_10558("teleporterName");
        this.showAdventureScreen = nbt.method_10577("showAdventureScreen");
        this.creativeScreenPage = CreativeScreenPage.byName(nbt.method_10558("creativeScreenPage")).orElseGet(() -> CreativeScreenPage.ACTIVATION);
        this.showActivationArea = nbt.method_10577("showActivationArea");
        this.activationAreaDimensions = new class_2382(class_3532.method_15340((int)nbt.method_10550("activationAreaDimensionsX"), (int)0, (int)48), class_3532.method_15340((int)nbt.method_10550("activationAreaDimensionsY"), (int)0, (int)48), class_3532.method_15340((int)nbt.method_10550("activationAreaDimensionsZ"), (int)0, (int)48));
        this.activationAreaPositionOffset = new class_2338(class_3532.method_15340((int)nbt.method_10550("activationAreaPositionOffsetX"), (int)-48, (int)48), class_3532.method_15340((int)nbt.method_10550("activationAreaPositionOffsetY"), (int)-48, (int)48), class_3532.method_15340((int)nbt.method_10550("activationAreaPositionOffsetZ"), (int)-48, (int)48));
        this.triggerActivation = nbt.method_10577("triggerActivation");
        this.accessPositionOffset = new class_2338(class_3532.method_15340((int)nbt.method_10550("accessPositionOffsetX"), (int)-48, (int)48), class_3532.method_15340((int)nbt.method_10550("accessPositionOffsetY"), (int)-48, (int)48), class_3532.method_15340((int)nbt.method_10550("accessPositionOffsetZ"), (int)-48, (int)48));
        this.setAccessPosition = nbt.method_10577("setAccessPosition");
        this.statusEffectsToDecrementLevelOnTeleport = nbt.method_10558("statusEffectsToDecrementLevelOnTeleport");
        this.onlyTeleportDimensionOwner = nbt.method_10577("onlyTeleportDimensionOwner");
        this.teleportTeam = nbt.method_10577("teleportTeam");
        this.teleportationMode = TeleportationMode.byName(nbt.method_10558("teleportationMode")).orElseGet(() -> TeleportationMode.DIRECT);
        this.directTeleportPositionOffset = new class_2338(nbt.method_10550("directTeleportPositionOffsetX"), nbt.method_10550("directTeleportPositionOffsetY"), nbt.method_10550("directTeleportPositionOffsetZ"));
        this.directTeleportOrientationYaw = nbt.method_10574("directTeleportPositionOffsetYaw");
        this.directTeleportOrientationPitch = nbt.method_10574("directTeleportPositionOffsetPitch");
        this.spawnPointType = SpawnPointType.byName(nbt.method_10558("spawnPointType")).orElseGet(() -> SpawnPointType.WORLD_SPAWN);
        int locationsListSize = nbt.method_10550("locationsListSize");
        this.locationsList.clear();
        for (int p = 0; p < locationsListSize; ++p) {
            this.locationsList.add((MutablePair<MutablePair<String, String>, MutablePair<String, String>>)new MutablePair((Object)new MutablePair((Object)nbt.method_10558("locationsListIdentifier_" + p), (Object)nbt.method_10558("locationsListEntrance_" + p)), (Object)new MutablePair((Object)nbt.method_10558("locationsListDataId_" + p), (Object)nbt.method_10558("locationsListData_" + p))));
        }
        this.location = new MutablePair((Object)new MutablePair((Object)nbt.method_10558("locationIdentifier"), (Object)nbt.method_10558("locationEntrance")), (Object)new MutablePair((Object)nbt.method_10558("locationDataId"), (Object)nbt.method_10558("locationData")));
        this.dataProvidingBlockPosOffset = new class_2338(nbt.method_10550("dataProvidingBlockPosOffsetX"), nbt.method_10550("dataProvidingBlockPosOffsetY"), nbt.method_10550("dataProvidingBlockPosOffsetZ"));
        this.locationDataIdentifier = nbt.method_10558("locationDataIdentifier");
        this.entranceDataIdentifier = nbt.method_10558("entranceDataIdentifier");
        this.sendDataIdentifierDataIdentifier = nbt.method_10558("sendDataIdentifierDataIdentifier");
        this.sendDataValueDataIdentifier = nbt.method_10558("sendDataValueDataIdentifier");
        this.currentTargetIdentifierLabel = nbt.method_10558("currentTargetIdentifierLabel");
        this.currentTargetOwnerLabel = nbt.method_10558("currentTargetOwnerLabel");
        this.showRegenerateButton = nbt.method_10577("showRegenerateButton");
        this.canOwnerBeChosen = nbt.method_10577("canOwnerBeChosen");
        this.teleportButtonLabel = nbt.method_10558("teleportButtonLabel");
        this.cancelTeleportButtonLabel = nbt.method_10558("cancelTeleportButtonLabel");
        if (nbt.method_10545("activationAreaMinX") && nbt.method_10545("activationAreaMinY") && nbt.method_10545("activationAreaMinZ") && nbt.method_10545("activationAreaMaxX") && nbt.method_10545("activationAreaMaxY") && nbt.method_10545("activationAreaMaxZ")) {
            this.activationArea = new class_238(nbt.method_10574("activationAreaMinX"), nbt.method_10574("activationAreaMinY"), nbt.method_10574("activationAreaMinZ"), nbt.method_10574("activationAreaMaxX"), nbt.method_10574("activationAreaMaxY"), nbt.method_10574("activationAreaMaxZ"));
            this.calculateActivationBox = true;
        }
        super.method_11014(nbt, registryLookup);
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return this.method_58692(registryLookup);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, TeleporterBlockEntity blockEntity) {
        if (!blockEntity.triggerActivation()) {
            TeleporterBlockEntity.tryOpenScreenRemotely(world, pos, state, blockEntity);
        }
    }

    private static void tryOpenScreenRemotely(class_1937 world, class_2338 pos, class_2680 state, TeleporterBlockEntity teleporterBlockEntity) {
        if (world.field_9236) {
            return;
        }
        if (state.method_27852(BlockRegistry.TELEPORTER_BLOCK)) {
            if (teleporterBlockEntity.calculateActivationBox || teleporterBlockEntity.activationArea == null) {
                class_2338 activationAreaPositionOffset = teleporterBlockEntity.getActivationAreaPositionOffset();
                class_2382 activationAreaDimensions = teleporterBlockEntity.getActivationAreaDimensions();
                class_243 activationAreaStart = new class_243((double)(pos.method_10263() + activationAreaPositionOffset.method_10263()), (double)(pos.method_10264() + activationAreaPositionOffset.method_10264()), (double)(pos.method_10260() + activationAreaPositionOffset.method_10260()));
                class_243 activationAreaEnd = new class_243(activationAreaStart.method_10216() + (double)activationAreaDimensions.method_10263(), activationAreaStart.method_10214() + (double)activationAreaDimensions.method_10264(), activationAreaStart.method_10215() + (double)activationAreaDimensions.method_10260());
                teleporterBlockEntity.activationArea = new class_238(activationAreaStart, activationAreaEnd);
                teleporterBlockEntity.calculateActivationBox = false;
            }
            List list = world.method_18467(class_1657.class, teleporterBlockEntity.activationArea);
            String worldName = world.method_27983().method_29177().method_12832();
            class_6880 portal_resistance_status_effect = class_7923.field_41174.method_47983((Object)StatusEffectsRegistry.PORTAL_RESISTANCE_EFFECT);
            for (class_1657 playerEntity : list) {
                if (playerEntity.method_6059(portal_resistance_status_effect) || playerEntity.method_7337()) continue;
                if (!teleporterBlockEntity.onlyTeleportDimensionOwner || playerEntity.method_5667().toString().equals(worldName)) {
                    playerEntity.method_26082(new class_1293(portal_resistance_status_effect, -1, 0, false, false, false), (class_1297)playerEntity);
                    playerEntity.method_17355(state.method_26196(world, pos));
                    continue;
                }
                playerEntity.method_7353((class_2561)class_2561.method_43471((String)"hud.message.onlyDimensionOwnerCanTeleport"), true);
            }
        }
    }

    @Override
    public void trigger() {
        class_1937 world = this.field_11863;
        if (world != null && this.triggerActivation) {
            TeleporterBlockEntity.tryOpenScreenRemotely(world, this.field_11867, world.method_8320(this.field_11867), this);
        }
    }

    public String getTeleporterName() {
        return this.teleporterName;
    }

    public void setTeleporterName(String teleporterName) {
        this.teleporterName = teleporterName;
    }

    public boolean getShowAdventureScreen() {
        return this.showAdventureScreen;
    }

    public void setShowAdventureScreen(boolean showAdventureScreen) {
        this.showAdventureScreen = showAdventureScreen;
    }

    public CreativeScreenPage getCreativeScreenPage() {
        return this.creativeScreenPage;
    }

    public void setCreativeScreenPage(CreativeScreenPage creativeScreenPage) {
        this.creativeScreenPage = creativeScreenPage;
    }

    public boolean getShowActivationArea() {
        return this.showActivationArea;
    }

    public void setShowActivationArea(boolean showActivationArea) {
        this.showActivationArea = showActivationArea;
    }

    public class_2382 getActivationAreaDimensions() {
        return this.activationAreaDimensions;
    }

    public void setActivationAreaDimensions(class_2382 activationAreaDimensions) {
        this.activationAreaDimensions = activationAreaDimensions;
        this.calculateActivationBox = true;
    }

    public class_2338 getActivationAreaPositionOffset() {
        return this.activationAreaPositionOffset;
    }

    public void setActivationAreaPositionOffset(class_2338 activationAreaPositionOffset) {
        this.activationAreaPositionOffset = activationAreaPositionOffset;
        this.calculateActivationBox = true;
    }

    public boolean triggerActivation() {
        return this.triggerActivation;
    }

    public void setTriggerActivation(boolean triggerActivation) {
        this.triggerActivation = triggerActivation;
    }

    public class_2338 getAccessPositionOffset() {
        return this.accessPositionOffset;
    }

    public void setAccessPositionOffset(class_2338 accessPositionOffset) {
        this.accessPositionOffset = accessPositionOffset;
    }

    public boolean getSetAccessPosition() {
        return this.setAccessPosition;
    }

    public void setSetAccessPosition(boolean setAccessPosition) {
        this.setAccessPosition = setAccessPosition;
    }

    public String getStatusEffectsToDecrementLevelOnTeleport() {
        return this.statusEffectsToDecrementLevelOnTeleport;
    }

    public void setStatusEffectsToDecrementLevelOnTeleport(String statusEffectsToDecrementLevelOnTeleport) {
        this.statusEffectsToDecrementLevelOnTeleport = statusEffectsToDecrementLevelOnTeleport;
    }

    public boolean onlyTeleportDimensionOwner() {
        return this.onlyTeleportDimensionOwner;
    }

    public void setOnlyTeleportDimensionOwner(boolean onlyTeleportDimensionOwner) {
        this.onlyTeleportDimensionOwner = onlyTeleportDimensionOwner;
    }

    public boolean teleportTeam() {
        return this.teleportTeam;
    }

    public void setTeleportTeam(boolean teleportTeam) {
        this.teleportTeam = teleportTeam;
    }

    public TeleportationMode getTeleportationMode() {
        return this.teleportationMode;
    }

    public void setTeleportationMode(TeleportationMode teleportationMode) {
        this.teleportationMode = teleportationMode;
    }

    public class_2338 getDirectTeleportPositionOffset() {
        return this.directTeleportPositionOffset;
    }

    public void setDirectTeleportPositionOffset(class_2338 directTeleportPositionOffset) {
        this.directTeleportPositionOffset = directTeleportPositionOffset;
    }

    public double getDirectTeleportOrientationYaw() {
        return this.directTeleportOrientationYaw;
    }

    public boolean setDirectTeleportOrientationYaw(double directTeleportOrientationYaw) {
        this.directTeleportOrientationYaw = directTeleportOrientationYaw;
        return true;
    }

    public double getDirectTeleportOrientationPitch() {
        return this.directTeleportOrientationPitch;
    }

    public boolean setDirectTeleportOrientationPitch(double directTeleportOrientationPitch) {
        this.directTeleportOrientationPitch = directTeleportOrientationPitch;
        return true;
    }

    public SpawnPointType getSpawnPointType() {
        return this.spawnPointType;
    }

    public void setSpawnPointType(SpawnPointType spawnPointType) {
        this.spawnPointType = spawnPointType;
    }

    public List<MutablePair<MutablePair<String, String>, MutablePair<String, String>>> getLocationsList() {
        return this.locationsList;
    }

    public void setLocationsList(List<MutablePair<MutablePair<String, String>, MutablePair<String, String>>> locationsList) {
        this.locationsList = locationsList;
    }

    public MutablePair<MutablePair<String, String>, MutablePair<String, String>> getDataDrivenLocation() {
        class_2586 blockEntity;
        Object locationString = (String)((MutablePair)this.location.getLeft()).getLeft();
        Object entranceString = (String)((MutablePair)this.location.getLeft()).getRight();
        String dataIdString = (String)((MutablePair)this.location.getRight()).getLeft() + this.sendDataIdentifierDataIdentifier;
        String dataValueString = (String)((MutablePair)this.location.getRight()).getRight() + this.sendDataValueDataIdentifier;
        class_2338 dataProvidingBlockPosOffset = this.dataProvidingBlockPosOffset;
        if (dataProvidingBlockPosOffset != class_2338.field_10980 && this.field_11863 != null && (blockEntity = this.field_11863.method_8321(this.method_11016().method_10069(dataProvidingBlockPosOffset.method_10263(), dataProvidingBlockPosOffset.method_10264(), dataProvidingBlockPosOffset.method_10260()))) instanceof ProvidesData) {
            ProvidesData providesDataBlockEntity = (ProvidesData)blockEntity;
            locationString = (String)locationString + providesDataBlockEntity.getData(this.locationDataIdentifier);
            entranceString = (String)entranceString + providesDataBlockEntity.getData(this.entranceDataIdentifier);
            dataIdString = dataIdString + providesDataBlockEntity.getData(this.sendDataIdentifierDataIdentifier);
            dataValueString = dataValueString + providesDataBlockEntity.getData(this.sendDataValueDataIdentifier);
        }
        return new MutablePair((Object)new MutablePair(locationString, entranceString), (Object)new MutablePair((Object)dataIdString, (Object)dataValueString));
    }

    public MutablePair<MutablePair<String, String>, MutablePair<String, String>> getLocation() {
        return this.location;
    }

    public void setLocation(MutablePair<MutablePair<String, String>, MutablePair<String, String>> location) {
        this.location = location;
    }

    public class_2338 getDataProvidingBlockPosOffset() {
        return this.dataProvidingBlockPosOffset;
    }

    public void setDataProvidingBlockPosOffset(class_2338 dataProvidingBlockPosOffset) {
        this.dataProvidingBlockPosOffset = dataProvidingBlockPosOffset;
    }

    public String getLocationDataIdentifier() {
        return this.locationDataIdentifier;
    }

    public void setLocationDataIdentifier(String locationDataIdentifier) {
        this.locationDataIdentifier = locationDataIdentifier;
    }

    public String getEntranceDataIdentifier() {
        return this.entranceDataIdentifier;
    }

    public void setEntranceDataIdentifier(String entranceDataIdentifier) {
        this.entranceDataIdentifier = entranceDataIdentifier;
    }

    public String getSendDataIdentifierDataIdentifier() {
        return this.sendDataIdentifierDataIdentifier;
    }

    public void setSendDataIdentifierDataIdentifier(String sendDataIdentifierDataIdentifier) {
        this.sendDataIdentifierDataIdentifier = sendDataIdentifierDataIdentifier;
    }

    public String getSendDataValueDataIdentifier() {
        return this.sendDataValueDataIdentifier;
    }

    public void setSendDataValueDataIdentifier(String sendDataValueDataIdentifier) {
        this.sendDataValueDataIdentifier = sendDataValueDataIdentifier;
    }

    public String getCurrentTargetIdentifierLabel() {
        return this.currentTargetIdentifierLabel;
    }

    public void setCurrentTargetIdentifierLabel(String currentTargetIdentifierLabel) {
        this.currentTargetIdentifierLabel = currentTargetIdentifierLabel;
    }

    public String getCurrentTargetOwnerLabel() {
        return this.currentTargetOwnerLabel;
    }

    public void setCurrentTargetOwnerLabel(String currentTargetOwnerLabel) {
        this.currentTargetOwnerLabel = currentTargetOwnerLabel;
    }

    public boolean showRegenerateButton() {
        return this.showRegenerateButton;
    }

    public void setShowRegenerateButton(boolean showRegenerateButton) {
        this.showRegenerateButton = showRegenerateButton;
    }

    public boolean canOwnerBeChosen() {
        return this.canOwnerBeChosen;
    }

    public void setCanOwnerBeChosen(boolean canOwnerBeChosen) {
        this.canOwnerBeChosen = canOwnerBeChosen;
    }

    public String getTeleportButtonLabel() {
        return this.teleportButtonLabel;
    }

    public void setTeleportButtonLabel(String teleportButtonLabel) {
        this.teleportButtonLabel = teleportButtonLabel;
    }

    public String getCancelTeleportButtonLabel() {
        return this.cancelTeleportButtonLabel;
    }

    public void setCancelTeleportButtonLabel(String cancelTeleportButtonLabel) {
        this.cancelTeleportButtonLabel = cancelTeleportButtonLabel;
    }

    public TeleporterBlockScreenHandler.TeleporterBlockData getScreenOpeningData(class_3222 player) {
        return new TeleporterBlockScreenHandler.TeleporterBlockData(this.field_11867);
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new TeleporterBlockScreenHandler(syncId, playerInventory, player.method_7338());
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)this.teleporterName);
    }

    @Override
    protected void onRotate(class_2680 state) {
        if (state.method_26204() instanceof RotatedBlockWithEntity) {
            MutablePair<class_2338, class_2382> offsetArea;
            if ((Integer)state.method_11654((class_2769)RotatedBlockWithEntity.ROTATED) != this.rotated) {
                class_2470 blockRotation = BlockRotationUtils.calculateRotationFromDifferentRotatedStates((Integer)state.method_11654((class_2769)RotatedBlockWithEntity.ROTATED), this.rotated);
                this.accessPositionOffset = BlockRotationUtils.rotateOffsetBlockPos(this.accessPositionOffset, blockRotation);
                this.directTeleportPositionOffset = BlockRotationUtils.rotateOffsetBlockPos(this.directTeleportPositionOffset, blockRotation);
                this.directTeleportOrientationYaw = BlockRotationUtils.rotateYaw(this.directTeleportOrientationYaw, blockRotation);
                MutablePair<class_2338, class_2382> offsetArea2 = BlockRotationUtils.rotateOffsetArea(this.activationAreaPositionOffset, this.activationAreaDimensions, blockRotation);
                this.activationAreaPositionOffset = (class_2338)offsetArea2.getLeft();
                this.activationAreaDimensions = (class_2382)offsetArea2.getRight();
                this.rotated = (Integer)state.method_11654((class_2769)RotatedBlockWithEntity.ROTATED);
            }
            if ((Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.X_MIRRORED) != this.x_mirrored) {
                this.accessPositionOffset = BlockRotationUtils.mirrorOffsetBlockPos(this.accessPositionOffset, class_2415.field_11301);
                this.directTeleportPositionOffset = BlockRotationUtils.mirrorOffsetBlockPos(this.directTeleportPositionOffset, class_2415.field_11301);
                this.directTeleportOrientationYaw = BlockRotationUtils.mirrorYaw(this.directTeleportOrientationYaw, class_2415.field_11301);
                offsetArea = BlockRotationUtils.mirrorOffsetArea(this.activationAreaPositionOffset, this.activationAreaDimensions, class_2415.field_11301);
                this.activationAreaPositionOffset = (class_2338)offsetArea.getLeft();
                this.activationAreaDimensions = (class_2382)offsetArea.getRight();
                this.x_mirrored = (Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.X_MIRRORED);
            }
            if ((Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.Z_MIRRORED) != this.z_mirrored) {
                this.accessPositionOffset = BlockRotationUtils.mirrorOffsetBlockPos(this.accessPositionOffset, class_2415.field_11300);
                this.directTeleportPositionOffset = BlockRotationUtils.mirrorOffsetBlockPos(this.directTeleportPositionOffset, class_2415.field_11300);
                this.directTeleportOrientationYaw = BlockRotationUtils.mirrorYaw(this.directTeleportOrientationYaw, class_2415.field_11300);
                offsetArea = BlockRotationUtils.mirrorOffsetArea(this.activationAreaPositionOffset, this.activationAreaDimensions, class_2415.field_11300);
                this.activationAreaPositionOffset = (class_2338)offsetArea.getLeft();
                this.activationAreaDimensions = (class_2382)offsetArea.getRight();
                this.z_mirrored = (Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.Z_MIRRORED);
            }
        }
    }

    public static enum CreativeScreenPage implements class_3542
    {
        ACTIVATION("activation"),
        TELEPORTATION_MODE("teleportation_mode"),
        STATUS_EFFECTS_TO_DECREMENT("status_effect_to_decrement"),
        ADVENTURE_SCREEN_CUSTOMIZATION("adventure_screen_customization");

        private final String name;

        private CreativeScreenPage(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        public static Optional<CreativeScreenPage> byName(String name) {
            return Arrays.stream(CreativeScreenPage.values()).filter(creativeScreenPage -> creativeScreenPage.method_15434().equals(name)).findFirst();
        }

        public class_2561 asText() {
            return class_2561.method_43471((String)("gui.teleporter_block.creativeScreenPage." + this.name));
        }
    }

    public static enum TeleportationMode implements class_3542
    {
        DIRECT("direct"),
        SPAWN_POINTS("spawn_points"),
        LOCATIONS("locations"),
        LOCATION("location");

        private final String name;

        private TeleportationMode(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        public static Optional<TeleportationMode> byName(String name) {
            return Arrays.stream(TeleportationMode.values()).filter(teleportationMode -> teleportationMode.method_15434().equals(name)).findFirst();
        }

        public class_2561 asText() {
            return class_2561.method_43471((String)("gui.teleporter_block.teleportation_mode." + this.name));
        }
    }

    public static enum SpawnPointType implements class_3542
    {
        WORLD_SPAWN("world_spawn"),
        PLAYER_SPAWN("player_spawn"),
        LOCATION_ACCESS_POSITION("location_access_position");

        private final String name;

        private SpawnPointType(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        public static Optional<SpawnPointType> byName(String name) {
            return Arrays.stream(SpawnPointType.values()).filter(spawnPointType -> spawnPointType.method_15434().equals(name)).findFirst();
        }

        public class_2561 asText() {
            return class_2561.method_43471((String)("gui.teleporter_block.spawn_point_type." + this.name));
        }
    }
}

