/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.scriptblocks.block.entity;

import com.github.theredbrain.scriptblocks.block.Resetable;
import com.github.theredbrain.scriptblocks.block.RotatedBlockWithEntity;
import com.github.theredbrain.scriptblocks.block.Triggerable;
import com.github.theredbrain.scriptblocks.block.entity.RotatedBlockEntity;
import com.github.theredbrain.scriptblocks.registry.EntityRegistry;
import com.github.theredbrain.scriptblocks.util.BlockRotationUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.apache.commons.lang3.tuple.MutablePair;

public class TriggeredBeaconBlockEntity
extends RotatedBlockEntity
implements Triggerable,
Resetable {
    private boolean calculateAreaBox = true;
    private class_238 area = null;
    private boolean showArea = false;
    private class_2382 areaDimensions = class_2382.field_11176;
    private class_2338 areaPositionOffset = new class_2338(0, 1, 0);
    private String appliedStatusEffectIdentifier = "";
    private int appliedStatusEffectAmplifier = 0;
    private int appliedStatusEffectDuration = 100;
    private boolean appliedStatusEffectAmbient = false;
    private boolean appliedStatusEffectShowParticles = false;
    private boolean appliedStatusEffectShowIcon = false;
    private boolean triggered = false;
    private TriggeredMode triggeredMode = TriggeredMode.ONCE;

    public TriggeredBeaconBlockEntity(class_2338 pos, class_2680 state) {
        super(EntityRegistry.TRIGGERED_BEACON_BLOCK_ENTITY, pos, state);
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        if (this.showArea) {
            nbt.method_10556("showArea", true);
        } else {
            nbt.method_10551("showArea");
        }
        if (this.area != null) {
            nbt.method_10549("areaMinX", this.area.field_1323);
            nbt.method_10549("areaMaxX", this.area.field_1320);
            nbt.method_10549("areaMinY", this.area.field_1322);
            nbt.method_10549("areaMaxY", this.area.field_1325);
            nbt.method_10549("areaMinZ", this.area.field_1321);
            nbt.method_10549("areaMaxZ", this.area.field_1324);
        } else {
            nbt.method_10551("areaMinX");
            nbt.method_10551("areaMaxX");
            nbt.method_10551("areaMinY");
            nbt.method_10551("areaMaxY");
            nbt.method_10551("areaMinZ");
            nbt.method_10551("areaMaxZ");
        }
        if (this.areaDimensions.method_10263() != 0) {
            nbt.method_10569("areaDimensionsX", this.areaDimensions.method_10263());
        } else {
            nbt.method_10551("areaDimensionsX");
        }
        if (this.areaDimensions.method_10264() != 0) {
            nbt.method_10569("areaDimensionsY", this.areaDimensions.method_10264());
        } else {
            nbt.method_10551("areaDimensionsY");
        }
        if (this.areaDimensions.method_10260() != 0) {
            nbt.method_10569("areaDimensionsZ", this.areaDimensions.method_10260());
        } else {
            nbt.method_10551("areaDimensionsZ");
        }
        if (this.areaPositionOffset.method_10263() != 0) {
            nbt.method_10569("areaPositionOffsetX", this.areaPositionOffset.method_10263());
        } else {
            nbt.method_10551("areaPositionOffsetX");
        }
        if (this.areaPositionOffset.method_10264() != 0) {
            nbt.method_10569("areaPositionOffsetY", this.areaPositionOffset.method_10264());
        } else {
            nbt.method_10551("areaPositionOffsetY");
        }
        if (this.areaPositionOffset.method_10260() != 0) {
            nbt.method_10569("areaPositionOffsetZ", this.areaPositionOffset.method_10260());
        } else {
            nbt.method_10551("areaPositionOffsetZ");
        }
        if (!this.appliedStatusEffectIdentifier.isEmpty()) {
            nbt.method_10582("appliedStatusEffectIdentifier", this.appliedStatusEffectIdentifier);
        } else {
            nbt.method_10551("appliedStatusEffectIdentifier");
        }
        if (this.appliedStatusEffectAmplifier != 0) {
            nbt.method_10569("appliedStatusEffectAmplifier", this.appliedStatusEffectAmplifier);
        } else {
            nbt.method_10551("appliedStatusEffectAmplifier");
        }
        if (this.appliedStatusEffectDuration != 100) {
            nbt.method_10569("appliedStatusEffectDuration", this.appliedStatusEffectDuration);
        } else {
            nbt.method_10551("appliedStatusEffectDuration");
        }
        if (this.appliedStatusEffectAmbient) {
            nbt.method_10556("appliedStatusEffectAmbient", true);
        } else {
            nbt.method_10551("appliedStatusEffectAmbient");
        }
        if (this.appliedStatusEffectShowParticles) {
            nbt.method_10556("appliedStatusEffectShowParticles", true);
        } else {
            nbt.method_10551("appliedStatusEffectShowParticles");
        }
        if (this.appliedStatusEffectShowIcon) {
            nbt.method_10556("appliedStatusEffectShowIcon", true);
        } else {
            nbt.method_10551("appliedStatusEffectShowIcon");
        }
        if (this.triggered) {
            nbt.method_10556("triggered", true);
        } else {
            nbt.method_10551("triggered");
        }
        if (this.triggeredMode != TriggeredMode.ONCE) {
            nbt.method_10582("triggeredMode", this.triggeredMode.method_15434());
        } else {
            nbt.method_10551("triggeredMode");
        }
        super.method_11007(nbt, registryLookup);
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        this.showArea = nbt.method_10577("showArea");
        if (nbt.method_10545("areaMinX") && nbt.method_10545("areaMinY") && nbt.method_10545("areaMinZ") && nbt.method_10545("areaMaxX") && nbt.method_10545("areaMaxY") && nbt.method_10545("areaMaxZ")) {
            this.area = new class_238(nbt.method_10574("areaMinX"), nbt.method_10574("areaMinY"), nbt.method_10574("areaMinZ"), nbt.method_10574("areaMaxX"), nbt.method_10574("areaMaxY"), nbt.method_10574("areaMaxZ"));
            this.calculateAreaBox = true;
        }
        int i = class_3532.method_15340((int)nbt.method_10550("areaDimensionsX"), (int)0, (int)48);
        int j = class_3532.method_15340((int)nbt.method_10550("areaDimensionsY"), (int)0, (int)48);
        int k = class_3532.method_15340((int)nbt.method_10550("areaDimensionsZ"), (int)0, (int)48);
        this.areaDimensions = new class_2382(i, j, k);
        int l = class_3532.method_15340((int)nbt.method_10550("areaPositionOffsetX"), (int)-48, (int)48);
        int m = class_3532.method_15340((int)nbt.method_10550("areaPositionOffsetY"), (int)-48, (int)48);
        int n = class_3532.method_15340((int)nbt.method_10550("areaPositionOffsetZ"), (int)-48, (int)48);
        this.areaPositionOffset = new class_2338(l, m, n);
        this.appliedStatusEffectIdentifier = nbt.method_10558("appliedStatusEffectIdentifier");
        this.appliedStatusEffectAmplifier = nbt.method_10550("appliedStatusEffectAmplifier");
        this.appliedStatusEffectDuration = nbt.method_10545("appliedStatusEffectDuration") ? nbt.method_10550("appliedStatusEffectDuration") : 100;
        this.appliedStatusEffectAmbient = nbt.method_10577("appliedStatusEffectAmbient");
        this.appliedStatusEffectShowParticles = nbt.method_10577("appliedStatusEffectShowParticles");
        this.appliedStatusEffectShowIcon = nbt.method_10577("appliedStatusEffectShowIcon");
        this.triggered = nbt.method_10577("triggered");
        this.triggeredMode = TriggeredMode.byName(nbt.method_10558("triggeredMode")).orElse(TriggeredMode.ONCE);
        super.method_11014(nbt, registryLookup);
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return this.method_58692(registryLookup);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, TriggeredBeaconBlockEntity triggeredBeaconBlockEntity) {
        if (!world.field_9236 && world.method_8510() % 80L == 0L) {
            if (triggeredBeaconBlockEntity.calculateAreaBox || triggeredBeaconBlockEntity.area == null) {
                class_2338 areaPositionOffset = triggeredBeaconBlockEntity.areaPositionOffset;
                class_2382 areaDimensions = triggeredBeaconBlockEntity.areaDimensions;
                class_243 areaStart = new class_243((double)(pos.method_10263() + areaPositionOffset.method_10263()), (double)(pos.method_10264() + areaPositionOffset.method_10264()), (double)(pos.method_10260() + areaPositionOffset.method_10260()));
                class_243 areaEnd = new class_243(areaStart.method_10216() + (double)areaDimensions.method_10263(), areaStart.method_10214() + (double)areaDimensions.method_10264(), areaStart.method_10215() + (double)areaDimensions.method_10260());
                triggeredBeaconBlockEntity.area = new class_238(areaStart, areaEnd);
                triggeredBeaconBlockEntity.calculateAreaBox = false;
            }
            if (triggeredBeaconBlockEntity.triggeredMode == TriggeredMode.CONTINUOUS && triggeredBeaconBlockEntity.triggered) {
                triggeredBeaconBlockEntity.applyStatusEffect(world);
            }
        }
    }

    private void applyStatusEffect(class_1937 world) {
        Optional statusEffect = class_7923.field_41174.method_55841(class_2960.method_12829((String)this.appliedStatusEffectIdentifier));
        if (statusEffect.isEmpty()) {
            return;
        }
        List playerList = world.method_18467(class_1657.class, this.area);
        ArrayList<UUID> playerUuidList = new ArrayList<UUID>();
        for (class_1657 player : playerList) {
            playerUuidList.add(player.method_5667());
        }
        for (UUID uuid : playerUuidList) {
            class_1657 playerEntity = world.method_18470(uuid);
            if (playerEntity == null) continue;
            playerEntity.method_6092(new class_1293((class_6880)statusEffect.get(), this.appliedStatusEffectDuration, this.appliedStatusEffectAmplifier, this.appliedStatusEffectAmbient, this.appliedStatusEffectShowParticles, this.appliedStatusEffectShowIcon));
        }
    }

    public boolean showArea() {
        return this.showArea;
    }

    public void setShowArea(boolean showArea) {
        this.showArea = showArea;
    }

    public class_2382 getAreaDimensions() {
        return this.areaDimensions;
    }

    public boolean setAreaDimensions(class_2382 areaDimensions) {
        this.areaDimensions = areaDimensions;
        this.calculateAreaBox = true;
        return true;
    }

    public class_2338 getAreaPositionOffset() {
        return this.areaPositionOffset;
    }

    public boolean setAreaPositionOffset(class_2338 areaPositionOffset) {
        this.areaPositionOffset = areaPositionOffset;
        this.calculateAreaBox = true;
        return true;
    }

    public String getAppliedStatusEffectIdentifier() {
        return this.appliedStatusEffectIdentifier;
    }

    public boolean setAppliedStatusEffectIdentifier(String appliedStatusEffectIdentifier) {
        if (class_7923.field_41174.method_10223(class_2960.method_12829((String)appliedStatusEffectIdentifier)) != null || appliedStatusEffectIdentifier.equals("")) {
            this.appliedStatusEffectIdentifier = appliedStatusEffectIdentifier;
            return true;
        }
        return false;
    }

    public int getAppliedStatusEffectAmplifier() {
        return this.appliedStatusEffectAmplifier;
    }

    public boolean setAppliedStatusEffectAmplifier(int appliedStatusEffectAmplifier) {
        if (appliedStatusEffectAmplifier >= 0 && appliedStatusEffectAmplifier < 127) {
            this.appliedStatusEffectAmplifier = appliedStatusEffectAmplifier;
            return true;
        }
        return false;
    }

    public int getAppliedStatusEffectDuration() {
        return this.appliedStatusEffectDuration;
    }

    public void setAppliedStatusEffectDuration(int appliedStatusEffectDuration) {
        if (appliedStatusEffectDuration < -1) {
            appliedStatusEffectDuration = 100;
        }
        this.appliedStatusEffectDuration = appliedStatusEffectDuration;
    }

    public boolean getAppliedStatusEffectAmbient() {
        return this.appliedStatusEffectAmbient;
    }

    public void setAppliedStatusEffectAmbient(boolean appliedStatusEffectAmbient) {
        this.appliedStatusEffectAmbient = appliedStatusEffectAmbient;
    }

    public boolean getAppliedStatusEffectShowParticles() {
        return this.appliedStatusEffectShowParticles;
    }

    public void setAppliedStatusEffectShowParticles(boolean appliedStatusEffectShowParticles) {
        this.appliedStatusEffectShowParticles = appliedStatusEffectShowParticles;
    }

    public boolean getAppliedStatusEffectShowIcon() {
        return this.appliedStatusEffectShowIcon;
    }

    public void setAppliedStatusEffectShowIcon(boolean appliedStatusEffectShowIcon) {
        this.appliedStatusEffectShowIcon = appliedStatusEffectShowIcon;
    }

    public boolean getTriggered() {
        return this.triggered;
    }

    public void setTriggered(boolean triggered) {
        this.triggered = triggered;
    }

    public TriggeredMode getTriggeredMode() {
        return this.triggeredMode;
    }

    public void setTriggeredMode(TriggeredMode triggeredMode) {
        this.triggeredMode = triggeredMode;
    }

    @Override
    public void reset() {
        if (this.triggered) {
            this.triggered = false;
        }
    }

    @Override
    public void trigger() {
        if (this.triggeredMode == TriggeredMode.CONTINUOUS && !this.triggered) {
            this.triggered = true;
        } else if (this.triggeredMode == TriggeredMode.ONCE && this.field_11863 != null) {
            this.applyStatusEffect(this.field_11863);
        }
    }

    @Override
    protected void onRotate(class_2680 state) {
        if (state.method_26204() instanceof RotatedBlockWithEntity) {
            MutablePair<class_2338, class_2382> offsetArea;
            if ((Integer)state.method_11654((class_2769)RotatedBlockWithEntity.ROTATED) != this.rotated) {
                class_2470 blockRotation = BlockRotationUtils.calculateRotationFromDifferentRotatedStates((Integer)state.method_11654((class_2769)RotatedBlockWithEntity.ROTATED), this.rotated);
                MutablePair<class_2338, class_2382> offsetArea2 = BlockRotationUtils.rotateOffsetArea(this.areaPositionOffset, this.areaDimensions, blockRotation);
                this.areaPositionOffset = (class_2338)offsetArea2.getLeft();
                this.areaDimensions = (class_2382)offsetArea2.getRight();
                this.rotated = (Integer)state.method_11654((class_2769)RotatedBlockWithEntity.ROTATED);
            }
            if ((Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.X_MIRRORED) != this.x_mirrored) {
                offsetArea = BlockRotationUtils.mirrorOffsetArea(this.areaPositionOffset, this.areaDimensions, class_2415.field_11301);
                this.areaPositionOffset = (class_2338)offsetArea.getLeft();
                this.areaDimensions = (class_2382)offsetArea.getRight();
                this.x_mirrored = (Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.X_MIRRORED);
            }
            if ((Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.Z_MIRRORED) != this.z_mirrored) {
                offsetArea = BlockRotationUtils.mirrorOffsetArea(this.areaPositionOffset, this.areaDimensions, class_2415.field_11300);
                this.areaPositionOffset = (class_2338)offsetArea.getLeft();
                this.areaDimensions = (class_2382)offsetArea.getRight();
                this.z_mirrored = (Boolean)state.method_11654((class_2769)RotatedBlockWithEntity.Z_MIRRORED);
            }
        }
    }

    public static enum TriggeredMode implements class_3542
    {
        CONTINUOUS("continuous"),
        ONCE("once");

        private final String name;

        private TriggeredMode(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        public static Optional<TriggeredMode> byName(String name) {
            return Arrays.stream(TriggeredMode.values()).filter(triggeredMode -> triggeredMode.method_15434().equals(name)).findFirst();
        }

        public class_2561 asText() {
            return class_2561.method_43471((String)("gui.triggered_beacon_block.triggered_mode." + this.name));
        }
    }
}

