/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.scriptblocks.block.lootable_vault;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_4844;

public class LootableVaultServerData {
    static final String SERVER_DATA_KEY = "server_data";
    public static Codec<LootableVaultServerData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_4844.field_48974.lenientOptionalFieldOf("rewarded_players", Set.of()).forGetter(data -> data.rewardedPlayers), (App)Codec.LONG.lenientOptionalFieldOf("state_updating_resumes_at", (Object)0L).forGetter(data -> data.stateUpdatingResumesAt)).apply((Applicative)instance, LootableVaultServerData::new));
    private static final int MAX_STORED_REWARDED_PLAYERS = 128;
    private final Set<UUID> rewardedPlayers = new ObjectLinkedOpenHashSet();
    private long stateUpdatingResumesAt;
    private long lastFailedUnlockTime;
    boolean dirty;

    LootableVaultServerData(Set<UUID> rewardedPlayers, long stateUpdatingResumesAt) {
        this.rewardedPlayers.addAll(rewardedPlayers);
        this.stateUpdatingResumesAt = stateUpdatingResumesAt;
    }

    public LootableVaultServerData() {
    }

    public void setLastFailedUnlockTime(long lastFailedUnlockTime) {
        this.lastFailedUnlockTime = lastFailedUnlockTime;
    }

    public long getLastFailedUnlockTime() {
        return this.lastFailedUnlockTime;
    }

    Set<UUID> getRewardedPlayers() {
        return this.rewardedPlayers;
    }

    public boolean hasRewardedPlayer(class_1657 player) {
        return this.rewardedPlayers.contains(player.method_5667());
    }

    @VisibleForTesting
    public void markPlayerAsRewarded(class_1657 player) {
        Iterator<UUID> iterator;
        this.rewardedPlayers.add(player.method_5667());
        if (this.rewardedPlayers.size() > 128 && (iterator = this.rewardedPlayers.iterator()).hasNext()) {
            iterator.next();
            iterator.remove();
        }
        this.markDirty();
    }

    @VisibleForTesting
    public void unmarkPlayerAsRewarded(class_1657 player) {
        this.rewardedPlayers.remove(player.method_5667());
        this.markDirty();
    }

    public long getStateUpdatingResumeTime() {
        return this.stateUpdatingResumesAt;
    }

    public void setStateUpdatingResumeTime(long stateUpdatingResumesAt) {
        this.stateUpdatingResumesAt = stateUpdatingResumesAt;
        this.markDirty();
    }

    public void copyFrom(LootableVaultServerData data) {
        this.stateUpdatingResumesAt = data.getStateUpdatingResumeTime();
        this.rewardedPlayers.clear();
        this.rewardedPlayers.addAll(data.rewardedPlayers);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    private void markDirty() {
        this.dirty = true;
    }

    public void markClean() {
        this.dirty = false;
    }
}

