/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.scriptblocks.mixin.entity.mob;

import com.github.theredbrain.scriptblocks.block.entity.BossControllerBlockEntity;
import com.github.theredbrain.scriptblocks.block.entity.TriggeredSpawnerBlockEntity;
import com.github.theredbrain.scriptblocks.entity.mob.DuckMobEntityMixin;
import java.util.Objects;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1308.class})
public abstract class MobEntityMixin
extends class_1309
implements DuckMobEntityMixin {
    @Unique
    private static final float BOSS_HEALTH_THRESHOLD_DEFAULT = -1.0f;
    @Unique
    private static final int BOSS_PHASE_DEFAULT = -1;
    @Unique
    private static final class_2338 CONTROLLER_BLOCK_POS_DEFAULT = new class_2338(0, -100, 0);
    @Unique
    private static final class_2338 USE_RELAY_BLOCK_POS_DEFAULT = new class_2338(0, -100, 0);
    @Unique
    private static final class_2940<Float> BOSS_HEALTH_THRESHOLD = class_2945.method_12791(class_1308.class, (class_2941)class_2943.field_13320);
    @Unique
    private static final class_2940<Integer> BOSS_PHASE = class_2945.method_12791(class_1308.class, (class_2941)class_2943.field_13327);
    @Unique
    private static final class_2940<class_2338> CONTROLLER_BLOCK_POS = class_2945.method_12791(class_1308.class, (class_2941)class_2943.field_13324);
    @Unique
    private static final class_2940<class_2338> USE_RELAY_BLOCK_POS = class_2945.method_12791(class_1308.class, (class_2941)class_2943.field_13324);

    protected MobEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method={"initDataTracker"}, at={@At(value="RETURN")})
    protected void overhauleddamage$initDataTracker(class_2945.class_9222 builder, CallbackInfo ci) {
        builder.method_56912(BOSS_HEALTH_THRESHOLD, (Object)Float.valueOf(-1.0f));
        builder.method_56912(BOSS_PHASE, (Object)-1);
        builder.method_56912(CONTROLLER_BLOCK_POS, (Object)CONTROLLER_BLOCK_POS_DEFAULT);
        builder.method_56912(USE_RELAY_BLOCK_POS, (Object)USE_RELAY_BLOCK_POS_DEFAULT);
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    public void scriptblocks$writeCustomDataToNbt(class_2487 nbt, CallbackInfo ci) {
        float bossHealthThreshold = this.scriptblocks$getBossHealthThreshold();
        if (bossHealthThreshold != -1.0f) {
            nbt.method_10548("boss_health_threshold", bossHealthThreshold);
        } else {
            nbt.method_10551("boss_health_threshold");
        }
        int bossPhase = this.scriptblocks$getBossPhase();
        if (bossPhase != -1) {
            nbt.method_10569("boss_phase", bossPhase);
        } else {
            nbt.method_10551("boss_phase");
        }
        class_2338 controllerBlockPos = this.scriptblocks$getControllerBlockPos();
        if (!controllerBlockPos.equals((Object)CONTROLLER_BLOCK_POS_DEFAULT)) {
            nbt.method_10569("controller_block_pos_x", controllerBlockPos.method_10263());
            nbt.method_10569("controller_block_pos_y", controllerBlockPos.method_10264());
            nbt.method_10569("controller_block_pos_z", controllerBlockPos.method_10260());
        } else {
            nbt.method_10551("controller_block_pos_x");
            nbt.method_10551("controller_block_pos_y");
            nbt.method_10551("controller_block_pos_z");
        }
        class_2338 useRelayBlockPos = this.scriptblocks$getUseRelayBlockPos();
        if (!useRelayBlockPos.equals((Object)USE_RELAY_BLOCK_POS_DEFAULT)) {
            nbt.method_10569("use_relay_block_pos_x", useRelayBlockPos.method_10263());
            nbt.method_10569("use_relay_block_pos_y", useRelayBlockPos.method_10264());
            nbt.method_10569("use_relay_block_pos_z", useRelayBlockPos.method_10260());
        } else {
            nbt.method_10551("use_relay_block_pos_x");
            nbt.method_10551("use_relay_block_pos_y");
            nbt.method_10551("use_relay_block_pos_z");
        }
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    public void scriptblocks$readCustomDataFromNbt(class_2487 nbt, CallbackInfo ci) {
        if (nbt.method_10545("boss_health_threshold")) {
            this.scriptblocks$setBossHealthThreshold(nbt.method_10583("boss_health_threshold"));
        }
        if (nbt.method_10545("boss_phase")) {
            this.scriptblocks$setBossPhase(nbt.method_10550("boss_phase"));
        }
        if (nbt.method_10545("controller_block_pos_x") || nbt.method_10545("controller_block_pos_y") || nbt.method_10545("controller_block_pos_z")) {
            this.scriptblocks$setControllerBlockPos(new class_2338(nbt.method_10550("controller_block_pos_x"), nbt.method_10550("controller_block_pos_y"), nbt.method_10550("controller_block_pos_z")));
        }
        if (nbt.method_10545("use_relay_block_pos_x") || nbt.method_10545("use_relay_block_pos_y") || nbt.method_10545("use_relay_block_pos_z")) {
            this.scriptblocks$setUseRelayBlockPos(new class_2338(nbt.method_10550("use_relay_block_pos_x"), nbt.method_10550("use_relay_block_pos_y"), nbt.method_10550("use_relay_block_pos_z")));
        }
    }

    @Inject(method={"interactMob"}, at={@At(value="TAIL")}, cancellable=true)
    protected void scriptblocks$interactMob(class_1657 player, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        class_2338 useRelayBlockPos = this.scriptblocks$getUseRelayBlockPos();
        if (!Objects.equals(useRelayBlockPos, USE_RELAY_BLOCK_POS_DEFAULT)) {
            if (player instanceof class_3222) {
                class_3222 serverPlayerEntity = (class_3222)player;
                class_1937 world = player.method_37908();
                class_3965 blockHitResult = new class_3965(player.method_19538(), class_2350.field_11036, useRelayBlockPos, false);
                class_1799 itemStack = player.method_5998(hand);
                serverPlayerEntity.field_13974.method_14262(serverPlayerEntity, world, itemStack, hand, blockHitResult);
                cir.setReturnValue((Object)class_1269.field_21466);
                cir.cancel();
            } else {
                cir.setReturnValue((Object)class_1269.field_5812);
                cir.cancel();
            }
        }
    }

    public void method_6033(float health) {
        float healthThreshold = this.scriptblocks$getBossHealthThreshold();
        if (healthThreshold > -1.0f && health <= healthThreshold) {
            health = healthThreshold;
            class_2338 controllerBlockPos = this.scriptblocks$getControllerBlockPos();
            class_1937 class_19372 = this.method_37908();
            if (class_19372 instanceof class_3218) {
                class_2586 blockEntity;
                class_3218 serverWorld = (class_3218)class_19372;
                if (!Objects.equals(controllerBlockPos, CONTROLLER_BLOCK_POS_DEFAULT) && (blockEntity = serverWorld.method_8321(controllerBlockPos)) instanceof BossControllerBlockEntity) {
                    BossControllerBlockEntity bossControllerBlockEntity = (BossControllerBlockEntity)blockEntity;
                    BossControllerBlockEntity.bossReachedHealthThreshold(bossControllerBlockEntity, (class_1308)this);
                }
            }
        }
        super.method_6033(health);
    }

    public void method_6078(class_1282 damageSource) {
        super.method_6078(damageSource);
        class_2338 controllerBlockPos = this.scriptblocks$getControllerBlockPos();
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_2586 blockEntity;
            class_3218 serverWorld = (class_3218)class_19372;
            if (!Objects.equals(controllerBlockPos, CONTROLLER_BLOCK_POS_DEFAULT) && (blockEntity = serverWorld.method_8321(controllerBlockPos)) instanceof TriggeredSpawnerBlockEntity) {
                TriggeredSpawnerBlockEntity triggeredSpawnerBlockEntity = (TriggeredSpawnerBlockEntity)blockEntity;
                triggeredSpawnerBlockEntity.onBoundEntityKilled();
            }
        }
    }

    @Override
    public float scriptblocks$getBossHealthThreshold() {
        return ((Float)this.field_6011.method_12789(BOSS_HEALTH_THRESHOLD)).floatValue();
    }

    @Override
    public void scriptblocks$setBossHealthThreshold(float bossHealthThreshold) {
        this.field_6011.method_12778(BOSS_HEALTH_THRESHOLD, (Object)Float.valueOf(bossHealthThreshold));
    }

    @Override
    public int scriptblocks$getBossPhase() {
        return (Integer)this.field_6011.method_12789(BOSS_PHASE);
    }

    @Override
    public void scriptblocks$setBossPhase(int bossPhase) {
        this.field_6011.method_12778(BOSS_PHASE, (Object)bossPhase);
    }

    @Override
    public class_2338 scriptblocks$getControllerBlockPos() {
        return (class_2338)this.field_6011.method_12789(CONTROLLER_BLOCK_POS);
    }

    @Override
    public void scriptblocks$setControllerBlockPos(class_2338 controllerBlockPos) {
        this.field_6011.method_12778(CONTROLLER_BLOCK_POS, (Object)controllerBlockPos);
    }

    @Override
    public class_2338 scriptblocks$getUseRelayBlockPos() {
        return (class_2338)this.field_6011.method_12789(USE_RELAY_BLOCK_POS);
    }

    @Override
    public void scriptblocks$setUseRelayBlockPos(class_2338 useRelayBlockPos) {
        this.field_6011.method_12778(USE_RELAY_BLOCK_POS, (Object)useRelayBlockPos);
    }
}

