/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.scriptblocks.network.packet;

import com.github.theredbrain.scriptblocks.block.DialogueAnchor;
import com.github.theredbrain.scriptblocks.block.Resetable;
import com.github.theredbrain.scriptblocks.block.Triggerable;
import com.github.theredbrain.scriptblocks.data.CommonDataStructures;
import com.github.theredbrain.scriptblocks.data.DialogueAnswer;
import com.github.theredbrain.scriptblocks.network.packet.DialogueAnswerPacket;
import com.github.theredbrain.scriptblocks.registry.CustomDynamicRegistries;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1277;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8567;
import net.minecraft.class_8779;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.MutablePair;

public class DialogueAnswerPacketReceiver
implements ServerPlayNetworking.PlayPayloadHandler<DialogueAnswerPacket> {
    public void receive(DialogueAnswerPacket payload, ServerPlayNetworking.Context context) {
        class_3222 serverPlayerEntity = context.player();
        class_2960 answerIdentifier = payload.answerIdentifier();
        class_2338 dataBlockPos = payload.dataBlockPos();
        List<MutablePair<String, class_2338>> dialogueUsedBlocks = payload.dialogueUsedBlocks();
        List<MutablePair<String, MutablePair<class_2338, Boolean>>> dialogueTriggeredBlocks = payload.dialogueTriggeredBlocks();
        class_1937 world = serverPlayerEntity.method_37908();
        Optional optionalDialogueAnswerReference = world.method_30349().method_30530(CustomDynamicRegistries.DIALOGUE_ANSWER_REGISTRY_KEY).method_55841(answerIdentifier);
        MinecraftServer server = serverPlayerEntity.method_5682();
        if (optionalDialogueAnswerReference.isPresent() && server != null) {
            String usedBlock;
            String responseDialogueIdentifierString;
            String overlayMessage;
            class_8779 advancementEntry;
            String lootTable;
            DialogueAnswer dialogueAnswer = (DialogueAnswer)((class_6880.class_6883)optionalDialogueAnswerReference.get()).comp_349();
            if (!dialogueAnswer.availability().itemCosts().isEmpty()) {
                int stackCount;
                class_1799 itemStack;
                int j;
                int playerInventorySize = serverPlayerEntity.method_31548().method_5439();
                class_1277 playerInventoryCopy = new class_1277(playerInventorySize);
                for (int k = 0; k < playerInventorySize; ++k) {
                    playerInventoryCopy.method_5447(k, serverPlayerEntity.method_31548().method_5438(k).method_7972());
                }
                for (CommonDataStructures.ItemCost itemCost : dialogueAnswer.availability().itemCosts()) {
                    int itemCount = itemCost.itemStack().method_7947();
                    for (j = 0; j < playerInventorySize; ++j) {
                        if (!class_1799.method_31577((class_1799)playerInventoryCopy.method_5438(j), (class_1799)itemCost.itemStack())) continue;
                        itemStack = playerInventoryCopy.method_5438(j).method_7972();
                        stackCount = itemStack.method_7947();
                        if (stackCount >= itemCount) {
                            itemStack.method_7939(stackCount - itemCount);
                            playerInventoryCopy.method_5447(j, itemStack);
                            itemCount = 0;
                            break;
                        }
                        playerInventoryCopy.method_5447(j, class_1799.field_8037);
                        itemCount -= stackCount;
                    }
                    if (itemCount <= 0) continue;
                    serverPlayerEntity.method_43496((class_2561)class_2561.method_43471((String)"gui.dialogue_screen.item_cost_too_high"));
                    return;
                }
                for (CommonDataStructures.ItemCost itemCost : dialogueAnswer.availability().itemCosts()) {
                    if (!itemCost.consumeStack()) continue;
                    int ingredientCount = itemCost.itemStack().method_7947();
                    for (j = 0; j < playerInventorySize; ++j) {
                        if (!class_1799.method_31577((class_1799)serverPlayerEntity.method_31548().method_5438(j), (class_1799)itemCost.itemStack())) continue;
                        itemStack = serverPlayerEntity.method_31548().method_5438(j).method_7972();
                        stackCount = itemStack.method_7947();
                        if (stackCount >= ingredientCount) {
                            itemStack.method_7939(stackCount - ingredientCount);
                            serverPlayerEntity.method_31548().method_5447(j, itemStack);
                            ingredientCount = 0;
                            break;
                        }
                        serverPlayerEntity.method_31548().method_5447(j, class_1799.field_8037);
                        ingredientCount -= stackCount;
                    }
                    if (ingredientCount <= 0) continue;
                    return;
                }
            }
            if (!(lootTable = dialogueAnswer.results().lootTable()).isEmpty()) {
                class_2960 lootTableIdentifier = class_2960.method_60654((String)lootTable);
                class_8567 lootContextParameterSet = new class_8567.class_8568(serverPlayerEntity.method_51469()).method_51874(class_181.field_1226, (Object)serverPlayerEntity).method_51874(class_181.field_24424, (Object)serverPlayerEntity.method_19538()).method_51875(class_173.field_1174);
                boolean bl = false;
                for (class_1799 itemStack : server.method_58576().method_58295(class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)lootTableIdentifier)).method_51878(lootContextParameterSet)) {
                    if (serverPlayerEntity.method_7270(itemStack)) {
                        serverPlayerEntity.method_37908().method_43128(null, serverPlayerEntity.method_23317(), serverPlayerEntity.method_23318(), serverPlayerEntity.method_23321(), class_3417.field_15197, class_3419.field_15248, 0.2f, ((serverPlayerEntity.method_59922().method_43057() - serverPlayerEntity.method_59922().method_43057()) * 0.7f + 1.0f) * 2.0f);
                        bl = true;
                        continue;
                    }
                    class_1542 itemEntity = serverPlayerEntity.method_7328(itemStack, false);
                    if (itemEntity == null) continue;
                    itemEntity.method_6975();
                    itemEntity.method_48349(serverPlayerEntity.method_5667());
                }
                if (bl) {
                    serverPlayerEntity.field_7512.method_7623();
                }
            }
            String grantedAdvancement = dialogueAnswer.results().grantedAdvancement();
            String criterionName = dialogueAnswer.results().criterionName();
            if (!grantedAdvancement.isEmpty() && !criterionName.isEmpty() && (advancementEntry = server.method_3851().method_12896(class_2960.method_60654((String)grantedAdvancement))) != null) {
                serverPlayerEntity.method_14236().method_12878(advancementEntry, criterionName);
            }
            if ((overlayMessage = dialogueAnswer.results().overlayMessage()) != null) {
                serverPlayerEntity.method_43502((class_2561)class_2561.method_43471((String)overlayMessage), true);
            }
            if ((responseDialogueIdentifierString = DialogueAnchor.getDialogue(serverPlayerEntity.method_37908(), (class_1657)serverPlayerEntity, dialogueAnswer.responseDialogues())).isEmpty()) {
                serverPlayerEntity.method_7346();
            } else {
                DialogueAnchor.openDialogueScreen(world, server, serverPlayerEntity, responseDialogueIdentifierString, dataBlockPos, dialogueUsedBlocks, dialogueTriggeredBlocks);
            }
            String triggeredBlock = dialogueAnswer.results().triggeredBlock();
            if (triggeredBlock != null) {
                for (MutablePair<String, MutablePair<class_2338, Boolean>> entry : dialogueTriggeredBlocks) {
                    if (!((String)entry.getLeft()).equals(triggeredBlock)) continue;
                    class_2586 blockEntity = serverPlayerEntity.method_37908().method_8321((class_2338)((MutablePair)entry.getRight()).getLeft());
                    boolean triggeredBlockResets = (Boolean)((MutablePair)entry.getRight()).getRight();
                    if (triggeredBlockResets && blockEntity instanceof Resetable) {
                        Resetable resetable = (Resetable)blockEntity;
                        resetable.reset();
                        break;
                    }
                    if (triggeredBlockResets || !(blockEntity instanceof Triggerable)) break;
                    Triggerable triggerable = (Triggerable)blockEntity;
                    triggerable.trigger();
                    break;
                }
            }
            if ((usedBlock = dialogueAnswer.results().usedBlock()) != null) {
                for (MutablePair<String, class_2338> entry : dialogueUsedBlocks) {
                    if (!((String)entry.getLeft()).equals(usedBlock)) continue;
                    class_3965 blockHitResult = new class_3965(serverPlayerEntity.method_19538(), class_2350.field_11036, (class_2338)entry.getRight(), false);
                    class_1268 hand = serverPlayerEntity.method_6058();
                    class_1799 itemStack = serverPlayerEntity.method_5998(hand);
                    serverPlayerEntity.field_13974.method_14262(serverPlayerEntity, world, itemStack, hand, blockHitResult);
                }
            }
        }
    }
}

