/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.scriptblocks.network.packet;

import com.github.theredbrain.scriptblocks.ScriptBlocks;
import com.github.theredbrain.scriptblocks.block.entity.LocationControlBlockEntity;
import com.github.theredbrain.scriptblocks.data.Location;
import com.github.theredbrain.scriptblocks.network.packet.SetManualResetLocationControlBlockPacket;
import com.github.theredbrain.scriptblocks.registry.CustomDynamicRegistries;
import com.github.theredbrain.scriptblocks.util.LocationUtils;
import com.github.theredbrain.scriptblocks.world.DimensionsManager;
import java.util.Optional;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class SetManualResetLocationControlBlockPacketReceiver
implements ServerPlayNetworking.PlayPayloadHandler<SetManualResetLocationControlBlockPacket> {
    public void receive(SetManualResetLocationControlBlockPacket payload, ServerPlayNetworking.Context context) {
        class_3222 serverPlayerEntity = context.player();
        String targetDimensionOwnerName = payload.targetDimensionOwnerName();
        String targetLocation = payload.targetLocation();
        boolean manualReset = payload.manualReset();
        MinecraftServer server = context.server();
        class_3218 targetWorld = null;
        Location location = null;
        Optional optionalLocationReference = serverPlayerEntity.method_37908().method_30349().method_30530(CustomDynamicRegistries.LOCATION_REGISTRY_KEY).method_55841(class_2960.method_12829((String)targetLocation));
        if (optionalLocationReference.isPresent()) {
            location = (Location)((class_6880.class_6883)optionalLocationReference.get()).comp_349();
        }
        class_3222 targetDimensionOwner = server.method_3760().method_14566(targetDimensionOwnerName);
        class_5250 message = class_2561.method_43473();
        if (location != null) {
            if (location.isPublic()) {
                if (ScriptBlocks.SERVER_CONFIG.enable_public_locations_dimension) {
                    class_5321 dimensionregistryKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)DimensionsManager.PUBLIC_LOCATIONS_DIMENSION_IDENTIFIER);
                    targetWorld = server.method_3847(dimensionregistryKey);
                    if (targetWorld == null) {
                        DimensionsManager.addAndSavePublicDimension(DimensionsManager.PUBLIC_LOCATIONS_DIMENSION_IDENTIFIER, server);
                        dimensionregistryKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)DimensionsManager.PUBLIC_LOCATIONS_DIMENSION_IDENTIFIER);
                        targetWorld = server.method_3847(dimensionregistryKey);
                    }
                } else {
                    targetWorld = server.method_30002();
                }
            } else if (targetDimensionOwner != null) {
                if (targetDimensionOwner.method_5667() == serverPlayerEntity.method_5667()) {
                    class_2960 targetDimensionId = ScriptBlocks.identifier(targetDimensionOwner.method_5845());
                    class_5321 dimensionregistryKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)targetDimensionId);
                    targetWorld = server.method_3847(dimensionregistryKey);
                    if (targetWorld == null) {
                        DimensionsManager.addAndSaveDynamicDimension(targetDimensionId, server);
                        dimensionregistryKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)targetDimensionId);
                        targetWorld = server.method_3847(dimensionregistryKey);
                    }
                } else {
                    message = class_2561.method_43471((String)"hud.message.location_reset.player_location_not_owned");
                }
            }
            if (targetWorld != null) {
                class_2338 blockPos = LocationUtils.getControlBlockPosForLocation(location);
                class_2586 blockEntity = targetWorld.method_8321(blockPos);
                class_2680 blockState = targetWorld.method_8320(blockPos);
                if (blockEntity instanceof LocationControlBlockEntity) {
                    LocationControlBlockEntity locationControlBlockEntity = (LocationControlBlockEntity)blockEntity;
                    locationControlBlockEntity.setManualReset(manualReset);
                    locationControlBlockEntity.method_5431();
                    targetWorld.method_8413(blockPos, blockState, blockState, 3);
                    if (ScriptBlocks.SERVER_CONFIG.confirm_successful_location_reset) {
                        message = class_2561.method_43471((String)"hud.message.location_reset.success");
                    }
                }
            } else {
                message = class_2561.method_43471((String)"hud.message.location_reset.target_world_not_found");
            }
        } else {
            message = class_2561.method_43471((String)"hud.message.location_reset.location_not_found");
        }
        serverPlayerEntity.method_7346();
        if (!message.equals((Object)class_2561.method_43473())) {
            serverPlayerEntity.method_43496((class_2561)message);
        }
    }
}

