/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.scriptblocks.network.packet;

import com.github.theredbrain.scriptblocks.ScriptBlocks;
import com.github.theredbrain.scriptblocks.block.ProvidesData;
import com.github.theredbrain.scriptblocks.block.entity.EntranceDelegationBlockEntity;
import com.github.theredbrain.scriptblocks.block.entity.LocationControlBlockEntity;
import com.github.theredbrain.scriptblocks.block.entity.TeleporterBlockEntity;
import com.github.theredbrain.scriptblocks.data.CommonDataStructures;
import com.github.theredbrain.scriptblocks.data.Location;
import com.github.theredbrain.scriptblocks.entity.player.DuckPlayerEntityMixin;
import com.github.theredbrain.scriptblocks.network.packet.TeleportFromTeleporterBlockPacket;
import com.github.theredbrain.scriptblocks.registry.CustomDynamicRegistries;
import com.github.theredbrain.scriptblocks.registry.StatusEffectsRegistry;
import com.github.theredbrain.scriptblocks.util.DebuggingHelper;
import com.github.theredbrain.scriptblocks.util.LocationUtils;
import com.github.theredbrain.scriptblocks.world.DimensionsManager;
import java.util.EnumSet;
import java.util.Optional;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_268;
import net.minecraft.class_2709;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.MutablePair;

public class TeleportFromTeleporterBlockPacketReceiver
implements ServerPlayNetworking.PlayPayloadHandler<TeleportFromTeleporterBlockPacket> {
    public void receive(TeleportFromTeleporterBlockPacket payload, ServerPlayNetworking.Context context) {
        class_3222 serverPlayerEntity = context.player();
        class_2338 teleportBlockPosition = payload.teleportBlockPosition();
        String accessPositionDimension = payload.accessPositionDimension();
        class_2338 accessPositionOffset = payload.accessPositionOffset();
        boolean setAccessPosition = payload.setAccessPosition();
        boolean teleportTeam = payload.teleportTeam();
        TeleporterBlockEntity.TeleportationMode teleportationMode = TeleporterBlockEntity.TeleportationMode.byName(payload.teleportationMode()).orElse(TeleporterBlockEntity.TeleportationMode.DIRECT);
        class_2338 directTeleportPositionOffset = payload.directTeleportPositionOffset();
        double directTeleportOrientationYaw = payload.directTeleportOrientationYaw();
        double directTeleportOrientationPitch = payload.directTeleportOrientationPitch();
        TeleporterBlockEntity.SpawnPointType spawnPointType = TeleporterBlockEntity.SpawnPointType.byName(payload.spawnPointType()).orElse(TeleporterBlockEntity.SpawnPointType.WORLD_SPAWN);
        String targetDimensionOwnerName = payload.targetDimensionOwnerName();
        String targetLocation = payload.targetLocation();
        String targetLocationEntrance = payload.targetLocationEntrance();
        String statusEffectsToDecrementLevelOnTeleport = payload.statusEffectsToDecrementLevelOnTeleport();
        String dataId = payload.dataId();
        String data = payload.data();
        class_3218 serverWorld = serverPlayerEntity.method_51469();
        MinecraftServer server = serverPlayerEntity.field_13995;
        class_3218 targetWorld = null;
        class_2338 targetPos = null;
        double targetYaw = 0.0;
        double targetPitch = 0.0;
        boolean locationWasGeneratedByOwner = true;
        boolean playerHadKeyItem = true;
        boolean locationWasReset = false;
        boolean targetLocationIsPublic = false;
        if (teleportationMode == TeleporterBlockEntity.TeleportationMode.DIRECT) {
            targetWorld = serverWorld;
            targetPos = new class_2338(teleportBlockPosition.method_10263() + directTeleportPositionOffset.method_10263(), teleportBlockPosition.method_10264() + directTeleportPositionOffset.method_10264(), teleportBlockPosition.method_10260() + directTeleportPositionOffset.method_10260());
            targetYaw = directTeleportOrientationYaw;
            targetPitch = directTeleportOrientationPitch;
            class_2586 class_25862 = targetWorld.method_8321(targetPos);
            if (class_25862 instanceof EntranceDelegationBlockEntity) {
                EntranceDelegationBlockEntity entranceDelegationBlockEntity = (EntranceDelegationBlockEntity)class_25862;
                MutablePair<class_2338, MutablePair<Double, Double>> entrance = entranceDelegationBlockEntity.getTargetEntrance(serverWorld);
                targetPos = (class_2338)entrance.getLeft();
                targetYaw = (Double)((MutablePair)entrance.getRight()).getLeft();
                targetPitch = (Double)((MutablePair)entrance.getRight()).getRight();
            }
        } else if (teleportationMode == TeleporterBlockEntity.TeleportationMode.SPAWN_POINTS) {
            MutablePair<String, class_2338> location_access_pos = ((DuckPlayerEntityMixin)serverPlayerEntity).scriptblocks$getLocationAccessPosition();
            if (spawnPointType == TeleporterBlockEntity.SpawnPointType.LOCATION_ACCESS_POSITION && location_access_pos != null) {
                targetWorld = server.method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)((String)location_access_pos.getLeft()))));
                targetPos = (class_2338)location_access_pos.getRight();
                if (targetWorld != null && targetPos != null) {
                    ((DuckPlayerEntityMixin)serverPlayerEntity).scriptblocks$setLocationAccessPosition(null);
                }
            } else if (spawnPointType == TeleporterBlockEntity.SpawnPointType.PLAYER_SPAWN) {
                targetWorld = server.method_3847(serverPlayerEntity.method_26281());
                targetPos = serverPlayerEntity.method_26280();
                targetYaw = serverPlayerEntity.method_30631();
            } else {
                targetWorld = server.method_30002();
                targetPos = server.method_30002().method_43126();
                targetYaw = server.method_30002().method_43127();
            }
        } else if (teleportationMode == TeleporterBlockEntity.TeleportationMode.LOCATIONS || teleportationMode == TeleporterBlockEntity.TeleportationMode.LOCATION) {
            Location location = null;
            Optional optionalLocationReference = serverPlayerEntity.method_37908().method_30349().method_30530(CustomDynamicRegistries.LOCATION_REGISTRY_KEY).method_55841(class_2960.method_12829((String)targetLocation));
            if (optionalLocationReference.isPresent()) {
                location = (Location)((class_6880.class_6883)optionalLocationReference.get()).comp_349();
            }
            class_3222 targetDimensionOwner = server.method_3760().method_14566(targetDimensionOwnerName);
            if (location != null) {
                class_2960 targetDimensionId;
                class_5321 dimensionregistryKey;
                if (location.isPublic()) {
                    if (ScriptBlocks.SERVER_CONFIG.enable_public_locations_dimension) {
                        class_5321 dimensionregistryKey2 = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)DimensionsManager.PUBLIC_LOCATIONS_DIMENSION_IDENTIFIER);
                        targetWorld = server.method_3847(dimensionregistryKey2);
                        if (targetWorld == null) {
                            DimensionsManager.addAndSavePublicDimension(DimensionsManager.PUBLIC_LOCATIONS_DIMENSION_IDENTIFIER, server);
                            dimensionregistryKey2 = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)DimensionsManager.PUBLIC_LOCATIONS_DIMENSION_IDENTIFIER);
                            targetWorld = server.method_3847(dimensionregistryKey2);
                        }
                    } else {
                        targetWorld = server.method_30002();
                    }
                    targetLocationIsPublic = true;
                } else if (targetDimensionOwner != null && (targetWorld = server.method_3847(dimensionregistryKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)(targetDimensionId = ScriptBlocks.identifier(targetDimensionOwner.method_5845()))))) == null) {
                    if (targetDimensionOwner.method_5667() == serverPlayerEntity.method_5667()) {
                        DimensionsManager.addAndSaveDynamicDimension(targetDimensionId, server);
                        dimensionregistryKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)targetDimensionId);
                        targetWorld = server.method_3847(dimensionregistryKey);
                    } else {
                        locationWasGeneratedByOwner = false;
                    }
                }
                if (targetWorld != null) {
                    LocationControlBlockEntity locationControlBlock;
                    class_2338 blockPos = LocationUtils.getControlBlockPosForLocation(location);
                    class_2586 blockEntity = targetWorld.method_8321(blockPos);
                    boolean initialise = false;
                    if (DebuggingHelper.isTeleporterLoggingEnabled()) {
                        DebuggingHelper.sendDebuggingMessage("targetLocation: " + targetLocation, (class_1657)serverPlayerEntity);
                        DebuggingHelper.sendDebuggingMessage("targetWorld: " + targetWorld.method_27983().toString(), (class_1657)serverPlayerEntity);
                        DebuggingHelper.sendDebuggingMessage("location: " + String.valueOf(location), (class_1657)serverPlayerEntity);
                        DebuggingHelper.sendDebuggingMessage("location.controlBlockPos: " + String.valueOf(LocationUtils.getControlBlockPosForLocation(location)), (class_1657)serverPlayerEntity);
                        DebuggingHelper.sendDebuggingMessage("block at controlBlockPos: " + targetWorld.method_8320(blockPos).method_26204().method_9539(), (class_1657)serverPlayerEntity);
                    }
                    if (!(blockEntity instanceof LocationControlBlockEntity)) {
                        String forceLoadAddCommand = "execute in " + String.valueOf(targetWorld.method_27983().method_29177()) + " run forceload add " + (blockPos.method_10263() - 16) + " " + (blockPos.method_10260() - 16) + " " + (blockPos.method_10263() + 31) + " " + (blockPos.method_10260() + 31);
                        server.method_3734().method_44252(server.method_3739(), forceLoadAddCommand);
                        String placeStructureCommand = "execute in " + String.valueOf(targetWorld.method_27983().method_29177()) + " run place structure " + location.structureIdentifier() + " " + blockPos.method_10263() + " " + blockPos.method_10264() + " " + blockPos.method_10260();
                        server.method_3734().method_44252(server.method_3739(), placeStructureCommand);
                        String forceLoadRemoveAllCommand = "execute in " + String.valueOf(targetWorld.method_27983().method_29177()) + " run forceload remove " + (blockPos.method_10263() - 16) + " " + (blockPos.method_10260() - 16) + " " + (blockPos.method_10263() + 31) + " " + (blockPos.method_10260() + 31);
                        server.method_3734().method_44252(server.method_3739(), forceLoadRemoveAllCommand);
                        blockEntity = targetWorld.method_8321(blockPos);
                        initialise = true;
                    }
                    if (blockEntity instanceof LocationControlBlockEntity && ((locationControlBlock = (LocationControlBlockEntity)blockEntity).shouldReset() || initialise)) {
                        class_2586 blockEntity1;
                        int resetAreaMinX = blockPos.method_10263() + locationControlBlock.getResetAreaMinX();
                        int resetAreaMinZ = blockPos.method_10260() + locationControlBlock.getResetAreaMinZ();
                        int resetAreaMaxX = blockPos.method_10263() + locationControlBlock.getResetAreaMaxX();
                        int resetAreaMaxZ = blockPos.method_10260() + locationControlBlock.getResetAreaMaxZ();
                        String forceLoadAddCommand = "execute in " + String.valueOf(targetWorld.method_27983().method_29177()) + " run forceload add " + resetAreaMinX + " " + resetAreaMinZ + " " + resetAreaMaxX + " " + resetAreaMaxZ;
                        server.method_3734().method_44252(server.method_3739(), forceLoadAddCommand);
                        class_2338 dataBlockPos = locationControlBlock.getDataProvidingBlockPosOffset();
                        if (dataBlockPos != class_2338.field_10980 && (blockEntity1 = targetWorld.method_8321(locationControlBlock.method_11016().method_10069(dataBlockPos.method_10263(), dataBlockPos.method_10264(), dataBlockPos.method_10260()))) instanceof ProvidesData) {
                            ProvidesData providesDataBlockEntity = (ProvidesData)blockEntity1;
                            providesDataBlockEntity.reset();
                            if (!dataId.isEmpty()) {
                                providesDataBlockEntity.setData(dataId, data);
                            }
                        }
                        locationControlBlock.trigger();
                        String forceLoadRemoveAllCommand = "execute in " + String.valueOf(targetWorld.method_27983().method_29177()) + " run forceload remove " + resetAreaMinX + " " + resetAreaMinZ + " " + resetAreaMaxX + " " + resetAreaMaxZ;
                        server.method_3734().method_44252(server.method_3739(), forceLoadRemoveAllCommand);
                        locationWasReset = true;
                    }
                    if (blockEntity instanceof LocationControlBlockEntity) {
                        locationControlBlock = (LocationControlBlockEntity)blockEntity;
                        MutablePair<class_2338, MutablePair<Double, Double>> entrance = locationControlBlock.getTargetEntrance(targetWorld, targetLocationEntrance);
                        targetPos = (class_2338)entrance.getLeft();
                        targetYaw = (Double)((MutablePair)entrance.getRight()).getLeft();
                        targetPitch = (Double)((MutablePair)entrance.getRight()).getRight();
                        for (CommonDataStructures.ItemCost itemCost : LocationUtils.getKeyForEntrance(location, targetLocationEntrance)) {
                            class_1799 keyStack = itemCost.itemStack();
                            int keyCount = keyStack.method_7947();
                            class_1661 playerInventory = serverPlayerEntity.method_31548();
                            for (int i = 0; i < playerInventory.method_5439(); ++i) {
                                class_1799 currentItemStack = playerInventory.method_5438(i);
                                if (!class_1799.method_31577((class_1799)keyStack, (class_1799)currentItemStack)) continue;
                                class_1799 currentItemStackCopy = currentItemStack.method_7972();
                                int currentItemStackCount = currentItemStackCopy.method_7947();
                                if (currentItemStackCount >= keyCount) {
                                    currentItemStackCopy.method_7939(currentItemStackCount - keyCount);
                                    if (itemCost.consumeStack()) {
                                        playerInventory.method_5447(i, currentItemStackCopy);
                                    }
                                    keyCount = 0;
                                    break;
                                }
                                if (itemCost.consumeStack()) {
                                    playerInventory.method_5447(i, class_1799.field_8037);
                                }
                                keyCount -= currentItemStackCount;
                            }
                            if (keyCount <= 0) continue;
                            playerHadKeyItem = false;
                            break;
                        }
                        if (setAccessPosition && class_2960.method_12829((String)accessPositionDimension) != null) {
                            ((DuckPlayerEntityMixin)serverPlayerEntity).scriptblocks$setLocationAccessPosition((MutablePair<String, class_2338>)new MutablePair((Object)accessPositionDimension, (Object)teleportBlockPosition.method_10069(accessPositionOffset.method_10263(), accessPositionOffset.method_10264(), accessPositionOffset.method_10260())));
                        }
                    }
                }
            }
        }
        if (targetWorld != null && targetPos != null && playerHadKeyItem) {
            class_268 team;
            class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41208, (class_2960)class_2960.method_60654((String)statusEffectsToDecrementLevelOnTeleport));
            serverPlayerEntity.field_6017 = 0.0f;
            serverPlayerEntity.method_48105(targetWorld, (double)targetPos.method_10263() + 0.5, (double)targetPos.method_10264() + 0.01, (double)targetPos.method_10260() + 0.5, EnumSet.noneOf(class_2709.class), (float)targetYaw, (float)targetPitch);
            if (DebuggingHelper.isTeleporterLoggingEnabled()) {
                DebuggingHelper.sendDebuggingMessage("Teleport to world: " + String.valueOf(targetWorld.method_27983().method_29177()) + " at position: " + ((double)targetPos.method_10263() + 0.5) + ", " + ((double)targetPos.method_10264() + 0.01) + ", " + ((double)targetPos.method_10260() + 0.5) + ", with yaw: " + targetYaw + " and pitch: " + targetPitch, (class_1657)serverPlayerEntity);
                if (!targetLocationIsPublic) {
                    DebuggingHelper.sendDebuggingMessage("World owned by: " + targetDimensionOwnerName, (class_1657)serverPlayerEntity);
                }
            }
            serverPlayerEntity.method_7346();
            for (class_1293 statusEffectInstance : serverPlayerEntity.method_6026().stream().toList()) {
                boolean isPortalResistanceEffect;
                class_6880 statusEffectRegistryEntry = statusEffectInstance.method_5579();
                boolean bl = isPortalResistanceEffect = statusEffectRegistryEntry.comp_349() == StatusEffectsRegistry.PORTAL_RESISTANCE_EFFECT;
                if (!isPortalResistanceEffect && !statusEffectRegistryEntry.method_40220(tag)) continue;
                int oldAmplifier = statusEffectInstance.method_5578();
                if (oldAmplifier <= 0 || isPortalResistanceEffect) {
                    serverPlayerEntity.method_6016(statusEffectRegistryEntry);
                    continue;
                }
                class_1293 newStatusEffectInstance = new class_1293(statusEffectRegistryEntry, statusEffectInstance.method_5584(), statusEffectInstance.method_5578() - 1, statusEffectInstance.method_5591(), statusEffectInstance.method_5581(), statusEffectInstance.method_5592());
                serverPlayerEntity.method_6016(statusEffectRegistryEntry);
                serverPlayerEntity.method_6092(newStatusEffectInstance);
            }
            if (teleportTeam && (team = serverPlayerEntity.method_5781()) != null) {
                for (String playerString : team.method_1204()) {
                    class_3222 teamServerPlayerEntity = server.method_3760().method_14566(playerString);
                    if (teamServerPlayerEntity == null || teamServerPlayerEntity == serverPlayerEntity) continue;
                    teamServerPlayerEntity.field_6017 = 0.0f;
                    teamServerPlayerEntity.method_48105(targetWorld, (double)targetPos.method_10263() + 0.5, (double)targetPos.method_10264() + 0.01, (double)targetPos.method_10260() + 0.5, EnumSet.noneOf(class_2709.class), (float)targetYaw, (float)targetPitch);
                    if (DebuggingHelper.isTeleporterLoggingEnabled()) {
                        DebuggingHelper.sendDebuggingMessage("Teleport to world: " + String.valueOf(targetWorld.method_27983().method_29177()) + " at position: " + ((double)targetPos.method_10263() + 0.5) + ", " + ((double)targetPos.method_10264() + 0.01) + ", " + ((double)targetPos.method_10260() + 0.5) + ", with yaw: " + targetYaw + " and pitch: " + targetPitch, (class_1657)teamServerPlayerEntity);
                        if (!targetLocationIsPublic) {
                            DebuggingHelper.sendDebuggingMessage("World owned by: " + targetDimensionOwnerName, (class_1657)teamServerPlayerEntity);
                        }
                    }
                    serverPlayerEntity.method_7346();
                    for (class_1293 statusEffectInstance : teamServerPlayerEntity.method_6026().stream().toList()) {
                        boolean isPortalResistanceEffect;
                        class_6880 statusEffectRegistryEntry = statusEffectInstance.method_5579();
                        boolean bl = isPortalResistanceEffect = statusEffectRegistryEntry.comp_349() == StatusEffectsRegistry.PORTAL_RESISTANCE_EFFECT;
                        if (!isPortalResistanceEffect && !statusEffectRegistryEntry.method_40220(tag)) continue;
                        int oldAmplifier = statusEffectInstance.method_5578();
                        if (oldAmplifier <= 0 || isPortalResistanceEffect) {
                            teamServerPlayerEntity.method_6016(statusEffectRegistryEntry);
                            continue;
                        }
                        class_1293 newStatusEffectInstance = new class_1293(statusEffectRegistryEntry, statusEffectInstance.method_5584(), statusEffectInstance.method_5578() - 1, statusEffectInstance.method_5591(), statusEffectInstance.method_5581(), statusEffectInstance.method_5592());
                        teamServerPlayerEntity.method_6016(statusEffectRegistryEntry);
                        teamServerPlayerEntity.method_6092(newStatusEffectInstance);
                    }
                }
            }
        } else {
            if (DebuggingHelper.isTeleporterLoggingEnabled()) {
                DebuggingHelper.sendDebuggingMessage("Teleport failed", (class_1657)serverPlayerEntity);
                if (targetWorld == null) {
                    DebuggingHelper.sendDebuggingMessage("targetWorld == null", (class_1657)serverPlayerEntity);
                }
                if (targetPos == null) {
                    DebuggingHelper.sendDebuggingMessage("targetPos == null", (class_1657)serverPlayerEntity);
                }
            }
            if (locationWasReset) {
                serverPlayerEntity.method_43496((class_2561)class_2561.method_43471((String)"gui.teleporter_block.location_was_reset"));
            } else if (!playerHadKeyItem) {
                serverPlayerEntity.method_43496((class_2561)class_2561.method_43471((String)"gui.teleporter_block.key_item_required"));
            } else if (!locationWasGeneratedByOwner) {
                serverPlayerEntity.method_43496((class_2561)class_2561.method_43471((String)"gui.teleporter_block.location_not_visited_by_owner"));
            }
        }
    }
}

