/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.scriptblocks.network.packet;

import com.github.theredbrain.scriptblocks.block.entity.TriggeredSpawnerBlockEntity;
import com.github.theredbrain.scriptblocks.block.entity.TriggeredVillagerSpawnerBlockEntity;
import com.github.theredbrain.scriptblocks.network.packet.UpdateTriggeredVillagerSpawnerBlockPacket;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3850;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.apache.commons.lang3.tuple.MutablePair;

public class UpdateTriggeredVillagerSpawnerBlockPacketReceiver
implements ServerPlayNetworking.PlayPayloadHandler<UpdateTriggeredVillagerSpawnerBlockPacket> {
    public void receive(UpdateTriggeredVillagerSpawnerBlockPacket payload, ServerPlayNetworking.Context context) {
        class_3222 serverPlayerEntity = context.player();
        if (!serverPlayerEntity.method_7338()) {
            return;
        }
        class_2338 triggeredSpawnerBlockPosition = payload.triggeredSpawnerBlockPosition();
        class_2338 entitySpawnPositionOffset = payload.entitySpawnPositionOffset();
        double entitySpawnOrientationPitch = payload.entitySpawnOrientationPitch();
        double entitySpawnOrientationYaw = payload.entitySpawnOrientationYaw();
        TriggeredSpawnerBlockEntity.SpawningMode spawningMode = TriggeredSpawnerBlockEntity.SpawningMode.byName(payload.spawningMode()).orElse(TriggeredSpawnerBlockEntity.SpawningMode.BOUND);
        String entityTypeId = payload.entityTypeId();
        class_3850 villagerData = payload.villagerData();
        List<MutablePair<class_2960, class_1322>> entityAttributeModifiersList = payload.entityAttributeModifiersList();
        Multimap entityAttributeModifiers = Multimaps.newMultimap((Map)Maps.newLinkedHashMap(), ArrayList::new);
        for (MutablePair<class_2960, class_1322> entityAttributeModifiersListEntry : entityAttributeModifiersList) {
            Optional optional = class_7923.field_41190.method_55841((class_2960)entityAttributeModifiersListEntry.getLeft());
            optional.ifPresent(entityAttribute -> entityAttributeModifiers.put(entityAttribute, (Object)((class_1322)entityAttributeModifiersListEntry.getRight())));
        }
        class_2338 useRelayBlockPositionOffset = payload.useRelayBlockPositionOffset();
        class_2338 triggeredBlockPositionOffset = payload.triggeredBlockPositionOffset();
        boolean triggeredBlockResets = payload.triggeredBlockResets();
        class_1937 world = serverPlayerEntity.method_37908();
        boolean updateSuccessful = true;
        class_2586 blockEntity = world.method_8321(triggeredSpawnerBlockPosition);
        class_2680 blockState = world.method_8320(triggeredSpawnerBlockPosition);
        if (blockEntity instanceof TriggeredVillagerSpawnerBlockEntity) {
            TriggeredVillagerSpawnerBlockEntity triggeredVillagerSpawnerBlockEntity = (TriggeredVillagerSpawnerBlockEntity)blockEntity;
            triggeredVillagerSpawnerBlockEntity.reset();
            if (!triggeredVillagerSpawnerBlockEntity.setEntitySpawnPositionOffset(entitySpawnPositionOffset)) {
                serverPlayerEntity.method_7353((class_2561)class_2561.method_43471((String)"triggered_spawner_block.entitySpawnPositionOffset.invalid"), false);
                updateSuccessful = false;
            }
            if (!triggeredVillagerSpawnerBlockEntity.setEntitySpawnPositionPitch(entitySpawnOrientationPitch)) {
                serverPlayerEntity.method_7353((class_2561)class_2561.method_43471((String)"triggered_spawner_block.entitySpawnOrientationPitch.invalid"), false);
                updateSuccessful = false;
            }
            if (!triggeredVillagerSpawnerBlockEntity.setEntitySpawnPositionYaw(entitySpawnOrientationYaw)) {
                serverPlayerEntity.method_7353((class_2561)class_2561.method_43471((String)"triggered_spawner_block.entitySpawnOrientationYaw.invalid"), false);
                updateSuccessful = false;
            }
            if (!triggeredVillagerSpawnerBlockEntity.setSpawningMode(spawningMode)) {
                serverPlayerEntity.method_7353((class_2561)class_2561.method_43471((String)"triggered_spawner_block.spawningMode.invalid"), false);
                updateSuccessful = false;
            }
            if (!triggeredVillagerSpawnerBlockEntity.setEntityType(entityTypeId)) {
                serverPlayerEntity.method_7353((class_2561)class_2561.method_43471((String)"triggered_spawner_block.entityTypeId.invalid"), false);
                updateSuccessful = false;
            }
            triggeredVillagerSpawnerBlockEntity.setVillagerData(villagerData);
            if (!triggeredVillagerSpawnerBlockEntity.setEntityAttributeModifiers((Multimap<class_6880<class_1320>, class_1322>)entityAttributeModifiers)) {
                serverPlayerEntity.method_7353((class_2561)class_2561.method_43471((String)"triggered_spawner_block.entityAttributeModifiers.invalid"), false);
                updateSuccessful = false;
            }
            triggeredVillagerSpawnerBlockEntity.setTriggeredBlock((MutablePair<class_2338, Boolean>)new MutablePair((Object)triggeredBlockPositionOffset, (Object)triggeredBlockResets));
            triggeredVillagerSpawnerBlockEntity.setUseRelayBlockPositionOffset(useRelayBlockPositionOffset);
            if (updateSuccessful) {
                serverPlayerEntity.method_7353((class_2561)class_2561.method_43471((String)"hud.message.script_block.update_successful"), true);
            }
            triggeredVillagerSpawnerBlockEntity.method_5431();
            world.method_8413(triggeredSpawnerBlockPosition, blockState, blockState, 3);
        }
    }
}

