/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.scriptblocks.render.block.entity;

import com.github.theredbrain.scriptblocks.block.entity.TriggeredDisplayBlockEntity;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4590;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5614;
import net.minecraft.class_8113;
import net.minecraft.class_824;
import net.minecraft.class_827;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

@Environment(value=EnvType.CLIENT)
public class TriggeredDisplayBlockEntityRenderer
implements class_827<TriggeredDisplayBlockEntity> {
    private final class_327 textRenderer;
    private final class_824 blockEntityRenderDispatcher;
    protected float shadowRadius;
    protected float shadowOpacity = 1.0f;

    public TriggeredDisplayBlockEntityRenderer(class_5614.class_5615 ctx) {
        this.textRenderer = ctx.method_32143();
        this.blockEntityRenderDispatcher = ctx.method_32139();
    }

    public void render(TriggeredDisplayBlockEntity triggeredDisplayBlockEntity, float tickDelta, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light, int overlay) {
        TriggeredDisplayBlockEntity.Data object;
        TriggeredDisplayBlockEntity.RenderState renderState = triggeredDisplayBlockEntity.getRenderState();
        if (triggeredDisplayBlockEntity.getIsTriggered() && renderState != null && (object = triggeredDisplayBlockEntity.getData()) != null) {
            float lerpProgress = triggeredDisplayBlockEntity.getLerpProgress(tickDelta);
            this.shadowRadius = renderState.shadowRadius().lerp(lerpProgress);
            this.shadowOpacity = renderState.shadowStrength().lerp(lerpProgress);
            int j = renderState.brightnessOverride();
            int brightness = j != -1 ? j : light;
            matrixStack.method_22903();
            matrixStack.method_22904(triggeredDisplayBlockEntity.getDisplayOffset().field_1352, triggeredDisplayBlockEntity.getDisplayOffset().field_1351, triggeredDisplayBlockEntity.getDisplayOffset().field_1350);
            matrixStack.method_22907(this.getBillboardRotation(renderState, triggeredDisplayBlockEntity, tickDelta, new Quaternionf()));
            class_4590 affineTransformation = renderState.transformation().interpolate(lerpProgress);
            matrixStack.method_34425(affineTransformation.method_22936());
            if (triggeredDisplayBlockEntity.getDisplayMode() == TriggeredDisplayBlockEntity.DisplayMode.TEXT) {
                this.renderTextMode(triggeredDisplayBlockEntity, object, matrixStack, vertexConsumerProvider, brightness, lerpProgress);
            }
            matrixStack.method_22909();
        }
    }

    public void renderTextMode(TriggeredDisplayBlockEntity triggeredDisplayBlockEntity, TriggeredDisplayBlockEntity.Data data, class_4587 matrixStack, class_4597 vertexConsumerProvider, int brightness, float lerpProgress) {
        int j;
        float g;
        byte b = data.flags();
        boolean bl = (b & 2) != 0;
        boolean bl2 = (b & 4) != 0;
        boolean bl3 = (b & 1) != 0;
        TriggeredDisplayBlockEntity.TextAlignment textAlignment = TriggeredDisplayBlockEntity.getAlignment(b);
        byte c = (byte)data.textOpacity().lerp(lerpProgress);
        if (bl2) {
            g = class_310.method_1551().field_1690.method_19343(0.25f);
            j = (int)(g * 255.0f) << 24;
        } else {
            j = data.backgroundColor().lerp(lerpProgress);
        }
        g = 0.0f;
        Matrix4f matrix4f = matrixStack.method_23760().method_23761();
        matrix4f.rotate((float)Math.PI, 0.0f, 1.0f, 0.0f);
        matrix4f.scale(-0.025f, -0.025f, -0.025f);
        TriggeredDisplayBlockEntity.TextLines textLines = triggeredDisplayBlockEntity.splitLines(this::getLines);
        int k = 10;
        int l = textLines.width();
        int m = textLines.lines().size() * k;
        matrix4f.translate(1.0f - (float)l / 2.0f, (float)(-m), 0.0f);
        if (j != 0) {
            class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(bl ? class_1921.method_49046() : class_1921.method_49045());
            vertexConsumer.method_22918(matrix4f, -1.0f, -1.0f, 0.0f).method_39415(j).method_60803(brightness);
            vertexConsumer.method_22918(matrix4f, -1.0f, (float)m, 0.0f).method_39415(j).method_60803(brightness);
            vertexConsumer.method_22918(matrix4f, (float)l, (float)m, 0.0f).method_39415(j).method_60803(brightness);
            vertexConsumer.method_22918(matrix4f, (float)l, -1.0f, 0.0f).method_39415(j).method_60803(brightness);
        }
        for (TriggeredDisplayBlockEntity.TextLine textLine : textLines.lines()) {
            float h = switch (textAlignment) {
                case TriggeredDisplayBlockEntity.TextAlignment.LEFT -> 0.0f;
                case TriggeredDisplayBlockEntity.TextAlignment.RIGHT -> l - textLine.width();
                case TriggeredDisplayBlockEntity.TextAlignment.CENTER -> (float)l / 2.0f - (float)textLine.width() / 2.0f;
                default -> throw new MatchException(null, null);
            };
            this.textRenderer.method_22942(textLine.contents(), h, g, c << 24 | 0xFFFFFF, bl3, matrix4f, vertexConsumerProvider, bl ? class_327.class_6415.field_33994 : class_327.class_6415.field_33995, 0, brightness);
            g += (float)k;
        }
    }

    private TriggeredDisplayBlockEntity.TextLines getLines(class_2561 text, int width) {
        List list = this.textRenderer.method_1728((class_5348)text, width);
        ArrayList<TriggeredDisplayBlockEntity.TextLine> list2 = new ArrayList<TriggeredDisplayBlockEntity.TextLine>(list.size());
        int i = 0;
        for (class_5481 orderedText : list) {
            int j = this.textRenderer.method_30880(orderedText);
            i = Math.max(i, j);
            list2.add(new TriggeredDisplayBlockEntity.TextLine(orderedText, j));
        }
        return new TriggeredDisplayBlockEntity.TextLines(list2, i);
    }

    private Quaternionf getBillboardRotation(TriggeredDisplayBlockEntity.RenderState renderState, TriggeredDisplayBlockEntity entity, float yaw, Quaternionf rotation) {
        class_4184 camera = this.blockEntityRenderDispatcher.field_4344;
        return switch (renderState.billboardConstraints()) {
            case TriggeredDisplayBlockEntity.BillboardMode.FIXED -> rotation.rotationYXZ((float)(-Math.PI) / 180 * TriggeredDisplayBlockEntityRenderer.lerpYaw(entity, yaw), (float)Math.PI / 180 * TriggeredDisplayBlockEntityRenderer.lerpPitch(entity, yaw), 0.0f);
            case TriggeredDisplayBlockEntity.BillboardMode.HORIZONTAL -> rotation.rotationYXZ((float)(-Math.PI) / 180 * TriggeredDisplayBlockEntityRenderer.lerpYaw(entity, yaw), (float)Math.PI / 180 * TriggeredDisplayBlockEntityRenderer.getNegatedPitch(camera), 0.0f);
            case TriggeredDisplayBlockEntity.BillboardMode.VERTICAL -> rotation.rotationYXZ((float)(-Math.PI) / 180 * TriggeredDisplayBlockEntityRenderer.getBackwardsYaw(camera), (float)Math.PI / 180 * TriggeredDisplayBlockEntityRenderer.lerpPitch(entity, yaw), 0.0f);
            case TriggeredDisplayBlockEntity.BillboardMode.CENTER -> rotation.rotationYXZ((float)(-Math.PI) / 180 * TriggeredDisplayBlockEntityRenderer.getBackwardsYaw(camera), (float)Math.PI / 180 * TriggeredDisplayBlockEntityRenderer.getNegatedPitch(camera), 0.0f);
            default -> throw new MatchException(null, null);
        };
    }

    private static float getBackwardsYaw(class_4184 camera) {
        return camera.method_19330() - 180.0f;
    }

    private static float getNegatedPitch(class_4184 camera) {
        return -camera.method_19329();
    }

    private static <T extends class_8113> float lerpYaw(TriggeredDisplayBlockEntity entity, float delta) {
        return class_3532.method_17821((float)delta, (float)entity.getPrevDisplayYaw(), (float)entity.getDisplayYaw());
    }

    private static <T extends class_8113> float lerpPitch(TriggeredDisplayBlockEntity entity, float delta) {
        return class_3532.method_16439((float)delta, (float)entity.getPrevDisplayPitch(), (float)entity.getDisplayPitch());
    }

    public int method_33893() {
        return 96;
    }
}

