/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.scriptblocks.util;

import com.github.theredbrain.scriptblocks.data.CommonDataStructures;
import com.github.theredbrain.scriptblocks.data.Location;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class LocationUtils {
    public static class_2338 getControlBlockPosForLocation(Location location) {
        return new class_2338((class_2382)location.controlBlockPos());
    }

    @Nullable
    public static class_2960 unlockAdvancementForEntrance(Location location, String entrance) {
        Location.SideEntrance sideEntrance;
        class_2960 unlockAdvancementIdentifier = null;
        if (location.side_entrances() != null && !entrance.isEmpty() && (sideEntrance = location.side_entrances().get(entrance)) != null && !sideEntrance.availability().unlockAdvancement().isEmpty()) {
            unlockAdvancementIdentifier = class_2960.method_12829((String)sideEntrance.availability().unlockAdvancement());
        }
        if (unlockAdvancementIdentifier == null && !location.availability().unlockAdvancement().isEmpty()) {
            unlockAdvancementIdentifier = class_2960.method_12829((String)location.availability().unlockAdvancement());
        }
        return unlockAdvancementIdentifier;
    }

    @Nullable
    public static class_2960 lockAdvancementForEntrance(Location location, String entrance) {
        Location.SideEntrance sideEntrance;
        class_2960 lockAdvancementIdentifier = null;
        if (location.side_entrances() != null && !entrance.isEmpty() && (sideEntrance = location.side_entrances().get(entrance)) != null && !sideEntrance.availability().lockAdvancement().isEmpty()) {
            lockAdvancementIdentifier = class_2960.method_12829((String)sideEntrance.availability().lockAdvancement());
        }
        if (lockAdvancementIdentifier == null && !location.availability().lockAdvancement().isEmpty()) {
            lockAdvancementIdentifier = class_2960.method_12829((String)location.availability().lockAdvancement());
        }
        return lockAdvancementIdentifier;
    }

    public static boolean showLockedLocationForEntrance(Location location, String entrance) {
        Location.SideEntrance sideEntrance;
        if (entrance.isEmpty()) {
            return location.availability().showLockedLocation();
        }
        if (location.side_entrances() != null && (sideEntrance = location.side_entrances().get(entrance)) != null) {
            return sideEntrance.availability().showLockedLocation();
        }
        return false;
    }

    public static boolean showLocationOwnerForEntrance(Location location, String entrance) {
        Location.SideEntrance sideEntrance;
        if (entrance.isEmpty()) {
            return location.showLocationOwner();
        }
        if (location.side_entrances() != null && (sideEntrance = location.side_entrances().get(entrance)) != null) {
            return sideEntrance.showLocationOwner();
        }
        return false;
    }

    public static List<CommonDataStructures.ItemCost> getKeyForEntrance(Location location, String entrance) {
        Location.SideEntrance sideEntrance;
        List<Object> itemCostList = new ArrayList();
        if (entrance.isEmpty()) {
            itemCostList = location.availability().itemCosts();
        }
        if (location.side_entrances() != null && (sideEntrance = location.side_entrances().get(entrance)) != null) {
            itemCostList = sideEntrance.availability().itemCosts();
        }
        return itemCostList;
    }

    public static boolean hasEntrance(Location location, String entrance) {
        if (location.side_entrances() != null) {
            return location.side_entrances().containsKey(entrance);
        }
        return false;
    }

    public static boolean hasSideEntrances(Location location) {
        return location.side_entrances() != null;
    }

    public static String getEntranceDisplayName(Location location, String entrance) {
        Location.SideEntrance sideEntrance;
        String entranceDisplayName = "";
        if (location.side_entrances() != null && (sideEntrance = location.side_entrances().get(entrance)) != null) {
            entranceDisplayName = sideEntrance.name();
        }
        return entranceDisplayName;
    }

    public static boolean isEntranceNameShownFirst(Location location, String entrance) {
        Location.SideEntrance sideEntrance;
        boolean isEntranceNameShownFirst = true;
        if (location.side_entrances() != null && (sideEntrance = location.side_entrances().get(entrance)) != null) {
            isEntranceNameShownFirst = sideEntrance.isEntranceNameShownFirst();
        }
        return isEntranceNameShownFirst;
    }
}

