/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.scriptblocks.util;

import java.util.Arrays;

public class UUIDUtilities {
    private static final byte[] NIBBLES;

    private static long parse4Nibbles(String name, int pos) {
        char ch4;
        char ch3;
        char ch2;
        byte[] ns = NIBBLES;
        char ch1 = name.charAt(pos);
        return (ch1 | (ch2 = name.charAt(pos + 1)) | (ch3 = name.charAt(pos + 2)) | (ch4 = name.charAt(pos + 3))) > 255 ? -1L : (long)(ns[ch1] << 12 | ns[ch2] << 8 | ns[ch3] << 4 | ns[ch4]);
    }

    public static boolean isStringValidUUID(String string) {
        if (string.length() == 36) {
            long lsb4;
            long lsb3;
            long lsb2;
            long lsb1;
            long msb4;
            long msb3;
            long msb2;
            long msb1;
            char ch1 = string.charAt(8);
            char ch2 = string.charAt(13);
            char ch3 = string.charAt(18);
            char ch4 = string.charAt(23);
            if (ch1 == '-' && ch2 == '-' && ch3 == '-' && ch4 == '-' && ((msb1 = UUIDUtilities.parse4Nibbles(string, 0)) | (msb2 = UUIDUtilities.parse4Nibbles(string, 4)) | (msb3 = UUIDUtilities.parse4Nibbles(string, 9)) | (msb4 = UUIDUtilities.parse4Nibbles(string, 14)) | (lsb1 = UUIDUtilities.parse4Nibbles(string, 19)) | (lsb2 = UUIDUtilities.parse4Nibbles(string, 24)) | (lsb3 = UUIDUtilities.parse4Nibbles(string, 28)) | (lsb4 = UUIDUtilities.parse4Nibbles(string, 32))) >= 0L) {
                return true;
            }
        }
        return false;
    }

    static {
        byte[] ns = new byte[256];
        Arrays.fill(ns, (byte)-1);
        ns[48] = 0;
        ns[49] = 1;
        ns[50] = 2;
        ns[51] = 3;
        ns[52] = 4;
        ns[53] = 5;
        ns[54] = 6;
        ns[55] = 7;
        ns[56] = 8;
        ns[57] = 9;
        ns[65] = 10;
        ns[66] = 11;
        ns[67] = 12;
        ns[68] = 13;
        ns[69] = 14;
        ns[70] = 15;
        ns[97] = 10;
        ns[98] = 11;
        ns[99] = 12;
        ns[100] = 13;
        ns[101] = 14;
        ns[102] = 15;
        NIBBLES = ns;
    }
}

