/*
 * Decompiled with CFR 0.152.
 */
package org.misaka;

import com.mojang.logging.LogUtils;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import org.misaka.api.common.network.NetworkSystem;
import org.misaka.api.common.registries.MisakaNetworkRegistries;
import org.misaka.internal.common.network.PacketTypes;
import org.slf4j.Logger;

@Mod(value="misaka_network")
public final class MisakaNetwork {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    public static final String MOD_ID = "misaka_network";

    public MisakaNetwork(IEventBus modEventBus) {
        PacketTypes.PACKET_TYPES.register(modEventBus);
        modEventBus.addListener(MisakaNetwork::onNewRegistry);
        modEventBus.addListener(MisakaNetwork::onCommonSetup);
    }

    public static ResourceLocation location(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    private static void onNewRegistry(NewRegistryEvent event) {
        event.register(MisakaNetworkRegistries.PACKET_TYPES);
    }

    private static void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(NetworkSystem::progressRegistry);
    }

    public static void shutdownExecutorService() {
        executorService.shutdown();
        try {
            if (!executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                LOGGER.warn("ExecutorService did not terminate in 5 seconds. Forcing shutdown.");
                executorService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("Interrupted while waiting for ExecutorService to terminate. Forcing shutdown.");
            executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

