/*
 * Decompiled with CFR 0.152.
 */
package org.misaka;

import com.mojang.logging.LogUtils;
import net.minecraft.network.Connection;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.lifecycle.ClientStoppingEvent;
import org.jetbrains.annotations.Nullable;
import org.misaka.MisakaNetwork;
import org.misaka.api.client.network.future.FutureManagerClient;
import org.misaka.api.common.network.NetworkManager;
import org.misaka.api.common.network.packet.C2SPacket;
import org.misaka.api.common.network.packet.Packet;
import org.slf4j.Logger;

@EventBusSubscriber(modid="misaka_network", value={Dist.CLIENT})
public final class MisakaNetworkClient {
    @Nullable
    public static Connection connection;
    public static final NetworkManager NETWORK_MANAGER;
    public static final FutureManagerClient FUTURE_MANAGER;
    private static final Logger LOGGER;

    public static void sendPacket(net.minecraft.network.protocol.Packet<?> packet) {
        if (connection != null) {
            connection.send(packet);
        }
    }

    @SubscribeEvent
    public static void onClientStopping(ClientStoppingEvent event) {
        LOGGER.info("Client is stopping. Shutting down MisakaNetwork ExecutorService.");
        MisakaNetwork.shutdownExecutorService();
    }

    public static <P extends Packet<ServerGamePacketListenerImpl, P>> void sendPacket(P packet) {
        MisakaNetworkClient.sendPacket(new C2SPacket(packet));
    }

    private MisakaNetworkClient() {
    }

    static {
        NETWORK_MANAGER = new NetworkManager();
        FUTURE_MANAGER = new FutureManagerClient();
        LOGGER = LogUtils.getLogger();
        NETWORK_MANAGER.registerPacketListener(FUTURE_MANAGER);
    }
}

