/*
 * Decompiled with CFR 0.152.
 */
package org.misaka;

import com.mojang.logging.LogUtils;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.Connection;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import org.misaka.MisakaNetwork;
import org.misaka.api.common.network.NetworkManager;
import org.misaka.api.common.network.packet.Packet;
import org.misaka.api.common.network.packet.S2CPacket;
import org.misaka.api.server.network.future.FutureManagerServer;
import org.slf4j.Logger;

@EventBusSubscriber(modid="misaka_network", value={Dist.DEDICATED_SERVER})
public final class MisakaNetworkServer {
    public static final NetworkManager NETWORK_MANAGER = new NetworkManager();
    public static final FutureManagerServer FUTURE_MANAGER = new FutureManagerServer();
    private static final Logger LOGGER = LogUtils.getLogger();

    public static <P extends Packet<ClientPacketListener, P>> void sendPacket(ServerPlayer player, P packet) {
        player.connection.send((net.minecraft.network.protocol.Packet)new S2CPacket(packet));
    }

    public static <P extends Packet<ClientPacketListener, P>> void sendPacket(Connection connection, P packet) {
        connection.send((net.minecraft.network.protocol.Packet)new S2CPacket(packet));
    }

    public static <P extends Packet<ClientPacketListener, P>> void sendPacket(ServerGamePacketListenerImpl listener, P packet) {
        listener.send((net.minecraft.network.protocol.Packet)new S2CPacket(packet));
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        LOGGER.info("Dedicated server is stopping. Shutting down MisakaNetwork ExecutorService.");
        MisakaNetwork.shutdownExecutorService();
    }

    private MisakaNetworkServer() {
    }

    static {
        NETWORK_MANAGER.registerPacketListener(FUTURE_MANAGER);
    }
}

