/*
 * Decompiled with CFR 0.152.
 */
package org.misaka.api.client.network.future;

import com.mojang.logging.LogUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.ClientboundPacketListener;
import net.minecraft.network.ServerboundPacketListener;
import org.misaka.MisakaNetworkClient;
import org.misaka.api.common.network.NetworkSystem;
import org.misaka.api.common.network.annotation.SubscribePacket;
import org.misaka.api.common.network.future.AbstractFutureManager;
import org.misaka.api.common.network.future.packet.FutureRequestPacket;
import org.misaka.api.common.network.future.packet.FutureResponsePacket;
import org.misaka.api.common.network.future.packet.RequestPacket;
import org.misaka.api.common.network.future.packet.ResponsePacket;
import org.slf4j.Logger;

public final class FutureManagerClient
extends AbstractFutureManager {
    private static final Logger LOGGER = LogUtils.getLogger();

    public <RES_L extends ClientboundPacketListener, RES_P extends ResponsePacket<RES_L, RES_P>, REQ_L extends ServerboundPacketListener, REQ_P extends RequestPacket<REQ_L, REQ_P, RES_L, RES_P>> void sendRequestToServer(REQ_P requestPacket, Consumer<RES_P> callback, long timeoutMillis) {
        int futureId = this.createPendingFuture(requestPacket.getResponsePacketType(), callback, timeoutMillis);
        if (futureId == -1) {
            return;
        }
        int requestTypeId = requestPacket.getPacketType().getPacketId();
        ByteBuf buffer = Unpooled.buffer();
        requestPacket.getPacketType().codec().encode((Object)buffer, requestPacket);
        byte[] bytes = new byte[buffer.readableBytes()];
        buffer.readBytes(bytes);
        FutureRequestPacket packet = new FutureRequestPacket(futureId, requestTypeId, bytes);
        MisakaNetworkClient.sendPacket(packet);
    }

    public <RES_L extends ClientboundPacketListener, RES_P extends ResponsePacket<RES_L, RES_P>, REQ_L extends ServerboundPacketListener, REQ_P extends RequestPacket<REQ_L, REQ_P, RES_L, RES_P>> void sendRequestToServer(REQ_P requestPacket, Consumer<RES_P> callback) {
        this.sendRequestToServer(requestPacket, callback, 60000L);
    }

    @SubscribePacket
    public void handleFutureRequestFromServer(FutureRequestPacket<ClientPacketListener> futureRequestPacket) {
        this.handleRequest(futureRequestPacket, (ClientPacketListener)futureRequestPacket.getPacketListener(), response -> {
            int responseTypeId = response.getPacketType().getPacketId();
            ByteBuf responseBuffer = Unpooled.buffer();
            response.getPacketType().codec().encode((Object)responseBuffer, response);
            byte[] bytes = new byte[responseBuffer.readableBytes()];
            responseBuffer.readBytes(bytes);
            if (NetworkSystem.isDebugInfo()) {
                LOGGER.debug("Response bytes: {}", (Object)Arrays.toString(bytes));
            }
            FutureResponsePacket responsePkt = new FutureResponsePacket(futureRequestPacket.getFutureId(), responseTypeId, bytes);
            MisakaNetworkClient.sendPacket(responsePkt);
        });
    }

    @SubscribePacket
    public void handleFutureResponseFromServer(FutureResponsePacket<ClientPacketListener> responsePacket) {
        this.handleResponse(responsePacket, resPacket -> Minecraft.getInstance().execute(() -> this.executeCallback(responsePacket.getFutureId(), (ResponsePacket<?, ?>)resPacket)));
    }
}

