/*
 * Decompiled with CFR 0.152.
 */
package org.misaka.api.common.network;

import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import org.misaka.api.common.network.listener.IPacketListener;
import org.misaka.api.common.network.packet.Packet;
import org.misaka.internal.MisakaRegistryAggregator;
import org.slf4j.Logger;

public final class NetworkManager {
    private final ConcurrentHashMap<Class<? extends Packet<?, ?>>, List<IPacketListener>> typedListeners = new ConcurrentHashMap();
    private final Map<Object, List<IPacketListener>> listenersByTarget = new MapMaker().weakKeys().makeMap();
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public void registerPacketListener(Class<?> targetClass) {
        List<IPacketListener> listeners = MisakaRegistryAggregator.getStaticListenersFor(targetClass);
        if (!listeners.isEmpty()) {
            this.registerAll(targetClass, listeners);
        }
    }

    public void registerPacketListener(Object targetInstance) {
        List<Function<Object, IPacketListener>> factories = MisakaRegistryAggregator.getInstanceListenerFactoriesFor(targetInstance.getClass());
        if (factories.isEmpty()) {
            return;
        }
        List<IPacketListener> generatedListeners = factories.stream().map(factory -> (IPacketListener)factory.apply(targetInstance)).toList();
        this.registerAll(targetInstance, generatedListeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerAll(Object key, List<IPacketListener> listeners) {
        this.lock.writeLock().lock();
        try {
            if (!this.listenersByTarget.containsKey(key)) {
                this.listenersByTarget.put(key, List.copyOf(listeners));
                for (IPacketListener listener : listeners) {
                    Class type = listener.getPacketClass();
                    if (!this.typedListeners.containsKey(type)) {
                        this.typedListeners.put(type, new ArrayList());
                    }
                    this.typedListeners.get(type).add(listener);
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void unregisterPacketListener(Class<?> targetClass) {
        this.unregisterPacketListenerInternal(targetClass);
    }

    public void unregisterPacketListener(Object targetInstance) {
        this.unregisterPacketListenerInternal(targetInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterPacketListenerInternal(Object keyToRemove) {
        this.lock.writeLock().lock();
        try {
            List<IPacketListener> handlersToRemove = this.listenersByTarget.remove(keyToRemove);
            if (handlersToRemove != null) {
                for (IPacketListener handler : handlersToRemove) {
                    List<IPacketListener> typedList = this.typedListeners.get(handler.getPacketClass());
                    if (typedList == null) continue;
                    typedList.remove(handler);
                    if (!typedList.isEmpty()) continue;
                    this.typedListeners.remove(handler.getPacketClass());
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchPacket(Packet<?, ?> packet) {
        ArrayList handlers;
        this.lock.readLock().lock();
        try {
            List<IPacketListener> typedList = this.typedListeners.get(packet.getClass());
            handlers = typedList != null && !typedList.isEmpty() ? Lists.newArrayList(typedList) : null;
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (handlers != null) {
            for (IPacketListener handler : handlers) {
                try {
                    handler.handlePacket(packet);
                }
                catch (Throwable e) {
                    LOGGER.error("Exception dispatching packet {} to handler {}: {}", new Object[]{packet.getClass().getSimpleName(), handler.getClass().getName(), e.getMessage(), e});
                }
            }
        }
    }
}

