/*
 * Decompiled with CFR 0.152.
 */
package org.misaka.api.common.network;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.misaka.api.common.network.ThreadType;
import org.misaka.api.common.network.annotation.PacketTarget;
import org.misaka.api.common.network.packet.Packet;
import org.misaka.api.common.network.packet.PacketType;
import org.misaka.api.common.registries.MisakaNetworkRegistries;
import org.slf4j.Logger;

public final class NetworkSystem {
    private static final AtomicBoolean DEBUG_INFO = new AtomicBoolean(false);
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final BiMap<Class<? extends Packet<?, ?>>, PacketType<?, ?>> CLASS_TO_TYPE = HashBiMap.create();
    private static final Map<Class<? extends Packet<?, ?>>, ThreadType> THREAD_TYPE_MAP = new HashMap();

    private NetworkSystem() {
    }

    public static boolean isDebugInfo() {
        return DEBUG_INFO.get();
    }

    public static void setDebugInfo(boolean debugInfo) {
        boolean prev;
        do {
            if ((prev = DEBUG_INFO.get()) != debugInfo) continue;
            return;
        } while (!DEBUG_INFO.compareAndSet(prev, debugInfo));
    }

    public static void progressRegistry() {
        for (PacketType type : MisakaNetworkRegistries.PACKET_TYPES) {
            CLASS_TO_TYPE.put(type.packetClass(), (Object)type);
            Class clazz = type.packetClass();
            if (!clazz.isAnnotationPresent(PacketTarget.class)) continue;
            ThreadType targetType = clazz.getAnnotation(PacketTarget.class).value();
            THREAD_TYPE_MAP.put(clazz, targetType);
        }
    }

    public static <T extends PacketType<?, ?>> T getPacketTypeById(int id) {
        return (T)((PacketType)MisakaNetworkRegistries.PACKET_TYPES.byIdOrThrow(id));
    }

    public static <T extends PacketType<?, ?>> T getPacketType(Class<?> packetClass) {
        PacketType packetType = (PacketType)CLASS_TO_TYPE.get(packetClass);
        if (packetType == null) {
            if (CLASS_TO_TYPE.isEmpty()) {
                throw new IllegalStateException("Too early!!! It should be called after FMLCommonSetupEvent.");
            }
            throw new IllegalStateException("Unregistered packet class used: " + packetClass.getName());
        }
        return (T)packetType;
    }

    public static <P extends Packet<?, ?>> boolean shouldReceive(Class<P> clazz, ThreadType currentThreadType) {
        ThreadType targetType = THREAD_TYPE_MAP.get(clazz);
        return targetType == null || targetType == currentThreadType;
    }
}

