/*
 * Decompiled with CFR 0.152.
 */
package org.misaka.api.common.network.future;

import com.mojang.logging.LogUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.network.PacketListener;
import net.minecraft.network.codec.StreamCodec;
import org.misaka.MisakaNetwork;
import org.misaka.api.common.network.NetworkSystem;
import org.misaka.api.common.network.future.invoker.IFutureHandlerInvoker;
import org.misaka.api.common.network.future.packet.FuturePacket;
import org.misaka.api.common.network.future.packet.FutureRequestPacket;
import org.misaka.api.common.network.future.packet.RequestPacket;
import org.misaka.api.common.network.future.packet.ResponsePacket;
import org.misaka.api.common.network.packet.PacketType;
import org.misaka.internal.MisakaRegistryAggregator;
import org.slf4j.Logger;

public abstract class AbstractFutureManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected final Map<Integer, PendingFutureInfo> pendingFutures = new ConcurrentHashMap<Integer, PendingFutureInfo>();
    protected final Map<Integer, IFutureHandlerInvoker> requestHandlers = new ConcurrentHashMap<Integer, IFutureHandlerInvoker>();
    private final AtomicInteger nextFutureId = new AtomicInteger(0);
    protected static final long DEFAULT_TIMEOUT_MS = 60000L;

    protected AbstractFutureManager() {
        MisakaNetwork.executorService.scheduleAtFixedRate(this::cleanupTimedOutFutures, 1L, 1L, TimeUnit.SECONDS);
    }

    public void clear() {
        this.pendingFutures.clear();
        this.requestHandlers.clear();
    }

    protected int generateFutureId() {
        return this.nextFutureId.getAndIncrement();
    }

    protected <T_RESP extends ResponsePacket<?, T_RESP>> int createPendingFuture(PacketType<?, T_RESP> responsePacketType, Consumer<T_RESP> callback, long timeoutMillis) {
        int futureId = this.generateFutureId();
        int expectedResponsePacketId = responsePacketType.getPacketId();
        if (expectedResponsePacketId == -1) {
            LOGGER.error("Response packet type {} is not registered.", (Object)responsePacketType.packetClass().getName());
            return -1;
        }
        long expireTime = System.currentTimeMillis() + timeoutMillis;
        this.pendingFutures.put(futureId, new PendingFutureInfo(callback, expectedResponsePacketId, expireTime));
        return futureId;
    }

    public final void registerFutureHandler(Class<?> targetClass) {
        List<IFutureHandlerInvoker> invokers = MisakaRegistryAggregator.getStaticInvokersFor(targetClass);
        for (IFutureHandlerInvoker invoker : invokers) {
            int requestTypeId = ((PacketType)NetworkSystem.getPacketType(invoker.getRequestPacketClass())).getPacketId();
            this.requestHandlers.put(requestTypeId, invoker);
        }
    }

    public final void registerFutureHandler(Object targetInstance) {
        List<Function<Object, IFutureHandlerInvoker>> factories = MisakaRegistryAggregator.getInstanceInvokerFactoriesFor(targetInstance.getClass());
        if (factories.isEmpty()) {
            return;
        }
        for (Function<Object, IFutureHandlerInvoker> factory : factories) {
            IFutureHandlerInvoker invoker = factory.apply(targetInstance);
            int requestTypeId = ((PacketType)NetworkSystem.getPacketType(invoker.getRequestPacketClass())).getPacketId();
            this.requestHandlers.put(requestTypeId, invoker);
        }
    }

    protected <REQ_L extends PacketListener, RES_L extends PacketListener, RES_P extends ResponsePacket<RES_L, RES_P>, REQ_P extends RequestPacket<REQ_L, REQ_P, RES_L, RES_P>> void handleRequest(FutureRequestPacket<REQ_L> futureRequestPacket, REQ_L packetListener, Consumer<RES_P> responseSender) {
        int targetPacketTypeId = futureRequestPacket.getTargetPacketTypeId();
        IFutureHandlerInvoker requestHandler = this.requestHandlers.get(targetPacketTypeId);
        if (requestHandler == null) {
            LOGGER.error("No handler for request packet ID {}", (Object)targetPacketTypeId);
            return;
        }
        IFutureHandlerInvoker invoker = this.requestHandlers.get(targetPacketTypeId);
        Object packetType = NetworkSystem.getPacketTypeById(targetPacketTypeId);
        StreamCodec codec = ((PacketType)packetType).codec();
        byte[] bytes = futureRequestPacket.getBytes();
        if (NetworkSystem.isDebugInfo()) {
            LOGGER.debug(Arrays.toString(bytes));
        }
        RequestPacket instance = (RequestPacket)codec.decode((Object)Unpooled.wrappedBuffer((byte[])bytes));
        instance.setPacketListener(packetListener);
        ResponsePacket<?, ?> responsePacket = invoker.invoke(instance);
        responseSender.accept(responsePacket);
    }

    protected <L extends PacketListener, F_P extends FuturePacket<L, F_P>, RES_P extends ResponsePacket<L, RES_P>> void handleResponse(F_P responsePacket, Consumer<RES_P> callbackExecutor) {
        int targetPacketTypeId = responsePacket.getTargetPacketTypeId();
        PendingFutureInfo info = this.pendingFutures.get(responsePacket.getFutureId());
        if (info == null) {
            LOGGER.warn("Received response for unknown/timed-out futureId: {}", (Object)responsePacket.getFutureId());
            return;
        }
        if (info.expectedResponsePacketId != -1 && info.expectedResponsePacketId != targetPacketTypeId) {
            LOGGER.error("Mismatched response packet. Expected ID {}, Got ID {}", (Object)info.expectedResponsePacketId, (Object)targetPacketTypeId);
            return;
        }
        StreamCodec codec = ((PacketType)NetworkSystem.getPacketTypeById(targetPacketTypeId)).codec();
        try {
            ByteBuf buffer = Unpooled.buffer();
            byte[] bytes = responsePacket.getBytes();
            if (NetworkSystem.isDebugInfo()) {
                LOGGER.debug(Arrays.toString(bytes));
            }
            ResponsePacket resP = (ResponsePacket)codec.decode((Object)buffer.writeBytes(bytes));
            resP.setPacketListener(responsePacket.getPacketListener());
            callbackExecutor.accept(resP);
        }
        catch (Exception e) {
            LOGGER.error("Error processing response for futureId {}: {}", new Object[]{responsePacket.getFutureId(), e.getMessage(), e});
        }
    }

    protected void executeCallback(int futureId, ResponsePacket<?, ?> responsePacket) {
        PendingFutureInfo info = this.pendingFutures.remove(futureId);
        if (info != null) {
            try {
                info.callback().accept(responsePacket);
            }
            catch (Exception e) {
                LOGGER.error("Error executing callback for futureId {}: {}", new Object[]{futureId, e.getMessage(), e});
            }
        } else {
            LOGGER.warn("Response for futureId {} arrived, but future was already handled/timed out.", (Object)futureId);
        }
    }

    private void cleanupTimedOutFutures() {
        long now = System.currentTimeMillis();
        this.pendingFutures.forEach((id, info) -> {
            if (now > info.expireTime()) {
                LOGGER.warn("Future {} timed out.", id);
                if (this.pendingFutures.remove(id, info)) {
                    try {
                        info.callback().accept(null);
                    }
                    catch (Exception e) {
                        LOGGER.error("Error executing timeout callback for futureId {}", id, (Object)e);
                    }
                }
            }
        });
    }

    protected record PendingFutureInfo(Consumer<?> callback, int expectedResponsePacketId, long expireTime) {
    }
}

