/*
 * Decompiled with CFR 0.152.
 */
package org.misaka.api.common.network.packet;

import com.mojang.logging.LogUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.network.VarInt;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.ApiStatus;
import org.misaka.MisakaNetwork;
import org.misaka.MisakaNetworkServer;
import org.misaka.api.common.network.NetworkSystem;
import org.misaka.api.common.network.ThreadType;
import org.misaka.api.common.network.event.C2SPacketEvent;
import org.misaka.api.common.network.packet.Packet;
import org.misaka.api.common.network.packet.PacketType;
import org.slf4j.Logger;

public final class C2SPacket
implements net.minecraft.network.protocol.Packet<ServerGamePacketListenerImpl> {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final net.minecraft.network.protocol.PacketType<C2SPacket> TYPE = new net.minecraft.network.protocol.PacketType(PacketFlow.SERVERBOUND, MisakaNetwork.location("c2s_packet"));
    public static final StreamCodec<ByteBuf, C2SPacket> STREAM_CODEC = net.minecraft.network.protocol.Packet.codec(C2SPacket::write, C2SPacket::new);
    private final int id;
    private final ByteBuf byteBuf;

    public <L extends ServerGamePacketListenerImpl, T extends Packet<L, T>> C2SPacket(T packet) {
        this.id = packet.getPacketType().getPacketId();
        this.byteBuf = Unpooled.buffer();
        long startTime = NetworkSystem.isDebugInfo() ? System.nanoTime() : 0L;
        packet.getPacketType().codec().encode((Object)this.byteBuf, packet);
        if (NetworkSystem.isDebugInfo()) {
            long endTime = System.nanoTime();
            int packetSize = this.byteBuf.readableBytes();
            LOGGER.debug("[SEND][C2S] Packet: {}(ID: {}), Size: {} bytes, Encode Time: {} ns", new Object[]{packet.getClass().getSimpleName(), this.id, packetSize, endTime - startTime});
        }
    }

    @ApiStatus.Internal
    private C2SPacket(ByteBuf byteBuf) {
        this.id = VarInt.read((ByteBuf)byteBuf);
        this.byteBuf = byteBuf.readBytes(byteBuf.readableBytes());
    }

    public void write(ByteBuf byteBuf) {
        VarInt.write((ByteBuf)byteBuf, (int)this.id);
        byteBuf.writeBytes(this.byteBuf.copy());
    }

    public net.minecraft.network.protocol.PacketType<? extends net.minecraft.network.protocol.Packet<ServerGamePacketListenerImpl>> type() {
        return TYPE;
    }

    public void handle(ServerGamePacketListenerImpl handler) {
        handler.server.execute(() -> {
            C2SPacketEvent event = new C2SPacketEvent(this);
            NeoForge.EVENT_BUS.post((Event)event);
            Object packetType = NetworkSystem.getPacketTypeById(this.id);
            Class packetClass = ((PacketType)packetType).packetClass();
            if (NetworkSystem.isDebugInfo()) {
                int packetSize = this.byteBuf.readableBytes();
                LOGGER.debug("[RECEIVE][C2S] Packet: {}(ID: {}), Size: {} bytes", new Object[]{packetClass.getSimpleName(), this.id, packetSize});
            }
            if (!NetworkSystem.shouldReceive(packetClass, ThreadType.SERVER)) {
                return;
            }
            try {
                Packet instance = (Packet)((PacketType)packetType).codec().decode((Object)this.byteBuf);
                instance.setPacketListener(handler);
                MisakaNetworkServer.NETWORK_MANAGER.dispatchPacket(instance);
            }
            catch (Throwable e) {
                LOGGER.error("Exception processing C2S packet. Class: {}, ID: {}. Player: {}. Error: {}", new Object[]{packetClass.getSimpleName(), this.id, handler.player.getGameProfile().name(), e.getMessage(), e});
            }
        });
    }
}

